/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.module;

import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.building.block.RopeBlock;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="building")
public class RopeModule
extends ZetaModule {
    @Hint
    public static Block rope;
    @Config(description="Set to true to allow ropes to move Tile Entities even if Pistons Push TEs is disabled.\nNote that ropes will still use the same blacklist.")
    public static boolean forceEnableMoveTileEntities;
    @Config
    public static boolean enableDispenserBehavior;

    @LoadEvent
    public final void register(ZRegister event) {
        rope = new RopeBlock("rope", this, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_278183_().m_60978_(0.5f).m_60918_(SoundType.f_56745_));
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        if (enableDispenserBehavior) {
            DispenserBlock.f_52661_.put(rope.m_5456_(), new BehaviourRope());
        } else {
            DispenserBlock.f_52661_.remove(rope.m_5456_());
        }
    }

    static {
        forceEnableMoveTileEntities = false;
        enableDispenserBehavior = true;
    }

    public static class BehaviourRope
    extends OptionalDispenseItemBehavior {
        @NotNull
        protected ItemStack m_7498_(BlockSource source, @NotNull ItemStack stack) {
            Direction facing = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            BlockPos pos = source.m_7961_().m_121945_(facing);
            ServerLevel world = source.m_7727_();
            this.m_123573_(false);
            BlockState state = world.m_8055_(pos);
            if (state.m_60734_() == rope) {
                if (((RopeBlock)rope).pullDown((Level)world, pos)) {
                    this.m_123573_(true);
                    stack.m_41774_(1);
                    return stack;
                }
            } else if (world.m_46859_(pos) && rope.m_49966_().m_60710_((LevelReader)world, pos)) {
                SoundType soundtype = rope.getSoundType(state, (LevelReader)world, pos, null);
                world.m_46597_(pos, rope.m_49966_());
                world.m_5594_(null, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                this.m_123573_(true);
                stack.m_41774_(1);
                return stack;
            }
            return stack;
        }
    }
}

