/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block.be;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import org.violetmoon.quark.addons.oddities.block.MagnetBlock;
import org.violetmoon.quark.addons.oddities.magnetsystem.MagnetSystem;
import org.violetmoon.quark.addons.oddities.module.MagnetsModule;

public class MagnetBlockEntity
extends BlockEntity {
    public MagnetBlockEntity(BlockPos pos, BlockState state) {
        super(MagnetsModule.magnetType, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MagnetBlockEntity be) {
        boolean powered = (Boolean)state.m_61143_((Property)MagnetBlock.POWERED);
        if (powered) {
            Direction dir = (Direction)state.m_61143_((Property)MagnetBlock.FACING);
            int power = level.m_277086_(pos);
            be.magnetize(dir, dir, power);
            be.magnetize(dir.m_122424_(), dir, power);
        }
    }

    private void magnetize(Direction dir, Direction moveDir, int power) {
        BlockPos targetPos;
        BlockState targetState;
        if (this.f_58857_ == null) {
            return;
        }
        double magnitude = dir == moveDir ? 1 : -1;
        double particleMotion = 0.05 * magnitude;
        double particleChance = 0.2;
        double xOff = (double)dir.m_122429_() * particleMotion;
        double yOff = (double)dir.m_122430_() * particleMotion;
        double zOff = (double)dir.m_122431_() * particleMotion;
        for (int i = 1; i <= power && (targetState = this.f_58857_.m_8055_(targetPos = this.f_58858_.m_5484_(dir, i))).m_60734_() != MagnetsModule.magnetized_block; ++i) {
            BlockPos frontPos;
            BlockState frontState;
            PushReaction reaction;
            if (!this.f_58857_.f_46443_ && targetState.m_60734_() != Blocks.f_50110_ && targetState.m_60734_() != MagnetsModule.magnetized_block && ((reaction = MagnetSystem.getPushAction(this, targetPos, targetState, moveDir)) == PushReaction.IGNORE || reaction == PushReaction.DESTROY) && (frontState = this.f_58857_.m_8055_(frontPos = targetPos.m_121945_(moveDir))).m_60795_()) {
                MagnetSystem.applyForce(this.f_58857_, targetPos, power - i + 1, dir == moveDir, moveDir, i, this.f_58858_);
            }
            if (!targetState.m_60795_()) break;
            if (!this.f_58857_.f_46443_ || !(Math.random() <= particleChance)) continue;
            double x = (double)targetPos.m_123341_() + (xOff == 0.0 ? 0.5 : Math.random());
            double y = (double)targetPos.m_123342_() + (yOff == 0.0 ? 0.5 : Math.random());
            double z = (double)targetPos.m_123343_() + (zOff == 0.0 ? 0.5 : Math.random());
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123763_, x, y, z, xOff, yOff, zOff);
        }
    }
}

