/*
 * Decompiled with CFR 0.152.
 */
package mod.motivationaldragon.potionblender.blockentities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mod.motivationaldragon.potionblender.Constants;
import mod.motivationaldragon.potionblender.advancements.CauldronExplosionTrigger;
import mod.motivationaldragon.potionblender.block.BrewingCauldron;
import mod.motivationaldragon.potionblender.config.ConfigController;
import mod.motivationaldragon.potionblender.config.PotionBlenderConfig;
import mod.motivationaldragon.potionblender.platform.Service;
import mod.motivationaldragon.potionblender.utils.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BrewingCauldronBlockEntity
extends BlockEntity {
    private static final String POTION_MIXER_KEY = "potionblender.ConfigController";
    private static final Map<Item, Item> recipes = new HashMap<Item, Item>(3);
    private static final int ITEM_DROP_OFFSET = 1;
    private static final PotionBlenderConfig config = ConfigController.getConfig();
    private boolean isBrewing = false;
    private boolean canBrew = false;
    private int progress = 0;
    private static final int MAX_PROGRESS;
    @NotNull
    private Item craftingIngredient = Items.f_41852_;
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)config.getMaxNbOfEffects(), (Object)ItemStack.f_41583_);
    private int numberOfPotion = 0;

    protected BrewingCauldronBlockEntity(BlockPos pos, BlockState state) {
        super(Service.PLATFORM.getPlatformBrewingCauldron(), pos, state);
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public int size() {
        return this.inventory.size();
    }

    private void emptyCauldron(@NotNull Level level) {
        this.inventory.clear();
        this.numberOfPotion = 0;
        BlockState hasFluid = (BlockState)((BlockState)level.m_8055_(this.m_58899_()).m_61124_((Property)BrewingCauldron.HAS_FLUID, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BrewingCauldron.IS_BREWING, (Comparable)Boolean.valueOf(false));
        level.m_46597_(this.m_58899_(), hasFluid);
        this.updateListeners();
    }

    private void updateListeners() {
        this.m_6596_();
        this.syncInventoryWithClient();
        assert (this.m_58904_() != null);
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 1);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected abstract void syncInventoryWithClient();

    public void onUseDelegate(BlockState state, Level level, BlockPos pos, Player player) {
        if (this.numberOfPotion >= 1) {
            Containers.m_18992_((Level)level, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)this.craftingIngredient.m_7968_());
            this.stopBrewing();
            this.dropInventoryContent(level);
        }
    }

    private void stopBrewing() {
        this.canBrew = false;
        this.isBrewing = false;
        this.craftingIngredient = Items.f_41852_;
        this.resetProgress();
        this.m_58900_().m_61124_((Property)BrewingCauldron.IS_BREWING, (Comparable)Boolean.valueOf(false));
        this.m_6596_();
    }

    public void onEntityLandDelegate(Entity entity) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_5776_() || this.isBrewing) {
            return;
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack itemStack = itemEntity.m_32055_();
            if (ModUtils.isACombinedPotion(itemStack) && itemEntity.m_19749_() != null) {
                this.explode(entity);
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            if (itemStack.m_150930_(Items.f_42589_) && this.numberOfPotion < this.inventory.size()) {
                if (this.wouldIgnoreInstantPotion(itemStack)) {
                    return;
                }
                this.addItemToCauldron(itemEntity);
                return;
            }
            if (recipes.containsKey(itemStack.m_41720_()) && this.numberOfPotion > 0) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                this.canBrew = true;
                this.craftingIngredient = itemStack.m_41720_();
                assert (this.m_58904_() != null);
                this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58904_().m_8055_(this.m_58899_()).m_61124_((Property)BrewingCauldron.IS_BREWING, (Comparable)Boolean.valueOf(true)));
                this.m_6596_();
                this.f_58857_.m_247517_(null, this.m_58899_(), SoundEvents.f_11874_, SoundSource.BLOCKS);
            }
        }
    }

    private void craftCombinedPotion(Level level, @NotNull BlockPos pos) {
        Item potionType;
        ItemStack potionToCraft;
        if (level.m_5776_()) {
            return;
        }
        if (this.craftingIngredient == Items.f_41852_) {
            Constants.LOG.error("Trying to make a potion with no ingredient selected. If you see this message, and you just migrated from an older version, you should break and replace the cauldron. Otherwise, it mean something bad has happened in the mod logic. Please report this bug to https://github.com/motivational-dragon/Potion-Blender/issues");
            this.craftingIngredient = config.getNormalPotionIngredient();
        }
        if ((potionToCraft = new ItemStack((ItemLike)(potionType = Objects.requireNonNullElseGet(recipes.get(this.craftingIngredient), BrewingCauldronBlockEntity::getDefaultPotion)))).m_150930_(Items.f_42589_)) {
            potionToCraft.m_41784_().m_128379_("potionblender_IsCombinedPotion", true);
        } else if (potionToCraft.m_150930_(Items.f_42736_)) {
            potionToCraft.m_41784_().m_128379_("potionblender_IsCombinedSplashPotion", true);
        } else if (potionToCraft.m_150930_(Items.f_42739_)) {
            potionToCraft.m_41784_().m_128379_("potionblender_IsCombinedLingeringPotion", true);
        }
        List<MobEffectInstance> finalPotionStatusEffects = BrewingCauldronBlockEntity.mergeCombinableEffects(this.getInventoryStatusEffectsInstances());
        if (ModUtils.isCombinedLingeringPotion(potionToCraft)) {
            finalPotionStatusEffects = BrewingCauldronBlockEntity.handleLingeringPotionEffects(finalPotionStatusEffects);
        }
        ItemStack potionItemStack = PotionUtils.m_43552_((ItemStack)potionToCraft, finalPotionStatusEffects);
        int color = PotionUtils.m_43564_(finalPotionStatusEffects);
        potionItemStack.m_41784_().m_128405_("CustomPotionColor", color);
        ItemEntity potionEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, potionItemStack);
        potionEntity.m_20242_(true);
        potionEntity.m_20256_(Vec3.f_82478_);
        potionEntity.m_32052_(null);
        level.m_7967_((Entity)potionEntity);
        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)((double)pos.m_123342_() + 1.0), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)Items.f_42590_, this.numberOfPotion - 1));
        level.m_5594_(null, pos, SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.emptyCauldron(level);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BrewingCauldronBlockEntity brewingCauldron) {
        if (level.m_5776_()) {
            return;
        }
        if (brewingCauldron.canBrew) {
            brewingCauldron.isBrewing = true;
            ++brewingCauldron.progress;
            if (brewingCauldron.progress >= MAX_PROGRESS) {
                brewingCauldron.craftCombinedPotion(level, pos);
                brewingCauldron.stopBrewing();
            }
            BrewingCauldronBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        } else {
            brewingCauldron.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static Item getDefaultPotion() {
        return Items.f_42589_;
    }

    private static List<MobEffectInstance> mergeCombinableEffects(List<MobEffectInstance> effectInstances) {
        HashSet<MobEffect> mergedStatusEffects = new HashSet<MobEffect>();
        ArrayList<MobEffectInstance> finalPotionStatusEffects = new ArrayList<MobEffectInstance>(effectInstances);
        for (int i = 0; i < finalPotionStatusEffects.size(); ++i) {
            MobEffectInstance effectInstance1 = (MobEffectInstance)finalPotionStatusEffects.get(i);
            ArrayList<MobEffectInstance> combinableEffects = new ArrayList<MobEffectInstance>();
            int totalDuration = effectInstance1.m_19557_();
            combinableEffects.add(effectInstance1);
            int potionDecay = 2;
            for (int j = 0; j < finalPotionStatusEffects.size(); ++j) {
                MobEffectInstance effectInstance2 = (MobEffectInstance)finalPotionStatusEffects.get(j);
                if (i == j || mergedStatusEffects.contains(effectInstance1.m_19544_()) || !BrewingCauldronBlockEntity.areEffectsDurationsAddable(effectInstance1, effectInstance2)) continue;
                totalDuration += (int)(1.0 / (double)potionDecay * (double)effectInstance2.m_19557_());
                ++potionDecay;
                combinableEffects.add(effectInstance2);
            }
            mergedStatusEffects.add(effectInstance1.m_19544_());
            if (combinableEffects.size() <= 1) continue;
            MobEffectInstance combinedEffect = ModUtils.copyEffectWithNewDuration((MobEffectInstance)combinableEffects.get(0), totalDuration);
            finalPotionStatusEffects.removeAll(combinableEffects);
            finalPotionStatusEffects.add(combinedEffect);
        }
        return finalPotionStatusEffects;
    }

    @NotNull
    private static List<MobEffectInstance> handleLingeringPotionEffects(List<MobEffectInstance> finalPotionStatusEffects) {
        ArrayList<MobEffectInstance> lingeringEffects = new ArrayList<MobEffectInstance>(finalPotionStatusEffects.size());
        for (MobEffectInstance effectInstance : finalPotionStatusEffects) {
            if (effectInstance.m_19544_().m_8093_()) {
                lingeringEffects.add(new MobEffectInstance(effectInstance.m_19544_(), effectInstance.m_19557_(), Math.round((float)effectInstance.m_19564_() * 0.5f), effectInstance.m_19571_(), effectInstance.m_19572_(), effectInstance.m_19575_()));
                continue;
            }
            lingeringEffects.add(ModUtils.copyEffectWithNewDuration(effectInstance, Math.round((float)effectInstance.m_19557_() * 0.25f)));
        }
        return lingeringEffects;
    }

    private static boolean areEffectsDurationsAddable(MobEffectInstance effectInstance1, MobEffectInstance effectInstance2) {
        return effectInstance1.m_19544_() == effectInstance2.m_19544_() && effectInstance1.m_19564_() == effectInstance2.m_19564_();
    }

    private void dropInventoryContent(@NotNull Level level) {
        if (level.m_5776_()) {
            return;
        }
        level.m_5594_(null, this.m_58899_(), SoundEvents.f_11752_, SoundSource.BLOCKS, 1.0f, 1.0f);
        Containers.m_19010_((Level)level, (BlockPos)this.m_58899_().m_7918_(0, 1, 0), this.getInventory());
        this.emptyCauldron(level);
    }

    private void explode(Entity entity) {
        assert (this.f_58857_ != null);
        assert (!this.f_58857_.m_5776_());
        BlockPos pos = this.m_58899_();
        List nearbyPlayers = this.m_58904_().m_45976_(ServerPlayer.class, new AABB(pos).m_82400_(5.0));
        for (ServerPlayer player : nearbyPlayers) {
            CauldronExplosionTrigger.INSTANCE.trigger(player, pos, (ServerLevel)this.m_58904_());
        }
        this.f_58857_.m_254849_(entity, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 1.5f, Level.ExplosionInteraction.BLOCK);
    }

    private boolean wouldIgnoreInstantPotion(ItemStack itemStack) {
        List<MobEffectInstance> effectInstances = PotionUtils.m_43547_((ItemStack)itemStack);
        effectInstances = effectInstances.stream().filter(e -> e.m_19544_().m_8093_()).toList();
        return this.getInventoryStatusEffectsInstances().stream().anyMatch(effectInstances::contains);
    }

    private void addItemToCauldron(@NotNull ItemEntity itemEntity) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11707_, SoundSource.BLOCKS, 2.0f * this.f_58857_.f_46441_.m_188501_(), 1.0f);
        this.addItem(itemEntity.m_32055_());
        BlockState mixerCauldronBlockState = (BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_((Property)BrewingCauldron.HAS_FLUID, (Comparable)Boolean.valueOf(true));
        this.f_58857_.m_46597_(this.m_58899_(), mixerCauldronBlockState);
        this.forceChunkUpdate();
        itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        this.updateListeners();
    }

    public boolean isFull() {
        return this.numberOfPotion == this.inventory.size();
    }

    private void addItem(@NotNull ItemStack itemStack) {
        assert (this.f_58857_ != null);
        if (this.numberOfPotion > this.inventory.size()) {
            this.countPotion(this.inventory);
        }
        this.inventory.set(this.numberOfPotion, (Object)itemStack);
        ++this.numberOfPotion;
    }

    private void forceChunkUpdate() {
        BlockState blockState;
        if (this.f_58857_ == null) {
            return;
        }
        boolean redrawValue = (Boolean)(blockState = this.f_58857_.m_8055_(this.m_58899_())).m_61143_((Property)BrewingCauldron.REDRAW_DUMMY);
        BlockState newRedraw = (BlockState)blockState.m_61124_((Property)BrewingCauldron.REDRAW_DUMMY, (Comparable)Boolean.valueOf(!redrawValue));
        this.f_58857_.m_46597_(this.m_58899_(), newRedraw);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        this.inventory = NonNullList.m_122780_((int)this.size(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.numberOfPotion = nbt.m_128451_(POTION_MIXER_KEY);
        this.isBrewing = nbt.m_128471_("potionblender.ConfigController_isBrewing");
        this.canBrew = nbt.m_128471_("potionblender.ConfigController_canBrew");
        ResourceLocation resourceLocation = new ResourceLocation(nbt.m_128461_("potionblender.ConfigController_brewingItem"));
        this.craftingIngredient = (Item)BuiltInRegistries.f_257033_.m_7745_(resourceLocation);
        super.m_142466_(nbt);
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_(POTION_MIXER_KEY, this.numberOfPotion);
        nbt.m_128379_("potionblender.ConfigController_isBrewing", this.isBrewing);
        nbt.m_128359_("potionblender.ConfigController_brewingItem", BuiltInRegistries.f_257033_.m_7981_((Object)this.craftingIngredient).toString());
        nbt.m_128379_("potionblender.ConfigController_canBrew", this.canBrew);
        super.m_183515_(nbt);
    }

    public int getWaterColor() {
        return PotionUtils.m_43564_(this.getInventoryStatusEffectsInstances());
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @NotNull
    protected List<MobEffectInstance> getInventoryStatusEffectsInstances() {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        if (this.numberOfPotion > this.inventory.size()) {
            this.numberOfPotion = this.size() - 1;
        }
        for (int i = 0; i < this.numberOfPotion; ++i) {
            ItemStack potionItemStack = (ItemStack)this.inventory.get(i);
            effects.addAll(PotionUtils.m_43547_((ItemStack)potionItemStack));
        }
        return effects;
    }

    public void setInventory(NonNullList<ItemStack> newInventory) {
        this.numberOfPotion = 0;
        this.inventory = newInventory;
        this.countPotion(newInventory);
    }

    private void countPotion(NonNullList<ItemStack> newInventory) {
        for (ItemStack stack : newInventory) {
            if (stack.m_150930_(Items.f_41852_)) continue;
            ++this.numberOfPotion;
        }
    }

    static {
        recipes.put(config.getNormalPotionIngredient(), Items.f_42589_);
        recipes.put(config.getSplashPotionIngredient(), Items.f_42736_);
        recipes.put(config.getLingeringPotionIngredient(), Items.f_42739_);
        MAX_PROGRESS = config.getBrewingTime();
    }
}

