/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.packmenu.buttons;

import com.google.gson.JsonObject;
import com.mojang.realmsclient.RealmsMainScreen;
import dev.shadowsoffire.packmenu.PackMenuClient;
import dev.shadowsoffire.packmenu.buttons.ActionInstance;
import dev.shadowsoffire.packmenu.buttons.ScreenType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.resolver.ServerAddress;

public enum ButtonAction {
    CONNECT_TO_SERVER(ai -> {
        Minecraft mc = Minecraft.m_91087_();
        ServerData data = ButtonAction.getOrCreateServerData((String)ai.getData());
        ServerAddress addr = ServerAddress.m_171864_((String)((String)ai.getData()));
        ConnectScreen.m_278792_((Screen)mc.f_91080_, (Minecraft)mc, (ServerAddress)addr, (ServerData)data, (boolean)false);
    }, j -> j.get("data").getAsString()),
    LOAD_WORLD(ai -> {}, j -> j.get("data").getAsString()),
    REALMS(ai -> Minecraft.m_91087_().m_91152_((Screen)new RealmsMainScreen(Minecraft.m_91087_().f_91080_)), j -> null),
    RELOAD(ai -> {
        PackMenuClient.loadConfig();
        Minecraft.m_91087_().m_91391_();
    }, j -> null),
    OPEN_GUI(ai -> Minecraft.m_91087_().m_91152_(((ScreenType)ai.getData()).apply(Minecraft.m_91087_().f_91080_)), j -> ScreenType.valueOf(ScreenType.class, j.get("data").getAsString().toUpperCase(Locale.ROOT))),
    OPEN_URL(ai -> Util.m_137581_().m_137648_((URI)ai.getData()), j -> {
        try {
            return new URI(j.get("data").getAsString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }),
    QUIT(ai -> Minecraft.m_91087_().m_91395_(), j -> null),
    NONE(ai -> {}, j -> null);

    private Consumer<ActionInstance> action;
    private Function<JsonObject, Object> reader;

    private ButtonAction(Consumer<ActionInstance> action, Function<JsonObject, Object> reader) {
        this.action = action;
        this.reader = reader;
    }

    public void onPress(ActionInstance button) {
        this.action.accept(button);
    }

    public Object readData(JsonObject json) {
        return this.reader.apply(json);
    }

    public static ServerData getOrCreateServerData(String ip) {
        JoinMultiplayerScreen scn = new JoinMultiplayerScreen(Minecraft.m_91087_().f_91080_);
        scn.m_6575_(Minecraft.m_91087_(), 0, 0);
        ServerList list = scn.m_99732_();
        for (int i = 0; i < list.m_105445_(); ++i) {
            ServerData data = list.m_105432_(i);
            if (!data.f_105363_.equals(ip)) continue;
            return data;
        }
        ServerData data = new ServerData("Packmenu Managed Server", ip, false);
        list.m_233842_(data, true);
        list.m_105442_();
        return data;
    }
}

