/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.ellpeck.naturesaura.recipes.ModRecipe;
import de.ellpeck.naturesaura.recipes.ModRecipes;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class AnimalSpawnerRecipe
extends ModRecipe {
    public final Ingredient[] ingredients;
    public final EntityType<?> entity;
    public final int aura;
    public final int time;

    public AnimalSpawnerRecipe(ResourceLocation name, EntityType<?> entity, int aura, int time, Ingredient ... ingredients) {
        super(name);
        this.ingredients = ingredients;
        this.entity = entity;
        this.aura = aura;
        this.time = time;
    }

    public Entity makeEntity(Level level, BlockPos pos) {
        if (pos == BlockPos.f_121853_) {
            return this.entity.m_20615_(level);
        }
        return this.entity.m_262451_((ServerLevel)level, null, null, pos, MobSpawnType.SPAWNER, false, false);
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.ANIMAL_SPAWNER_SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return ModRecipes.ANIMAL_SPAWNER_TYPE;
    }

    public static class Serializer
    implements RecipeSerializer<AnimalSpawnerRecipe> {
        public AnimalSpawnerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            for (JsonElement e : json.getAsJsonArray("ingredients")) {
                ingredients.add(Ingredient.m_43917_((JsonElement)e));
            }
            return new AnimalSpawnerRecipe(recipeId, (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(json.get("entity").getAsString())), json.get("aura").getAsInt(), json.get("time").getAsInt(), ingredients.toArray(new Ingredient[0]));
        }

        @Nullable
        public AnimalSpawnerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient[] ings = new Ingredient[buffer.readInt()];
            for (int i = 0; i < ings.length; ++i) {
                ings[i] = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            }
            return new AnimalSpawnerRecipe(recipeId, (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(buffer.m_130281_()), buffer.readInt(), buffer.readInt(), ings);
        }

        public void toNetwork(FriendlyByteBuf buffer, AnimalSpawnerRecipe recipe) {
            buffer.writeInt(recipe.ingredients.length);
            for (Ingredient ing : recipe.ingredients) {
                ing.m_43923_(buffer);
            }
            buffer.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey(recipe.entity));
            buffer.writeInt(recipe.aura);
            buffer.writeInt(recipe.time);
        }
    }
}

