/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ItemStackHandlerNA;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.recipes.ModRecipes;
import de.ellpeck.naturesaura.recipes.OfferingRecipe;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class BlockEntityOfferingTable
extends BlockEntityImpl
implements ITickableBlockEntity {
    public final ItemStackHandler items = new ItemStackHandlerNA(1, this, true){

        public int getSlotLimit(int slot) {
            return 16;
        }
    };
    private final Queue<ItemStack> itemsToSpawn = new ArrayDeque<ItemStack>();

    public BlockEntityOfferingTable(BlockPos pos, BlockState state) {
        super(ModBlockEntities.OFFERING_TABLE, pos, state);
    }

    private OfferingRecipe getRecipe(ItemStack input) {
        for (OfferingRecipe recipe : this.f_58857_.m_7465_().m_44056_(ModRecipes.OFFERING_TYPE, null, this.f_58857_)) {
            if (!recipe.input.test(input)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_) {
            if (this.f_58857_.m_46467_() % 20L == 0L) {
                if (!Multiblocks.OFFERING_TABLE.isComplete(this.f_58857_, this.f_58858_)) {
                    return;
                }
                ItemStack stack = this.items.getStackInSlot(0);
                if (stack.m_41619_()) {
                    return;
                }
                List items = this.f_58857_.m_45976_(ItemEntity.class, new AABB(this.f_58858_).m_82400_(1.0));
                if (items.isEmpty()) {
                    return;
                }
                OfferingRecipe recipe = this.getRecipe(stack);
                if (recipe == null) {
                    return;
                }
                for (ItemEntity item : items) {
                    int i;
                    ItemStack itemStack;
                    if (!item.m_6084_() || item.m_32063_() || (itemStack = item.m_32055_()).m_41619_() || itemStack.m_41613_() != 1 || !recipe.startItem.test(itemStack)) continue;
                    int amount = Helper.getIngredientAmount(recipe.input);
                    int recipeCount = stack.m_41613_() / amount;
                    stack.m_41774_(recipeCount * amount);
                    item.m_6074_();
                    this.sendToClients();
                    for (i = 0; i < recipeCount; ++i) {
                        this.itemsToSpawn.add(recipe.output.m_41777_());
                    }
                    if (Multiblocks.OFFERING_TABLE.forEach(this.f_58858_, 'R', (pos, m) -> this.f_58857_.m_8055_(pos).m_60734_() == Blocks.f_50070_)) {
                        for (i = this.f_58857_.f_46441_.m_188503_(5) + 3; i >= 0; --i) {
                            this.itemsToSpawn.add(new ItemStack((ItemLike)Items.f_42498_));
                        }
                    }
                    LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(this.f_58857_);
                    lightningboltentity.m_20874_(true);
                    lightningboltentity.m_20219_(Vec3.m_82512_((Vec3i)this.f_58858_));
                    this.f_58857_.m_7967_((Entity)lightningboltentity);
                    PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles((float)item.m_20185_(), (float)item.m_20186_(), (float)item.m_20189_(), PacketParticles.Type.OFFERING_TABLE, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_()));
                    break;
                }
            } else if (this.f_58857_.m_46467_() % 3L == 0L && !this.itemsToSpawn.isEmpty()) {
                this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)((float)this.f_58858_.m_123341_() + 0.5f), 256.0, (double)((float)this.f_58858_.m_123343_() + 0.5f), this.itemsToSpawn.remove()));
            }
        }
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            compound.m_128365_("items", (Tag)this.items.serializeNBT());
            if (type != BlockEntityImpl.SaveType.SYNC) {
                ListTag list = new ListTag();
                for (ItemStack stack : this.itemsToSpawn) {
                    list.add((Object)stack.serializeNBT());
                }
                compound.m_128365_("items_to_spawn", (Tag)list);
            }
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            this.items.deserializeNBT(compound.m_128469_("items"));
            if (type != BlockEntityImpl.SaveType.SYNC) {
                this.itemsToSpawn.clear();
                ListTag list = compound.m_128437_("items_to_spawn", 10);
                for (Tag base : list) {
                    this.itemsToSpawn.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)base)));
                }
            }
        }
    }

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return this.items;
    }
}

