/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityChunkLoader
extends BlockEntityImpl
implements ITickableBlockEntity {
    private final List<ChunkPos> forcedChunks = new ArrayList<ChunkPos>();
    private boolean firstTick = true;
    private boolean canUseRightNow = true;

    public BlockEntityChunkLoader(BlockPos pos, BlockState state) {
        super(ModBlockEntities.CHUNK_LOADER, pos, state);
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        this.loadChunks(true);
    }

    @Override
    public void onRedstonePowerChange(int newPower) {
        super.onRedstonePowerChange(newPower);
        if (!this.f_58857_.f_46443_) {
            this.loadChunks(false);
            this.sendToClients();
        }
    }

    public int range() {
        return this.redstonePower * 2;
    }

    public int getAuraUsed() {
        return Mth.m_14167_((float)((float)this.range() / 2.0f));
    }

    private void loadChunks(boolean unload) {
        int range;
        if (this.f_58857_.f_46443_ || !((Boolean)ModConfig.instance.chunkLoader.get()).booleanValue()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.f_58857_;
        ArrayList<ChunkPos> shouldBeForced = new ArrayList<ChunkPos>();
        if (!unload && (range = this.range()) > 0 && this.canUseRightNow) {
            for (int x = this.f_58858_.m_123341_() - range >> 4; x <= this.f_58858_.m_123341_() + range >> 4; ++x) {
                for (int z = this.f_58858_.m_123343_() - range >> 4; z <= this.f_58858_.m_123343_() + range >> 4; ++z) {
                    ChunkPos pos = new ChunkPos(x, z);
                    if (!this.forcedChunks.contains(pos) && level.m_8902_().contains(pos.m_45588_())) continue;
                    shouldBeForced.add(pos);
                }
            }
        }
        for (ChunkPos pos : this.forcedChunks) {
            if (shouldBeForced.contains(pos)) continue;
            level.m_8602_(pos.f_45578_, pos.f_45579_, false);
        }
        this.forcedChunks.clear();
        for (ChunkPos pos : shouldBeForced) {
            level.m_8602_(pos.f_45578_, pos.f_45579_, true);
            this.forcedChunks.add(pos);
        }
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_ && ((Boolean)ModConfig.instance.chunkLoader.get()).booleanValue()) {
            int toUse;
            boolean canUse;
            if (this.firstTick) {
                this.loadChunks(false);
                this.firstTick = false;
            }
            if (this.canUseRightNow != (canUse = this.canUseRightNow(toUse = this.getAuraUsed()))) {
                this.canUseRightNow = canUse;
                this.loadChunks(false);
            }
            if (this.f_58857_.m_46467_() % 20L != 0L) {
                return;
            }
            if (toUse > 0 && this.canUseRightNow) {
                BlockPos spot = IAuraChunk.getHighestSpot(this.f_58857_, this.f_58858_, 35, this.f_58858_);
                IAuraChunk.getAuraChunk(this.f_58857_, spot).drainAura(spot, toUse);
            }
        }
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type == BlockEntityImpl.SaveType.TILE) {
            compound.m_128428_("forced_chunks", this.forcedChunks.stream().map(ChunkPos::m_45588_).collect(Collectors.toList()));
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type == BlockEntityImpl.SaveType.TILE) {
            this.forcedChunks.clear();
            Arrays.stream(compound.m_128467_("forced_chunks")).mapToObj(ChunkPos::new).forEach(this.forcedChunks::add);
        }
    }

    @Override
    public boolean allowsLowerLimiter() {
        return true;
    }
}

