/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import com.google.common.collect.ImmutableMap;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ItemStackHandlerNA;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.items.ItemAuraBottle;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BlockEntityAuraTimer
extends BlockEntityImpl
implements ITickableBlockEntity {
    private static final Map<IAuraType, Integer> TIMES = ImmutableMap.builder().put((Object)NaturesAuraAPI.TYPE_OVERWORLD, (Object)20).put((Object)NaturesAuraAPI.TYPE_NETHER, (Object)1200).put((Object)NaturesAuraAPI.TYPE_END, (Object)72000).build();
    private final ItemStackHandlerNA itemHandler = new ItemStackHandlerNA(1, this, true){

        @Override
        protected boolean canInsert(ItemStack stack, int slot) {
            return stack.m_41720_() == ModItems.AURA_BOTTLE;
        }
    };
    private int timer;

    public BlockEntityAuraTimer(BlockPos pos, BlockState state) {
        super(ModBlockEntities.AURA_TIMER, pos, state);
    }

    @Override
    public void onRedstonePowerChange(int newPower) {
        if (this.redstonePower <= 0 && newPower > 0) {
            this.timer = 0;
            int color = ItemAuraBottle.getType(this.itemHandler.getStackInSlot(0)).getColor();
            PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), PacketParticles.Type.TIMER_RESET, color));
            this.sendToClients();
        }
        super.onRedstonePowerChange(newPower);
    }

    @Override
    public void tick() {
        int total = this.getTotalTime();
        if (total <= 0) {
            this.timer = 0;
            return;
        }
        if (this.f_58857_.f_46443_) {
            if (this.f_58857_.m_46467_() % 8L == 0L) {
                int color = ItemAuraBottle.getType(this.itemHandler.getStackInSlot(0)).getColor();
                NaturesAuraAPI.instance().spawnMagicParticle((float)this.f_58858_.m_123341_() + 0.0625f + this.f_58857_.f_46441_.m_188501_() * 14.0f / 16.0f, (float)this.f_58858_.m_123342_() + 0.0625f + this.f_58857_.f_46441_.m_188501_() * 14.0f / 16.0f, (float)this.f_58858_.m_123343_() + 0.0625f + this.f_58857_.f_46441_.m_188501_() * 14.0f / 16.0f, 0.0, 0.0, 0.0, color, 1.0f, 80 + this.f_58857_.f_46441_.m_188503_(50), 0.0f, false, true);
            }
            return;
        }
        ++this.timer;
        if (this.timer >= total) {
            this.timer = 0;
            BlockState state = this.m_58900_();
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)), 1);
            this.f_58857_.m_186460_(this.f_58858_, state.m_60734_(), 4);
            int color = ItemAuraBottle.getType(this.itemHandler.getStackInSlot(0)).getColor();
            PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), PacketParticles.Type.TIMER_RESET, color));
        }
        if (this.timer % 2 == 0) {
            this.sendToClients();
        }
    }

    public int getTotalTime() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.m_41619_()) {
            return 0;
        }
        Integer amount = TIMES.get(ItemAuraBottle.getType(stack));
        if (amount == null) {
            return 0;
        }
        return amount * stack.m_41613_();
    }

    public int getTimeLeft() {
        return this.getTotalTime() - this.timer;
    }

    public float getTimerPercentage() {
        return (float)this.timer / (float)this.getTotalTime();
    }

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            compound.m_128365_("items", (Tag)this.itemHandler.serializeNBT());
            compound.m_128405_("timer", this.timer);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            this.itemHandler.deserializeNBT(compound.m_128469_("items"));
            this.timer = compound.m_128451_("timer");
        }
    }
}

