/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityProjectileGenerator;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.blocks.tiles.render.RenderProjectileGenerator;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.ITESRProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class BlockProjectileGenerator
extends BlockContainerImpl
implements ITESRProvider<BlockEntityProjectileGenerator>,
ICustomBlockState {
    public BlockProjectileGenerator() {
        super("projectile_generator", BlockEntityProjectileGenerator.class, BlockBehaviour.Properties.m_284310_().m_60978_(2.5f).m_60918_(SoundType.f_56742_));
        MinecraftForge.EVENT_BUS.register((Object)this);
        DispenserBlock.m_52672_((ItemLike)Items.f_42584_, (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level levelIn, Position position, ItemStack stackIn) {
                ThrownEnderpearl ret = new ThrownEnderpearl(EntityType.f_20484_, levelIn);
                ret.m_6034_(position.m_7096_(), position.m_7098_(), position.m_7094_());
                return ret;
            }
        });
        DispenserBlock.m_52672_((ItemLike)Items.f_42713_, (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level levelIn, Position position, ItemStack stackIn) {
                ThrownTrident ret = new ThrownTrident(EntityType.f_20487_, levelIn);
                ret.m_6034_(position.m_7096_(), position.m_7098_(), position.m_7094_());
                ObfuscationReflectionHelper.setPrivateValue(ThrownTrident.class, (Object)ret, (Object)stackIn.m_41777_(), (String)"f_37555_");
                ret.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                return ret;
            }
        });
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        Entity entity = event.getEntity();
        if (entity.m_9236_().f_46443_) {
            return;
        }
        HitResult ray = event.getRayTraceResult();
        if (!(ray instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockRay = (BlockHitResult)ray;
        BlockPos pos = blockRay.m_82425_();
        if (pos == null) {
            return;
        }
        BlockEntity tile = entity.m_9236_().m_7702_(pos);
        if (!(tile instanceof BlockEntityProjectileGenerator)) {
            return;
        }
        BlockEntityProjectileGenerator generator = (BlockEntityProjectileGenerator)tile;
        if (generator.nextSide != blockRay.m_82434_()) {
            return;
        }
        Integer amount = NaturesAuraAPI.PROJECTILE_GENERATIONS.get(entity.m_6095_());
        if (amount == null || amount <= 0) {
            return;
        }
        if (!generator.canGenerateRightNow(amount)) {
            return;
        }
        generator.generateAura(amount);
        PacketHandler.sendToAllAround(entity.m_9236_(), pos, 32, new PacketParticles((float)entity.m_20185_(), (float)entity.m_20186_(), (float)entity.m_20189_(), PacketParticles.Type.PROJECTILE_GEN, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
        entity.m_9236_().m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11898_, SoundSource.BLOCKS, 0.8f, 1.0f);
        generator.nextSide = generator.nextSide.m_122427_();
        generator.sendToClients();
        entity.m_6074_();
        event.setCanceled(true);
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().cubeBottomTop(this.getBaseName(), generator.modLoc("block/" + this.getBaseName()), generator.modLoc("block/" + this.getBaseName() + "_top"), generator.modLoc("block/" + this.getBaseName() + "_top")));
    }

    @Override
    public void registerTESR() {
        BlockEntityRenderers.m_173590_(ModBlockEntities.PROJECTILE_GENERATOR, RenderProjectileGenerator::new);
    }
}

