/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityGratedChute;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BlockGratedChute
extends BlockContainerImpl
implements ICustomBlockState,
ICustomItemModel {
    public static final DirectionProperty FACING = HopperBlock.f_54021_;
    private static final VoxelShape INPUT_SHAPE = Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape INPUT_MIDDLE_SHAPE = Shapes.m_83110_((VoxelShape)MIDDLE_SHAPE, (VoxelShape)INPUT_SHAPE);
    private static final VoxelShape COMBINED_SHAPE = Shapes.m_83113_((VoxelShape)INPUT_MIDDLE_SHAPE, (VoxelShape)Hopper.f_59296_, (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape DOWN_SHAPE = Shapes.m_83110_((VoxelShape)COMBINED_SHAPE, (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0));
    private static final VoxelShape EAST_SHAPE = Shapes.m_83110_((VoxelShape)COMBINED_SHAPE, (VoxelShape)Block.m_49796_((double)12.0, (double)4.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0));
    private static final VoxelShape NORTH_SHAPE = Shapes.m_83110_((VoxelShape)COMBINED_SHAPE, (VoxelShape)Block.m_49796_((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.m_83110_((VoxelShape)COMBINED_SHAPE, (VoxelShape)Block.m_49796_((double)6.0, (double)4.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = Shapes.m_83110_((VoxelShape)COMBINED_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0));
    private static final VoxelShape DOWN_RAYTRACE_SHAPE = Hopper.f_59296_;
    private static final VoxelShape EAST_RAYTRACE_SHAPE = Shapes.m_83110_((VoxelShape)Hopper.f_59296_, (VoxelShape)Block.m_49796_((double)12.0, (double)8.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
    private static final VoxelShape NORTH_RAYTRACE_SHAPE = Shapes.m_83110_((VoxelShape)Hopper.f_59296_, (VoxelShape)Block.m_49796_((double)6.0, (double)8.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0));
    private static final VoxelShape SOUTH_RAYTRACE_SHAPE = Shapes.m_83110_((VoxelShape)Hopper.f_59296_, (VoxelShape)Block.m_49796_((double)6.0, (double)8.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0));
    private static final VoxelShape WEST_RAYTRACE_SHAPE = Shapes.m_83110_((VoxelShape)Hopper.f_59296_, (VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0));

    public BlockGratedChute() {
        super("grated_chute", BlockEntityGratedChute.class, BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 8.0f).m_60918_(SoundType.f_56743_));
    }

    @Override
    protected boolean hasWaterlogging() {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter levelIn, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.DOWN -> DOWN_SHAPE;
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> COMBINED_SHAPE;
        };
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter levelIn, BlockPos pos) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.DOWN -> DOWN_RAYTRACE_SHAPE;
            case Direction.NORTH -> NORTH_RAYTRACE_SHAPE;
            case Direction.SOUTH -> SOUTH_RAYTRACE_SHAPE;
            case Direction.WEST -> WEST_RAYTRACE_SHAPE;
            case Direction.EAST -> EAST_RAYTRACE_SHAPE;
            default -> Hopper.f_59296_;
        };
    }

    public InteractionResult m_6227_(BlockState state, Level levelIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity tile = levelIn.m_7702_(pos);
        if (!(tile instanceof BlockEntityGratedChute)) {
            return InteractionResult.FAIL;
        }
        BlockEntityGratedChute chute = (BlockEntityGratedChute)tile;
        if (!levelIn.f_46443_) {
            chute.isBlacklist = !chute.isBlacklist;
            chute.sendToClients();
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction newFacing = context.m_43719_().m_122424_();
        if (newFacing == Direction.UP) {
            newFacing = Direction.DOWN;
        }
        return (BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)newFacing);
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level levelIn, BlockPos pos) {
        BlockEntity tile = levelIn.m_7702_(pos);
        if (tile instanceof BlockEntityGratedChute) {
            IItemHandlerModifiable handler = ((BlockEntityGratedChute)tile).getItemHandler();
            ItemStack stack = handler.getStackInSlot(0);
            if (stack.m_41619_()) {
                return 0;
            }
            return Mth.m_14167_((float)((float)stack.m_41613_() / (float)stack.m_41741_() * 15.0f));
        }
        return 0;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        generator.withExistingParent(this.getBaseName(), generator.modLoc("block/" + this.getBaseName() + "_down"));
    }
}

