/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.aura.item.IAuraRecharge;
import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import de.ellpeck.naturesaura.compat.Compat;
import de.ellpeck.naturesaura.misc.LevelData;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public final class Helper {
    public static boolean getBlockEntitiesInArea(LevelAccessor level, BlockPos pos, int radius, Function<BlockEntity, Boolean> consumer) {
        for (int x = pos.m_123341_() - radius >> 4; x <= pos.m_123341_() + radius >> 4; ++x) {
            for (int z = pos.m_123343_() - radius >> 4; z <= pos.m_123343_() + radius >> 4; ++z) {
                ChunkAccess chunk = Helper.getLoadedChunk(level, x, z);
                if (chunk == null) continue;
                for (BlockPos tilePos : chunk.m_5928_()) {
                    BlockEntity tile;
                    if (!(tilePos.m_123331_((Vec3i)pos) <= (double)(radius * radius)) || (tile = chunk.m_7702_(tilePos)) == null || !consumer.apply(tile).booleanValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void getAuraChunksWithSpotsInArea(Level level, BlockPos pos, int radius, Consumer<AuraChunk> consumer) {
        LevelData data = (LevelData)ILevelData.getLevelData(level);
        for (int x = pos.m_123341_() - radius >> 4; x <= pos.m_123341_() + radius >> 4; ++x) {
            for (int z = pos.m_123343_() - radius >> 4; z <= pos.m_123343_() + radius >> 4; ++z) {
                AuraChunk chunk = (AuraChunk)data.auraChunksWithSpots.get(ChunkPos.m_45589_((int)x, (int)z));
                if (chunk == null) continue;
                consumer.accept(chunk);
            }
        }
    }

    public static List<ItemFrame> getAttachedItemFrames(Level level, BlockPos pos) {
        List frames = level.m_45976_(ItemFrame.class, new AABB(pos).m_82400_(0.25));
        for (int i = frames.size() - 1; i >= 0; --i) {
            ItemFrame frame = (ItemFrame)frames.get(i);
            BlockPos framePos = frame.m_31748_().m_121945_(frame.m_6350_().m_122424_());
            if (pos.equals((Object)framePos)) continue;
            frames.remove(i);
        }
        return frames;
    }

    public static ChunkAccess getLoadedChunk(LevelAccessor level, int x, int z) {
        ChunkSource chunkSource = level.m_7726_();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache cache = (ServerChunkCache)chunkSource;
            return cache.m_143239_(ChunkPos.m_45589_((int)x, (int)z)) ? cache.m_7587_(x, z, ChunkStatus.f_62326_, false) : null;
        }
        return level.m_6522_(x, z, ChunkStatus.f_62326_, false);
    }

    public static int blendColors(int c1, int c2, float ratio) {
        int a = (int)((float)(c1 >> 24 & 0xFF) * ratio + (float)(c2 >> 24 & 0xFF) * (1.0f - ratio));
        int r = (int)((float)(c1 >> 16 & 0xFF) * ratio + (float)(c2 >> 16 & 0xFF) * (1.0f - ratio));
        int g = (int)((float)(c1 >> 8 & 0xFF) * ratio + (float)(c2 >> 8 & 0xFF) * (1.0f - ratio));
        int b = (int)((float)(c1 & 0xFF) * ratio + (float)(c2 & 0xFF) * (1.0f - ratio));
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static boolean areItemsEqual(ItemStack first, ItemStack second, boolean nbt) {
        return nbt ? ItemStack.m_150942_((ItemStack)first, (ItemStack)second) : ItemStack.m_41656_((ItemStack)first, (ItemStack)second);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemInGui(GuiGraphics graphics, ItemStack stack, int x, int y, float scale) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 0.0f);
        poseStack.m_85841_(scale, scale, scale);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280480_(stack, 0, 0);
        graphics.m_280302_(Minecraft.m_91087_().f_91062_, stack, 0, 0, null);
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderWeirdBox(VertexConsumer buffer, double x, double y, double z, double width, double height, double depth, float r, float g, float b, float a) {
        buffer.m_5483_(x, y + height, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y + height, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y + height, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y + height, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y + height, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y + height, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y + height, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y + height, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y + height, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y + height, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y + height, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y + height, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y, z).m_85950_(r, g, b, a).m_5752_();
    }

    public static InteractionResult putStackOnTile(Player player, InteractionHand hand, BlockPos pos, int slot, boolean sound) {
        IItemHandlerModifiable handler;
        BlockEntity tile = player.m_9236_().m_7702_(pos);
        if (tile instanceof BlockEntityImpl && (handler = ((BlockEntityImpl)tile).getItemHandler()) != null) {
            ItemStack remain;
            ItemStack handStack = player.m_21120_(hand);
            if (!handStack.m_41619_() && !ItemStack.m_41728_((ItemStack)(remain = handler.insertItem(slot, handStack, player.m_9236_().f_46443_)), (ItemStack)handStack)) {
                if (sound) {
                    player.m_9236_().m_6263_(player, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12013_, SoundSource.PLAYERS, 0.75f, 1.0f);
                }
                if (!player.m_9236_().f_46443_) {
                    player.m_21008_(hand, remain);
                }
                return InteractionResult.SUCCESS;
            }
            if (!handler.getStackInSlot(slot).m_41619_()) {
                if (sound) {
                    player.m_9236_().m_6263_(player, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12016_, SoundSource.PLAYERS, 0.75f, 1.0f);
                }
                if (!player.m_9236_().f_46443_) {
                    ItemStack stack = handler.getStackInSlot(slot);
                    if (!player.m_36356_(stack)) {
                        ItemEntity item = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
                        player.m_9236_().m_7967_((Entity)item);
                    }
                    handler.setStackInSlot(slot, ItemStack.f_41583_);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.CONSUME;
    }

    public static ICapabilityProvider makeRechargeProvider(final ItemStack stack, final boolean needsSelected) {
        return new ICapabilityProvider(){
            private final LazyOptional<IAuraRecharge> recharge = LazyOptional.of(() -> (container, containerSlot, itemSlot, isSelected) -> {
                if (isSelected || !needsSelected) {
                    return Helper.rechargeAuraItem(stack, container, 300);
                }
                return false;
            });

            @Nullable
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
                if (capability == NaturesAuraAPI.CAP_AURA_RECHARGE) {
                    return this.recharge.cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public static boolean rechargeAuraItem(ItemStack stack, IAuraContainer container, int toDrain) {
        if (stack.m_41773_() > 0 && container.drainAura(toDrain, true) >= toDrain) {
            stack.m_41721_(stack.m_41773_() - 1);
            container.drainAura(toDrain, false);
            return true;
        }
        return false;
    }

    public static BlockState getStateFromString(String raw) {
        String[] split = raw.split("\\[");
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[0]));
        if (block != null) {
            BlockState state = block.m_49966_();
            if (split.length > 1) {
                block0: for (String part : split[1].replace("]", "").split(",")) {
                    String[] keyValue = part.split("=");
                    for (Property prop : state.m_61147_()) {
                        BlockState changed = Helper.findProperty(state, prop, keyValue[0], keyValue[1]);
                        if (changed == null) continue;
                        state = changed;
                        continue block0;
                    }
                }
            }
            return state;
        }
        return null;
    }

    private static <T extends Comparable<T>> BlockState findProperty(BlockState state, Property<T> prop, String key, String newValue) {
        if (key.equals(prop.m_61708_())) {
            for (Comparable value : prop.m_6908_()) {
                if (!prop.m_6940_(value).equals(newValue)) continue;
                return (BlockState)state.m_61124_(prop, value);
            }
        }
        return null;
    }

    public static void addAdvancement(Player player, ResourceLocation advancement, String criterion) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer playerMp = (ServerPlayer)player;
        Advancement adv = playerMp.m_9236_().m_7654_().m_129889_().m_136041_(advancement);
        if (adv != null) {
            playerMp.m_8960_().m_135988_(adv, criterion);
        }
    }

    public static int getIngredientAmount(Ingredient ingredient) {
        int highestAmount = 0;
        for (ItemStack stack : ingredient.m_43908_()) {
            if (stack.m_41613_() <= highestAmount) continue;
            highestAmount = stack.m_41613_();
        }
        return highestAmount;
    }

    public static boolean isHoldingItem(Player player, Item item) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41619_() || stack.m_41720_() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static AABB aabb(Vec3 pos) {
        return new AABB(pos.f_82479_, pos.f_82480_, pos.f_82481_, pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public static <T> void populateObjectHolders(Class<?> clazz, IForgeRegistry<T> registry) {
        for (Field entry : clazz.getFields()) {
            if (!Modifier.isStatic(entry.getModifiers())) continue;
            ResourceLocation location = new ResourceLocation("naturesaura", entry.getName().toLowerCase(Locale.ROOT));
            if (!registry.containsKey(location)) {
                NaturesAura.LOGGER.fatal("Couldn't find entry named " + location + " in registry " + registry.getRegistryName());
                continue;
            }
            try {
                entry.set(null, registry.getValue(location));
            }
            catch (IllegalAccessException e) {
                NaturesAura.LOGGER.error((Object)e);
            }
        }
    }

    public static ItemStack getEquippedItem(Predicate<ItemStack> predicate, Player player, boolean hotbarOnly) {
        Optional<ItemStack> stack;
        if (Compat.hasCompat("curios") && (stack = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, predicate).map(SlotResult::stack)).isPresent()) {
            return stack.get();
        }
        int invSize = hotbarOnly ? 9 : player.m_150109_().m_6643_();
        for (int i = 0; i < invSize; ++i) {
            ItemStack slot = player.m_150109_().m_8020_(i);
            if (slot.m_41619_() || !predicate.test(slot)) continue;
            return slot;
        }
        return ItemStack.f_41583_;
    }

    public static BlockPos getClosestAirAboveGround(Level level, BlockPos pos, int radius) {
        for (int i = 0; i < radius; ++i) {
            BlockPos up = pos.m_6630_(i);
            if (level.m_46859_(up) && !level.m_46859_(up.m_7495_())) {
                return up;
            }
            BlockPos dn = pos.m_6625_(i);
            if (!level.m_46859_(dn) || level.m_46859_(dn.m_7495_())) continue;
            return dn;
        }
        return pos;
    }

    public static void mineRecursively(Level level, BlockPos pos, BlockPos start, ItemStack tool, int horizontalRange, int verticalRange, Predicate<BlockState> filter) {
        if (Math.abs(pos.m_123341_() - start.m_123341_()) >= horizontalRange || Math.abs(pos.m_123343_() - start.m_123343_()) >= horizontalRange || Math.abs(pos.m_123342_() - start.m_123342_()) >= verticalRange) {
            return;
        }
        if (!tool.m_41619_()) {
            BlockState state = level.m_8055_(pos);
            level.m_46961_(pos, false);
            Block.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)(state.m_155947_() ? level.m_7702_(pos) : null), null, (ItemStack)tool);
        } else {
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            PacketHandler.sendToAllAround(level, pos, 32, new PacketParticles(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), PacketParticles.Type.TR_DISAPPEAR, new int[0]));
        }
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos offset;
                    BlockState state;
                    if (x == 0 && y == 0 && z == 0 || !filter.test(state = level.m_8055_(offset = pos.m_7918_(x, y, z)))) continue;
                    Helper.mineRecursively(level, offset, start, tool, horizontalRange, verticalRange, filter);
                }
            }
        }
    }

    public static boolean isToolEnabled(ItemStack stack) {
        return stack.m_41782_() && !stack.m_41783_().m_128471_("naturesaura:disabled");
    }

    public static boolean toggleToolEnabled(Player player, ItemStack stack) {
        if (!player.m_6144_()) {
            return false;
        }
        boolean disabled = !Helper.isToolEnabled(stack);
        stack.m_41784_().m_128379_("naturesaura:disabled", !disabled);
        player.m_9236_().m_6263_(null, player.m_20185_() + 0.5, player.m_20186_() + 0.5, player.m_20189_() + 0.5, SoundEvents.f_11686_, SoundSource.PLAYERS, 0.65f, 1.0f);
        return true;
    }
}

