/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.patchouli;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import mythicbotany.MythicBotany;
import mythicbotany.patchouli.PageRuneRitualBase;
import mythicbotany.rune.RuneRitualRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class PageRitualPattern
extends PageRuneRitualBase {
    public static final ResourceLocation OVERLAY_TEXTURE = MythicBotany.getInstance().resource("textures/gui/patchouli_ritual_pattern.png");

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        RenderSystem.enableBlend();
        graphics.m_280163_(OVERLAY_TEXTURE, 0, 9, 0.0f, 0.0f, 116, 116, 256, 256);
        if (this.recipe != null) {
            this.addRune(graphics, this.recipe.getCenterRune(), 0, 0, true, mouseX, mouseY);
            for (RuneRitualRecipe.RunePosition rune : this.recipe.getRunes()) {
                this.addRune(graphics, rune.getRune(), rune.getX(), rune.getZ(), rune.isConsumed(), mouseX, mouseY);
            }
        }
    }

    private void addRune(GuiGraphics graphics, Ingredient rune, int x, int z, boolean consume, int mouseX, int mouseY) {
        int realX = 3 + 10 * (x + 5);
        int realY = 12 + 10 * (-z + 5);
        ItemStack[] stacks = rune.m_43908_();
        if (stacks.length > 0) {
            ItemStack stack = stacks[this.parent.getTicksInBook() / 20 % stacks.length];
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)(realX - 1), (float)(realY - 1), 0.0f);
            graphics.m_280168_().m_85841_(0.75f, 0.75f, 0.75f);
            graphics.m_280480_(stack, 0, 0);
            graphics.m_280370_(this.parent.f_96547_, stack, realX, realY);
            graphics.m_280168_().m_85849_();
            if (this.parent.isMouseInRelativeRange((double)mouseX, (double)mouseY, realX, realY, 10, 10)) {
                this.parent.setTooltipStack(stack);
                boolean keep = (x != 0 || z != 0) && !consume;
                String text1 = keep ? I18n.m_118938_((String)"tooltip.mythicbotany.rune_offset", (Object[])new Object[]{x, z}) : I18n.m_118938_((String)"tooltip.mythicbotany.rune_central", (Object[])new Object[0]);
                int color1 = ChatFormatting.GOLD.m_126665_() == null ? 0 : ChatFormatting.GOLD.m_126665_();
                String text2 = I18n.m_118938_((String)(keep ? "tooltip.mythicbotany.rune_keep" : "tooltip.mythicbotany.rune_consume"), (Object[])new Object[0]);
                Integer colorInt2 = keep ? ChatFormatting.DARK_GREEN.m_126665_() : ChatFormatting.DARK_RED.m_126665_();
                int color2 = colorInt2 == null ? 0 : colorInt2;
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(58.0f, 126.0f, 0.0f);
                graphics.m_280168_().m_85841_(0.7f, 0.7f, 0.7f);
                this.parent.drawCenteredStringNoShadow(graphics, text1, 0, 0, color1);
                Objects.requireNonNull(this.parent.f_96547_);
                this.parent.drawCenteredStringNoShadow(graphics, text2, 0, 2 + 9, color2);
                graphics.m_280168_().m_85849_();
            }
        }
    }
}

