/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.data.recipes.extension;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.infuser.InfuserRecipe;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.moddingx.libx.crafting.RecipeHelper;
import org.moddingx.libx.datagen.provider.recipe.RecipeExtension;

public interface InfuserExtension
extends RecipeExtension {
    default public InfuserRecipeBuilder infuser(ItemLike result) {
        return new InfuserRecipeBuilder(this, new ItemStack(result)).setGroup("infuser");
    }

    default public InfuserRecipeBuilder infuser(ItemStack result) {
        return new InfuserRecipeBuilder(this, result).setGroup("infuser");
    }

    public static class InfuserRecipeBuilder {
        private final RecipeExtension ext;
        private final ItemStack result;
        private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
        private String group;
        private int manaCost = -1;
        private int fromColor = 0xFFFFFF;
        private int toColor = 0xFFFFFF;

        private InfuserRecipeBuilder(RecipeExtension ext, ItemStack result) {
            this.ext = ext;
            this.result = result;
        }

        public InfuserRecipeBuilder addIngredient(TagKey<Item> tag) {
            return this.addIngredient(Ingredient.m_204132_(tag));
        }

        public InfuserRecipeBuilder addIngredient(ItemLike item) {
            return this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), 1);
        }

        public InfuserRecipeBuilder addIngredient(ItemLike item, int quantity) {
            for (int i = 0; i < quantity; ++i) {
                this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
            }
            return this;
        }

        public InfuserRecipeBuilder addIngredient(Ingredient ingredient) {
            return this.addIngredient(ingredient, 1);
        }

        public InfuserRecipeBuilder addIngredient(Ingredient ingredient, int quantity) {
            for (int i = 0; i < quantity; ++i) {
                this.ingredients.add(ingredient);
            }
            return this;
        }

        public InfuserRecipeBuilder setManaCost(int mana) {
            this.manaCost = mana;
            return this;
        }

        public InfuserRecipeBuilder setColors(int fromColor, int toColor) {
            this.fromColor = fromColor;
            this.toColor = toColor;
            return this;
        }

        public InfuserRecipeBuilder setGroup(String group) {
            this.group = group;
            return this;
        }

        public void build() {
            this.build(this.ext.provider().loc((ItemLike)this.result.m_41720_()));
        }

        public void build(ResourceLocation id) {
            this.validate(id);
            this.ext.consumer().accept(new TheRecipe(new ResourceLocation(id.m_135827_(), "mythicbotany_infusion/" + id.m_135815_()), this.result, this.manaCost, this.group == null ? "" : this.group, this.fromColor, this.toColor, this.ingredients));
        }

        private void validate(ResourceLocation id) {
            if (this.manaCost < 0) {
                throw new IllegalStateException("No mana cost set for " + id);
            }
        }

        private static class TheRecipe
        implements FinishedRecipe {
            private final ResourceLocation id;
            private final ItemStack output;
            private final int mana;
            private final String group;
            private final int fromColor;
            private final int toColor;
            private final List<Ingredient> inputs;

            private TheRecipe(ResourceLocation id, ItemStack output, int mana, String group, int fromColor, int toColor, List<Ingredient> inputs) {
                this.id = id;
                this.output = output;
                this.mana = mana;
                this.group = group;
                this.fromColor = fromColor;
                this.toColor = toColor;
                this.inputs = inputs;
            }

            public void m_7917_(@Nonnull JsonObject json) {
                if (!this.group.isEmpty()) {
                    json.addProperty("group", this.group);
                }
                json.add("output", (JsonElement)RecipeHelper.serializeItemStack((ItemStack)this.output, (boolean)true));
                JsonArray ingredients = new JsonArray();
                for (Ingredient ingredient : this.inputs) {
                    ingredients.add(ingredient.m_43942_());
                }
                json.addProperty("mana", (Number)this.mana);
                json.add("ingredients", (JsonElement)ingredients);
                json.addProperty("fromColor", (Number)this.fromColor);
                json.addProperty("toColor", (Number)this.toColor);
            }

            @Nonnull
            public ResourceLocation m_6445_() {
                return this.id;
            }

            @Nonnull
            public RecipeSerializer<?> m_6637_() {
                return InfuserRecipe.Serializer.INSTANCE;
            }

            @Nullable
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return null;
            }
        }
    }
}

