/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client;

import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.CropTextures;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.item.ExperienceCapsuleItem;
import com.blakebr0.mysticalagriculture.item.SoulJarItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceBowItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceCrossbowItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceFishingRodItem;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import com.google.common.base.Stopwatch;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.CropBlock;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

public final class ModelHandler {
    private static final ResourceLocation MISSING_NO = new ResourceLocation("minecraft", "missingno");

    @SubscribeEvent
    public void onRegisterAdditionalModels(ModelEvent.RegisterAdditional event) {
        if (!((Boolean)ModConfigs.ANIMATED_GROWTH_ACCELERATORS.get()).booleanValue()) {
            for (String string : List.of("block", "item")) {
                for (String tier : List.of("inferium", "prudentium", "tertium", "imperium", "supremium")) {
                    event.register(new ResourceLocation("mysticalagriculture", String.format("%s/%s_growth_accelerator_static", string, tier)));
                }
            }
        }
        for (int i = 0; i < 8; ++i) {
            event.register(new ResourceLocation("mysticalagriculture", "block/mystical_resource_crop_" + i));
            event.register(new ResourceLocation("mysticalagriculture", "block/mystical_mob_crop_" + i));
        }
        for (CropType cropType : CropRegistry.getInstance().getTypes()) {
            event.register(new ResourceLocation(CropTextures.FLOWER_INGOT_BLANK + "_" + cropType.getName()));
            event.register(new ResourceLocation(CropTextures.FLOWER_ROCK_BLANK + "_" + cropType.getName()));
            event.register(new ResourceLocation(CropTextures.FLOWER_DUST_BLANK + "_" + cropType.getName()));
            event.register(new ResourceLocation(CropTextures.FLOWER_FACE_BLANK + "_" + cropType.getName()));
        }
        event.register(CropTextures.ESSENCE_INGOT_BLANK);
        event.register(CropTextures.ESSENCE_ROCK_BLANK);
        event.register(CropTextures.ESSENCE_DUST_BLANK);
        event.register(CropTextures.ESSENCE_GEM_BLANK);
        event.register(CropTextures.ESSENCE_TALL_GEM_BLANK);
        event.register(CropTextures.ESSENCE_DIAMOND_BLANK);
        event.register(CropTextures.ESSENCE_QUARTZ_BLANK);
        event.register(CropTextures.ESSENCE_FLAME_BLANK);
        event.register(CropTextures.ESSENCE_ROD_BLANK);
        event.register(CropTextures.SEED_BLANK);
    }

    @SubscribeEvent
    public void onModifyBakingResults(ModelEvent.ModifyBakingResult event) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Map registry = event.getModels();
        if (!((Boolean)ModConfigs.ANIMATED_GROWTH_ACCELERATORS.get()).booleanValue()) {
            for (String tier : List.of("inferium", "prudentium", "tertium", "imperium", "supremium")) {
                String loc = String.format("%s_growth_accelerator", tier);
                BakedModel blockModel = (BakedModel)registry.get(new ResourceLocation("mysticalagriculture", "block/" + loc + "_static"));
                BakedModel itemModel = (BakedModel)registry.get(new ResourceLocation("mysticalagriculture", "item/" + loc + "_static"));
                registry.replace(new ModelResourceLocation("mysticalagriculture", loc, ""), blockModel);
                registry.replace(new ModelResourceLocation("mysticalagriculture", loc, "inventory"), itemModel);
            }
        }
        HashMap<ResourceLocation, BakedModel[]> cropModels = new HashMap<ResourceLocation, BakedModel[]>();
        for (CropType cropType : CropRegistry.getInstance().getTypes()) {
            cropModels.put(cropType.getId(), (BakedModel[])IntStream.range(0, 7).mapToObj(i -> (BakedModel)registry.get(new ResourceLocation(cropType.getStemModel() + "_" + i))).toArray(BakedModel[]::new));
        }
        for (Crop crop : CropRegistry.getInstance().getCrops()) {
            ModelResourceLocation location;
            BakedModel bakedModel;
            ItemNameBlockItem seeds;
            ResourceLocation seedsId;
            ModelResourceLocation location2;
            BakedModel bakedModel2;
            Item essence;
            ResourceLocation essenceId;
            BakedModel model;
            CropTextures textures = crop.getTextures();
            CropBlock crops = crop.getCropBlock();
            ResourceLocation cropId = ForgeRegistries.BLOCKS.getKey((Object)crops);
            if (cropId != null) {
                ResourceLocation type;
                for (int i2 = 0; i2 < 7; ++i2) {
                    ModelResourceLocation location3 = new ModelResourceLocation(cropId, "age=" + i2);
                    BakedModel bakedModel3 = (BakedModel)registry.get(location3);
                    if (bakedModel3 != null && !bakedModel3.getParticleIcon(ModelData.EMPTY).m_245424_().m_246162_().equals((Object)MISSING_NO)) continue;
                    type = crop.getType().getId();
                    registry.replace(location3, ((BakedModel[])cropModels.get(type))[i2]);
                }
                ModelResourceLocation location4 = new ModelResourceLocation(cropId, "age=7");
                BakedModel bakedModel4 = (BakedModel)registry.get(location4);
                if (bakedModel4 == null || bakedModel4.getParticleIcon(ModelData.EMPTY).m_245424_().m_246162_().equals((Object)MISSING_NO)) {
                    ResourceLocation flower = textures.getFlowerTexture();
                    type = crop.getType().getId();
                    ResourceLocation path = new ResourceLocation(type.m_135827_(), flower.m_135815_() + "_" + type.m_135815_());
                    model = (BakedModel)registry.get(path);
                    registry.replace(location4, model);
                }
            }
            if ((essenceId = ForgeRegistries.ITEMS.getKey((Object)(essence = crop.getEssenceItem()))) != null && ((bakedModel2 = (BakedModel)registry.get(location2 = new ModelResourceLocation(essenceId, "inventory"))) == null || bakedModel2.getParticleIcon(ModelData.EMPTY).m_245424_().m_246162_().equals((Object)MISSING_NO))) {
                ResourceLocation texture = textures.getEssenceTexture();
                model = (BakedModel)registry.get(texture);
                registry.replace(location2, model);
            }
            if ((seedsId = ForgeRegistries.ITEMS.getKey((Object)(seeds = crop.getSeedsItem()))) == null || (bakedModel = (BakedModel)registry.get(location = new ModelResourceLocation(seedsId, "inventory"))) != null && !bakedModel.getParticleIcon(ModelData.EMPTY).m_245424_().m_246162_().equals((Object)MISSING_NO)) continue;
            ResourceLocation texture = textures.getSeedTexture();
            BakedModel model2 = (BakedModel)registry.get(texture);
            registry.replace(location, model2);
        }
        stopwatch.stop();
        MysticalAgriculture.LOGGER.info("Model replacement took {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ModItems.EXPERIENCE_CAPSULE.get()), (ResourceLocation)new ResourceLocation("fill"), (ItemPropertyFunction)ExperienceCapsuleItem.getFillPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SOUL_JAR.get()), (ResourceLocation)new ResourceLocation("fill"), (ItemPropertyFunction)SoulJarItem.getFillPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceBowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceBowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceCrossbowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceCrossbowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("charged"), (ItemPropertyFunction)EssenceCrossbowItem.getChargedPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("firework"), (ItemPropertyFunction)EssenceCrossbowItem.getFireworkPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_FISHING_ROD.get()), (ResourceLocation)new ResourceLocation("cast"), (ItemPropertyFunction)EssenceFishingRodItem.getCastPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceBowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceBowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceCrossbowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceCrossbowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("charged"), (ItemPropertyFunction)EssenceCrossbowItem.getChargedPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("firework"), (ItemPropertyFunction)EssenceCrossbowItem.getFireworkPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_FISHING_ROD.get()), (ResourceLocation)new ResourceLocation("cast"), (ItemPropertyFunction)EssenceFishingRodItem.getCastPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceBowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceBowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceCrossbowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceCrossbowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("charged"), (ItemPropertyFunction)EssenceCrossbowItem.getChargedPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("firework"), (ItemPropertyFunction)EssenceCrossbowItem.getFireworkPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_FISHING_ROD.get()), (ResourceLocation)new ResourceLocation("cast"), (ItemPropertyFunction)EssenceFishingRodItem.getCastPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceBowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceBowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceCrossbowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceCrossbowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("charged"), (ItemPropertyFunction)EssenceCrossbowItem.getChargedPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("firework"), (ItemPropertyFunction)EssenceCrossbowItem.getFireworkPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_FISHING_ROD.get()), (ResourceLocation)new ResourceLocation("cast"), (ItemPropertyFunction)EssenceFishingRodItem.getCastPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceBowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceBowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceCrossbowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceCrossbowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("charged"), (ItemPropertyFunction)EssenceCrossbowItem.getChargedPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("firework"), (ItemPropertyFunction)EssenceCrossbowItem.getFireworkPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_FISHING_ROD.get()), (ResourceLocation)new ResourceLocation("cast"), (ItemPropertyFunction)EssenceFishingRodItem.getCastPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceBowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceBowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceCrossbowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceCrossbowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("charged"), (ItemPropertyFunction)EssenceCrossbowItem.getChargedPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("firework"), (ItemPropertyFunction)EssenceCrossbowItem.getFireworkPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_FISHING_ROD.get()), (ResourceLocation)new ResourceLocation("cast"), (ItemPropertyFunction)EssenceFishingRodItem.getCastPropertyGetter());
        });
    }
}

