/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client.screen;

import com.blakebr0.cucumber.client.screen.BaseContainerScreen;
import com.blakebr0.cucumber.client.screen.widget.EnergyBarWidget;
import com.blakebr0.cucumber.energy.DynamicEnergyStorage;
import com.blakebr0.cucumber.util.Formatting;
import com.blakebr0.mysticalagriculture.container.ReprocessorContainer;
import com.blakebr0.mysticalagriculture.tileentity.ReprocessorTileEntity;
import com.blakebr0.mysticalagriculture.util.MachineUpgradeTier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.energy.IEnergyStorage;

public class ReprocessorScreen
extends BaseContainerScreen<ReprocessorContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("mysticalagriculture", "textures/gui/reprocessor.png");
    private ReprocessorTileEntity tile;

    public ReprocessorScreen(ReprocessorContainer container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title, BACKGROUND, 176, 194);
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.tile = this.getTileEntity();
        if (this.tile != null) {
            this.m_142416_((GuiEventListener)new EnergyBarWidget(x + 7, y + 17, (IEnergyStorage)this.tile.getEnergy()));
        }
    }

    protected void m_280003_(GuiGraphics gfx, int mouseX, int mouseY) {
        String title = this.m_96636_().getString();
        gfx.m_280056_(this.f_96547_, title, this.f_97726_ / 2 - this.f_96547_.m_92895_(title) / 2, 6, 0x404040, false);
        gfx.m_280614_(this.f_96547_, this.f_169604_, 8, this.f_97727_ - 96 + 2, 0x404040, false);
        if (this.tile != null) {
            MachineUpgradeTier tier = this.tile.getMachineTier();
            DynamicEnergyStorage energy = this.tile.getEnergy();
            energy.resetMaxEnergyStorage();
            if (tier != null) {
                energy.setMaxEnergyStorage((int)((double)this.tile.getEnergy().getMaxEnergyStored() * tier.getFuelCapacityMultiplier()));
            }
        }
    }

    protected void m_7286_(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        this.renderDefaultBg(gfx, partialTicks, mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (this.getFuelItemValue() > 0) {
            int i = this.getBurnLeftScaled(13);
            gfx.m_280218_(BACKGROUND, x + 31, y + 52 - i, 176, 12 - i, 14, i + 1);
        }
        if (this.getProgress() > 0) {
            int i2 = this.getProgressScaled(24);
            gfx.m_280218_(BACKGROUND, x + 98, y + 51, 176, 14, i2 + 1, 16);
        }
    }

    protected void m_280072_(GuiGraphics gfx, int mouseX, int mouseY) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        super.m_280072_(gfx, mouseX, mouseY);
        if (this.getFuelLeft() > 0 && mouseX > x + 30 && mouseX < x + 45 && mouseY > y + 39 && mouseY < y + 53) {
            gfx.m_280557_(this.f_96547_, (Component)Formatting.energy((Object)this.getFuelLeft()), mouseX, mouseY);
        }
    }

    private ReprocessorTileEntity getTileEntity() {
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().f_91073_;
        if (level != null && (tile = level.m_7702_(((ReprocessorContainer)this.m_6262_()).getBlockPos())) instanceof ReprocessorTileEntity) {
            ReprocessorTileEntity reprocessor = (ReprocessorTileEntity)tile;
            return reprocessor;
        }
        return null;
    }

    public int getProgress() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgress();
    }

    public int getOperationTime() {
        if (this.tile == null) {
            return 0;
        }
        MachineUpgradeTier tier = this.tile.getMachineTier();
        if (tier != null) {
            return (int)((double)this.tile.getOperationTime() * tier.getOperationTimeMultiplier());
        }
        return this.tile.getOperationTime();
    }

    public int getFuelLeft() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getFuelLeft();
    }

    public int getFuelItemValue() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getFuelItemValue();
    }

    public int getProgressScaled(int pixels) {
        int i = this.getProgress();
        int j = this.getOperationTime();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public int getBurnLeftScaled(int pixels) {
        int i = this.getFuelLeft();
        int j = this.getFuelItemValue();
        return (int)(j != 0 && i != 0 ? (long)i * (long)pixels / (long)j : 0L);
    }
}

