/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.IFluidHandlerSlot;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class FluidInventorySlot
extends BasicInventorySlot
implements IFluidHandlerSlot {
    protected final IExtendedFluidTank fluidTank;
    private boolean isDraining;
    private boolean isFilling;

    public static FluidInventorySlot input(IExtendedFluidTank fluidTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(fluidTank, "Fluid tank cannot be null");
        return new FluidInventorySlot(fluidTank, alwaysFalse, FluidInventorySlot.getInputPredicate(fluidTank), stack -> FluidUtil.getFluidHandler((ItemStack)stack).isPresent(), listener, x, y);
    }

    protected static Predicate<ItemStack> getInputPredicate(IExtendedFluidTank fluidTank) {
        return stack -> {
            Optional cap = FluidUtil.getFluidHandler((ItemStack)(stack.m_41613_() > 1 ? stack.m_255036_(1) : stack)).resolve();
            if (cap.isPresent()) {
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)cap.get();
                boolean hasEmpty = false;
                for (int tank = 0; tank < fluidHandlerItem.getTanks(); ++tank) {
                    FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tank);
                    if (fluidInTank.isEmpty()) {
                        hasEmpty = true;
                        continue;
                    }
                    if (fluidTank.insert(fluidInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() >= fluidInTank.getAmount()) continue;
                    return true;
                }
                if (fluidTank.isEmpty()) {
                    return hasEmpty;
                }
                return fluidHandlerItem.fill(fluidTank.getFluid(), IFluidHandler.FluidAction.SIMULATE) > 0;
            }
            return false;
        };
    }

    public static FluidInventorySlot rotary(IExtendedFluidTank fluidTank, BooleanSupplier modeSupplier, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(fluidTank, "Fluid tank cannot be null");
        Objects.requireNonNull(modeSupplier, "Mode supplier cannot be null");
        return new FluidInventorySlot(fluidTank, alwaysFalse, stack -> {
            Optional cap = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
            if (cap.isPresent()) {
                boolean mode = modeSupplier.getAsBoolean();
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)cap.get();
                boolean allEmpty = true;
                for (int tank = 0; tank < fluidHandlerItem.getTanks(); ++tank) {
                    FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tank);
                    if (fluidInTank.isEmpty()) continue;
                    if (fluidTank.insert(fluidInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() < fluidInTank.getAmount()) {
                        return mode;
                    }
                    allEmpty = false;
                }
                return allEmpty && !mode;
            }
            return false;
        }, stack -> {
            LazyOptional capability = FluidUtil.getFluidHandler((ItemStack)stack);
            if (capability.isPresent()) {
                if (modeSupplier.getAsBoolean()) {
                    IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)capability.orElseThrow(MekanismUtils.MISSING_CAP_ERROR);
                    for (int tank = 0; tank < fluidHandlerItem.getTanks(); ++tank) {
                        FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tank);
                        if (fluidInTank.isEmpty() || !fluidTank.isFluidValid(fluidInTank)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }, listener, x, y);
    }

    public static FluidInventorySlot fill(IExtendedFluidTank fluidTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(fluidTank, "Fluid tank cannot be null");
        return new FluidInventorySlot(fluidTank, alwaysFalse, stack -> {
            Optional cap = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
            if (cap.isPresent()) {
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)cap.get();
                for (int tank = 0; tank < fluidHandlerItem.getTanks(); ++tank) {
                    FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tank);
                    if (fluidInTank.isEmpty() || fluidTank.insert(fluidInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() >= fluidInTank.getAmount()) continue;
                    return true;
                }
            }
            return false;
        }, stack -> FluidUtil.getFluidHandler((ItemStack)stack).isPresent(), listener, x, y);
    }

    public static FluidInventorySlot drain(IExtendedFluidTank fluidTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(fluidTank, "Fluid handler cannot be null");
        return new FluidInventorySlot(fluidTank, alwaysFalse, stack -> {
            LazyOptional cap = FluidUtil.getFluidHandler((ItemStack)(stack.m_41613_() > 1 ? stack.m_255036_(1) : stack));
            if (cap.isPresent()) {
                FluidStack fluidInTank = fluidTank.getFluid();
                if (fluidInTank.isEmpty()) {
                    return true;
                }
                IFluidHandlerItem itemFluidHandler = (IFluidHandlerItem)cap.orElseThrow(MekanismUtils.MISSING_CAP_ERROR);
                return itemFluidHandler.fill(fluidInTank, IFluidHandler.FluidAction.SIMULATE) > 0;
            }
            return false;
        }, stack -> FluidInventorySlot.isNonFullFluidContainer((LazyOptional<IFluidHandlerItem>)FluidUtil.getFluidHandler((ItemStack)stack)), listener, x, y);
    }

    private static boolean isNonFullFluidContainer(LazyOptional<IFluidHandlerItem> capability) {
        Optional cap = capability.resolve();
        if (cap.isPresent()) {
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)cap.get();
            for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                if (fluidHandler.getFluidInTank(tank).getAmount() >= fluidHandler.getTankCapacity(tank)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected FluidInventorySlot(IExtendedFluidTank fluidTank, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        super(canExtract, canInsert, validator, listener, x, y);
        this.setSlotType(ContainerSlotType.EXTRA);
        this.fluidTank = fluidTank;
    }

    @Override
    public void setStack(ItemStack stack) {
        super.setStack(stack);
        this.isDraining = false;
        this.isFilling = false;
    }

    @Override
    public IExtendedFluidTank getFluidTank() {
        return this.fluidTank;
    }

    @Override
    public boolean isDraining() {
        return this.isDraining;
    }

    @Override
    public boolean isFilling() {
        return this.isFilling;
    }

    @Override
    public void setDraining(boolean draining) {
        this.isDraining = draining;
    }

    @Override
    public void setFilling(boolean filling) {
        this.isFilling = filling;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        if (this.isDraining) {
            nbt.m_128379_("draining", true);
        }
        if (this.isFilling) {
            nbt.m_128379_("filling", true);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.isDraining = nbt.m_128471_("draining");
        this.isFilling = nbt.m_128471_("filling");
        super.deserializeNBT(nbt);
    }
}

