/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.render.entity;

import com.github.L_Ender.cataclysm.client.model.entity.ModelThe_Leviathan;
import com.github.L_Ender.cataclysm.client.model.entity.ModelThe_Leviathan_Tongue;
import com.github.L_Ender.cataclysm.client.model.entity.ModelThe_Leviathan_Tongue_End;
import com.github.L_Ender.cataclysm.client.render.RenderUtils;
import com.github.L_Ender.cataclysm.client.render.layer.LayerBasicGlow;
import com.github.L_Ender.cataclysm.client.render.layer.The_Leviathan_Layer;
import com.github.L_Ender.cataclysm.entity.BossMonsters.The_Leviathan.The_Leviathan_Entity;
import com.github.L_Ender.cataclysm.entity.BossMonsters.The_Leviathan.The_Leviathan_Part;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RendererThe_Leviathan
extends MobRenderer<The_Leviathan_Entity, ModelThe_Leviathan> {
    private static final ResourceLocation LEVIATHAN_TEXTURES = new ResourceLocation("cataclysm:textures/entity/leviathan/the_leviathan.png");
    private static final ResourceLocation BURNING_LEVIATHAN_TEXTURES = new ResourceLocation("cataclysm:textures/entity/leviathan/the_burning_leviathan.png");
    private static final ResourceLocation LEVIATHAN_TEXTURE_EYES = new ResourceLocation("cataclysm:textures/entity/leviathan/the_leviathan_eye.png");
    private final RandomSource rnd = RandomSource.m_216327_();
    private static final ModelThe_Leviathan_Tongue TONGUE_MODEL = new ModelThe_Leviathan_Tongue();
    private static final ModelThe_Leviathan_Tongue_End TONGUE_END_MODEL = new ModelThe_Leviathan_Tongue_End();

    public RendererThe_Leviathan(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelThe_Leviathan(), 1.5f);
        this.m_115326_(new The_Leviathan_Layer(this));
        this.m_115326_(new LayerBasicGlow(this, LEVIATHAN_TEXTURE_EYES));
    }

    public ResourceLocation getTextureLocation(The_Leviathan_Entity entity) {
        return entity.getMeltDown() ? BURNING_LEVIATHAN_TEXTURES : LEVIATHAN_TEXTURES;
    }

    public boolean shouldRender(The_Leviathan_Entity livingentity, Frustum camera, double camX, double camY, double camZ) {
        if (super.m_5523_((Mob)livingentity, camera, camX, camY, camZ)) {
            return true;
        }
        for (The_Leviathan_Part part : livingentity.leviathanParts) {
            if (!camera.m_113029_(part.m_20191_())) continue;
            return true;
        }
        return false;
    }

    public Vec3 getRenderOffset(The_Leviathan_Entity entity, float partialTicks) {
        if (entity.getAnimation() == The_Leviathan_Entity.LEVIATHAN_ABYSS_BLAST && entity.getAnimationTick() <= 66) {
            double d0 = 0.01;
            return new Vec3(this.rnd.m_188583_() * d0, 0.0, this.rnd.m_188583_() * d0);
        }
        return super.m_7860_((Entity)entity, partialTicks);
    }

    public void render(The_Leviathan_Entity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Mob)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        if (entity.getAnimation() == The_Leviathan_Entity.LEVIATHAN_TAIL_WHIPS) {
            Vec3 bladePos = RenderUtils.getWorldPosFromModel((Entity)entity, entityYaw, ((ModelThe_Leviathan)this.f_115290_).Tail_Particle);
            entity.setSocketPosArray(0, bladePos);
        }
        double x = Mth.m_14139_((double)partialTicks, (double)entity.f_19790_, (double)entity.m_20185_());
        double y = Mth.m_14139_((double)partialTicks, (double)entity.f_19791_, (double)entity.m_20186_());
        double z = Mth.m_14139_((double)partialTicks, (double)entity.f_19792_, (double)entity.m_20189_());
        float yaw = entity.f_20884_ + (entity.f_20883_ - entity.f_20884_) * partialTicks;
        Entity weapon = entity.getTongue();
        if (weapon != null && entity.m_6084_() && weapon.m_6084_()) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(-x, -y, -z);
            Vec3 headModelPos = ((ModelThe_Leviathan)this.m_7200_()).translateToTongue(new Vec3(0.0, 0.0, 0.0), yaw).m_82490_(0.2);
            Vec3 fromVec = entity.getTonguePosition().m_82549_(headModelPos);
            Vec3 toVec = weapon.m_20318_(partialTicks);
            Vec3 currentNeckButt = fromVec;
            VertexConsumer neckConsumer = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)LEVIATHAN_TEXTURES));
            double remainingDistance = toVec.m_82554_(fromVec);
            for (int segmentCount = 0; segmentCount < 128 && remainingDistance > 0.0; ++segmentCount) {
                Vec3 powVec;
                remainingDistance = Math.min(fromVec.m_82554_(toVec), 0.5);
                Vec3 linearVec = toVec.m_82546_(currentNeckButt);
                Vec3 smoothedVec = powVec = new Vec3(this.modifyVecAngle(linearVec.f_82479_), this.modifyVecAngle(linearVec.f_82480_), this.modifyVecAngle(linearVec.f_82481_));
                Vec3 next = smoothedVec.m_82541_().m_82490_(remainingDistance).m_82549_(currentNeckButt);
                int neckLight = this.getLightColor((Entity)entity, toVec.m_82549_(currentNeckButt).m_82520_(x, y, z));
                RendererThe_Leviathan.renderNeckCube(currentNeckButt, next, matrixStackIn, neckConsumer, neckLight, OverlayTexture.f_118083_, 0.0f);
                currentNeckButt = next;
            }
            VertexConsumer clawConsumer = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)LEVIATHAN_TEXTURES));
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(toVec.f_82479_, toVec.f_82480_, toVec.f_82481_);
            matrixStackIn.m_252880_(0.0f, -0.5f, 0.0f);
            float rotY = (float)(Mth.m_14136_((double)toVec.f_82479_, (double)toVec.f_82481_) * 57.2957763671875);
            float rotX = (float)(-(Mth.m_14136_((double)toVec.f_82480_, (double)toVec.m_165924_()) * 57.2957763671875));
            TONGUE_END_MODEL.setAttributes(rotX, rotY);
            TONGUE_END_MODEL.m_7695_(matrixStackIn, clawConsumer, this.getLightColor((Entity)entity, toVec.m_82520_(x, y, z)), OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.m_85849_();
            matrixStackIn.m_85849_();
        }
    }

    public static void renderNeckCube(Vec3 from, Vec3 to, PoseStack poseStack, VertexConsumer buffer, int packedLightIn, int overlayCoords, float additionalYaw) {
        Vec3 sub = from.m_82546_(to);
        double d = sub.m_165924_();
        float rotY = (float)(Mth.m_14136_((double)sub.f_82479_, (double)sub.f_82481_) * 57.2957763671875);
        float rotX = (float)(-(Mth.m_14136_((double)sub.f_82480_, (double)d) * 57.2957763671875)) - 90.0f;
        poseStack.m_85836_();
        poseStack.m_85837_(from.f_82479_, from.f_82480_, from.f_82481_);
        poseStack.m_252880_(0.0f, -0.5f, 0.0f);
        TONGUE_MODEL.setAttributes((float)sub.m_82553_(), rotX, rotY, additionalYaw);
        TONGUE_MODEL.m_7695_(poseStack, buffer, packedLightIn, overlayCoords, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    private double modifyVecAngle(double dimension) {
        float abs = (float)Math.abs(dimension);
        return Math.signum(dimension) * Mth.m_14008_((double)Math.pow(abs, 0.1), (double)(0.05 * (double)abs), (double)abs);
    }

    private int getLightColor(Entity head, Vec3 vec3) {
        BlockPos blockpos = BlockPos.m_274446_((Position)vec3);
        if (head.m_9236_().m_46805_(blockpos)) {
            int i = LevelRenderer.m_109541_((BlockAndTintGetter)head.m_9236_(), (BlockPos)blockpos);
            int j = LevelRenderer.m_109541_((BlockAndTintGetter)head.m_9236_(), (BlockPos)blockpos.m_7494_());
            int k = i & 0xFF;
            int l = j & 0xFF;
            int i1 = i >> 16 & 0xFF;
            int j1 = j >> 16 & 0xFF;
            return (k > l ? k : l) | (i1 > j1 ? i1 : j1) << 16;
        }
        return 0;
    }

    protected void scale(The_Leviathan_Entity entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        matrixStackIn.m_85841_(1.75f, 1.75f, 1.75f);
    }

    protected float getFlipDegrees(The_Leviathan_Entity entity) {
        return 0.0f;
    }
}

