/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.Deepling;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.Deepling.AbstractDeepling;
import com.github.L_Ender.cataclysm.entity.Deepling.Lionfish_Entity;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Deepling_Angler_Entity
extends AbstractDeepling {
    boolean searchingForLand;
    public static final Animation DEEPLING_MELEE = Animation.create((int)20);
    public static final Animation DEEPLING_HUG = Animation.create((int)20);
    private static final EntityDimensions SWIMMING_SIZE = new EntityDimensions(1.225f, 0.65f, false);
    private int hugcooldown = 100;
    public static final int HUG_COOLDOWN = 100;

    public Deepling_Angler_Entity(EntityType entity, Level world) {
        super(entity, world);
        this.f_21342_ = new DeeplingMoveControl(this, 2.0f);
        this.switchNavigator(false);
        this.f_21364_ = 8;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new DeeplingGoToBeachGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new DeeplingSwimUpGoal(this, 1.0, this.m_9236_().m_5736_()));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new AnimationMeleeAttackGoal(this, 1.0, false));
    }

    public static AttributeSupplier.Builder deepling() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.27f).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22278_, 0.25);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    protected void m_213945_(RandomSource p_219154_, DifficultyInstance p_219155_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42523_));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.DEEPLING_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.DEEPLING_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.DEEPLING_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ModSounds.DEEPLING_IDLE.get(), 0.15f, 0.6f);
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return ModEntities.rollSpawn(CMConfig.DeeplingAnglerSpawnRolls, this.m_217043_(), spawnReasonIn);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_34088_, DifficultyInstance p_34089_, MobSpawnType p_34090_, @Nullable SpawnGroupData p_34091_, @Nullable CompoundTag p_34092_) {
        SpawnGroupData spawngroupdata = super.m_6518_(p_34088_, p_34089_, p_34090_, p_34091_, p_34092_);
        RandomSource randomsource = p_34088_.m_213780_();
        this.m_213945_(randomsource, p_34089_);
        Lionfish_Entity drowned = (Lionfish_Entity)((EntityType)ModEntities.LIONFISH.get()).m_20615_(this.m_9236_());
        drowned.m_6518_(p_34088_, p_34089_, p_34090_, p_34091_, p_34092_);
        drowned.m_20359_((Entity)this);
        drowned.m_21463_((Entity)this, true);
        p_34088_.m_7967_((Entity)drowned);
        return spawngroupdata;
    }

    public boolean m_6914_(LevelReader p_32829_) {
        return p_32829_.m_45784_((Entity)this);
    }

    public static boolean candeeplingSpawn(EntityType<Deepling_Angler_Entity> p_223364_0_, LevelAccessor p_223364_1_, MobSpawnType reason, BlockPos p_223364_3_, RandomSource p_223364_4_) {
        return p_223364_1_.m_46791_() != Difficulty.PEACEFUL && (reason == MobSpawnType.SPAWNER || p_223364_1_.m_6425_(p_223364_3_).m_205070_(FluidTags.f_13131_));
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, DEEPLING_MELEE, DEEPLING_HUG};
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        LivingEntity target = this.m_5448_();
        if (this.hugcooldown > 0) {
            --this.hugcooldown;
        }
        if (this.m_6084_()) {
            float damage;
            if (this.getAnimation() == DEEPLING_MELEE && this.getAnimationTick() == 5) {
                this.m_5496_((SoundEvent)ModSounds.DEEPLING_SWING.get(), 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                if (target != null && this.m_20270_((Entity)target) < 3.0f) {
                    damage = (float)this.m_21133_(Attributes.f_22281_);
                    target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage);
                }
            }
            if (this.getAnimation() == DEEPLING_HUG && this.getAnimationTick() == 9) {
                this.m_5496_((SoundEvent)ModSounds.DEEPLING_SWING.get(), 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                if (target != null && this.m_20270_((Entity)target) < 3.0f) {
                    damage = (float)this.m_21133_(Attributes.f_22281_);
                    boolean flag = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage);
                    if (flag) {
                        target.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 60, 1), (Entity)this);
                    }
                }
            }
        }
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.9f;
    }

    boolean wantsToSwim() {
        if (this.searchingForLand) {
            return true;
        }
        LivingEntity livingentity = this.m_5448_();
        return livingentity != null && livingentity.m_20069_();
    }

    @Override
    public EntityDimensions getSwimmingSize() {
        return SWIMMING_SIZE;
    }

    @Override
    public AABB getSwimmingBox() {
        return new AABB(this.m_20185_() - (double)1.225f, this.m_20186_(), this.m_20189_() - (double)1.225f, this.m_20185_() + (double)1.225f, this.m_20186_() + (double)0.65f, this.m_20189_() + (double)1.225f);
    }

    @Override
    public AABB getNormalBox() {
        return new AABB(this.m_20185_() - (double)0.65f, this.m_20186_(), this.m_20189_() - (double)0.65f, this.m_20185_() + (double)0.65f, this.m_20186_() + (double)2.45f, this.m_20189_() + (double)0.65f);
    }

    public void m_7023_(Vec3 p_32394_) {
        if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
            this.m_19920_(0.01f, p_32394_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(p_32394_);
        }
    }

    protected boolean closeToNextPos() {
        double d0;
        BlockPos blockpos;
        Path path = this.m_21573_().m_26570_();
        return path != null && (blockpos = path.m_77406_()) != null && (d0 = this.m_20275_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_())) < 4.0;
    }

    public void setSearchingForLand(boolean p_32399_) {
        this.searchingForLand = p_32399_;
    }

    static class DeeplingMoveControl
    extends MoveControl {
        private final Deepling_Angler_Entity drowned;
        private final float speedMulti;

        public DeeplingMoveControl(Deepling_Angler_Entity p_32433_, float speedMulti) {
            super((Mob)p_32433_);
            this.drowned = p_32433_;
            this.speedMulti = speedMulti;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.drowned.m_5448_();
            if (this.drowned.wantsToSwim() && this.drowned.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.drowned.m_20186_() || this.drowned.searchingForLand) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.drowned.m_21573_().m_26571_()) {
                    this.drowned.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.drowned.m_20185_();
                double d1 = this.f_24976_ - this.drowned.m_20186_();
                double d2 = this.f_24977_ - this.drowned.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.drowned.m_146922_(this.m_24991_(this.drowned.m_146908_(), f, 90.0f));
                this.drowned.f_20883_ = this.drowned.m_146908_();
                float f1 = (float)(this.f_24978_ * (double)this.speedMulti * this.drowned.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.drowned.m_6113_(), (float)f1);
                this.drowned.m_7910_(f2);
                this.drowned.m_20256_(this.drowned.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.drowned.m_20096_()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }

    static class DeeplingGoToBeachGoal
    extends MoveToBlockGoal {
        private final Deepling_Angler_Entity drowned;

        public DeeplingGoToBeachGoal(Deepling_Angler_Entity p_32409_, double p_32410_) {
            super((PathfinderMob)p_32409_, p_32410_, 8, 2);
            this.drowned = p_32409_;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.drowned.m_9236_().m_46471_() && this.drowned.m_20069_() && this.drowned.m_20186_() >= (double)(this.drowned.m_9236_().m_5736_() - 3);
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        protected boolean m_6465_(LevelReader p_32413_, BlockPos p_32414_) {
            BlockPos blockpos = p_32414_.m_7494_();
            return p_32413_.m_46859_(blockpos) && p_32413_.m_46859_(blockpos.m_7494_()) ? p_32413_.m_8055_(p_32414_).m_60634_((BlockGetter)p_32413_, p_32414_, (Entity)this.drowned) : false;
        }

        public void m_8056_() {
            this.drowned.setSearchingForLand(false);
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }

    static class DeeplingSwimUpGoal
    extends Goal {
        private final Deepling_Angler_Entity drowned;
        private final double speedModifier;
        private final int seaLevel;
        private boolean stuck;

        public DeeplingSwimUpGoal(Deepling_Angler_Entity p_32440_, double p_32441_, int p_32442_) {
            this.drowned = p_32440_;
            this.speedModifier = p_32441_;
            this.seaLevel = p_32442_;
        }

        public boolean m_8036_() {
            return (this.drowned.m_9236_().m_46471_() || this.drowned.m_20069_()) && this.drowned.m_20186_() < (double)(this.seaLevel - 2);
        }

        public boolean m_8045_() {
            return this.m_8036_() && !this.stuck;
        }

        public void m_8037_() {
            if (this.drowned.m_20186_() < (double)(this.seaLevel - 1) && (this.drowned.m_21573_().m_26571_() || this.drowned.closeToNextPos())) {
                Vec3 vec3 = DefaultRandomPos.m_148412_((PathfinderMob)this.drowned, (int)4, (int)8, (Vec3)new Vec3(this.drowned.m_20185_(), (double)(this.seaLevel - 1), this.drowned.m_20189_()), (double)1.5707963705062866);
                if (vec3 == null) {
                    this.stuck = true;
                    return;
                }
                this.drowned.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.speedModifier);
            }
        }

        public void m_8056_() {
            this.drowned.setSearchingForLand(true);
            this.stuck = false;
        }

        public void m_8041_() {
            this.drowned.setSearchingForLand(false);
        }
    }

    static class AnimationMeleeAttackGoal
    extends MeleeAttackGoal {
        protected final Deepling_Angler_Entity mob;

        public AnimationMeleeAttackGoal(Deepling_Angler_Entity p_25552_, double p_25553_, boolean p_25554_) {
            super((PathfinderMob)p_25552_, p_25553_, p_25554_);
            this.mob = p_25552_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        protected double m_6639_(LivingEntity p_25556_) {
            return this.mob.m_20205_() * 2.5f * this.mob.m_20205_() * 2.5f + p_25556_.m_20205_();
        }

        protected void m_6739_(LivingEntity p_25557_, double p_25558_) {
            double d0 = this.m_6639_(p_25557_);
            if (p_25558_ <= d0 && this.mob.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                if (this.mob.hugcooldown <= 0) {
                    this.mob.setAnimation(DEEPLING_HUG);
                    this.mob.hugcooldown = 100;
                } else {
                    this.mob.setAnimation(DEEPLING_MELEE);
                }
            }
        }
    }
}

