/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.event;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.BossMonsters.Ancient_Remnant_Entity;
import com.github.L_Ender.cataclysm.entity.BossMonsters.Ender_Guardian_Entity;
import com.github.L_Ender.cataclysm.entity.BossMonsters.Ignis_Entity;
import com.github.L_Ender.cataclysm.entity.BossMonsters.Netherite_Monstrosity_Entity;
import com.github.L_Ender.cataclysm.entity.BossMonsters.The_Harbinger_Entity;
import com.github.L_Ender.cataclysm.entity.BossMonsters.The_Leviathan.The_Leviathan_Entity;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BossBarEvent {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("cataclysm", "textures/gui/boss_bar_frames.png");
    private static final ResourceLocation GUI_BARS_LOCATION = new ResourceLocation("textures/gui/bars.png");
    public static final Set<Mob> BOSSES = Collections.newSetFromMap(new WeakHashMap());

    @SubscribeEvent
    public static void renderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (CMConfig.custombossbar && !BOSSES.isEmpty()) {
            int i = minecraft.m_91268_().m_85445_();
            for (Mob boss : BOSSES) {
                if (boss == null || event.getBossEvent().m_18860_() != boss.m_20148_()) continue;
                event.setCanceled(true);
                int k = i / 2 - 94;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                BossBarEvent.drawBar(event.getGuiGraphics(), k, event.getY() - 2, boss, (BossEvent)event.getBossEvent());
                Component itextcomponent = boss.m_5446_();
                int l = minecraft.f_91062_.m_92852_((FormattedText)itextcomponent);
                int i1 = i / 2 - l / 2;
                event.getGuiGraphics().m_280430_(minecraft.f_91062_, itextcomponent, i1, event.getY() - 10, 0xFFFFFF);
                if (event.getY() >= minecraft.m_91268_().m_85446_() / 3) break;
                Objects.requireNonNull(minecraft.f_91062_);
                event.setIncrement(12 + 9);
            }
        }
    }

    private static void drawBar(GuiGraphics pPoseStack, int pX, int pY, Mob pEntity, BossEvent bossEvent) {
        int i = (int)(bossEvent.m_142717_() * 182.0f);
        if (pEntity instanceof Netherite_Monstrosity_Entity) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_BARS_LOCATION);
            pPoseStack.m_280163_(GUI_BARS_LOCATION, pX + 3, pY + 2, 0.0f, 20.0f, 182, 5, 256, 256);
            if (i > 0) {
                pPoseStack.m_280163_(GUI_BARS_LOCATION, pX + 3, pY + 3, 0.0f, 26.0f, i, 5, 256, 256);
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            pPoseStack.m_280163_(TEXTURE, pX, pY, 0.0f, 0.0f, 188, 9, 256, 256);
        }
        if (pEntity instanceof Ender_Guardian_Entity) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_BARS_LOCATION);
            pPoseStack.m_280163_(GUI_BARS_LOCATION, pX + 3, pY + 2, 0.0f, 50.0f, 182, 5, 256, 256);
            if (i > 0) {
                pPoseStack.m_280163_(GUI_BARS_LOCATION, pX + 3, pY + 3, 0.0f, 56.0f, i, 5, 256, 256);
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            pPoseStack.m_280163_(TEXTURE, pX, pY, 0.0f, 9.0f, 188, 9, 256, 256);
        }
        if (pEntity instanceof Ignis_Entity) {
            Ignis_Entity ignis = (Ignis_Entity)pEntity;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_BARS_LOCATION);
            if (ignis.getBossPhase() > 0) {
                pPoseStack.m_280163_(GUI_BARS_LOCATION, pX + 3, pY + 2, 0.0f, 10.0f, 182, 5, 256, 256);
                if (i > 0) {
                    pPoseStack.m_280163_(GUI_BARS_LOCATION, pX + 3, pY + 3, 0.0f, 16.0f, i, 5, 256, 256);
                }
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
                pPoseStack.m_280163_(TEXTURE, pX, pY, 0.0f, 36.0f, 188, 9, 256, 256);
            } else {
                pPoseStack.m_280163_(GUI_BARS_LOCATION, pX + 3, pY + 2, 0.0f, 40.0f, 182, 5, 256, 256);
                if (i > 0) {
                    pPoseStack.m_280163_(GUI_BARS_LOCATION, pX + 3, pY + 3, 0.0f, 46.0f, i, 5, 256, 256);
                }
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
                pPoseStack.m_280163_(TEXTURE, pX, pY, 0.0f, 27.0f, 188, 9, 256, 256);
            }
        }
        if (pEntity instanceof The_Harbinger_Entity) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_BARS_LOCATION);
            pPoseStack.m_280163_(GUI_BARS_LOCATION, pX + 3, pY + 2, 0.0f, 20.0f, 182, 5, 256, 256);
            if (i > 0) {
                pPoseStack.m_280163_(GUI_BARS_LOCATION, pX + 3, pY + 3, 0.0f, 26.0f, i, 5, 256, 256);
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            pPoseStack.m_280163_(TEXTURE, pX, pY, 0.0f, 18.0f, 188, 9, 256, 256);
        }
        if (pEntity instanceof The_Leviathan_Entity) {
            The_Leviathan_Entity leviathan = (The_Leviathan_Entity)pEntity;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_BARS_LOCATION);
            if (leviathan.getMeltDown()) {
                pPoseStack.m_280163_(GUI_BARS_LOCATION, pX + 3, pY + 6, 0.0f, 50.0f, 182, 5, 256, 256);
                if (i > 0) {
                    pPoseStack.m_280163_(GUI_BARS_LOCATION, pX + 3, pY + 7, 0.0f, 56.0f, i, 5, 256, 256);
                }
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
                pPoseStack.m_280163_(TEXTURE, pX, pY, 0.0f, 62.0f, 188, 16, 256, 256);
            } else {
                pPoseStack.m_280163_(GUI_BARS_LOCATION, pX + 3, pY + 5, 0.0f, 50.0f, 182, 5, 256, 256);
                if (i > 0) {
                    pPoseStack.m_280163_(GUI_BARS_LOCATION, pX + 3, pY + 6, 0.0f, 56.0f, i, 5, 256, 256);
                }
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
                pPoseStack.m_280163_(TEXTURE, pX, pY, 0.0f, 45.0f, 188, 13, 256, 256);
            }
        }
        if (pEntity instanceof Ancient_Remnant_Entity) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_BARS_LOCATION);
            pPoseStack.m_280163_(GUI_BARS_LOCATION, pX + 3, pY + 10, 0.0f, 60.0f, 182, 5, 256, 256);
            if (i > 0) {
                pPoseStack.m_280163_(GUI_BARS_LOCATION, pX + 3, pY + 11, 0.0f, 66.0f, i, 5, 256, 256);
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            pPoseStack.m_280163_(TEXTURE, pX, pY, 0.0f, 79.0f, 188, 26, 256, 256);
        }
    }

    public static void addBoss(Mob mob) {
        BOSSES.add(mob);
    }

    public static void removeBoss(Mob mob) {
        BOSSES.remove(mob);
    }

    public static Set<Mob> getBosses() {
        return BOSSES;
    }
}

