/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.capabilities;

import com.github.L_Ender.cataclysm.Cataclysm;
import com.github.L_Ender.cataclysm.message.MessageHoldEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class HoldAttackCapability {
    public static ResourceLocation ID = new ResourceLocation("cataclysm", "hold_attack_cap");

    public static class HoldAttackCapabilityImp
    implements IHoldAttackCapability {
        private boolean hold;
        private LivingEntity target;
        @Nullable
        private LivingEntity holder;
        private Vec3 PosVector = Vec3.f_82478_;

        @Override
        public void setEntity(LivingEntity entity) {
            this.target = entity;
        }

        @Override
        public void tick(LivingEntity entity) {
            if (this.getHold()) {
                if (this.holder != null) {
                    if (this.target instanceof Player) {
                        this.target.m_6034_(this.PosVector.m_7096_(), this.PosVector.m_7098_(), this.PosVector.m_7094_());
                        this.target.m_20256_(Vec3.f_82478_);
                    } else if (!this.target.m_9236_().m_5776_()) {
                        this.target.m_6034_(this.PosVector.m_7096_(), this.PosVector.m_7098_(), this.PosVector.m_7094_());
                        this.target.m_20256_(Vec3.f_82478_);
                    }
                } else {
                    this.setHold(false, null, Vec3.f_82478_);
                }
            }
        }

        @Override
        public boolean getHold() {
            return this.hold;
        }

        @Override
        public void setHold(boolean hold, @Nullable LivingEntity holder, Vec3 vector) {
            this.hold = hold;
            this.holder = holder;
            this.PosVector = vector;
            this.sendUpdatePacket();
        }

        @Override
        @Nullable
        public LivingEntity getHolder() {
            return this.holder;
        }

        @Override
        public void setPosVector(Vec3 vector) {
            this.PosVector = vector;
        }

        @Override
        public Vec3 getPosVector() {
            return this.PosVector;
        }

        private void sendUpdatePacket() {
            if (!this.target.m_9236_().m_5776_()) {
                Cataclysm.NETWORK_WRAPPER.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.target), (Object)new MessageHoldEntity((Entity)this.target, (IHoldAttackCapability)this));
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("Hold", this.getHold());
            tag.m_128347_("PosX", this.PosVector.m_7096_());
            tag.m_128347_("PosY", this.PosVector.m_7098_());
            tag.m_128347_("PosZ", this.PosVector.m_7094_());
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.setHold(nbt.m_128471_("Hold"), null, this.PosVector);
            this.PosVector = new Vec3(nbt.m_128459_("PosX"), nbt.m_128459_("PosY"), nbt.m_128459_("PosZ"));
        }
    }

    public static interface IHoldAttackCapability
    extends INBTSerializable<CompoundTag> {
        public void tick(LivingEntity var1);

        public void setEntity(LivingEntity var1);

        public boolean getHold();

        public void setHold(boolean var1, @Nullable LivingEntity var2, Vec3 var3);

        @Nullable
        public LivingEntity getHolder();

        public void setPosVector(Vec3 var1);

        public Vec3 getPosVector();
    }
}

