/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.network;

import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import snownee.jade.Jade;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.util.JsonConfig;

public class ServerPingPacket {
    public final String serverConfig;

    public ServerPingPacket(String serverConfig) {
        this.serverConfig = Strings.nullToEmpty((String)serverConfig);
    }

    public ServerPingPacket(PluginConfig config) {
        this(PluginConfig.INSTANCE.getServerConfigs());
    }

    public static ServerPingPacket read(FriendlyByteBuf buffer) {
        return new ServerPingPacket(buffer.m_130277_());
    }

    public static void write(ServerPingPacket message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.serverConfig);
    }

    public static class Handler {
        public static void onMessage(ServerPingPacket message, Supplier<NetworkEvent.Context> context) {
            JsonObject json;
            String s = message.serverConfig;
            try {
                json = s.isEmpty() ? null : (JsonObject)JsonConfig.DEFAULT_GSON.fromJson(s, JsonObject.class);
            }
            catch (Throwable e2) {
                Jade.LOGGER.error("Received malformed config from the server: {}", (Object)s);
                return;
            }
            context.get().enqueueWork(() -> {
                ObjectDataCenter.serverConnected = true;
                PluginConfig.INSTANCE.reload();
                if (json != null && !json.keySet().isEmpty()) {
                    PluginConfig.INSTANCE.applyServerConfigs(json);
                }
                Jade.LOGGER.info("Received config from the server: {}", (Object)s);
            }).exceptionally(e -> {
                Jade.LOGGER.error("Failed to apply config from the server: {}", (Object)s);
                Jade.LOGGER.catching(e);
                return null;
            });
            context.get().setPacketHandled(true);
        }
    }
}

