/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part;

import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.PositionedAddonsNetworkIngredientsFilter;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integratedtunnels.api.network.IItemNetwork;
import org.cyclops.integratedtunnels.core.part.PartStatePositionedAddon;

public class PartStateItem<P extends IPartTypeWriter>
extends PartStatePositionedAddon<P, IItemNetwork, ItemStack>
implements IItemHandler {
    public PartStateItem(int inventorySize, boolean canReceive, boolean canExtract) {
        super(inventorySize, canReceive, canExtract);
    }

    public <T2> LazyOptional<T2> getCapability(Capability<T2> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(capability, network, partNetwork, target);
    }

    protected IItemHandler getItemHandler() {
        return (IItemHandler)((IItemNetwork)this.getPositionedAddonsNetwork()).getChannelExternal(ForgeCapabilities.ITEM_HANDLER, this.getChannel());
    }

    public int getSlots() {
        return this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null ? this.getItemHandler().getSlots() : 0;
    }

    public ItemStack getStackInSlot(int slot) {
        ItemStack ret;
        ItemStack itemStack = ret = this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null ? this.getItemHandler().getStackInSlot(slot) : ItemStack.f_41583_;
        if (!ret.m_41619_() && !this.getStorageFilter().testView((Object)ret)) {
            return ItemStack.f_41583_;
        }
        return ret;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.canReceive() && this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null) {
            if (!this.getStorageFilter().testInsertion((Object)stack)) {
                return stack;
            }
            return this.getItemHandler().insertItem(slot, stack, simulate);
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.canExtract() && this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null) {
            ItemStack extractedSimulated;
            PositionedAddonsNetworkIngredientsFilter filter = this.getStorageFilter();
            if (!simulate && !filter.testExtraction((Object)(extractedSimulated = this.getItemHandler().extractItem(slot, amount, true)))) {
                return ItemStack.f_41583_;
            }
            ItemStack extracted = this.getItemHandler().extractItem(slot, amount, simulate);
            if (simulate && !filter.testExtraction((Object)extracted)) {
                return ItemStack.f_41583_;
            }
            return extracted;
        }
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return this.getPositionedAddonsNetwork() != null ? this.getItemHandler().getSlotLimit(slot) : 0;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null && this.getItemHandler().isItemValid(slot, stack) && !this.getStorageFilter().testInsertion((Object)stack);
    }
}

