/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.nbt.TagTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.nbt.path.INbtPathExpression;
import org.cyclops.cyclopscore.nbt.path.NbtParseException;
import org.cyclops.cyclopscore.nbt.path.NbtPath;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorRegistry;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNumber;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.IOperatorValuePropagator;
import org.cyclops.integrateddynamics.core.evaluate.OperatorBuilders;
import org.cyclops.integrateddynamics.core.evaluate.operator.CombinedOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.CompositionalOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.CurriedOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.GeneralChoiceOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.GeneralConstantOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.GeneralIdentityOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.GeneralOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.IterativeFunction;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorRegistry;
import org.cyclops.integrateddynamics.core.evaluate.operator.ParseOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBlock;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeEntity;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyAppend;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyConcat;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyEntityArmorInventory;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyEntityFluids;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyEntityInventory;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyEntityItems;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyLazyBuilt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNbtAsListByte;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNbtAsListInt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNbtAsListLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNbtAsListTag;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNbtKeys;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNbtValueListByte;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNbtValueListInt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNbtValueListLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNbtValueListTag;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyOperatorMapped;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxySlice;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyTail;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.helper.NbtHelpers;
import org.cyclops.integrateddynamics.core.ingredient.ExtendedIngredientsList;
import org.cyclops.integrateddynamics.core.ingredient.ExtendedIngredientsSingle;
import vendors.com.google.re2j.Pattern;
import vendors.com.google.re2j.PatternSyntaxException;

public final class Operators {
    public static final IOperatorRegistry REGISTRY = Operators.constructRegistry();
    public static final IOperator LOGICAL_AND = REGISTRY.register(OperatorBuilders.LOGICAL_2.symbol("&&").operatorInteract("and").function(variables -> {
        ValueTypeBoolean.ValueBoolean a = variables.getValue(0, ValueTypes.BOOLEAN);
        if (!a.getRawValue()) {
            return ValueTypeBoolean.ValueBoolean.of(false);
        }
        return variables.getValue(1, ValueTypes.BOOLEAN);
    }).build());
    public static final IOperator LOGICAL_OR = REGISTRY.register(OperatorBuilders.LOGICAL_2.symbol("||").operatorInteract("or").function(variables -> {
        ValueTypeBoolean.ValueBoolean a = variables.getValue(0, ValueTypes.BOOLEAN);
        if (a.getRawValue()) {
            return ValueTypeBoolean.ValueBoolean.of(true);
        }
        return variables.getValue(1, ValueTypes.BOOLEAN);
    }).build());
    public static final IOperator LOGICAL_NOT = REGISTRY.register(OperatorBuilders.LOGICAL_1_PREFIX.symbol("!").operatorInteract("not").function(variables -> {
        ValueTypeBoolean.ValueBoolean valueBoolean = variables.getValue(0, ValueTypes.BOOLEAN);
        return ValueTypeBoolean.ValueBoolean.of(!valueBoolean.getRawValue());
    }).build());
    public static final IOperator LOGICAL_NAND = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_NOT).apply(LOGICAL_AND).build("!&&", "nand", "nand", IConfigRenderPattern.INFIX, "logical"));
    public static final IOperator LOGICAL_NOR = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_NOT).apply(LOGICAL_OR).build("!||", "nor", "nor", IConfigRenderPattern.INFIX, "logical"));
    public static final IOperator ARITHMETIC_ADDITION = REGISTRY.register(OperatorBuilders.ARITHMETIC_2.symbol("+").operatorName("addition").interactName("add").function(variables -> ValueTypes.CATEGORY_NUMBER.add(variables.getVariables()[0], variables.getVariables()[1])).build());
    public static final IOperator ARITHMETIC_SUBTRACTION = REGISTRY.register(OperatorBuilders.ARITHMETIC_2.symbol("-").operatorName("subtraction").interactName("subtract").function(variables -> ValueTypes.CATEGORY_NUMBER.subtract(variables.getVariables()[0], variables.getVariables()[1])).build());
    public static final IOperator ARITHMETIC_MULTIPLICATION = REGISTRY.register(OperatorBuilders.ARITHMETIC_2.symbol("*").operatorName("multiplication").interactName("multiply").function(variables -> ValueTypes.CATEGORY_NUMBER.multiply(variables.getVariables()[0], variables.getVariables()[1])).build());
    public static final IOperator ARITHMETIC_DIVISION = REGISTRY.register(OperatorBuilders.ARITHMETIC_2.symbol("/").operatorName("division").interactName("divide").function(variables -> ValueTypes.CATEGORY_NUMBER.divide(variables.getVariables()[0], variables.getVariables()[1])).build());
    public static final IOperator ARITHMETIC_MAXIMUM = REGISTRY.register(OperatorBuilders.ARITHMETIC_2_PREFIX.symbol("max").operatorName("maximum").interactName("max").function(variables -> ValueTypes.CATEGORY_NUMBER.max(variables.getVariables()[0], variables.getVariables()[1])).build());
    public static final IOperator ARITHMETIC_MINIMUM = REGISTRY.register(OperatorBuilders.ARITHMETIC_2_PREFIX.symbol("min").operatorName("minimum").interactName("min").function(variables -> ValueTypes.CATEGORY_NUMBER.min(variables.getVariables()[0], variables.getVariables()[1])).build());
    public static final IOperator ARITHMETIC_INCREMENT = REGISTRY.register(OperatorBuilders.ARITHMETIC_1_SUFFIX.symbol("++").operatorInteract("increment").function(variables -> ValueTypes.CATEGORY_NUMBER.increment(variables.getVariables()[0])).build());
    public static final IOperator ARITHMETIC_DECREMENT = REGISTRY.register(OperatorBuilders.ARITHMETIC_1_SUFFIX.symbol("--").operatorInteract("decrement").function(variables -> ValueTypes.CATEGORY_NUMBER.decrement(variables.getVariables()[0])).build());
    public static final IOperator ARITHMETIC_MODULUS = REGISTRY.register(OperatorBuilders.ARITHMETIC_2.symbol("%").operatorInteract("modulus").function(variables -> ValueTypes.CATEGORY_NUMBER.modulus(variables.getVariables()[0], variables.getVariables()[1])).build());
    private static final ValueTypeInteger.ValueInteger ZERO = ValueTypeInteger.ValueInteger.of(0);
    @Deprecated
    public static final IOperator INTEGER_MODULUS = REGISTRY.register(OperatorBuilders.INTEGER_2.symbol("%").operatorName("modulus").interactName("modulus_old").function(variables -> {
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        if (b.getRawValue() == 0) {
            throw new EvaluationException(Component.m_237115_((String)"operator.integrateddynamics.error.divide_by_zero"));
        }
        if (b.getRawValue() == 1) {
            return ZERO;
        }
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue() % b.getRawValue());
    }).build());
    @Deprecated
    public static final IOperator INTEGER_INCREMENT = REGISTRY.register(OperatorBuilders.INTEGER_1_SUFFIX.symbol("++").operatorName("increment").interactName("increment_old").function(variables -> {
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue() + 1);
    }).build());
    @Deprecated
    public static final IOperator INTEGER_DECREMENT = REGISTRY.register(OperatorBuilders.INTEGER_1_SUFFIX.symbol("--").operatorName("decrement").interactName("decrement_old").function(variables -> {
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue() - 1);
    }).build());
    public static final IOperator RELATIONAL_EQUALS = REGISTRY.register(OperatorBuilders.RELATIONAL.inputTypes(2, (IValueType)ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.INFIX).symbol("==").operatorInteract("equals").function(variables -> ValueTypeBoolean.ValueBoolean.of(variables.getValue(0).equals(variables.getValue(1)))).typeValidator((operator, input) -> {
        int requiredInputLength = operator.getRequiredInputLength();
        if (input.length != requiredInputLength) {
            return Component.m_237110_((String)"operator.integrateddynamics.error.wrong_input_length", (Object[])new Object[]{operator.getOperatorName(), input.length, requiredInputLength});
        }
        IValueType temporarySecondInputType = null;
        for (int i = 0; i < requiredInputLength; ++i) {
            IValueType inputType = input[i];
            if (inputType instanceof IValueTypeNumber) {
                inputType = ValueTypes.CATEGORY_NUMBER;
            }
            if (inputType == null) {
                return Component.m_237110_((String)"operator.integrateddynamics.error.null_type", (Object[])new Object[]{operator.getOperatorName(), Integer.toString(i)});
            }
            if (i == 0) {
                temporarySecondInputType = inputType;
                continue;
            }
            if (i != 1 || ValueHelpers.correspondsTo(temporarySecondInputType, inputType)) continue;
            return Component.m_237110_((String)"operator.integrateddynamics.error.wrong_type", (Object[])new Object[]{operator.getOperatorName(), Component.m_237115_((String)inputType.getTranslationKey()), Integer.toString(i), Component.m_237115_((String)temporarySecondInputType.getTranslationKey())});
        }
        return null;
    }).build());
    public static final IOperator RELATIONAL_GT = REGISTRY.register(OperatorBuilders.RELATIONAL_2.inputTypes(2, (IValueType)ValueTypes.CATEGORY_NUMBER).symbol(">").operatorName("gt").interactName("greaterThan").function(variables -> ValueTypeBoolean.ValueBoolean.of(ValueTypes.CATEGORY_NUMBER.greaterThan(variables.getVariables()[0], variables.getVariables()[1]))).build());
    public static final IOperator RELATIONAL_LT = REGISTRY.register(OperatorBuilders.RELATIONAL_2.inputTypes(2, (IValueType)ValueTypes.CATEGORY_NUMBER).symbol("<").operatorName("lt").interactName("lessThan").function(variables -> ValueTypeBoolean.ValueBoolean.of(ValueTypes.CATEGORY_NUMBER.lessThan(variables.getVariables()[0], variables.getVariables()[1]))).build());
    public static final IOperator RELATIONAL_NOTEQUALS = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_NOT).apply(RELATIONAL_EQUALS).build("!=", "notequals", "notEquals", IConfigRenderPattern.INFIX, "relational"));
    public static final IOperator RELATIONAL_GE = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_OR).apply(RELATIONAL_EQUALS, RELATIONAL_GT).build(">=", "ge", "greaterThanOrEquals", IConfigRenderPattern.INFIX, "relational"));
    public static final IOperator RELATIONAL_LE = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_OR).apply(RELATIONAL_EQUALS, RELATIONAL_LT).build("<=", "le", "lessThanOrEquals", IConfigRenderPattern.INFIX, "relational"));
    public static final IOperator BINARY_AND = REGISTRY.register(OperatorBuilders.BINARY_2.symbol("&").operatorName("and").interactName("binaryAnd").function(variables -> {
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue() & b.getRawValue());
    }).build());
    public static final IOperator BINARY_OR = REGISTRY.register(OperatorBuilders.BINARY_2.symbol("|").operatorName("or").interactName("binaryOr").function(variables -> {
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue() | b.getRawValue());
    }).build());
    public static final IOperator BINARY_XOR = REGISTRY.register(OperatorBuilders.BINARY_2.symbol("^").operatorInteract("xor").function(variables -> {
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue() ^ b.getRawValue());
    }).build());
    public static final IOperator BINARY_COMPLEMENT = REGISTRY.register(OperatorBuilders.BINARY_1_PREFIX.symbol("~").operatorInteract("complement").function(variables -> {
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(~a.getRawValue());
    }).build());
    public static final IOperator BINARY_LSHIFT = REGISTRY.register(OperatorBuilders.BINARY_2.symbol("<<").operatorName("lshift").interactName("leftShift").function(variables -> {
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue() << b.getRawValue());
    }).build());
    public static final IOperator BINARY_RSHIFT = REGISTRY.register(OperatorBuilders.BINARY_2.symbol(">>").operatorName("rshift").interactName("rightShift").function(variables -> {
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue() >> b.getRawValue());
    }).build());
    public static final IOperator BINARY_RZSHIFT = REGISTRY.register(OperatorBuilders.BINARY_2.symbol(">>>").operatorName("rzshift").interactName("unsignedRightShift").function(variables -> {
        ValueTypeInteger.ValueInteger a = variables.getValue(0, ValueTypes.INTEGER);
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue() >>> b.getRawValue());
    }).build());
    public static final IOperator STRING_LENGTH = REGISTRY.register(OperatorBuilders.STRING_1_PREFIX.symbol("len").operatorInteract("length").output(ValueTypes.INTEGER).function(variables -> {
        ValueTypeString.ValueString a = variables.getValue(0, ValueTypes.STRING);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue().length());
    }).build());
    public static final IOperator STRING_CONCAT = REGISTRY.register(OperatorBuilders.STRING_2.symbol("+").operatorInteract("concat").function(variables -> {
        ValueTypeString.ValueString a = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString b = variables.getValue(1, ValueTypes.STRING);
        return ValueTypeString.ValueString.of(a.getRawValue() + b.getRawValue());
    }).build());
    public static final IOperator STRING_CONTAINS = REGISTRY.register(OperatorBuilders.STRING_2.symbolOperatorInteract("contains").output(ValueTypes.BOOLEAN).function(variables -> {
        ValueTypeString.ValueString search = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        return ValueTypeBoolean.ValueBoolean.of(str.getRawValue().contains(search.getRawValue()));
    }).build());
    public static final IOperator STRING_CONTAINS_REGEX = REGISTRY.register(OperatorBuilders.STRING_2_LONG.symbolOperator("contains_regex").interactName("containsRegex").output(ValueTypes.BOOLEAN).function(variables -> {
        ValueTypeString.ValueString pattern = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        try {
            vendors.com.google.re2j.Matcher m = Pattern.compile(pattern.getRawValue()).matcher(str.getRawValue());
            return ValueTypeBoolean.ValueBoolean.of(m.find());
        }
        catch (PatternSyntaxException e) {
            throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.regex.invalid", (Object[])new Object[]{pattern.getRawValue()}));
        }
    }).build());
    public static final IOperator STRING_MATCHES_REGEX = REGISTRY.register(OperatorBuilders.STRING_2_LONG.symbolOperator("matches_regex").interactName("matchesRegex").output(ValueTypes.BOOLEAN).function(variables -> {
        ValueTypeString.ValueString pattern = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        try {
            vendors.com.google.re2j.Matcher m = Pattern.compile(pattern.getRawValue()).matcher(str.getRawValue());
            return ValueTypeBoolean.ValueBoolean.of(m.matches());
        }
        catch (PatternSyntaxException e) {
            throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.regex.invalid", (Object[])new Object[]{pattern.getRawValue()}));
        }
    }).build());
    public static final IOperator STRING_INDEX_OF = REGISTRY.register(OperatorBuilders.STRING_2_LONG.symbolOperator("index_of").interactName("indexOf").output(ValueTypes.INTEGER).function(variables -> {
        ValueTypeString.ValueString search = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        return ValueTypeInteger.ValueInteger.of(str.getRawValue().indexOf(search.getRawValue()));
    }).build());
    public static final IOperator STRING_INDEX_OF_REGEX = REGISTRY.register(OperatorBuilders.STRING_2_LONG.symbolOperator("index_of_regex").interactName("indexOfRegex").output(ValueTypes.INTEGER).function(variables -> {
        ValueTypeString.ValueString pattern = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        try {
            vendors.com.google.re2j.Matcher m = Pattern.compile(pattern.getRawValue()).matcher(str.getRawValue());
            if (m.find()) {
                return ValueTypeInteger.ValueInteger.of(m.start());
            }
            return ValueTypeInteger.ValueInteger.of(-1);
        }
        catch (PatternSyntaxException e) {
            throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.regex.invalid", (Object[])new Object[]{pattern.getRawValue()}));
        }
    }).build());
    public static final IOperator STRING_STARTS_WITH = REGISTRY.register(OperatorBuilders.STRING_2.symbolOperator("starts_with").interactName("startsWith").output(ValueTypes.BOOLEAN).function(variables -> {
        ValueTypeString.ValueString search = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        return ValueTypeBoolean.ValueBoolean.of(str.getRawValue().startsWith(search.getRawValue()));
    }).build());
    public static final IOperator STRING_ENDS_WITH = REGISTRY.register(OperatorBuilders.STRING_2.symbolOperator("ends_with").interactName("endsWith").output(ValueTypes.BOOLEAN).function(variables -> {
        ValueTypeString.ValueString search = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        return ValueTypeBoolean.ValueBoolean.of(str.getRawValue().endsWith(search.getRawValue()));
    }).build());
    public static final IOperator STRING_SPLIT_ON = REGISTRY.register(OperatorBuilders.STRING_2.symbolOperator("split_on").interactName("splitOn").output(ValueTypes.LIST).function(variables -> {
        ValueTypeString.ValueString search = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        List<String> pieces = Arrays.asList(str.getRawValue().split(java.util.regex.Pattern.quote(search.getRawValue())));
        ArrayList values = Lists.newArrayList();
        for (String piece : pieces) {
            values.add(ValueTypeString.ValueString.of(piece));
        }
        return ValueTypeList.ValueList.ofList(ValueTypes.STRING, values);
    }).build());
    public static final IOperator STRING_SPLIT_ON_REGEX = REGISTRY.register(OperatorBuilders.STRING_2_LONG.symbolOperator("split_on_regex").interactName("splitOnRegex").output(ValueTypes.LIST).function(variables -> {
        ValueTypeString.ValueString pattern = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        try {
            List<String> pieces = Arrays.asList(Pattern.compile(pattern.getRawValue()).split(str.getRawValue()));
            ArrayList values = Lists.newArrayList();
            for (String piece : pieces) {
                values.add(ValueTypeString.ValueString.of(piece));
            }
            return ValueTypeList.ValueList.ofList(ValueTypes.STRING, values);
        }
        catch (PatternSyntaxException e) {
            throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.regex.invalid", (Object[])new Object[]{pattern.getRawValue()}));
        }
    }).build());
    public static final IOperator STRING_SUBSTRING = REGISTRY.register(OperatorBuilders.STRING.symbolOperatorInteract("substring").renderPattern(IConfigRenderPattern.PREFIX_3_LONG).inputTypes(ValueTypes.INTEGER, ValueTypes.INTEGER, ValueTypes.STRING).output(ValueTypes.STRING).function(variables -> {
        ValueTypeInteger.ValueInteger from = variables.getValue(0, ValueTypes.INTEGER);
        ValueTypeInteger.ValueInteger to = variables.getValue(1, ValueTypes.INTEGER);
        ValueTypeString.ValueString str = variables.getValue(2, ValueTypes.STRING);
        if (from.getRawValue() > to.getRawValue()) {
            throw new EvaluationException(Component.m_237115_((String)"operator.integrateddynamics.error.substring.to_greater_than_from"));
        }
        if (from.getRawValue() < 0 || to.getRawValue() < 0) {
            throw new EvaluationException(Component.m_237115_((String)"operator.integrateddynamics.error.substring.index_negative"));
        }
        int stringLength = str.getRawValue().length();
        if (from.getRawValue() > stringLength || to.getRawValue() > stringLength) {
            throw new EvaluationException(Component.m_237115_((String)"operator.integrateddynamics.error.substring.longer_than_string"));
        }
        return ValueTypeString.ValueString.of(str.getRawValue().substring(from.getRawValue(), to.getRawValue()));
    }).build());
    public static final IOperator STRING_REGEX_GROUP = REGISTRY.register(OperatorBuilders.STRING.symbolOperator("regex_group").interactName("regexGroup").renderPattern(IConfigRenderPattern.PREFIX_3_LONG).inputTypes(ValueTypes.STRING, ValueTypes.INTEGER, ValueTypes.STRING).output(ValueTypes.STRING).function(variables -> {
        ValueTypeString.ValueString pattern = variables.getValue(0, ValueTypes.STRING);
        ValueTypeInteger.ValueInteger group = variables.getValue(1, ValueTypes.INTEGER);
        ValueTypeString.ValueString str = variables.getValue(2, ValueTypes.STRING);
        if (group.getRawValue() < 0) {
            throw new EvaluationException(Component.m_237115_((String)"operator.integrateddynamics.error.group.index_negative"));
        }
        try {
            vendors.com.google.re2j.Matcher m = Pattern.compile(pattern.getRawValue()).matcher(str.getRawValue());
            if (m.find()) {
                String result = m.group(group.getRawValue());
                return ValueTypeString.ValueString.of(result == null ? "" : result);
            }
            throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.group.no_match", (Object[])new Object[]{str.getRawValue(), pattern.getRawValue()}));
        }
        catch (PatternSyntaxException e) {
            throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.regex.invalid", (Object[])new Object[]{pattern.getRawValue()}));
        }
        catch (IndexOutOfBoundsException e) {
            throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.group.no_match_group", (Object[])new Object[]{str.getRawValue(), pattern.getRawValue(), group.getRawValue()}));
        }
    }).build());
    public static final IOperator STRING_REGEX_GROUPS = REGISTRY.register(OperatorBuilders.STRING_2_LONG.symbolOperator("regex_groups").interactName("regexGroups").output(ValueTypes.LIST).function(variables -> {
        ValueTypeString.ValueString pattern = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(1, ValueTypes.STRING);
        try {
            vendors.com.google.re2j.Matcher m = Pattern.compile(pattern.getRawValue()).matcher(str.getRawValue());
            if (m.find()) {
                ArrayList values = Lists.newArrayList();
                for (int i = 0; i <= m.groupCount(); ++i) {
                    String result = m.group(i);
                    values.add(ValueTypeString.ValueString.of(result == null ? "" : result));
                }
                return ValueTypeList.ValueList.ofList(ValueTypes.STRING, values);
            }
            return ValueTypeList.ValueList.ofList(ValueTypes.STRING, Collections.emptyList());
        }
        catch (PatternSyntaxException e) {
            throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.regex.invalid", (Object[])new Object[]{pattern.getRawValue()}));
        }
    }).build());
    public static final IOperator STRING_REGEX_SCAN = REGISTRY.register(OperatorBuilders.STRING.symbolOperator("regex_scan").interactName("regexScan").renderPattern(IConfigRenderPattern.PREFIX_3_LONG).inputTypes(ValueTypes.STRING, ValueTypes.INTEGER, ValueTypes.STRING).output(ValueTypes.LIST).function(variables -> {
        ValueTypeString.ValueString pattern = variables.getValue(0, ValueTypes.STRING);
        ValueTypeInteger.ValueInteger group = variables.getValue(1, ValueTypes.INTEGER);
        ValueTypeString.ValueString str = variables.getValue(2, ValueTypes.STRING);
        if (group.getRawValue() < 0) {
            throw new EvaluationException(Component.m_237115_((String)"operator.integrateddynamics.error.regex_scan.index_negative"));
        }
        try {
            vendors.com.google.re2j.Matcher m = Pattern.compile(pattern.getRawValue()).matcher(str.getRawValue());
            ArrayList values = Lists.newArrayList();
            while (m.find()) {
                values.add(ValueTypeString.ValueString.of(m.group(group.getRawValue())));
            }
            return ValueTypeList.ValueList.ofList(ValueTypes.STRING, values);
        }
        catch (PatternSyntaxException e) {
            throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.regex.invalid", (Object[])new Object[]{pattern.getRawValue()}));
        }
        catch (IndexOutOfBoundsException e) {
            throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.regex_scan.no_match_group", (Object[])new Object[]{str.getRawValue(), pattern.getRawValue(), group.getRawValue()}));
        }
    }).build());
    public static final IOperator STRING_REPLACE = REGISTRY.register(OperatorBuilders.STRING.symbolOperatorInteract("replace").renderPattern(IConfigRenderPattern.PREFIX_3_LONG).inputTypes(3, (IValueType)ValueTypes.STRING).output(ValueTypes.STRING).function(variables -> {
        ValueTypeString.ValueString search = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString replacement = variables.getValue(1, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(2, ValueTypes.STRING);
        return ValueTypeString.ValueString.of(str.getRawValue().replaceAll(java.util.regex.Pattern.quote(search.getRawValue()), Matcher.quoteReplacement(replacement.getRawValue())));
    }).build());
    public static final IOperator STRING_REPLACE_REGEX = REGISTRY.register(OperatorBuilders.STRING.symbolOperator("replace_regex").interactName("replaceRegex").renderPattern(IConfigRenderPattern.PREFIX_3_LONG).inputTypes(3, (IValueType)ValueTypes.STRING).output(ValueTypes.STRING).function(variables -> {
        ValueTypeString.ValueString pattern = variables.getValue(0, ValueTypes.STRING);
        ValueTypeString.ValueString replacement = variables.getValue(1, ValueTypes.STRING);
        ValueTypeString.ValueString str = variables.getValue(2, ValueTypes.STRING);
        try {
            return ValueTypeString.ValueString.of(Pattern.compile(pattern.getRawValue()).matcher(str.getRawValue()).replaceAll(replacement.getRawValue()));
        }
        catch (PatternSyntaxException e) {
            throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.regex.invalid", (Object[])new Object[]{pattern.getRawValue()}));
        }
        catch (IndexOutOfBoundsException e) {
            throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.replace_regex.invalid_group", (Object[])new Object[]{replacement.getRawValue(), e.getMessage()}));
        }
    }).build());
    public static final IOperator STRING_JOIN = REGISTRY.register(OperatorBuilders.STRING.symbolOperatorInteract("join").renderPattern(IConfigRenderPattern.PREFIX_2).inputTypes(ValueTypes.STRING, ValueTypes.LIST).output(ValueTypes.STRING).function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeString.ValueString delimiter = variables.getValue(0, ValueTypes.STRING);
            ValueTypeList.ValueList elements = variables.getValue(1, ValueTypes.LIST);
            if (!ValueHelpers.correspondsTo(elements.getRawValue().getValueType(), ValueTypes.STRING)) {
                throw new EvaluationException(Component.m_237110_((String)"valuetype.integrateddynamics.error.invalid_list_value_type", (Object[])new Object[]{Component.m_237115_((String)elements.getRawValue().getValueType().getTranslationKey()), Component.m_237115_((String)ValueTypes.STRING.getTranslationKey())}));
            }
            if (elements.getRawValue().isInfinite()) {
                throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.infinite_list.illegal", (Object[])new Object[]{STRING_JOIN.getLocalizedNameFull()}));
            }
            StringBuilder sb = new StringBuilder();
            for (IValue value : elements.getRawValue()) {
                if (value.getType() != ValueTypes.STRING) {
                    throw new EvaluationException(Component.m_237110_((String)"valuetype.integrateddynamics.error.invalid_list_value_type", (Object[])new Object[]{Component.m_237115_((String)value.getType().getTranslationKey()), Component.m_237115_((String)ValueTypes.STRING.getTranslationKey())}));
                }
                if (sb.length() > 0) {
                    sb.append(delimiter.getRawValue());
                }
                sb.append(((ValueTypeString.ValueString)value).getRawValue());
            }
            return ValueTypeString.ValueString.of(sb.toString());
        }
    }).build());
    public static final IOperator NAMED_NAME = REGISTRY.register(OperatorBuilders.STRING_2.symbolOperatorInteract("name").inputType(ValueTypes.CATEGORY_NAMED).renderPattern(IConfigRenderPattern.SUFFIX_1_LONG).function(variables -> ValueTypeString.ValueString.of(ValueTypes.CATEGORY_NAMED.getName(variables.getVariables()[0]))).build());
    public static final IOperator UNIQUELYNAMED_UNIQUENAME = REGISTRY.register(OperatorBuilders.STRING_2.symbol("uname").operatorName("unique_name").interactName("uniqueName").inputType(ValueTypes.CATEGORY_UNIQUELY_NAMED).renderPattern(IConfigRenderPattern.SUFFIX_1_LONG).function(variables -> ValueTypeString.ValueString.of(ValueTypes.CATEGORY_UNIQUELY_NAMED.getUniqueName(variables.getVariables()[0]))).build());
    public static final IOperator NUMBER_ROUND = REGISTRY.register(OperatorBuilders.NUMBER_1_PREFIX.inputType(ValueTypes.CATEGORY_NUMBER).output(ValueTypes.INTEGER).symbol("|| ||").operatorInteract("round").function(variables -> ValueTypes.CATEGORY_NUMBER.round(variables.getVariables()[0])).build());
    public static final IOperator NUMBER_CEIL = REGISTRY.register(OperatorBuilders.NUMBER_1_PREFIX.inputType(ValueTypes.CATEGORY_NUMBER).output(ValueTypes.INTEGER).symbol("\u2308 \u2309").operatorInteract("ceil").function(variables -> ValueTypes.CATEGORY_NUMBER.ceil(variables.getVariables()[0])).build());
    public static final IOperator NUMBER_FLOOR = REGISTRY.register(OperatorBuilders.NUMBER_1_PREFIX.inputType(ValueTypes.CATEGORY_NUMBER).output(ValueTypes.INTEGER).symbol("\u230a \u230b").operatorInteract("floor").function(variables -> ValueTypes.CATEGORY_NUMBER.floor(variables.getVariables()[0])).build());
    public static final IOperator NUMBER_COMPACT = REGISTRY.register(OperatorBuilders.NUMBER_1_LONG.inputType(ValueTypes.CATEGORY_NUMBER).output(ValueTypes.STRING).symbolOperatorInteract("compact").function(variables -> ValueTypes.CATEGORY_NUMBER.compact(variables.getVariables()[0])).build());
    public static final IOperator NULLABLE_ISNULL = REGISTRY.register(OperatorBuilders.NULLABLE_1_PREFIX.symbol("o").operatorName("isnull").interactName("isNull").inputType(ValueTypes.CATEGORY_ANY).output(ValueTypes.BOOLEAN).function(variables -> {
        if (ValueHelpers.correspondsTo(variables.getVariables()[0].getType(), ValueTypes.CATEGORY_NULLABLE)) {
            return ValueTypeBoolean.ValueBoolean.of(ValueTypes.CATEGORY_NULLABLE.isNull(variables.getVariables()[0]));
        }
        return ValueTypeBoolean.ValueBoolean.of(false);
    }).build());
    public static final IOperator NULLABLE_ISNOTNULL = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_NOT).apply(NULLABLE_ISNULL).build("\u2205", "isnotnull", "isNotNull", IConfigRenderPattern.PREFIX_1, "general"));
    public static final IOperator LIST_LENGTH = REGISTRY.register(OperatorBuilders.LIST_1_PREFIX.output(ValueTypes.INTEGER).symbol("| |").operatorInteract("length").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy a = valueList.getRawValue();
        return ValueTypeInteger.ValueInteger.of(a.getLength());
    }).build());
    public static final IOperator LIST_EMPTY = REGISTRY.register(OperatorBuilders.LIST_1_PREFIX.output(ValueTypes.BOOLEAN).symbol("\u2205").operatorName("empty").interactName("isEmpty").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy a = valueList.getRawValue();
        return ValueTypeBoolean.ValueBoolean.of(a.getLength() == 0);
    }).build());
    public static final IOperator LIST_NOT_EMPTY = REGISTRY.register(new CompositionalOperator.AppliedOperatorBuilder(LOGICAL_NOT).apply(LIST_EMPTY).build("o", "notempty", "isNotEmpty", IConfigRenderPattern.PREFIX_1, "list"));
    public static final IOperator LIST_ELEMENT = REGISTRY.register(OperatorBuilders.LIST_1_PREFIX.inputTypes(ValueTypes.LIST, ValueTypes.INTEGER).output(ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.INFIX).symbolOperatorInteract("get").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy a = valueList.getRawValue();
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        if (b.getRawValue() < a.getLength() && b.getRawValue() >= 0) {
            return a.get(b.getRawValue());
        }
        throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.index_out_of_bounds", (Object[])new Object[]{b.getRawValue(), a.getLength()}));
    }).conditionalOutputTypeDeriver((operator, input) -> {
        try {
            IValueTypeListProxy a = ((ValueTypeList.ValueList)input[0].getValue()).getRawValue();
            return a.getValueType();
        }
        catch (ClassCastException | EvaluationException e) {
            return operator.getOutputType();
        }
    }).build());
    public static final IOperator LIST_ELEMENT_DEFAULT = REGISTRY.register(OperatorBuilders.LIST_1_PREFIX.inputTypes(ValueTypes.LIST, ValueTypes.INTEGER, ValueTypes.CATEGORY_ANY).output(ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.INFIX_2_LONG).symbolOperator("get_or_default").interactName("getOrDefault").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy a = valueList.getRawValue();
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        if (b.getRawValue() < a.getLength() && b.getRawValue() >= 0) {
            return a.get(b.getRawValue());
        }
        if (!ValueHelpers.correspondsTo(a.getValueType(), variables.getVariables()[2].getType())) {
            throw new EvaluationException(Component.m_237110_((String)"valuetype.integrateddynamics.error.invalid_list_value_type", (Object[])new Object[]{Component.m_237115_((String)a.getValueType().getTranslationKey()), Component.m_237115_((String)variables.getVariables()[2].getType().getTranslationKey())}));
        }
        return variables.getValue(2);
    }).conditionalOutputTypeDeriver((operator, input) -> input[2].getType()).build());
    public static final IOperator LIST_CONTAINS = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.PREFIX_2_LONG).output(ValueTypes.BOOLEAN).symbolOperatorInteract("contains").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy list = valueList.getRawValue();
        IValue input = variables.getValue(1);
        for (IValue value : list) {
            if (!value.equals(input)) continue;
            return ValueTypeBoolean.ValueBoolean.of(true);
        }
        return ValueTypeBoolean.ValueBoolean.of(false);
    }).build());
    public static final IOperator LIST_CONTAINS_PREDICATE = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.OPERATOR).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.BOOLEAN).symbolOperator("contains_p").interactName("containsPredicate").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy list = valueList.getRawValue();
        IOperator operator = OperatorBuilders.getSafePredictate(variables.getValue(1, ValueTypes.OPERATOR));
        for (IValue value : list) {
            IValue result = ValueHelpers.evaluateOperator(operator, value);
            ValueHelpers.validatePredicateOutput(operator, result);
            if (!((ValueTypeBoolean.ValueBoolean)result).getRawValue()) continue;
            return ValueTypeBoolean.ValueBoolean.of(true);
        }
        return ValueTypeBoolean.ValueBoolean.of(false);
    }).build());
    public static final IOperator LIST_COUNT = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.INTEGER).symbolOperatorInteract("count").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
            IValueTypeListProxy list = valueList.getRawValue();
            if (list.isInfinite()) {
                throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.infinite_list.illegal", (Object[])new Object[]{LIST_COUNT.getLocalizedNameFull()}));
            }
            IValue value = variables.getValue(1);
            int count = 0;
            for (IValue listValue : list) {
                if (!listValue.equals(value)) continue;
                ++count;
            }
            return ValueTypeInteger.ValueInteger.of(count);
        }
    }).build());
    public static final IOperator LIST_COUNT_PREDICATE = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.OPERATOR).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.INTEGER).symbolOperator("count_p").interactName("countPredicate").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
            IValueTypeListProxy list = valueList.getRawValue();
            if (list.isInfinite()) {
                throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.infinite_list.illegal", (Object[])new Object[]{LIST_COUNT_PREDICATE.getLocalizedNameFull()}));
            }
            IOperator operator = OperatorBuilders.getSafePredictate(variables.getValue(1, ValueTypes.OPERATOR));
            int count = 0;
            for (IValue listValue : list) {
                IValue result = ValueHelpers.evaluateOperator(operator, listValue);
                ValueHelpers.validatePredicateOutput(operator, result);
                if (!((ValueTypeBoolean.ValueBoolean)result).getRawValue()) continue;
                ++count;
            }
            return ValueTypeInteger.ValueInteger.of(count);
        }
    }).build());
    public static final IOperator LIST_APPEND = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.LIST).symbolOperatorInteract("append").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy a = valueList.getRawValue();
        IValue value = variables.getValue(1);
        if (!ValueHelpers.correspondsTo(a.getValueType(), value.getType())) {
            throw new EvaluationException(Component.m_237110_((String)"valuetype.integrateddynamics.error.invalid_list_value_type", (Object[])new Object[]{Component.m_237115_((String)a.getValueType().getTranslationKey()), Component.m_237115_((String)value.getType().getTranslationKey())}));
        }
        return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyAppend(a, value));
    }).build());
    public static final IOperator LIST_CONCAT = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.LIST).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.LIST).symbolOperatorInteract("concat").function(variables -> {
        ValueTypeList.ValueList valueList0 = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy a = valueList0.getRawValue();
        ValueTypeList.ValueList valueList1 = variables.getValue(1, ValueTypes.LIST);
        IValueTypeListProxy b = valueList1.getRawValue();
        if (!ValueHelpers.correspondsTo(a.getValueType(), b.getValueType())) {
            throw new EvaluationException(Component.m_237110_((String)"valuetype.integrateddynamics.error.invalid_list_value_type", (Object[])new Object[]{Component.m_237115_((String)a.getValueType().getTranslationKey()), Component.m_237115_((String)b.getValueType().getTranslationKey())}));
        }
        return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyConcat(a, b));
    }).build());
    public static final IOperator LIST_LAZYBUILT = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.CATEGORY_ANY, ValueTypes.OPERATOR).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.LIST).symbolOperator("lazybuilt").interactName("lazyBuilt").function(variables -> {
        IValue a = variables.getValue(0);
        IOperator operator = OperatorBuilders.getSafeOperator(variables.getValue(1, ValueTypes.OPERATOR), a.getType());
        return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyLazyBuilt(a, operator));
    }).build());
    public static final IOperator LIST_HEAD = REGISTRY.register(OperatorBuilders.LIST_1_PREFIX.inputTypes(ValueTypes.LIST).output(ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.PREFIX_1_LONG).symbolOperatorInteract("head").function(variables -> {
        ValueTypeList.ValueList list = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy a = list.getRawValue();
        if (a.getLength() > 0) {
            return a.get(0);
        }
        throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.index_out_of_bounds", (Object[])new Object[]{0, a.getLength()}));
    }).conditionalOutputTypeDeriver((operator, input) -> {
        try {
            IValueTypeListProxy a = ((ValueTypeList.ValueList)input[0].getValue()).getRawValue();
            return a.getValueType();
        }
        catch (EvaluationException e) {
            return operator.getOutputType();
        }
    }).build());
    public static final IOperator LIST_TAIL = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST).renderPattern(IConfigRenderPattern.PREFIX_1_LONG).output(ValueTypes.LIST).symbolOperatorInteract("tail").function(variables -> {
        ValueTypeList.ValueList list = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy a = list.getRawValue();
        return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyTail(a));
    }).build());
    public static final IOperator LIST_UNIQ_PREDICATE = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.OPERATOR).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.LIST).symbolOperator("uniq_p").interactName("uniquePredicate").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy list = valueList.getRawValue();
        IOperator operator = OperatorBuilders.getSafePredictate(variables.getValue(1, ValueTypes.OPERATOR));
        ArrayList<IValue> values = new ArrayList<IValue>();
        block2: for (IValue value : list) {
            for (IValue existing : values) {
                IValue result = ValueHelpers.evaluateOperator(operator, value, existing);
                ValueHelpers.validatePredicateOutput(operator, result);
                if (!((ValueTypeBoolean.ValueBoolean)result).getRawValue()) continue;
                continue block2;
            }
            values.add(value);
        }
        return ValueTypeList.ValueList.ofList(list.getValueType(), values);
    }).build());
    public static final IOperator LIST_UNIQ = REGISTRY.register(OperatorBuilders.LIST.inputType(ValueTypes.LIST).renderPattern(IConfigRenderPattern.PREFIX_1_LONG).output(ValueTypes.LIST).symbolOperator("uniq").interactName("unique").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy list = valueList.getRawValue();
        return ValueTypeList.ValueList.ofList(list.getValueType(), new ArrayList(Sets.newLinkedHashSet(list)));
    }).build());
    public static final IOperator LIST_SLICE = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.INTEGER, ValueTypes.INTEGER).renderPattern(IConfigRenderPattern.PREFIX_3).output(ValueTypes.LIST).symbolOperatorInteract("slice").function(variables -> {
        ValueTypeList.ValueList valueList = variables.getValue(0, ValueTypes.LIST);
        IValueTypeListProxy list = valueList.getRawValue();
        ValueTypeInteger.ValueInteger from = variables.getValue(1, ValueTypes.INTEGER);
        ValueTypeInteger.ValueInteger to = variables.getValue(2, ValueTypes.INTEGER);
        if (from.getRawValue() >= to.getRawValue()) {
            throw new EvaluationException(Component.m_237115_((String)"operator.integrateddynamics.error.slice.to_greater_than_from"));
        }
        if (from.getRawValue() < 0 || to.getRawValue() < 0) {
            throw new EvaluationException(Component.m_237115_((String)"operator.integrateddynamics.error.slice.index_negative"));
        }
        return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxySlice(list, from.getRawValue(), to.getRawValue()));
    }).build());
    public static final IOperator LIST_INTERSECTION = REGISTRY.register(OperatorBuilders.LIST.inputTypes(ValueTypes.LIST, ValueTypes.LIST).renderPattern(IConfigRenderPattern.INFIX).output(ValueTypes.LIST).symbol("\u2229").operatorInteract("intersection").function(new OperatorBase.IFunction(){

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValueTypeListProxy rawList1 = variables.getValue(0, ValueTypes.LIST).getRawValue();
            IValueTypeListProxy rawList2 = variables.getValue(1, ValueTypes.LIST).getRawValue();
            if (rawList1.isInfinite() || rawList2.isInfinite()) {
                throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.infinite_list.illegal", (Object[])new Object[]{LIST_INTERSECTION.getLocalizedNameFull()}));
            }
            LinkedHashSet result = Sets.newLinkedHashSet(rawList1);
            result.retainAll(Sets.newLinkedHashSet(rawList2));
            return ValueTypeList.ValueList.ofList(rawList1.getValueType(), result.stream().toList());
        }
    }).build());
    public static final IOperator OBJECT_BLOCK_OPAQUE = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("opaque").interactName("isOpaque").function(variables -> {
        ValueObjectTypeBlock.ValueBlock a = variables.getValue(0, ValueTypes.OBJECT_BLOCK);
        return ValueTypeBoolean.ValueBoolean.of(a.getRawValue().isPresent() && ((BlockState)a.getRawValue().get()).m_60804_(null, null));
    }).build());
    public static final IOperator OBJECT_BLOCK_ITEMSTACK = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ITEMSTACK).symbolOperator("itemstack").interactName("itemStack").function(variables -> {
        ValueObjectTypeBlock.ValueBlock a = variables.getValue(0, ValueTypes.OBJECT_BLOCK);
        return ValueObjectTypeItemStack.ValueItemStack.of(a.getRawValue().isPresent() ? BlockHelpers.getItemStackFromBlockState((BlockState)((BlockState)a.getRawValue().get())) : ItemStack.f_41583_);
    }).build());
    public static final IOperator OBJECT_BLOCK_MODNAME = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperatorInteract("mod").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{variables -> {
        ValueObjectTypeBlock.ValueBlock a = variables.getValue(0, ValueTypes.OBJECT_BLOCK);
        return a.getRawValue().isPresent() ? ForgeRegistries.BLOCKS.getKey((Object)((BlockState)a.getRawValue().get()).m_60734_()) : new ResourceLocation("");
    }, OperatorBuilders.PROPAGATOR_RESOURCELOCATION_MODNAME}))).build());
    public static final IOperator OBJECT_BLOCK_BREAKSOUND = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbol("break_sound").operatorName("breaksound").interactName("breakSound").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{OperatorBuilders.BLOCK_SOUND, sound -> sound.isPresent() ? ((SoundType)sound.get()).m_56775_().f_11656_.toString() : "", OperatorBuilders.PROPAGATOR_STRING_VALUE}))).build());
    public static final IOperator OBJECT_BLOCK_PLACESOUND = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbol("place_sound").operatorName("placesound").interactName("placeSound").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{OperatorBuilders.BLOCK_SOUND, sound -> sound.isPresent() ? ((SoundType)sound.get()).m_56777_().f_11656_.toString() : "", OperatorBuilders.PROPAGATOR_STRING_VALUE}))).build());
    public static final IOperator OBJECT_BLOCK_STEPSOUND = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbol("step_sound").operatorName("stepsound").interactName("stepSound").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{OperatorBuilders.BLOCK_SOUND, sound -> sound.isPresent() ? ((SoundType)sound.get()).m_56776_().f_11656_.toString() : "", OperatorBuilders.PROPAGATOR_STRING_VALUE}))).build());
    public static final IOperator OBJECT_BLOCK_ISSHEARABLE = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_shearable").operatorName("isshearable").interactName("isShearable").function(variables -> {
        ValueObjectTypeBlock.ValueBlock a = variables.getValue(0, ValueTypes.OBJECT_BLOCK);
        return ValueTypeBoolean.ValueBoolean.of(a.getRawValue().isPresent() && ((BlockState)a.getRawValue().get()).m_60734_() instanceof IForgeShearable && ((IForgeShearable)((BlockState)a.getRawValue().get()).m_60734_()).isShearable(ItemStack.f_41583_, null, null));
    }).build());
    public static final IOperator OBJECT_BLOCK_ISPLANTABLE = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_plantable").operatorName("isplantable").interactName("isPlantable").function(variables -> {
        ValueObjectTypeBlock.ValueBlock a = variables.getValue(0, ValueTypes.OBJECT_BLOCK);
        return ValueTypeBoolean.ValueBoolean.of(a.getRawValue().isPresent() && ((BlockState)a.getRawValue().get()).m_60734_() instanceof IPlantable);
    }).build());
    public static final IOperator OBJECT_BLOCK_PLANTTYPE = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbol("plant_type").operatorName("planttype").interactName("plantType").function(variables -> {
        ValueObjectTypeBlock.ValueBlock a = variables.getValue(0, ValueTypes.OBJECT_BLOCK);
        String type = "none";
        if (a.getRawValue().isPresent() && ((BlockState)a.getRawValue().get()).m_60734_() instanceof IPlantable) {
            type = ((IPlantable)((BlockState)a.getRawValue().get()).m_60734_()).getPlantType(null, null).getName();
        }
        return ValueTypeString.ValueString.of(type);
    }).build());
    public static final IOperator OBJECT_BLOCK_PLANT = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_BLOCK).symbolOperator("plant").interactName("plant").function(variables -> {
        ValueObjectTypeBlock.ValueBlock a = variables.getValue(0, ValueTypes.OBJECT_BLOCK);
        BlockState plant = null;
        if (a.getRawValue().isPresent() && ((BlockState)a.getRawValue().get()).m_60734_() instanceof IPlantable) {
            plant = ((IPlantable)((BlockState)a.getRawValue().get()).m_60734_()).getPlant(null, null);
        }
        return ValueObjectTypeBlock.ValueBlock.of(plant);
    }).build());
    public static final IOperator OBJECT_BLOCK_PLANTAGE = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("plant_age").operatorName("plantage").interactName("plantAge").function(variables -> {
        ValueObjectTypeBlock.ValueBlock a = variables.getValue(0, ValueTypes.OBJECT_BLOCK);
        int age = 0;
        if (a.getRawValue().isPresent()) {
            for (Property prop : ((BlockState)a.getRawValue().get()).m_61147_()) {
                if (!prop.m_61708_().equals("age") || prop.m_61709_() != Integer.class) continue;
                age = (Integer)((BlockState)a.getRawValue().get()).m_61143_(prop);
            }
        }
        return ValueTypeInteger.ValueInteger.of(age);
    }).build());
    public static final IOperator OBJECT_BLOCK_BY_NAME = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.inputType(ValueTypes.STRING).output(ValueTypes.OBJECT_BLOCK).symbol("block_by_name").operatorName("blockbyname").interactName("blockByName").function(OperatorBuilders.FUNCTION_STRING_TO_RESOURCE_LOCATION.build(input -> {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(input);
        return ValueObjectTypeBlock.ValueBlock.of(block.m_49966_());
    })).build());
    public static final IOperator OBJECT_BLOCK_PROPERTIES = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.NBT).symbol("block_props").operatorName("blockproperties").interactName("properties").function(variables -> {
        ValueObjectTypeBlock.ValueBlock a = variables.getValue(0, ValueTypes.OBJECT_BLOCK);
        return ValueTypeNbt.ValueNbt.of(a.getRawValue().map(blockState -> {
            CompoundTag tag = new CompoundTag();
            for (Property property : blockState.m_61147_()) {
                Comparable value = blockState.m_61143_(property);
                tag.m_128359_(property.m_61708_(), property.m_6940_(value));
            }
            return tag;
        }));
    }).build());
    public static final IOperator OBJECT_BLOCK_WITH_PROPERTIES = REGISTRY.register(OperatorBuilders.BLOCK_INFIX_VERYLONG.inputTypes(ValueTypes.OBJECT_BLOCK, ValueTypes.NBT).output(ValueTypes.OBJECT_BLOCK).symbol("block_with_props").operatorName("blockfromproperties").interactName("withProperties").function(variables -> {
        ValueObjectTypeBlock.ValueBlock a = variables.getValue(0, ValueTypes.OBJECT_BLOCK);
        ValueTypeNbt.ValueNbt b = variables.getValue(1, ValueTypes.NBT);
        if (a.getRawValue().isPresent() && a.getRawValue().isPresent()) {
            BlockState blockState = (BlockState)a.getRawValue().get();
            Tag tagRaw = (Tag)b.getRawValue().get();
            if (tagRaw instanceof CompoundTag) {
                CompoundTag tag = (CompoundTag)tagRaw;
                for (Property property : blockState.m_61147_()) {
                    Optional valueOptional;
                    if (!tag.m_128425_(property.m_61708_(), 8) || !(valueOptional = property.m_6215_(tag.m_128461_(property.m_61708_()))).isPresent()) continue;
                    blockState = (BlockState)blockState.m_61124_(property, (Comparable)valueOptional.get());
                }
                return ValueObjectTypeBlock.ValueBlock.of(blockState);
            }
        }
        return a;
    }).build());
    public static final IOperator OBJECT_BLOCK_POSSIBLE_PROPERTIES = REGISTRY.register(OperatorBuilders.BLOCK_1_SUFFIX_LONG.output(ValueTypes.NBT).symbol("block_all_props").operatorName("blockpossibleproperties").interactName("possibleProperties").function(variables -> {
        ValueObjectTypeBlock.ValueBlock a = variables.getValue(0, ValueTypes.OBJECT_BLOCK);
        return ValueTypeNbt.ValueNbt.of(a.getRawValue().map(blockState -> {
            CompoundTag tag = new CompoundTag();
            for (Property property : blockState.m_61147_()) {
                ListTag list = new ListTag();
                for (Comparable value : property.m_6908_()) {
                    list.add((Object)StringTag.m_129297_((String)property.m_6940_(value)));
                }
                tag.m_128365_(property.m_61708_(), (Tag)list);
            }
            return tag;
        }));
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_SIZE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("size").interactName("size").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(itemStack -> !itemStack.m_41619_() ? itemStack.m_41613_() : 0)).build());
    public static final IOperator OBJECT_ITEMSTACK_MAXSIZE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("maxsize").interactName("maxSize").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(itemStack -> !itemStack.m_41619_() ? itemStack.m_41741_() : 0)).build());
    public static final IOperator OBJECT_ITEMSTACK_ISSTACKABLE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("stackable").interactName("isStackable").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(itemStack -> !itemStack.m_41619_() && itemStack.m_41753_())).build());
    public static final IOperator OBJECT_ITEMSTACK_ISDAMAGEABLE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("damageable").interactName("isDamageable").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(itemStack -> !itemStack.m_41619_() && itemStack.m_41763_())).build());
    public static final IOperator OBJECT_ITEMSTACK_DAMAGE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("damage").interactName("damage").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(itemStack -> !itemStack.m_41619_() ? itemStack.m_41773_() : 0)).build());
    public static final IOperator OBJECT_ITEMSTACK_MAXDAMAGE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("max_damage").operatorName("maxdamage").interactName("maxDamage").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(itemStack -> !itemStack.m_41619_() ? itemStack.m_41776_() : 0)).build());
    public static final IOperator OBJECT_ITEMSTACK_ISENCHANTED = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("enchanted").interactName("isEnchanted").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(itemStack -> !itemStack.m_41619_() && itemStack.m_41793_())).build());
    public static final IOperator OBJECT_ITEMSTACK_ISENCHANTABLE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("enchantable").interactName("isEnchantable").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(itemStack -> !itemStack.m_41619_() && itemStack.m_41792_())).build());
    public static final IOperator OBJECT_ITEMSTACK_REPAIRCOST = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("repair_cost").operatorName("repaircost").interactName("repairCost").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(itemStack -> !itemStack.m_41619_() ? itemStack.m_41610_() : 0)).build());
    public static final IOperator OBJECT_ITEMSTACK_RARITY = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperatorInteract("rarity").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        return ValueTypeString.ValueString.of(!a.getRawValue().m_41619_() ? a.getRawValue().m_41791_().name() : "");
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_STRENGTH_VS_BLOCK = REGISTRY.register(OperatorBuilders.ITEMSTACK_2.inputTypes(ValueTypes.OBJECT_ITEMSTACK, ValueTypes.OBJECT_BLOCK).output(ValueTypes.DOUBLE).symbolOperatorInteract("strength").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        ValueObjectTypeBlock.ValueBlock b = variables.getValue(1, ValueTypes.OBJECT_BLOCK);
        return ValueTypeDouble.ValueDouble.of(!a.getRawValue().m_41619_() && b.getRawValue().isPresent() ? (double)a.getRawValue().m_41691_((BlockState)b.getRawValue().get()) : 0.0);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_CAN_HARVEST_BLOCK = REGISTRY.register(OperatorBuilders.ITEMSTACK_2_LONG.inputTypes(ValueTypes.OBJECT_ITEMSTACK, ValueTypes.OBJECT_BLOCK).output(ValueTypes.BOOLEAN).symbol("can_harvest").operatorName("canharvest").interactName("canHarvest").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        ValueObjectTypeBlock.ValueBlock b = variables.getValue(1, ValueTypes.OBJECT_BLOCK);
        return ValueTypeBoolean.ValueBoolean.of(!a.getRawValue().m_41619_() && b.getRawValue().isPresent() && a.getRawValue().m_41735_((BlockState)b.getRawValue().get()));
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_BLOCK = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_BLOCK).symbolOperatorInteract("block").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        return ValueObjectTypeBlock.ValueBlock.of(!a.getRawValue().m_41619_() && a.getRawValue().m_41720_() instanceof BlockItem ? BlockHelpers.getBlockStateFromItemStack((ItemStack)a.getRawValue()) : null);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_ISFLUIDSTACK = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_fluidstack").operatorName("isfluidstack").interactName("isFluidStack").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(itemStack -> !itemStack.m_41619_() && !Helpers.getFluidStack(itemStack).isEmpty())).build());
    public static final IOperator OBJECT_ITEMSTACK_FLUIDSTACK = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_FLUIDSTACK).symbolOperator("fluidstack").interactName("fluidStack").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        return ValueObjectTypeFluidStack.ValueFluidStack.of(!a.getRawValue().m_41619_() ? Helpers.getFluidStack(a.getRawValue()) : null);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_FLUIDSTACKCAPACITY = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("fluidstack_capacity").operatorName("fluidstackcapacity").interactName("fluidCapacity").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(itemStack -> !itemStack.m_41619_() ? Helpers.getFluidStackCapacity(itemStack) : 0)).build());
    public static final IOperator OBJECT_ITEMSTACK_ISNBTEQUAL = REGISTRY.register(OperatorBuilders.ITEMSTACK_2.output(ValueTypes.BOOLEAN).symbol("=NBT=").operatorName("isnbtequal").interactName("isNbtEqual").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack valueStack0 = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        ValueObjectTypeItemStack.ValueItemStack valueStack1 = variables.getValue(1, ValueTypes.OBJECT_ITEMSTACK);
        ItemStack a = valueStack0.getRawValue();
        ItemStack b = valueStack1.getRawValue();
        boolean equal = false;
        if (!a.m_41619_() && !b.m_41619_()) {
            equal = ItemStack.m_41656_((ItemStack)a, (ItemStack)b) && ItemMatch.areItemStacksEqual((ItemStack)a, (ItemStack)b, (int)4);
        } else if (a.m_41619_() && b.m_41619_()) {
            equal = true;
        }
        return ValueTypeBoolean.ValueBoolean.of(equal);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_ISITEMEQUALNONBT = REGISTRY.register(OperatorBuilders.ITEMSTACK_2.output(ValueTypes.BOOLEAN).symbol("=NoNBT=").operatorName("isitemequalnonbt").interactName("isEqualNonNbt").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack valueStack0 = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        ValueObjectTypeItemStack.ValueItemStack valueStack1 = variables.getValue(1, ValueTypes.OBJECT_ITEMSTACK);
        ItemStack a = valueStack0.getRawValue();
        ItemStack b = valueStack1.getRawValue();
        boolean equal = false;
        if (!a.m_41619_() && !b.m_41619_()) {
            equal = ItemMatch.areItemStacksEqual((ItemStack)a, (ItemStack)b, (int)1);
        } else if (a.m_41619_() && b.m_41619_()) {
            equal = true;
        }
        return ValueTypeBoolean.ValueBoolean.of(equal);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_ISRAWITEMEQUAL = REGISTRY.register(OperatorBuilders.ITEMSTACK_2.output(ValueTypes.BOOLEAN).symbol("=Raw=").operatorName("israwitemequal").interactName("isEqualRaw").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack valueStack0 = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        ValueObjectTypeItemStack.ValueItemStack valueStack1 = variables.getValue(1, ValueTypes.OBJECT_ITEMSTACK);
        ItemStack a = valueStack0.getRawValue();
        ItemStack b = valueStack1.getRawValue();
        boolean equal = false;
        if (!a.m_41619_() && !b.m_41619_()) {
            equal = ItemMatch.areItemStacksEqual((ItemStack)a, (ItemStack)b, (int)1);
        } else if (a.m_41619_() && b.m_41619_()) {
            equal = true;
        }
        return ValueTypeBoolean.ValueBoolean.of(equal);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_MODNAME = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperatorInteract("mod").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        return !a.getRawValue().m_41619_() ? ForgeRegistries.ITEMS.getKey((Object)a.getRawValue().m_41720_()) : new ResourceLocation("");
    }, OperatorBuilders.PROPAGATOR_RESOURCELOCATION_MODNAME}))).build());
    public static final IOperator OBJECT_ITEMSTACK_FUELBURNTIME = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("burn_time").operatorName("burntime").interactName("burnTime").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_INT.build(itemStack -> {
        if (!itemStack.m_41619_()) {
            int burnTime = itemStack.getBurnTime(null);
            return ForgeEventFactory.getItemBurnTime((ItemStack)itemStack, (int)(burnTime == -1 ? ForgeHooks.getBurnTime((ItemStack)itemStack, null) : burnTime), null);
        }
        return 0;
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_CANBURN = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("can_burn").operatorName("canburn").interactName("canBurn").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(AbstractFurnaceBlockEntity::m_58399_)).build());
    public static final IOperator OBJECT_ITEMSTACK_TAG = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.LIST).symbol("tag_names").operatorName("tag").interactName("tags").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!a.getRawValue().m_41619_()) {
            Optional optionalReverseTag = ForgeRegistries.ITEMS.tags().getReverseTag((Object)a.getRawValue().m_41720_());
            optionalReverseTag.ifPresent(reverseTag -> reverseTag.getTagKeys().forEach(owningTag -> builder.add((Object)ValueTypeString.ValueString.of(owningTag.f_203868_().toString()))));
        }
        return ValueTypeList.ValueList.ofList(ValueTypes.STRING, builder.build());
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_TAG_STACKS = REGISTRY.register(OperatorBuilders.STRING_1_PREFIX.output(ValueTypes.LIST).symbol("tag_values").operatorName("tag").interactName("itemsByTag").inputType(ValueTypes.STRING).renderPattern(IConfigRenderPattern.SUFFIX_1_LONG).function(variables -> {
        ValueTypeString.ValueString a = variables.getValue(0, ValueTypes.STRING);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!StringUtil.m_14408_((String)a.getRawValue())) {
            try {
                Helpers.getTagValues(a.getRawValue()).map(ValueObjectTypeItemStack.ValueItemStack::of).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            }
            catch (ResourceLocationException e) {
                throw new EvaluationException(Component.m_237115_((String)e.getMessage()));
            }
        }
        return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, builder.build());
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_WITHSIZE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_INTEGER_1.output(ValueTypes.OBJECT_ITEMSTACK).symbol("with_size").operatorName("withsize").interactName("withSize").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        ValueTypeInteger.ValueInteger b = variables.getValue(1, ValueTypes.INTEGER);
        if (!a.getRawValue().m_41619_()) {
            ItemStack itemStack = a.getRawValue().m_41777_();
            itemStack.m_41764_(b.getRawValue());
            return ValueObjectTypeItemStack.ValueItemStack.of(itemStack);
        }
        return a;
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_ISFECONTAINER = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_fe_container").operatorName("isfecontainer").interactName("isFeContainer").function(OperatorBuilders.FUNCTION_CONTAINERITEM_TO_BOOLEAN.build(Objects::nonNull)).build());
    public static final IOperator OBJECT_ITEMSTACK_STOREDFE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("stored_fe").operatorName("storedfe").interactName("feStored").function(OperatorBuilders.FUNCTION_CONTAINERITEM_TO_INT.build(input -> input != null ? input.getEnergyStored() : 0)).build());
    public static final IOperator OBJECT_ITEMSTACK_FECAPACITY = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("capacity_fe").operatorName("fecapacity").interactName("feCapacity").function(OperatorBuilders.FUNCTION_CONTAINERITEM_TO_INT.build(input -> input != null ? input.getMaxEnergyStored() : 0)).build());
    public static final IOperator OBJECT_ITEMSTACK_HASINVENTORY = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("has_inventory").operatorName("hasinventory").interactName("hasInventory").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        return ValueTypeBoolean.ValueBoolean.of(!a.getRawValue().m_41619_() && a.getRawValue().getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent());
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_ISPLANTABLE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_plantable").operatorName("isplantable").interactName("isPlantable").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        return ValueTypeBoolean.ValueBoolean.of(!a.getRawValue().m_41619_() && a.getRawValue().m_41720_() instanceof BlockItem && ((BlockItem)a.getRawValue().m_41720_()).m_40614_() instanceof IPlantable);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_INVENTORYSIZE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("inventory_size").operatorName("inventorysize").interactName("inventorySize").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        return ValueTypeInteger.ValueInteger.of(a.getRawValue().getCapability(ForgeCapabilities.ITEM_HANDLER).map(IItemHandler::getSlots).orElse(0));
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_PLANTTYPE = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbol("plant_type").operatorName("planttype").interactName("plantType").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        String type = "none";
        if (!a.getRawValue().m_41619_() && a.getRawValue().m_41720_() instanceof BlockItem && ((BlockItem)a.getRawValue().m_41720_()).m_40614_() instanceof IPlantable) {
            type = ((IPlantable)((BlockItem)a.getRawValue().m_41720_()).m_40614_()).getPlantType(null, null).getName();
        }
        return ValueTypeString.ValueString.of(type);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_INVENTORY = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.LIST).symbolOperator("inventory").interactName("inventory").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        return a.getRawValue().getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(itemHandler -> {
            ArrayList values = Lists.newArrayListWithCapacity((int)itemHandler.getSlots());
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                values.add(ValueObjectTypeItemStack.ValueItemStack.of(itemHandler.getStackInSlot(i)));
            }
            return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, values);
        }).orElseGet(() -> ValueTypes.LIST.getDefault());
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_PLANT = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_BLOCK).symbolOperatorInteract("plant").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = variables.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        BlockState plant = null;
        if (!a.getRawValue().m_41619_() && a.getRawValue().m_41720_() instanceof BlockItem && ((BlockItem)a.getRawValue().m_41720_()).m_40614_() instanceof IPlantable) {
            plant = ((BlockItem)a.getRawValue().m_41720_()).m_40614_().m_49966_();
        }
        return ValueObjectTypeBlock.ValueBlock.of(plant);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_BY_NAME = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_PREFIX_LONG.inputType(ValueTypes.STRING).output(ValueTypes.OBJECT_ITEMSTACK).symbol("item_by_name").operatorName("itembyname").interactName("itemByName").function(OperatorBuilders.FUNCTION_STRING_TO_RESOURCE_LOCATION.build(input -> {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(input);
        ItemStack itemStack = ItemStack.f_41583_;
        if (item != null) {
            itemStack = new ItemStack((ItemLike)item);
        }
        return ValueObjectTypeItemStack.ValueItemStack.of(itemStack);
    })).build());
    public static final IOperator OBJECT_ITEMSTACK_LIST_COUNT = REGISTRY.register(OperatorBuilders.ITEMSTACK_2_LONG.inputTypes(ValueTypes.LIST, ValueTypes.OBJECT_ITEMSTACK).output(ValueTypes.INTEGER).symbol("item_list_count").operatorName("itemlistcount").interactName("itemListCount").function(variables -> {
        ValueTypeList.ValueList a = variables.getValue(0, ValueTypes.LIST);
        ValueObjectTypeItemStack.ValueItemStack b = variables.getValue(1, ValueTypes.OBJECT_ITEMSTACK);
        if (!ValueHelpers.correspondsTo(a.getRawValue().getValueType(), ValueTypes.OBJECT_ITEMSTACK)) {
            MutableComponent error = Component.m_237110_((String)"valuetype.integrateddynamics.error.invalid_list_value_type", (Object[])new Object[]{Component.m_237115_((String)a.getRawValue().getValueType().getTranslationKey()), Component.m_237115_((String)ValueTypes.OBJECT_ITEMSTACK.getTranslationKey())});
            throw new EvaluationException(error);
        }
        ItemStack itemStack = b.getRawValue();
        int count = 0;
        for (IValue listValueRaw : a.getRawValue()) {
            ValueObjectTypeItemStack.ValueItemStack listValue;
            if (!listValueRaw.getType().correspondsTo(ValueTypes.OBJECT_ITEMSTACK) || (listValue = (ValueObjectTypeItemStack.ValueItemStack)listValueRaw).getRawValue().m_41619_()) continue;
            ItemStack listItem = listValue.getRawValue();
            if (!itemStack.m_41619_()) {
                if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)listItem)) continue;
                count += listItem.m_41613_();
                continue;
            }
            count += listItem.m_41613_();
        }
        return ValueTypeInteger.ValueInteger.of(count);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_NBT = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.NBT).symbol("NBT()").operatorName("nbt").interactName("nbt").function(input -> {
        ValueObjectTypeItemStack.ValueItemStack itemStack = input.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        return ValueTypeNbt.ValueNbt.of((Tag)(itemStack.getRawValue().m_41619_() ? new CompoundTag() : itemStack.getRawValue().m_41783_()));
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_HASNBT = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_PREFIX_LONG.output(ValueTypes.BOOLEAN).symbol("has_nbt").operatorName("hasnbt").interactName("hasNbt").function(OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(itemStack -> !itemStack.m_41619_() && itemStack.m_41782_())).build());
    public static final IOperator OBJECT_ENTITY_ISMOB = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_mob").operatorName("ismob").interactName("isMob").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(entity -> entity instanceof Enemy)).build());
    public static final IOperator OBJECT_ENTITY_ISANIMAL = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_animal").operatorName("isanimal").interactName("isAnimal").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(entity -> entity instanceof Animal && !(entity instanceof Enemy))).build());
    public static final IOperator OBJECT_ENTITY_ISITEM = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_item").operatorName("isitem").interactName("isItem").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(entity -> entity instanceof ItemEntity)).build());
    public static final IOperator OBJECT_ENTITY_ISPLAYER = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_player").operatorName("isplayer").interactName("isPlayer").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(entity -> entity instanceof Player)).build());
    public static final IOperator OBJECT_ENTITY_ISMINECART = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_minecart").operatorName("isminecart").interactName("isMinecart").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(entity -> entity instanceof AbstractMinecart)).build());
    public static final IOperator OBJECT_ENTITY_ITEMSTACK = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX.output(ValueTypes.OBJECT_ITEMSTACK).symbolOperatorInteract("item").function(variables -> {
        ValueObjectTypeEntity.ValueEntity valueEntity = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        Optional<Entity> a = valueEntity.getRawValue();
        return ValueObjectTypeItemStack.ValueItemStack.of(a.isPresent() && a.get() instanceof ItemEntity ? ((ItemEntity)a.get()).m_32055_() : ItemStack.f_41583_);
    }).build());
    public static final IOperator OBJECT_ENTITY_HEALTH = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.DOUBLE).symbolOperatorInteract("health").function(OperatorBuilders.FUNCTION_ENTITY_TO_DOUBLE.build(entity -> entity instanceof LivingEntity ? (double)((LivingEntity)entity).m_21223_() : 0.0)).build());
    public static final IOperator OBJECT_ENTITY_WIDTH = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.DOUBLE).symbolOperatorInteract("width").function(OperatorBuilders.FUNCTION_ENTITY_TO_DOUBLE.build(entity -> entity != null ? (double)entity.m_20205_() : 0.0)).build());
    public static final IOperator OBJECT_ENTITY_HEIGHT = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.DOUBLE).symbolOperatorInteract("height").function(OperatorBuilders.FUNCTION_ENTITY_TO_DOUBLE.build(entity -> entity != null ? (double)entity.m_20206_() : 0.0)).build());
    public static final IOperator OBJECT_ENTITY_ISBURNING = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_burning").operatorName("isburning").interactName("entityIsBurning").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(entity -> entity != null && entity.m_6060_())).build());
    public static final IOperator OBJECT_ENTITY_ISWET = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_wet").operatorName("iswet").interactName("isWet").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(entity -> entity != null && entity.m_20070_())).build());
    public static final IOperator OBJECT_ENTITY_ISCROUCHING = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_crouching").operatorName("iscrouching").interactName("isCrouching").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(entity -> entity != null && entity.m_6047_())).build());
    public static final IOperator OBJECT_ENTITY_ISEATING = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_eating").operatorName("iseating").interactName("isEating").function(OperatorBuilders.FUNCTION_ENTITY_TO_BOOLEAN.build(entity -> entity instanceof LivingEntity && ((LivingEntity)entity).m_21212_() > 0)).build());
    public static final IOperator OBJECT_ENTITY_ARMORINVENTORY = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.LIST).symbol("armor_inventory").operatorName("armorinventory").interactName("armorInventory").function(variables -> {
        ValueObjectTypeEntity.ValueEntity valueEntity = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        Optional<Entity> a = valueEntity.getRawValue();
        if (a.isPresent()) {
            Entity entity = a.get();
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyEntityArmorInventory(entity.m_9236_(), entity));
        }
        return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, Collections.emptyList());
    }).build());
    public static final IOperator OBJECT_ENTITY_INVENTORY = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.LIST).symbolOperator("inventory").interactName("inventory").function(variables -> {
        ValueObjectTypeEntity.ValueEntity valueEntity = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        Optional<Entity> a = valueEntity.getRawValue();
        if (a.isPresent()) {
            Entity entity = a.get();
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyEntityInventory(entity.m_9236_(), entity));
        }
        return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, Collections.emptyList());
    }).build());
    public static final IOperator OBJECT_ENTITY_MODNAME = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperatorInteract("mod").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        if (a.getRawValue().isPresent()) {
            Entity entity = a.getRawValue().get();
            return ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        }
        return new ResourceLocation("");
    }, OperatorBuilders.PROPAGATOR_RESOURCELOCATION_MODNAME}))).build());
    public static final IOperator OBJECT_PLAYER_TARGETBLOCK = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_BLOCK).symbol("target_block").operatorName("targetblock").interactName("targetBlock").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        BlockState blockState = null;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)a.getRawValue().get();
            AttributeInstance reachDistanceAttribute = entity.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get());
            double reachDistance = reachDistanceAttribute == null ? 5.0 : reachDistanceAttribute.m_22135_();
            double eyeHeight = entity.m_20192_();
            Vec3 lookVec = entity.m_20154_();
            Vec3 origin = new Vec3(entity.m_20185_(), entity.m_20186_() + eyeHeight, entity.m_20189_());
            Vec3 direction = origin.m_82520_(lookVec.f_82479_ * reachDistance, lookVec.f_82480_ * reachDistance, lookVec.f_82481_ * reachDistance);
            ClipContext rayTraceContext = new ClipContext(origin, direction, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity);
            BlockHitResult mop = entity.m_9236_().m_45547_(rayTraceContext);
            if (mop != null && mop.m_6662_() == HitResult.Type.BLOCK) {
                blockState = entity.m_9236_().m_8055_(mop.m_82425_());
            }
        }
        return ValueObjectTypeBlock.ValueBlock.of(blockState);
    }).build());
    public static final IOperator OBJECT_PLAYER_TARGETENTITY = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ENTITY).symbol("target_entity").operatorName("targetentity").interactName("targetEntity").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        Entity entityOut = null;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof LivingEntity) {
            AABB boundingBox;
            LivingEntity entity = (LivingEntity)a.getRawValue().get();
            AttributeInstance reachDistanceAttribute = entity.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get());
            double reachDistance = reachDistanceAttribute == null ? 5.0 : reachDistanceAttribute.m_22135_();
            Vec3 origin = entity.m_20299_(1.0f);
            double reachDistanceSquared = reachDistance * reachDistance;
            Vec3 lookVec = entity.m_20252_(1.0f);
            Vec3 direction = origin.m_82520_(lookVec.f_82479_ * reachDistance, lookVec.f_82480_ * reachDistance, lookVec.f_82481_ * reachDistance);
            EntityHitResult entityraytraceresult = ProjectileUtil.m_37287_((Entity)entity, (Vec3)origin, (Vec3)direction, (AABB)(boundingBox = entity.m_20191_().m_82369_(lookVec.m_82490_(reachDistance)).m_82377_(1.0, 1.0, 1.0)), e -> !e.m_5833_() && e.m_6087_(), (double)reachDistanceSquared);
            if (entityraytraceresult != null) {
                Entity entity1 = entityraytraceresult.m_82443_();
                Vec3 vec3d3 = entityraytraceresult.m_82450_();
                double distanceSquared = origin.m_82557_(vec3d3);
                if (distanceSquared < reachDistanceSquared && (entity1 instanceof LivingEntity || entity1 instanceof ItemFrame)) {
                    entityOut = entity1;
                }
            }
        }
        return ValueObjectTypeEntity.ValueEntity.of(entityOut);
    }).build());
    public static final IOperator OBJECT_PLAYER_HASGUIOPEN = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("has_gui_open").operatorName("hasguiopen").interactName("hasGuiOpen").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof Player) {
            Player entity = (Player)a.getRawValue().get();
            return ValueTypeBoolean.ValueBoolean.of(entity.f_36096_ != entity.f_36095_);
        }
        return ValueTypeBoolean.ValueBoolean.of(false);
    }).build());
    public static final IOperator OBJECT_ENTITY_HELDITEM_MAIN = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ITEMSTACK).symbol("held_item_1").operatorName("helditem").interactName("heldItem").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        ItemStack itemStack = ItemStack.f_41583_;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof LivingEntity) {
            itemStack = ((LivingEntity)a.getRawValue().get()).m_21205_();
        }
        return ValueObjectTypeItemStack.ValueItemStack.of(itemStack);
    }).build());
    public static final IOperator OBJECT_ENTITY_HELDITEM_OFF = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ITEMSTACK).symbol("held_item_2").operatorName("helditemoffhand").interactName("heldItemOffHand").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        ItemStack itemStack = ItemStack.f_41583_;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof LivingEntity) {
            itemStack = ((LivingEntity)a.getRawValue().get()).m_21206_();
        }
        return ValueObjectTypeItemStack.ValueItemStack.of(itemStack);
    }).build());
    public static final IOperator OBJECT_ENTITY_MOUNTED = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.LIST).symbolOperator("mounted").interactName("mounted").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        ArrayList passengers = Lists.newArrayList();
        if (a.getRawValue().isPresent()) {
            for (Entity passenger : a.getRawValue().get().m_20197_()) {
                passengers.add(ValueObjectTypeEntity.ValueEntity.of(passenger));
            }
        }
        return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ENTITY, passengers);
    }).build());
    public static final IOperator OBJECT_ITEMFRAME_CONTENTS = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ITEMSTACK).symbol("itemframe_contents").operatorName("itemframecontents").interactName("itemFrameContents").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        ItemStack itemStack = ItemStack.f_41583_;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof ItemFrame) {
            itemStack = ((ItemFrame)a.getRawValue().get()).m_31822_();
        }
        return ValueObjectTypeItemStack.ValueItemStack.of(itemStack);
    }).build());
    public static final IOperator OBJECT_ITEMFRAME_ROTATION = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("itemframe_rotation").operatorName("itemframerotation").interactName("itemFrameRotation").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        Integer rotation = 0;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof ItemFrame) {
            rotation = ((ItemFrame)a.getRawValue().get()).m_31823_();
        }
        return ValueTypeInteger.ValueInteger.of(rotation);
    }).build());
    public static final IOperator OBJECT_ENTITY_HURTSOUND = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("hurtsound").interactName("hurtSound").function(variables -> {
        String sound;
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        String hurtSound = "";
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof LivingEntity && (sound = ((LivingEntity)a.getRawValue().get()).m_7975_((DamageSource)a.getRawValue().get().m_269291_().m_269264_()).f_11656_.toString()) != null) {
            hurtSound = sound;
        }
        return ValueTypeString.ValueString.of(hurtSound);
    }).build());
    public static final IOperator OBJECT_ENTITY_DEATHSOUND = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("deathsound").interactName("deathSound").function(variables -> {
        String sound;
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        String hurtSound = "";
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof LivingEntity && (sound = ((LivingEntity)a.getRawValue().get()).m_5592_().f_11656_.toString()) != null) {
            hurtSound = sound;
        }
        return ValueTypeString.ValueString.of(hurtSound);
    }).build());
    public static final IOperator OBJECT_ENTITY_AGE = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperatorInteract("age").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        int age = 0;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof LivingEntity) {
            age = ((LivingEntity)a.getRawValue().get()).m_21216_();
        }
        return ValueTypeInteger.ValueInteger.of(age);
    }).build());
    public static final IOperator OBJECT_ENTITY_ISCHILD = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_child").operatorName("ischild").interactName("isChild").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        boolean child = false;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof LivingEntity) {
            child = ((LivingEntity)a.getRawValue().get()).m_6162_();
        }
        return ValueTypeBoolean.ValueBoolean.of(child);
    }).build());
    public static final IOperator OBJECT_ENTITY_CANBREED = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("canbreed").operatorName("canbreed").interactName("canBreed").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        boolean canBreed = false;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof AgeableMob) {
            canBreed = ((AgeableMob)a.getRawValue().get()).m_146764_() == 0;
        }
        return ValueTypeBoolean.ValueBoolean.of(canBreed);
    }).build());
    public static final IOperator OBJECT_ENTITY_ISINLOVE = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_in_love").operatorName("isinlove").interactName("isInLove").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        boolean inLove = false;
        if (a.getRawValue().isPresent() && a.getRawValue().get() instanceof Animal) {
            inLove = ((Animal)a.getRawValue().get()).m_27593_();
        }
        return ValueTypeBoolean.ValueBoolean.of(inLove);
    }).build());
    public static final IOperator OBJECT_ENTITY_CANBREEDWITH = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.inputTypes(ValueTypes.OBJECT_ENTITY, ValueTypes.OBJECT_ITEMSTACK).output(ValueTypes.BOOLEAN).symbol("can_breed_with").operatorName("canbreedwith").interactName("canBreedWith").renderPattern(IConfigRenderPattern.INFIX_LONG).function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        ValueObjectTypeItemStack.ValueItemStack b = variables.getValue(1, ValueTypes.OBJECT_ITEMSTACK);
        boolean canBreedWith = false;
        if (a.getRawValue().isPresent() && !b.getRawValue().m_41619_() && a.getRawValue().get() instanceof Animal) {
            canBreedWith = ((Animal)a.getRawValue().get()).m_6898_(b.getRawValue());
        }
        return ValueTypeBoolean.ValueBoolean.of(canBreedWith);
    }).build());
    public static final IOperator OBJECT_ENTITY_ISSHEARABLE = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbol("is_shearable").operatorName("isshearable").interactName("isShearable").function(variables -> {
        ValueObjectTypeEntity.ValueEntity a = variables.getValue(0, ValueTypes.OBJECT_ENTITY);
        return ValueTypeBoolean.ValueBoolean.of(a.getRawValue().isPresent() && a.getRawValue().get() instanceof IForgeShearable && ((IForgeShearable)a.getRawValue().get()).isShearable(ItemStack.f_41583_, null, null));
    }).build());
    public static final IOperator OBJECT_ENTITY_NBT = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.NBT).symbol("NBT()").operatorInteract("nbt").function(input -> {
        ValueObjectTypeEntity.ValueEntity entity = input.getValue(0, ValueTypes.OBJECT_ENTITY);
        try {
            if (entity.getRawValue().isPresent()) {
                return ValueTypeNbt.ValueNbt.of((Tag)entity.getRawValue().get().serializeNBT());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ValueTypes.NBT.getDefault();
    }).build());
    public static final IOperator OBJECT_ENTITY_TYPE = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.STRING).symbol("entity_type").operatorName("entitytype").interactName("type").function(input -> {
        ValueObjectTypeEntity.ValueEntity entity = input.getValue(0, ValueTypes.OBJECT_ENTITY);
        String entityType = "";
        if (entity.getRawValue().isPresent()) {
            Entity e = entity.getRawValue().get();
            entityType = ForgeRegistries.ENTITY_TYPES.getKey((Object)e.m_6095_()).toString();
        }
        return ValueTypeString.ValueString.of(entityType);
    }).build());
    public static final IOperator OBJECT_ENTITY_ITEMS = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.LIST).symbol("entity_items").operatorName("entityitems").interactName("items").function(input -> {
        ValueObjectTypeEntity.ValueEntity valueEntity = input.getValue(0, ValueTypes.OBJECT_ENTITY);
        Optional<Entity> a = valueEntity.getRawValue();
        if (a.isPresent()) {
            Entity entity = a.get();
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyEntityItems(entity.m_9236_(), entity, null));
        }
        return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_ITEMSTACK, Collections.emptyList());
    }).build());
    public static final IOperator OBJECT_ENTITY_FLUIDS = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.LIST).symbol("entity_fluids").operatorName("entityfluids").interactName("fluids").function(input -> {
        ValueObjectTypeEntity.ValueEntity valueEntity = input.getValue(0, ValueTypes.OBJECT_ENTITY);
        Optional<Entity> a = valueEntity.getRawValue();
        if (a.isPresent()) {
            Entity entity = a.get();
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyEntityFluids(entity.m_9236_(), entity, null));
        }
        return ValueTypeList.ValueList.ofList(ValueTypes.OBJECT_FLUIDSTACK, Collections.emptyList());
    }).build());
    public static final IOperator OBJECT_ENTITY_ENERGY_STORED = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("entity_stored_fe").operatorName("entityenergystored").interactName("energy").function(input -> {
        ValueObjectTypeEntity.ValueEntity valueEntity = input.getValue(0, ValueTypes.OBJECT_ENTITY);
        Optional<Entity> a = valueEntity.getRawValue();
        if (a.isPresent()) {
            Entity entity = a.get();
            return ValueTypeInteger.ValueInteger.of(entity.getCapability(ForgeCapabilities.ENERGY, null).map(IEnergyStorage::getEnergyStored).orElse(0));
        }
        return ValueTypeInteger.ValueInteger.of(0);
    }).build());
    public static final IOperator OBJECT_ENTITY_ENERGY_CAPACITY = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbol("entity_capacity_fe").operatorName("entityenergycapacity").interactName("energyCapacity").function(input -> {
        ValueObjectTypeEntity.ValueEntity valueEntity = input.getValue(0, ValueTypes.OBJECT_ENTITY);
        Optional<Entity> a = valueEntity.getRawValue();
        if (a.isPresent()) {
            Entity entity = a.get();
            return ValueTypeInteger.ValueInteger.of(entity.getCapability(ForgeCapabilities.ENERGY, null).map(IEnergyStorage::getMaxEnergyStored).orElse(0));
        }
        return ValueTypeInteger.ValueInteger.of(0);
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_AMOUNT = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperatorInteract("amount").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_INT.build(FluidStack::getAmount)).build());
    public static final IOperator OBJECT_FLUIDSTACK_BLOCK = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_BLOCK).symbolOperatorInteract("block").function(variables -> {
        ValueObjectTypeFluidStack.ValueFluidStack valueFluidStack = variables.getValue(0, ValueTypes.OBJECT_FLUIDSTACK);
        FluidStack a = valueFluidStack.getRawValue();
        return ValueObjectTypeBlock.ValueBlock.of(!a.isEmpty() ? a.getFluid().getFluidType().getStateForPlacement(null, null, a).m_76188_() : null);
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_LIGHT_LEVEL = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("light_level").interactName("lightLevel").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_INT.build(fluidStack -> fluidStack.getFluid().getFluidType().getLightLevel(fluidStack))).build());
    public static final IOperator OBJECT_FLUIDSTACK_DENSITY = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperatorInteract("density").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_INT.build(fluidStack -> fluidStack.getFluid().getFluidType().getDensity(fluidStack))).build());
    public static final IOperator OBJECT_FLUIDSTACK_TEMPERATURE = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperatorInteract("temperature").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_INT.build(fluidStack -> fluidStack.getFluid().getFluidType().getTemperature(fluidStack))).build());
    public static final IOperator OBJECT_FLUIDSTACK_VISCOSITY = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperatorInteract("viscosity").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_INT.build(fluidStack -> fluidStack.getFluid().getFluidType().getViscosity(fluidStack))).build());
    public static final IOperator OBJECT_FLUIDSTACK_IS_LIGHTER_THAN_AIR = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("lighter_than_air").interactName("isLighterThanAir").function(OperatorBuilders.FUNCTION_FLUIDSTACK_TO_BOOLEAN.build(fluidStack -> fluidStack.getFluid().getFluidType().isLighterThanAir())).build());
    public static final IOperator OBJECT_FLUIDSTACK_RARITY = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperatorInteract("rarity").function(variables -> {
        ValueObjectTypeFluidStack.ValueFluidStack valueFluidStack = variables.getValue(0, ValueTypes.OBJECT_FLUIDSTACK);
        FluidStack a = valueFluidStack.getRawValue();
        return ValueTypeString.ValueString.of(a.getFluid().getFluidType().getRarity(a).name());
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_SOUND_BUCKET_EMPTY = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("sound_bucket_empty").interactName("bucketEmptySound").function(variables -> {
        ValueObjectTypeFluidStack.ValueFluidStack valueFluidStack = variables.getValue(0, ValueTypes.OBJECT_FLUIDSTACK);
        FluidStack a = valueFluidStack.getRawValue();
        return ValueTypeString.ValueString.of(Optional.ofNullable(a.getFluid().getFluidType().getSound(a, SoundActions.BUCKET_EMPTY)).map(soundEvent -> soundEvent.m_11660_().toString()).orElse(""));
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_SOUND_FLUID_VAPORIZE = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("sound_fluid_vaporize").interactName("fluidVaporizeSound").function(variables -> {
        ValueObjectTypeFluidStack.ValueFluidStack valueFluidStack = variables.getValue(0, ValueTypes.OBJECT_FLUIDSTACK);
        FluidStack a = valueFluidStack.getRawValue();
        return ValueTypeString.ValueString.of(Optional.ofNullable(a.getFluid().getFluidType().getSound(a, SoundActions.FLUID_VAPORIZE)).map(soundEvent -> soundEvent.m_11660_().toString()).orElse(""));
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_SOUND_BUCKET_FILL = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperator("sound_bucket_fill").interactName("bucketFillSound").function(variables -> {
        ValueObjectTypeFluidStack.ValueFluidStack valueFluidStack = variables.getValue(0, ValueTypes.OBJECT_FLUIDSTACK);
        FluidStack a = valueFluidStack.getRawValue();
        return ValueTypeString.ValueString.of(Optional.ofNullable(a.getFluid().getFluidType().getSound(a, SoundActions.BUCKET_FILL)).map(soundEvent -> soundEvent.m_11660_().toString()).orElse(""));
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_BUCKET = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.OBJECT_ITEMSTACK).symbolOperatorInteract("bucket").function(variables -> {
        ValueObjectTypeFluidStack.ValueFluidStack valueFluidStack = variables.getValue(0, ValueTypes.OBJECT_FLUIDSTACK);
        FluidStack a = valueFluidStack.getRawValue();
        return ValueObjectTypeItemStack.ValueItemStack.of(a.getFluid().getFluidType().getBucket(a));
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_ISRAWFLUIDEQUAL = REGISTRY.register(OperatorBuilders.FLUIDSTACK_2.output(ValueTypes.BOOLEAN).symbol("=Raw=").operatorName("israwfluidequal").interactName("isRawEqual").function(variables -> {
        ValueObjectTypeFluidStack.ValueFluidStack valueFluidStack0 = variables.getValue(0, ValueTypes.OBJECT_FLUIDSTACK);
        ValueObjectTypeFluidStack.ValueFluidStack valueFluidStack1 = variables.getValue(1, ValueTypes.OBJECT_FLUIDSTACK);
        return ValueTypeBoolean.ValueBoolean.of(valueFluidStack0.getRawValue().isFluidEqual(valueFluidStack1.getRawValue()));
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_MODNAME = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.STRING).symbolOperatorInteract("mod").function(new IterativeFunction(Lists.newArrayList((Object[])new IOperatorValuePropagator[]{variables -> {
        ValueObjectTypeFluidStack.ValueFluidStack a = variables.getValue(0, ValueTypes.OBJECT_FLUIDSTACK);
        return ForgeRegistries.FLUIDS.getKey((Object)a.getRawValue().getFluid());
    }, OperatorBuilders.PROPAGATOR_RESOURCELOCATION_MODNAME}))).build());
    public static final IOperator OBJECT_FLUIDSTACK_NBT = REGISTRY.register(OperatorBuilders.FLUIDSTACK_1_SUFFIX_LONG.output(ValueTypes.NBT).symbol("NBT()").operatorInteract("nbt").function(input -> {
        ValueObjectTypeFluidStack.ValueFluidStack fluidStack = input.getValue(0, ValueTypes.OBJECT_FLUIDSTACK);
        return ValueTypeNbt.ValueNbt.of((Tag)fluidStack.getRawValue().getTag());
    }).build());
    public static final IOperator OBJECT_FLUIDSTACK_WITH_AMOUNT = REGISTRY.register(OperatorBuilders.FLUIDSTACK_2.inputTypes(ValueTypes.OBJECT_FLUIDSTACK, ValueTypes.INTEGER).output(ValueTypes.OBJECT_FLUIDSTACK).symbolOperator("with_amount").interactName("withAmount").function(variables -> {
        ValueObjectTypeFluidStack.ValueFluidStack valueFluidStack = variables.getValue(0, ValueTypes.OBJECT_FLUIDSTACK);
        ValueTypeInteger.ValueInteger valueInteger = variables.getValue(1, ValueTypes.INTEGER);
        FluidStack fluidStack = valueFluidStack.getRawValue().copy();
        fluidStack.setAmount(valueInteger.getRawValue());
        return ValueObjectTypeFluidStack.ValueFluidStack.of(fluidStack);
    }).build());
    public static final IOperator OPERATOR_APPLY = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.conditionalOutputTypeDeriver(OperatorBuilders.OPERATOR_CONDITIONAL_OUTPUT_DERIVER).output(ValueTypes.CATEGORY_ANY).symbolOperatorInteract("apply").typeValidator(OperatorBuilders.createOperatorTypeValidator(ValueTypes.CATEGORY_ANY)).function(OperatorBuilders.FUNCTION_OPERATOR_TAKE_OPERATOR.build(input -> {
        IOperator innerOperator = (IOperator)input.getLeft();
        OperatorBase.SafeVariablesGetter variables = (OperatorBase.SafeVariablesGetter)input.getRight();
        IVariable variable = variables.getVariables()[0];
        return ValueHelpers.evaluateOperator(innerOperator, variable);
    })).build());
    public static final IOperator OPERATOR_APPLY_2;
    public static final IOperator OPERATOR_APPLY_3;
    public static final IOperator OPERATOR_APPLY_N;
    public static final IOperator OPERATOR_APPLY_0;
    public static final IOperator OPERATOR_MAP;
    public static final IOperator OPERATOR_FILTER;
    public static final IOperator OPERATOR_CONJUNCTION;
    public static final IOperator OPERATOR_DISJUNCTION;
    public static final IOperator OPERATOR_NEGATION;
    public static final IOperator OPERATOR_PIPE;
    public static final IOperator OPERATOR_PIPE2;
    public static final IOperator OPERATOR_FLIP;
    public static final IOperator OPERATOR_REDUCE;
    public static final IOperator OPERATOR_REDUCE1;
    public static final IOperator OPERATOR_BY_NAME;
    public static final IOperator NBT_COMPOUND_SIZE;
    public static final IOperator NBT_COMPOUND_KEYS;
    public static final IOperator NBT_COMPOUND_HASKEY;
    public static final IOperator NBT_COMPOUND_VALUE_TYPE;
    public static final IOperator NBT_COMPOUND_VALUE_TAG;
    public static final IOperator NBT_COMPOUND_VALUE_BOOLEAN;
    public static final IOperator NBT_COMPOUND_VALUE_INTEGER;
    public static final IOperator NBT_COMPOUND_VALUE_LONG;
    public static final IOperator NBT_COMPOUND_VALUE_DOUBLE;
    public static final IOperator NBT_COMPOUND_VALUE_STRING;
    public static final IOperator NBT_COMPOUND_VALUE_COMPOUND;
    public static final IOperator NBT_COMPOUND_VALUE_LIST_TAG;
    public static final IOperator NBT_COMPOUND_VALUE_LIST_BYTE;
    public static final IOperator NBT_COMPOUND_VALUE_LIST_INT;
    public static final IOperator NBT_COMPOUND_VALUE_LIST_LONG;
    public static final IOperator NBT_COMPOUND_WITHOUT;
    public static final IOperator NBT_COMPOUND_WITH_BOOLEAN;
    public static final IOperator NBT_COMPOUND_WITH_SHORT;
    public static final IOperator NBT_COMPOUND_WITH_INTEGER;
    public static final IOperator NBT_COMPOUND_WITH_LONG;
    public static final IOperator NBT_COMPOUND_WITH_DOUBLE;
    public static final IOperator NBT_COMPOUND_WITH_FLOAT;
    public static final IOperator NBT_COMPOUND_WITH_STRING;
    public static final IOperator NBT_COMPOUND_WITH_COMPOUND;
    public static final IOperator NBT_COMPOUND_WITH_LIST_TAG;
    public static final IOperator NBT_COMPOUND_WITH_LIST_BYTE;
    public static final IOperator NBT_COMPOUND_WITH_LIST_INT;
    public static final IOperator NBT_COMPOUND_WITH_LIST_LONG;
    public static final IOperator NBT_COMPOUND_SUBSET;
    public static final IOperator NBT_COMPOUND_UNION;
    public static final IOperator NBT_COMPOUND_INTERSECTION;
    public static final IOperator NBT_COMPOUND_MINUS;
    public static final IOperator NBT_AS_BOOLEAN;
    public static final IOperator NBT_AS_BYTE;
    public static final IOperator NBT_AS_SHORT;
    public static final IOperator NBT_AS_INT;
    public static final IOperator NBT_AS_LONG;
    public static final IOperator NBT_AS_DOUBLE;
    public static final IOperator NBT_AS_FLOAT;
    public static final IOperator NBT_AS_STRING;
    public static final IOperator NBT_AS_TAG_LIST;
    public static final IOperator NBT_AS_BYTE_LIST;
    public static final IOperator NBT_AS_INT_LIST;
    public static final IOperator NBT_AS_LONG_LIST;
    public static final IOperator NBT_FROM_BOOLEAN;
    public static final IOperator NBT_FROM_SHORT;
    public static final IOperator NBT_FROM_BYTE;
    public static final IOperator NBT_FROM_INT;
    public static final IOperator NBT_FROM_LONG;
    public static final IOperator NBT_FROM_DOUBLE;
    public static final IOperator NBT_FROM_FLOAT;
    public static final IOperator NBT_FROM_STRING;
    public static final IOperator NBT_FROM_TAG_LIST;
    public static final IOperator NBT_FROM_BYTE_LIST;
    public static final IOperator NBT_FROM_INT_LIST;
    public static final IOperator NBT_FROM_LONG_LIST;
    public static final IOperator NBT_PATH_MATCH_FIRST;
    public static final IOperator NBT_PATH_MATCH_ALL;
    public static final IOperator NBT_PATH_TEST;
    public static final IOperator INGREDIENTS_ITEMS;
    public static final IOperator INGREDIENTS_FLUIDS;
    public static final IOperator INGREDIENTS_ENERGIES;
    public static final IOperator INGREDIENTS_WITH_ITEM;
    public static final IOperator INGREDIENTS_WITH_FLUID;
    public static final IOperator INGREDIENTS_WITH_ENERGY;
    public static final IOperator INGREDIENTS_WITH_ITEMS;
    public static final IOperator INGREDIENTS_WITH_FLUIDS;
    public static final IOperator INGREDIENTS_WITH_ENERGIES;
    public static final IOperator RECIPE_INPUT;
    public static final IOperator RECIPE_OUTPUT;
    public static final IOperator RECIPE_WITH_INPUT;
    public static final IOperator RECIPE_WITH_OUTPUT;
    public static final IOperator RECIPE_WITH_INPUT_OUTPUT;
    public static final IOperator PARSE_BOOLEAN;
    public static final IOperator PARSE_DOUBLE;
    public static final IOperator PARSE_INTEGER;
    public static final IOperator PARSE_LONG;
    public static final IOperator PARSE_NBT;
    public static final GeneralOperator GENERAL_CHOICE;
    public static final GeneralOperator GENERAL_IDENTITY;
    public static final GeneralOperator GENERAL_CONSTANT;

    private static IOperatorRegistry constructRegistry() {
        if (MinecraftHelpers.isModdedEnvironment()) {
            return (IOperatorRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IOperatorRegistry.class);
        }
        return OperatorRegistry.getInstance();
    }

    public static void load() {
    }

    static {
        REGISTRY.registerSerializer(new CurriedOperator.Serializer());
        OPERATOR_APPLY_2 = REGISTRY.register(OperatorBuilders.OPERATOR.renderPattern(IConfigRenderPattern.INFIX_2).conditionalOutputTypeDeriver(OperatorBuilders.OPERATOR_CONDITIONAL_OUTPUT_DERIVER).inputTypes(ValueTypes.OPERATOR, ValueTypes.CATEGORY_ANY, ValueTypes.CATEGORY_ANY).output(ValueTypes.CATEGORY_ANY).symbolOperatorInteract("apply2").typeValidator(OperatorBuilders.createOperatorTypeValidator(ValueTypes.CATEGORY_ANY, ValueTypes.CATEGORY_ANY)).function(OperatorBuilders.FUNCTION_OPERATOR_TAKE_OPERATOR.build(input -> {
            IOperator innerOperator = (IOperator)input.getLeft();
            OperatorBase.SafeVariablesGetter variables = (OperatorBase.SafeVariablesGetter)input.getRight();
            IVariable variable0 = variables.getVariables()[0];
            IVariable variable1 = variables.getVariables()[1];
            return ValueHelpers.evaluateOperator(innerOperator, variable0, variable1);
        })).build());
        OPERATOR_APPLY_3 = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.renderPattern(IConfigRenderPattern.INFIX_3).conditionalOutputTypeDeriver(OperatorBuilders.OPERATOR_CONDITIONAL_OUTPUT_DERIVER).inputTypes(ValueTypes.OPERATOR, ValueTypes.CATEGORY_ANY, ValueTypes.CATEGORY_ANY, ValueTypes.CATEGORY_ANY).output(ValueTypes.CATEGORY_ANY).symbolOperatorInteract("apply3").typeValidator(OperatorBuilders.createOperatorTypeValidator(ValueTypes.CATEGORY_ANY, ValueTypes.CATEGORY_ANY, ValueTypes.CATEGORY_ANY)).function(OperatorBuilders.FUNCTION_OPERATOR_TAKE_OPERATOR.build(input -> {
            IOperator innerOperator = (IOperator)input.getLeft();
            OperatorBase.SafeVariablesGetter variables = (OperatorBase.SafeVariablesGetter)input.getRight();
            IVariable variable0 = variables.getVariables()[0];
            IVariable variable1 = variables.getVariables()[1];
            IVariable variable2 = variables.getVariables()[2];
            return ValueHelpers.evaluateOperator(innerOperator, variable0, variable1, variable2);
        })).build());
        OPERATOR_APPLY_N = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.conditionalOutputTypeDeriver(OperatorBuilders.OPERATOR_CONDITIONAL_OUTPUT_DERIVER_LIST).inputTypes(ValueTypes.OPERATOR, ValueTypes.LIST).output(ValueTypes.CATEGORY_ANY).symbolOperatorInteract("apply_n").typeValidator(OperatorBuilders.createOperatorTypeValidator(ValueTypes.LIST)).function(OperatorBuilders.FUNCTION_OPERATOR_TAKE_OPERATOR_LIST.build(input -> {
            IOperator innerOperator = (IOperator)input.getLeft();
            OperatorBase.SafeVariablesGetter variables = (OperatorBase.SafeVariablesGetter)input.getRight();
            IValueTypeListProxy list = variables.getValue(0, ValueTypes.LIST).getRawValue();
            return ValueHelpers.evaluateOperator(innerOperator, (IValue[])Iterables.toArray(list, IValue.class));
        })).build());
        OPERATOR_APPLY_0 = REGISTRY.register(OperatorBuilders.OPERATOR_1_PREFIX_LONG.conditionalOutputTypeDeriver(OperatorBuilders.OPERATOR_CONDITIONAL_OUTPUT_DERIVER).output(ValueTypes.CATEGORY_ANY).symbolOperatorInteract("apply0").typeValidator(OperatorBuilders.createOperatorTypeValidator(new IValueType[0])).function(OperatorBuilders.FUNCTION_OPERATOR_TAKE_OPERATOR.build(input -> {
            IOperator innerOperator = (IOperator)input.getLeft();
            return ValueHelpers.evaluateOperator(innerOperator, new IVariable[0]);
        })).build());
        OPERATOR_MAP = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.inputTypes(ValueTypes.OPERATOR, ValueTypes.LIST).output(ValueTypes.LIST).symbolOperatorInteract("map").function(OperatorBuilders.FUNCTION_OPERATOR_TAKE_OPERATOR_LIST.build(input -> {
            IOperator innerOperator = (IOperator)input.getLeft();
            OperatorBase.SafeVariablesGetter variables = (OperatorBase.SafeVariablesGetter)input.getRight();
            ValueTypeList.ValueList inputList = variables.getValue(0, ValueTypes.LIST);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyOperatorMapped(innerOperator, inputList.getRawValue()));
        })).build());
        OPERATOR_FILTER = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.inputTypes(ValueTypes.OPERATOR, ValueTypes.LIST).output(ValueTypes.LIST).symbolOperatorInteract("filter").function(OperatorBuilders.FUNCTION_OPERATOR_TAKE_OPERATOR_LIST.build(new IOperatorValuePropagator<Pair<IOperator, OperatorBase.SafeVariablesGetter>, IValue>(){

            @Override
            public IValue getOutput(Pair<IOperator, OperatorBase.SafeVariablesGetter> input) throws EvaluationException {
                IOperator innerOperator = (IOperator)input.getLeft();
                OperatorBase.SafeVariablesGetter variables = (OperatorBase.SafeVariablesGetter)input.getRight();
                ValueTypeList.ValueList inputList = variables.getValue(0, ValueTypes.LIST);
                ArrayList filtered = Lists.newArrayList();
                for (IValue value : inputList.getRawValue()) {
                    IValue result = ValueHelpers.evaluateOperator(innerOperator, value);
                    ValueHelpers.validatePredicateOutput(innerOperator, result);
                    if (!((ValueTypeBoolean.ValueBoolean)result).getRawValue()) continue;
                    filtered.add(value);
                }
                Object valueType = inputList.getRawValue().getValueType();
                return ValueTypeList.ValueList.ofList(valueType, filtered);
            }
        })).build());
        OPERATOR_CONJUNCTION = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.inputTypes(ValueTypes.OPERATOR, ValueTypes.OPERATOR).output(ValueTypes.OPERATOR).symbol(".&&.").operatorInteract("conjunction").function(OperatorBuilders.FUNCTION_TWO_PREDICATES.build(input -> ValueTypeOperator.ValueOperator.of(CombinedOperator.Conjunction.asOperator((IOperator)input.getLeft(), (IOperator)input.getRight())))).build());
        REGISTRY.registerSerializer(new CombinedOperator.Conjunction.Serializer());
        OPERATOR_DISJUNCTION = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.inputTypes(ValueTypes.OPERATOR, ValueTypes.OPERATOR).output(ValueTypes.OPERATOR).symbol(".||.").operatorInteract("disjunction").function(OperatorBuilders.FUNCTION_TWO_PREDICATES.build(input -> ValueTypeOperator.ValueOperator.of(CombinedOperator.Disjunction.asOperator((IOperator)input.getLeft(), (IOperator)input.getRight())))).build());
        REGISTRY.registerSerializer(new CombinedOperator.Disjunction.Serializer());
        OPERATOR_NEGATION = REGISTRY.register(OperatorBuilders.OPERATOR_1_PREFIX_LONG.renderPattern(IConfigRenderPattern.PREFIX_1).inputTypes(ValueTypes.OPERATOR).output(ValueTypes.OPERATOR).symbol("!.").operatorInteract("negation").function(OperatorBuilders.FUNCTION_ONE_PREDICATE.build(input -> ValueTypeOperator.ValueOperator.of(CombinedOperator.Negation.asOperator(input)))).build());
        REGISTRY.registerSerializer(new CombinedOperator.Negation.Serializer());
        OPERATOR_PIPE = REGISTRY.register(OperatorBuilders.OPERATOR_2_INFIX_LONG.inputTypes(ValueTypes.OPERATOR, ValueTypes.OPERATOR).output(ValueTypes.OPERATOR).symbol(".").operatorInteract("pipe").function(OperatorBuilders.FUNCTION_TWO_OPERATORS.build(input -> ValueTypeOperator.ValueOperator.of(CombinedOperator.Pipe.asOperator((IOperator)input.getLeft(), (IOperator)input.getRight())))).build());
        REGISTRY.registerSerializer(new CombinedOperator.Pipe.Serializer());
        OPERATOR_PIPE2 = REGISTRY.register(OperatorBuilders.OPERATOR.inputTypes(ValueTypes.OPERATOR, ValueTypes.OPERATOR, ValueTypes.OPERATOR).renderPattern(IConfigRenderPattern.INFIX_2_LATE).output(ValueTypes.OPERATOR).symbol(".2").operatorInteract("pipe2").function(OperatorBuilders.FUNCTION_THREE_OPERATORS.build(input -> ValueTypeOperator.ValueOperator.of(CombinedOperator.Pipe2.asOperator((IOperator)input.getLeft(), (IOperator)input.getMiddle(), (IOperator)input.getRight())))).build());
        REGISTRY.registerSerializer(new CombinedOperator.Pipe2.Serializer());
        OPERATOR_FLIP = REGISTRY.register(OperatorBuilders.OPERATOR_1_PREFIX_LONG.renderPattern(IConfigRenderPattern.PREFIX_1).inputTypes(ValueTypes.OPERATOR).output(ValueTypes.OPERATOR).symbolOperatorInteract("flip").function(OperatorBuilders.FUNCTION_ONE_OPERATOR.build(input -> ValueTypeOperator.ValueOperator.of(CombinedOperator.Flip.asOperator(input)))).build());
        REGISTRY.registerSerializer(new CombinedOperator.Flip.Serializer());
        OPERATOR_REDUCE = REGISTRY.register(OperatorBuilders.OPERATOR.inputTypes(ValueTypes.OPERATOR, ValueTypes.LIST, ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.PREFIX_3_LONG).output(ValueTypes.CATEGORY_ANY).symbolOperatorInteract("reduce").conditionalOutputTypeDeriver((operator, input) -> input[2].getType()).function(variables -> {
            IValue accumulator = variables.getValue(2);
            IOperator innerOperator = OperatorBuilders.getSafeOperator(variables.getValue(0, ValueTypes.OPERATOR), accumulator.getType());
            ValueTypeList.ValueList inputList = variables.getValue(1, ValueTypes.LIST);
            for (IValue listValue : inputList.getRawValue()) {
                accumulator = ValueHelpers.evaluateOperator(innerOperator, accumulator, listValue);
            }
            return accumulator;
        }).build());
        OPERATOR_REDUCE1 = REGISTRY.register(OperatorBuilders.OPERATOR.inputTypes(ValueTypes.OPERATOR, ValueTypes.LIST).renderPattern(IConfigRenderPattern.PREFIX_2_LONG).output(ValueTypes.CATEGORY_ANY).symbolOperatorInteract("reduce1").conditionalOutputTypeDeriver((operator, input) -> {
            try {
                IValueTypeListProxy a = ((ValueTypeList.ValueList)input[1].getValue()).getRawValue();
                return a.getValueType();
            }
            catch (EvaluationException e) {
                return operator.getOutputType();
            }
        }).function(variables -> {
            ValueTypeList.ValueList valueList = variables.getValue(1, ValueTypes.LIST);
            Iterator iter = valueList.getRawValue().iterator();
            if (!iter.hasNext()) {
                throw new EvaluationException(Component.m_237115_((String)"operator.integrateddynamics.error.reduce.empty"));
            }
            IValue accumulator = (IValue)iter.next();
            IOperator innerOperator = OperatorBuilders.getSafeOperator(variables.getValue(0, ValueTypes.OPERATOR), accumulator.getType());
            while (iter.hasNext()) {
                IValue listValue = (IValue)iter.next();
                accumulator = ValueHelpers.evaluateOperator(innerOperator, accumulator, listValue);
            }
            return accumulator;
        }).build());
        OPERATOR_BY_NAME = REGISTRY.register(OperatorBuilders.OPERATOR_1_PREFIX_LONG.inputType(ValueTypes.STRING).output(ValueTypes.OPERATOR).symbol("op_by_name").operatorName("by_name").interactName("operatorByName").function(input -> {
            ValueTypeString.ValueString name = input.getValue(0, ValueTypes.STRING);
            IOperator operator = REGISTRY.getOperator(ResourceLocation.m_135820_((String)name.getRawValue()));
            if (operator == null) {
                throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.operator_not_found", (Object[])new Object[]{name.getRawValue()}));
            }
            return ValueTypeOperator.ValueOperator.of(operator);
        }).build());
        NBT_COMPOUND_SIZE = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.INTEGER).operatorName("compound_size").symbol("NBT{}.size").interactName("size").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_TO_INT.build(opt -> opt.map(CompoundTag::m_128440_).orElse(0))).build());
        NBT_COMPOUND_KEYS = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.LIST).operatorName("compound_keys").symbol("NBT{}.keys").interactName("keys").function(variables -> {
            ValueTypeNbt.ValueNbt value = variables.getValue(0, ValueTypes.NBT);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyNbtKeys(value.getRawValue()));
        }).build());
        NBT_COMPOUND_HASKEY = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.BOOLEAN).operatorName("compound_haskey").symbol("NBT{}.has_key").interactName("hasKey").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_ENTRY_TO_BOOLEAN.build(Optional::isPresent)).build());
        NBT_COMPOUND_VALUE_TYPE = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.STRING).operatorName("compound_type").symbol("NBT{}.type").interactName("type").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_ENTRY_TO_STRING.build(tag -> {
            if (tag.isPresent()) {
                try {
                    return TagTypes.m_129397_((int)((Tag)tag.get()).m_7060_()).m_5987_();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return "null";
        })).build());
        NBT_COMPOUND_VALUE_TAG = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.NBT).operatorName("compound_value_tag").symbol("NBT{}.get_tag").interactName("getTag").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_ENTRY_TO_NBT.build(o -> o)).build());
        NBT_COMPOUND_VALUE_BOOLEAN = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.BOOLEAN).operatorName("compound_value_boolean").symbol("NBT{}.get_boolean").interactName("getBoolean").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_ENTRY_TO_BOOLEAN.build(o -> o.map(tag -> tag instanceof NumericTag && ((NumericTag)tag).m_7063_() != 0).orElse(false))).build());
        NBT_COMPOUND_VALUE_INTEGER = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.INTEGER).operatorName("compound_value_integer").symbol("NBT{}.get_integer").interactName("getInteger").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_ENTRY_TO_INT.build(o -> o.map(tag -> tag instanceof NumericTag ? ((NumericTag)tag).m_7047_() : 0).orElse(0))).build());
        NBT_COMPOUND_VALUE_LONG = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.LONG).operatorName("compound_value_long").symbol("NBT{}.get_long").interactName("getLong").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_ENTRY_TO_LONG.build(o -> o.map(tag -> tag instanceof NumericTag ? ((NumericTag)tag).m_7046_() : 0L).orElse(0L))).build());
        NBT_COMPOUND_VALUE_DOUBLE = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.DOUBLE).operatorName("compound_value_double").symbol("NBT{}.get_double").interactName("getDouble").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_ENTRY_TO_DOUBLE.build(o -> o.map(tag -> tag instanceof NumericTag ? ((NumericTag)tag).m_7061_() : 0.0).orElse(0.0))).build());
        NBT_COMPOUND_VALUE_STRING = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.STRING).operatorName("compound_value_string").symbol("NBT{}.get_string").interactName("getString").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_ENTRY_TO_STRING.build(o -> o.map(tag -> tag instanceof StringTag ? tag.m_7916_() : "").orElse(""))).build());
        NBT_COMPOUND_VALUE_COMPOUND = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.NBT).operatorName("compound_value_compound").symbol("NBT{}.get_compound").interactName("getCompound").function(OperatorBuilders.FUNCTION_NBT_COMPOUND_ENTRY_TO_NBT.build(o -> o.map(tag -> tag instanceof CompoundTag ? (CompoundTag)tag : new CompoundTag()))).build());
        NBT_COMPOUND_VALUE_LIST_TAG = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.LIST).operatorName("compound_value_list_tag").symbol("NBT{}.get_list_tag").interactName("getListTag").function(variables -> {
            ValueTypeNbt.ValueNbt value = variables.getValue(0, ValueTypes.NBT);
            ValueTypeString.ValueString key = variables.getValue(1, ValueTypes.STRING);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyNbtValueListTag(key.getRawValue(), value.getRawValue()));
        }).build());
        NBT_COMPOUND_VALUE_LIST_BYTE = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.LIST).operatorName("compound_value_list_byte").symbol("NBT{}.get_list_byte").interactName("getListByte").function(variables -> {
            ValueTypeNbt.ValueNbt value = variables.getValue(0, ValueTypes.NBT);
            ValueTypeString.ValueString key = variables.getValue(1, ValueTypes.STRING);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyNbtValueListByte(key.getRawValue(), value.getRawValue()));
        }).build());
        NBT_COMPOUND_VALUE_LIST_INT = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.LIST).operatorName("compound_value_list_int").symbol("NBT{}.get_list_int").interactName("getListInt").function(variables -> {
            ValueTypeNbt.ValueNbt value = variables.getValue(0, ValueTypes.NBT);
            ValueTypeString.ValueString key = variables.getValue(1, ValueTypes.STRING);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyNbtValueListInt(key.getRawValue(), value.getRawValue()));
        }).build());
        NBT_COMPOUND_VALUE_LIST_LONG = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.LIST).operatorName("compound_value_list_long").symbol("NBT{}.get_list_long").interactName("getListLong").function(variables -> {
            ValueTypeNbt.ValueNbt value = variables.getValue(0, ValueTypes.NBT);
            ValueTypeString.ValueString key = variables.getValue(1, ValueTypes.STRING);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyNbtValueListLong(key.getRawValue(), value.getRawValue()));
        }).build());
        NBT_COMPOUND_WITHOUT = REGISTRY.register(OperatorBuilders.NBT_2.output(ValueTypes.NBT).operatorName("compound_without").symbol("NBT{}.without").interactName("without").function(variables -> {
            ValueTypeNbt.ValueNbt valueNbt = variables.getValue(0, ValueTypes.NBT);
            Optional tag = valueNbt.getRawValue();
            if (tag.isPresent()) {
                if (!(tag.get() instanceof CompoundTag)) {
                    return ValueTypeNbt.ValueNbt.of();
                }
                ValueTypeString.ValueString valueString = variables.getValue(1, ValueTypes.STRING);
                String key = valueString.getRawValue();
                CompoundTag tagCompound = (CompoundTag)tag.get();
                if (tagCompound.m_128441_(key)) {
                    tagCompound = tagCompound.m_6426_();
                    tagCompound.m_128473_(key);
                }
                return ValueTypeNbt.ValueNbt.of((Tag)tagCompound);
            }
            return valueNbt;
        }).build());
        NBT_COMPOUND_WITH_BOOLEAN = REGISTRY.register(OperatorBuilders.NBT_3.renderPattern(IConfigRenderPattern.INFIX_2_VERYLONG).inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.BOOLEAN).operatorName("compound_with_boolean").symbol("NBT{}.with_boolean").interactName("withBoolean").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(input -> {
            ValueTypeBoolean.ValueBoolean value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.BOOLEAN);
            ((Optional)input.getLeft()).ifPresent(tag -> tag.m_128379_((String)input.getMiddle(), value.getRawValue()));
            return (Optional)input.getLeft();
        })).build());
        NBT_COMPOUND_WITH_SHORT = REGISTRY.register(OperatorBuilders.NBT_3.inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.INTEGER).operatorName("compound_with_short").symbol("NBT{}.with_short").interactName("withShort").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(input -> {
            ValueTypeInteger.ValueInteger value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.INTEGER);
            ((Optional)input.getLeft()).ifPresent(tag -> tag.m_128376_((String)input.getMiddle(), (short)value.getRawValue()));
            return (Optional)input.getLeft();
        })).build());
        NBT_COMPOUND_WITH_INTEGER = REGISTRY.register(OperatorBuilders.NBT_3.inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.INTEGER).operatorName("compound_with_integer").symbol("NBT{}.with_integer").interactName("withInteger").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(input -> {
            ValueTypeInteger.ValueInteger value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.INTEGER);
            ((Optional)input.getLeft()).ifPresent(tag -> tag.m_128405_((String)input.getMiddle(), value.getRawValue()));
            return (Optional)input.getLeft();
        })).build());
        NBT_COMPOUND_WITH_LONG = REGISTRY.register(OperatorBuilders.NBT_3.inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.LONG).operatorName("compound_with_long").symbol("NBT{}.with_long").interactName("withLong").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(input -> {
            ValueTypeLong.ValueLong value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.LONG);
            ((Optional)input.getLeft()).ifPresent(tag -> tag.m_128356_((String)input.getMiddle(), value.getRawValue()));
            return (Optional)input.getLeft();
        })).build());
        NBT_COMPOUND_WITH_DOUBLE = REGISTRY.register(OperatorBuilders.NBT_3.inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.DOUBLE).operatorName("compound_with_double").symbol("NBT{}.with_double").interactName("withDouble").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(input -> {
            ValueTypeDouble.ValueDouble value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.DOUBLE);
            ((Optional)input.getLeft()).ifPresent(tag -> tag.m_128347_((String)input.getMiddle(), value.getRawValue()));
            return (Optional)input.getLeft();
        })).build());
        NBT_COMPOUND_WITH_FLOAT = REGISTRY.register(OperatorBuilders.NBT_3.inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.DOUBLE).operatorName("compound_with_float").symbol("NBT{}.with_float").interactName("withFloat").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(input -> {
            ValueTypeDouble.ValueDouble value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.DOUBLE);
            ((Optional)input.getLeft()).ifPresent(tag -> tag.m_128350_((String)input.getMiddle(), (float)value.getRawValue()));
            return (Optional)input.getLeft();
        })).build());
        NBT_COMPOUND_WITH_STRING = REGISTRY.register(OperatorBuilders.NBT_3.inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.STRING).operatorName("compound_with_string").symbol("NBT{}.with_string").interactName("withString").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(input -> {
            ValueTypeString.ValueString value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.STRING);
            ((Optional)input.getLeft()).ifPresent(tag -> tag.m_128359_((String)input.getMiddle(), value.getRawValue()));
            return (Optional)input.getLeft();
        })).build());
        NBT_COMPOUND_WITH_COMPOUND = REGISTRY.register(OperatorBuilders.NBT_3.inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.NBT).operatorName("compound_with_tag").symbol("NBT{}.with_tag").interactName("withTag").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(input -> {
            ValueTypeNbt.ValueNbt value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.NBT);
            ((Optional)input.getLeft()).ifPresent(tag -> value.getRawValue().ifPresent(v -> tag.m_128365_((String)input.getMiddle(), v)));
            return (Optional)input.getLeft();
        })).build());
        NBT_COMPOUND_WITH_LIST_TAG = REGISTRY.register(OperatorBuilders.NBT_3.renderPattern(IConfigRenderPattern.INFIX_2_VERYLONG).inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.LIST).operatorName("compound_with_list_tag").symbol("NBT{}.with_tag_list").interactName("withTagList").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(new IOperatorValuePropagator<Triple<Optional<CompoundTag>, String, OperatorBase.SafeVariablesGetter>, Optional<CompoundTag>>(){

            @Override
            public Optional<CompoundTag> getOutput(Triple<Optional<CompoundTag>, String, OperatorBase.SafeVariablesGetter> input) throws EvaluationException {
                ValueTypeList.ValueList value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.LIST);
                ((Optional)input.getLeft()).ifPresent(tag -> tag.m_128365_((String)input.getMiddle(), (Tag)NbtHelpers.getListNbtTag(value, (Component)NBT_COMPOUND_WITH_LIST_TAG.getLocalizedNameFull())));
                return (Optional)input.getLeft();
            }
        })).build());
        NBT_COMPOUND_WITH_LIST_BYTE = REGISTRY.register(OperatorBuilders.NBT_3.renderPattern(IConfigRenderPattern.INFIX_2_VERYLONG).inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.LIST).operatorName("compound_with_list_byte").symbol("NBT{}.with_byte_list").interactName("withByteList").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(new IOperatorValuePropagator<Triple<Optional<CompoundTag>, String, OperatorBase.SafeVariablesGetter>, Optional<CompoundTag>>(){

            @Override
            public Optional<CompoundTag> getOutput(Triple<Optional<CompoundTag>, String, OperatorBase.SafeVariablesGetter> input) throws EvaluationException {
                ValueTypeList.ValueList value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.LIST);
                ((Optional)input.getLeft()).ifPresent(tag -> tag.m_128365_((String)input.getMiddle(), (Tag)NbtHelpers.getListNbtByte(value, (Component)NBT_COMPOUND_WITH_LIST_BYTE.getLocalizedNameFull())));
                return (Optional)input.getLeft();
            }
        })).build());
        NBT_COMPOUND_WITH_LIST_INT = REGISTRY.register(OperatorBuilders.NBT_3.renderPattern(IConfigRenderPattern.INFIX_2_VERYLONG).inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.LIST).operatorName("compound_with_list_int").symbol("NBT{}.with_int_list").interactName("withIntList").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(new IOperatorValuePropagator<Triple<Optional<CompoundTag>, String, OperatorBase.SafeVariablesGetter>, Optional<CompoundTag>>(){

            @Override
            public Optional<CompoundTag> getOutput(Triple<Optional<CompoundTag>, String, OperatorBase.SafeVariablesGetter> input) throws EvaluationException {
                ValueTypeList.ValueList value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.LIST);
                ((Optional)input.getLeft()).ifPresent(tag -> tag.m_128365_((String)input.getMiddle(), (Tag)NbtHelpers.getListNbtInt(value, (Component)NBT_COMPOUND_WITH_LIST_INT.getLocalizedNameFull())));
                return (Optional)input.getLeft();
            }
        })).build());
        NBT_COMPOUND_WITH_LIST_LONG = REGISTRY.register(OperatorBuilders.NBT_3.renderPattern(IConfigRenderPattern.INFIX_2_VERYLONG).inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.LIST).operatorName("compound_with_list_long").symbol("NBT{}.with_list_long").interactName("withListLong").function(OperatorBuilders.FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT.build(new IOperatorValuePropagator<Triple<Optional<CompoundTag>, String, OperatorBase.SafeVariablesGetter>, Optional<CompoundTag>>(){

            @Override
            public Optional<CompoundTag> getOutput(Triple<Optional<CompoundTag>, String, OperatorBase.SafeVariablesGetter> input) throws EvaluationException {
                ValueTypeList.ValueList value = ((OperatorBase.SafeVariablesGetter)input.getRight()).getValue(0, ValueTypes.LIST);
                ((Optional)input.getLeft()).ifPresent(tag -> tag.m_128365_((String)input.getMiddle(), (Tag)NbtHelpers.getListNbtLong(value, (Component)NBT_COMPOUND_WITH_LIST_LONG.getLocalizedNameFull())));
                return (Optional)input.getLeft();
            }
        })).build());
        NBT_COMPOUND_SUBSET = REGISTRY.register(OperatorBuilders.NBT_2_NBT.output(ValueTypes.BOOLEAN).operatorName("compound_subset").symbol("NBT{}.\u2286").interactName("isSubset").function(variables -> {
            ValueTypeNbt.ValueNbt valueNbt0 = variables.getValue(0, ValueTypes.NBT);
            ValueTypeNbt.ValueNbt valueNbt1 = variables.getValue(1, ValueTypes.NBT);
            if (valueNbt0.getRawValue().isPresent() && valueNbt1.getRawValue().isPresent() && valueNbt0.getRawValue().get() instanceof CompoundTag && valueNbt1.getRawValue().get() instanceof CompoundTag) {
                return ValueTypeBoolean.ValueBoolean.of(NbtHelpers.nbtMatchesSubset((CompoundTag)valueNbt0.getRawValue().get(), (CompoundTag)valueNbt1.getRawValue().get(), true));
            }
            return ValueTypeBoolean.ValueBoolean.of(false);
        }).build());
        NBT_COMPOUND_UNION = REGISTRY.register(OperatorBuilders.NBT_2_NBT.output(ValueTypes.NBT).operatorName("compound_union").symbol("NBT{}.\u222a").interactName("union").function(variables -> {
            ValueTypeNbt.ValueNbt valueNbt0 = variables.getValue(0, ValueTypes.NBT);
            ValueTypeNbt.ValueNbt valueNbt1 = variables.getValue(1, ValueTypes.NBT);
            if (valueNbt0.getRawValue().isPresent() && valueNbt1.getRawValue().isPresent() && valueNbt0.getRawValue().get() instanceof CompoundTag && valueNbt1.getRawValue().get() instanceof CompoundTag) {
                return ValueTypeNbt.ValueNbt.of((Tag)NbtHelpers.union((CompoundTag)valueNbt0.getRawValue().get(), (CompoundTag)valueNbt1.getRawValue().get()));
            }
            return ValueTypeNbt.ValueNbt.of();
        }).build());
        NBT_COMPOUND_INTERSECTION = REGISTRY.register(OperatorBuilders.NBT_2_NBT.output(ValueTypes.NBT).operatorName("compound_intersection").symbol("NBT{}.\u2229").interactName("intersection").function(variables -> {
            ValueTypeNbt.ValueNbt valueNbt0 = variables.getValue(0, ValueTypes.NBT);
            ValueTypeNbt.ValueNbt valueNbt1 = variables.getValue(1, ValueTypes.NBT);
            if (valueNbt0.getRawValue().isPresent() && valueNbt1.getRawValue().isPresent() && valueNbt0.getRawValue().get() instanceof CompoundTag && valueNbt1.getRawValue().get() instanceof CompoundTag) {
                return ValueTypeNbt.ValueNbt.of((Tag)NbtHelpers.intersection((CompoundTag)valueNbt0.getRawValue().get(), (CompoundTag)valueNbt1.getRawValue().get()));
            }
            return ValueTypeNbt.ValueNbt.of();
        }).build());
        NBT_COMPOUND_MINUS = REGISTRY.register(OperatorBuilders.NBT_2_NBT.output(ValueTypes.NBT).operatorName("compound_minus").symbol("NBT{}.\u2216").interactName("minus").function(variables -> {
            ValueTypeNbt.ValueNbt valueNbt0 = variables.getValue(0, ValueTypes.NBT);
            ValueTypeNbt.ValueNbt valueNbt1 = variables.getValue(1, ValueTypes.NBT);
            if (valueNbt0.getRawValue().isPresent() && valueNbt1.getRawValue().isPresent() && valueNbt0.getRawValue().get() instanceof CompoundTag && valueNbt1.getRawValue().get() instanceof CompoundTag) {
                return ValueTypeNbt.ValueNbt.of((Tag)NbtHelpers.minus((CompoundTag)valueNbt0.getRawValue().get(), (CompoundTag)valueNbt1.getRawValue().get()));
            }
            return ValueTypeNbt.ValueNbt.of();
        }).build());
        NBT_AS_BOOLEAN = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).operatorName("as_boolean").symbol("NBT.as_boolean").interactName("asBoolean").function(OperatorBuilders.FUNCTION_NBT_TO_BOOLEAN.build(o -> o.map(tag -> tag instanceof ByteTag && ((ByteTag)tag).m_7063_() != 0).orElse(false))).build());
        NBT_AS_BYTE = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.INTEGER).operatorName("as_byte").symbol("NBT.as_byte").interactName("asByte").function(OperatorBuilders.FUNCTION_NBT_TO_INT.build(o -> o.map(tag -> tag instanceof NumericTag ? ((NumericTag)tag).m_7047_() : 0).orElse(0))).build());
        NBT_AS_SHORT = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.INTEGER).operatorName("as_short").symbol("NBT.as_short").interactName("asShort").function(OperatorBuilders.FUNCTION_NBT_TO_INT.build(o -> o.map(tag -> tag instanceof NumericTag ? ((NumericTag)tag).m_7047_() : 0).orElse(0))).build());
        NBT_AS_INT = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.INTEGER).operatorName("as_int").symbol("NBT.as_int").interactName("asInt").function(OperatorBuilders.FUNCTION_NBT_TO_INT.build(o -> o.map(tag -> tag instanceof NumericTag ? ((NumericTag)tag).m_7047_() : 0).orElse(0))).build());
        NBT_AS_LONG = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.LONG).operatorName("as_long").symbol("NBT.as_long").interactName("asLong").function(OperatorBuilders.FUNCTION_NBT_TO_LONG.build(o -> o.map(tag -> tag instanceof NumericTag ? ((NumericTag)tag).m_7046_() : 0L).orElse(0L))).build());
        NBT_AS_DOUBLE = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.DOUBLE).operatorName("as_double").symbol("NBT.as_double").interactName("asDouble").function(OperatorBuilders.FUNCTION_NBT_TO_DOUBLE.build(o -> o.map(tag -> tag instanceof NumericTag ? ((NumericTag)tag).m_7061_() : 0.0).orElse(0.0))).build());
        NBT_AS_FLOAT = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.DOUBLE).operatorName("as_float").symbol("NBT.as_float").interactName("asFloat").function(OperatorBuilders.FUNCTION_NBT_TO_DOUBLE.build(o -> o.map(tag -> tag instanceof NumericTag ? (double)((NumericTag)tag).m_7057_() : 0.0).orElse(0.0))).build());
        NBT_AS_STRING = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.STRING).operatorName("as_string").symbol("NBT.as_string").interactName("asString").function(OperatorBuilders.FUNCTION_NBT_TO_STRING.build(o -> o.map(tag -> tag instanceof StringTag ? ((StringTag)tag).m_7916_() : "").orElse(""))).build());
        NBT_AS_TAG_LIST = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.LIST).operatorName("as_tag_list").symbol("NBT.as_tag_list").interactName("asTagList").function(variables -> {
            ValueTypeNbt.ValueNbt value = variables.getValue(0, ValueTypes.NBT);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyNbtAsListTag(value.getRawValue()));
        }).build());
        NBT_AS_BYTE_LIST = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.LIST).operatorName("as_byte_list").symbol("NBT.as_byte_list").interactName("asByteList").function(variables -> {
            ValueTypeNbt.ValueNbt value = variables.getValue(0, ValueTypes.NBT);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyNbtAsListByte(value.getRawValue()));
        }).build());
        NBT_AS_INT_LIST = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.LIST).operatorName("as_int_list").symbol("NBT.as_int_list").interactName("asIntList").function(variables -> {
            ValueTypeNbt.ValueNbt value = variables.getValue(0, ValueTypes.NBT);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyNbtAsListInt(value.getRawValue()));
        }).build());
        NBT_AS_LONG_LIST = REGISTRY.register(OperatorBuilders.NBT_1_SUFFIX_LONG.output(ValueTypes.LIST).operatorName("as_long_list").symbol("NBT.as_long_list").interactName("asLongList").function(variables -> {
            ValueTypeNbt.ValueNbt value = variables.getValue(0, ValueTypes.NBT);
            return ValueTypeList.ValueList.ofFactory(new ValueTypeListProxyNbtAsListLong(value.getRawValue()));
        }).build());
        NBT_FROM_BOOLEAN = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.BOOLEAN).output(ValueTypes.NBT).operatorName("from_boolean").symbol("NBT.from_boolean").interactName("asNbt").function(variables -> {
            ValueTypeBoolean.ValueBoolean value = variables.getValue(0, ValueTypes.BOOLEAN);
            return ValueTypeNbt.ValueNbt.of((Tag)ByteTag.m_128273_((boolean)value.getRawValue()));
        }).build());
        NBT_FROM_SHORT = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.INTEGER).output(ValueTypes.NBT).operatorName("from_short").symbol("NBT.from_short").interactName("asNbt", "short", true).function(variables -> {
            ValueTypeInteger.ValueInteger value = variables.getValue(0, ValueTypes.INTEGER);
            return ValueTypeNbt.ValueNbt.of((Tag)ShortTag.m_129258_((short)((short)value.getRawValue())));
        }).build());
        NBT_FROM_BYTE = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.INTEGER).output(ValueTypes.NBT).operatorName("from_byte").symbol("NBT.from_byte").interactName("asNbt", "byte", true).function(variables -> {
            ValueTypeInteger.ValueInteger value = variables.getValue(0, ValueTypes.INTEGER);
            return ValueTypeNbt.ValueNbt.of((Tag)ByteTag.m_128266_((byte)((byte)value.getRawValue())));
        }).build());
        NBT_FROM_INT = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.INTEGER).output(ValueTypes.NBT).operatorName("from_int").symbol("NBT.from_int").interactName("asNbt").function(variables -> {
            ValueTypeInteger.ValueInteger value = variables.getValue(0, ValueTypes.INTEGER);
            return ValueTypeNbt.ValueNbt.of((Tag)IntTag.m_128679_((int)value.getRawValue()));
        }).build());
        NBT_FROM_LONG = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.LONG).output(ValueTypes.NBT).operatorName("from_long").symbol("NBT.from_long").interactName("asNbt").function(variables -> {
            ValueTypeLong.ValueLong value = variables.getValue(0, ValueTypes.LONG);
            return ValueTypeNbt.ValueNbt.of((Tag)LongTag.m_128882_((long)value.getRawValue()));
        }).build());
        NBT_FROM_DOUBLE = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.DOUBLE).output(ValueTypes.NBT).operatorName("from_double").symbol("NBT.from_double").interactName("asNbt").function(variables -> {
            ValueTypeDouble.ValueDouble value = variables.getValue(0, ValueTypes.DOUBLE);
            return ValueTypeNbt.ValueNbt.of((Tag)DoubleTag.m_128500_((double)value.getRawValue()));
        }).build());
        NBT_FROM_FLOAT = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.DOUBLE).output(ValueTypes.NBT).operatorName("from_float").symbol("NBT.from_float").interactName("asNbt", "float", true).function(variables -> {
            ValueTypeDouble.ValueDouble value = variables.getValue(0, ValueTypes.DOUBLE);
            return ValueTypeNbt.ValueNbt.of((Tag)FloatTag.m_128566_((float)((float)value.getRawValue())));
        }).build());
        NBT_FROM_STRING = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.STRING).output(ValueTypes.NBT).operatorName("from_string").symbol("NBT.from_string").interactName("asNbt").function(variables -> {
            ValueTypeString.ValueString value = variables.getValue(0, ValueTypes.STRING);
            return ValueTypeNbt.ValueNbt.of((Tag)StringTag.m_129297_((String)value.getRawValue()));
        }).build());
        NBT_FROM_TAG_LIST = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.LIST).output(ValueTypes.NBT).operatorName("from_tag_list").symbol("NBT.from_tag_list").interactName("asNbt", "tagList", true).function(new OperatorBase.IFunction(){

            @Override
            public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
                ValueTypeList.ValueList value = variables.getValue(0, ValueTypes.LIST);
                return ValueTypeNbt.ValueNbt.of((Tag)NbtHelpers.getListNbtTag(value, (Component)NBT_FROM_TAG_LIST.getLocalizedNameFull()));
            }
        }).build());
        NBT_FROM_BYTE_LIST = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.LIST).output(ValueTypes.NBT).operatorName("from_byte_list").symbol("NBT.from_byte_list").interactName("asNbt", "byteList", true).function(new OperatorBase.IFunction(){

            @Override
            public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
                ValueTypeList.ValueList value = variables.getValue(0, ValueTypes.LIST);
                return ValueTypeNbt.ValueNbt.of((Tag)NbtHelpers.getListNbtByte(value, (Component)NBT_FROM_BYTE_LIST.getLocalizedNameFull()));
            }
        }).build());
        NBT_FROM_INT_LIST = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.LIST).output(ValueTypes.NBT).operatorName("from_int_list").symbol("NBT.from_int_list").interactName("asNbt", "intList", true).function(new OperatorBase.IFunction(){

            @Override
            public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
                ValueTypeList.ValueList value = variables.getValue(0, ValueTypes.LIST);
                return ValueTypeNbt.ValueNbt.of((Tag)NbtHelpers.getListNbtInt(value, (Component)NBT_FROM_INT_LIST.getLocalizedNameFull()));
            }
        }).build());
        NBT_FROM_LONG_LIST = REGISTRY.register(OperatorBuilders.NBT_1_PREFIX_LONG.inputType(ValueTypes.LIST).output(ValueTypes.NBT).operatorName("from_long_list").symbol("NBT.from_long_list").interactName("asNbt", "longList", true).function(new OperatorBase.IFunction(){

            @Override
            public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
                ValueTypeList.ValueList value = variables.getValue(0, ValueTypes.LIST);
                return ValueTypeNbt.ValueNbt.of((Tag)NbtHelpers.getListNbtLong(value, (Component)NBT_FROM_LONG_LIST.getLocalizedNameFull()));
            }
        }).build());
        NBT_PATH_MATCH_FIRST = REGISTRY.register(OperatorBuilders.NBT_2.inputTypes(ValueTypes.STRING, ValueTypes.NBT).output(ValueTypes.NBT).operatorName("path_match_first").symbol("NBT.path_match_first").interactName("nbtPathMatchFirst").function(variables -> {
            ValueTypeString.ValueString string = variables.getValue(0, ValueTypes.STRING);
            ValueTypeNbt.ValueNbt nbt = variables.getValue(1, ValueTypes.NBT);
            INbtPathExpression expression = null;
            try {
                expression = NbtPath.parse((String)string.getRawValue());
            }
            catch (NbtParseException e) {
                throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.operator_nbt_path_expression", (Object[])new Object[]{string.getRawValue(), e.getMessage()}));
            }
            if (!nbt.getRawValue().isPresent()) {
                return ValueTypeNbt.ValueNbt.of();
            }
            return ValueTypeNbt.ValueNbt.of(expression.match((Tag)nbt.getRawValue().get()).getMatches().findAny());
        }).build());
        NBT_PATH_MATCH_ALL = REGISTRY.register(OperatorBuilders.NBT_2.inputTypes(ValueTypes.STRING, ValueTypes.NBT).output(ValueTypes.LIST).operatorName("path_match_all").symbol("NBT.path_match_all").interactName("nbtPathMatchAll").function(variables -> {
            ValueTypeString.ValueString string = variables.getValue(0, ValueTypes.STRING);
            ValueTypeNbt.ValueNbt nbt = variables.getValue(1, ValueTypes.NBT);
            INbtPathExpression expression = null;
            try {
                expression = NbtPath.parse((String)string.getRawValue());
            }
            catch (NbtParseException e) {
                throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.operator_nbt_path_expression", (Object[])new Object[]{string.getRawValue(), e.getMessage()}));
            }
            if (!nbt.getRawValue().isPresent()) {
                return ValueTypeList.ValueList.ofAll((IValueType)ValueTypes.NBT, (IValue[])new IValue[0]);
            }
            List matches = expression.match((Tag)nbt.getRawValue().get()).getMatches().map(ValueTypeNbt.ValueNbt::of).collect(Collectors.toList());
            return ValueTypeList.ValueList.ofList(ValueTypes.NBT, matches);
        }).build());
        NBT_PATH_TEST = REGISTRY.register(OperatorBuilders.NBT_2.inputTypes(ValueTypes.STRING, ValueTypes.NBT).output(ValueTypes.BOOLEAN).operatorName("path_test").symbol("NBT.path_test").interactName("nbtPathTest").function(variables -> {
            ValueTypeString.ValueString string = variables.getValue(0, ValueTypes.STRING);
            ValueTypeNbt.ValueNbt nbt = variables.getValue(1, ValueTypes.NBT);
            INbtPathExpression expression = null;
            try {
                expression = NbtPath.parse((String)string.getRawValue());
            }
            catch (NbtParseException e) {
                throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.operator_nbt_path_expression", (Object[])new Object[]{string.getRawValue(), e.getMessage()}));
            }
            if (!nbt.getRawValue().isPresent()) {
                return ValueTypeBoolean.ValueBoolean.of(false);
            }
            return ValueTypeBoolean.ValueBoolean.of(expression.test((Tag)nbt.getRawValue().get()));
        }).build());
        INGREDIENTS_ITEMS = REGISTRY.register(OperatorBuilders.INGREDIENTS_1_PREFIX_LONG.output(ValueTypes.LIST).operatorInteract("items").symbol("Ingr.items").function(OperatorBuilders.createFunctionIngredientsList(() -> IngredientComponent.ITEMSTACK)).build());
        INGREDIENTS_FLUIDS = REGISTRY.register(OperatorBuilders.INGREDIENTS_1_PREFIX_LONG.output(ValueTypes.LIST).operatorInteract("fluids").symbol("Ingr.fluids").function(OperatorBuilders.createFunctionIngredientsList(() -> IngredientComponent.FLUIDSTACK)).build());
        INGREDIENTS_ENERGIES = REGISTRY.register(OperatorBuilders.INGREDIENTS_1_PREFIX_LONG.output(ValueTypes.LIST).operatorInteract("energies").symbol("Ingr.energies").function(OperatorBuilders.createFunctionIngredientsList(() -> IngredientComponent.ENERGY)).build());
        INGREDIENTS_WITH_ITEM = REGISTRY.register(OperatorBuilders.INGREDIENTS_3_ITEMSTACK.operatorName("with_item").symbol("Ingr.with_item").interactName("withItem").function(variables -> {
            ValueObjectTypeIngredients.ValueIngredients value = variables.getValue(0, ValueTypes.OBJECT_INGREDIENTS);
            ValueTypeInteger.ValueInteger index = variables.getValue(1, ValueTypes.INTEGER);
            ValueObjectTypeItemStack.ValueItemStack itemStack = variables.getValue(2, ValueTypes.OBJECT_ITEMSTACK);
            if (!value.getRawValue().isPresent()) {
                return value;
            }
            IMixedIngredients baseIngredients = (IMixedIngredients)value.getRawValue().get();
            return ValueObjectTypeIngredients.ValueIngredients.of(new ExtendedIngredientsSingle(baseIngredients, index.getRawValue(), IngredientComponent.ITEMSTACK, itemStack.getRawValue()));
        }).build());
        INGREDIENTS_WITH_FLUID = REGISTRY.register(OperatorBuilders.INGREDIENTS_3_FLUIDSTACK.operatorName("with_fluid").symbol("Ingr.with_fluid").interactName("withFluid").function(variables -> {
            ValueObjectTypeIngredients.ValueIngredients value = variables.getValue(0, ValueTypes.OBJECT_INGREDIENTS);
            ValueTypeInteger.ValueInteger index = variables.getValue(1, ValueTypes.INTEGER);
            ValueObjectTypeFluidStack.ValueFluidStack fluidStack = variables.getValue(2, ValueTypes.OBJECT_FLUIDSTACK);
            if (!value.getRawValue().isPresent()) {
                return value;
            }
            IMixedIngredients baseIngredients = (IMixedIngredients)value.getRawValue().get();
            return ValueObjectTypeIngredients.ValueIngredients.of(new ExtendedIngredientsSingle(baseIngredients, index.getRawValue(), IngredientComponent.FLUIDSTACK, fluidStack.getRawValue()));
        }).build());
        INGREDIENTS_WITH_ENERGY = REGISTRY.register(OperatorBuilders.INGREDIENTS_3_LONG.operatorName("with_energy").symbol("Ingr.with_energy").interactName("withEnergy").function(variables -> {
            ValueObjectTypeIngredients.ValueIngredients value = variables.getValue(0, ValueTypes.OBJECT_INGREDIENTS);
            ValueTypeInteger.ValueInteger index = variables.getValue(1, ValueTypes.INTEGER);
            ValueTypeLong.ValueLong energy = variables.getValue(2, ValueTypes.LONG);
            if (!value.getRawValue().isPresent()) {
                return value;
            }
            IMixedIngredients baseIngredients = (IMixedIngredients)value.getRawValue().get();
            return ValueObjectTypeIngredients.ValueIngredients.of(new ExtendedIngredientsSingle(baseIngredients, index.getRawValue(), IngredientComponent.ENERGY, energy.getRawValue()));
        }).build());
        INGREDIENTS_WITH_ITEMS = REGISTRY.register(OperatorBuilders.INGREDIENTS_2_LIST.operatorName("with_items").symbol("Ingr.with_items").interactName("withItems").function(variables -> {
            ValueObjectTypeIngredients.ValueIngredients valueIngredients = variables.getValue(0, ValueTypes.OBJECT_INGREDIENTS);
            ValueTypeList.ValueList list = variables.getValue(1, ValueTypes.LIST);
            if (!valueIngredients.getRawValue().isPresent()) {
                return valueIngredients;
            }
            IMixedIngredients baseIngredients = (IMixedIngredients)valueIngredients.getRawValue().get();
            return ValueObjectTypeIngredients.ValueIngredients.of(new ExtendedIngredientsList(baseIngredients, IngredientComponent.ITEMSTACK, OperatorBuilders.unwrapIngredientComponentList(IngredientComponent.ITEMSTACK, list)));
        }).build());
        INGREDIENTS_WITH_FLUIDS = REGISTRY.register(OperatorBuilders.INGREDIENTS_2_LIST.operatorName("with_fluids").symbol("Ingr.with_fluids").interactName("withFluids").function(variables -> {
            ValueObjectTypeIngredients.ValueIngredients valueIngredients = variables.getValue(0, ValueTypes.OBJECT_INGREDIENTS);
            ValueTypeList.ValueList list = variables.getValue(1, ValueTypes.LIST);
            if (!valueIngredients.getRawValue().isPresent()) {
                return valueIngredients;
            }
            IMixedIngredients baseIngredients = (IMixedIngredients)valueIngredients.getRawValue().get();
            return ValueObjectTypeIngredients.ValueIngredients.of(new ExtendedIngredientsList(baseIngredients, IngredientComponent.FLUIDSTACK, OperatorBuilders.unwrapIngredientComponentList(IngredientComponent.FLUIDSTACK, list)));
        }).build());
        INGREDIENTS_WITH_ENERGIES = REGISTRY.register(OperatorBuilders.INGREDIENTS_2_LIST.renderPattern(IConfigRenderPattern.INFIX_VERYLONG).operatorName("with_energies").symbol("Ingr.with_energies").interactName("withEnergies").function(variables -> {
            ValueObjectTypeIngredients.ValueIngredients valueIngredients = variables.getValue(0, ValueTypes.OBJECT_INGREDIENTS);
            ValueTypeList.ValueList list = variables.getValue(1, ValueTypes.LIST);
            if (!valueIngredients.getRawValue().isPresent()) {
                return valueIngredients;
            }
            IMixedIngredients baseIngredients = (IMixedIngredients)valueIngredients.getRawValue().get();
            return ValueObjectTypeIngredients.ValueIngredients.of(new ExtendedIngredientsList(baseIngredients, IngredientComponent.ENERGY, OperatorBuilders.unwrapIngredientComponentList(IngredientComponent.ENERGY, list)));
        }).build());
        RECIPE_INPUT = REGISTRY.register(OperatorBuilders.RECIPE_1_SUFFIX_LONG.output(ValueTypes.OBJECT_INGREDIENTS).operatorInteract("input").symbol("recipe_in").function(variables -> {
            ValueObjectTypeRecipe.ValueRecipe value = variables.getValue(0, ValueTypes.OBJECT_RECIPE);
            if (value.getRawValue().isPresent()) {
                return ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)MixedIngredients.fromRecipeInput((IRecipeDefinition)((IRecipeDefinition)value.getRawValue().get())));
            }
            return ValueObjectTypeIngredients.ValueIngredients.of(null);
        }).build());
        RECIPE_OUTPUT = REGISTRY.register(OperatorBuilders.RECIPE_1_SUFFIX_LONG.output(ValueTypes.OBJECT_INGREDIENTS).operatorInteract("output").symbol("recipe_out").function(variables -> {
            ValueObjectTypeRecipe.ValueRecipe value = variables.getValue(0, ValueTypes.OBJECT_RECIPE);
            if (value.getRawValue().isPresent()) {
                return ValueObjectTypeIngredients.ValueIngredients.of(((IRecipeDefinition)value.getRawValue().get()).getOutput());
            }
            return ValueObjectTypeIngredients.ValueIngredients.of(null);
        }).build());
        RECIPE_WITH_INPUT = REGISTRY.register(OperatorBuilders.RECIPE_2_INFIX.output(ValueTypes.OBJECT_RECIPE).operatorName("with_input").symbol("Recipe.with_in").interactName("withInput").function(variables -> {
            ValueObjectTypeRecipe.ValueRecipe valueRecipe = variables.getValue(0, ValueTypes.OBJECT_RECIPE);
            ValueObjectTypeIngredients.ValueIngredients valueIngredients = variables.getValue(1, ValueTypes.OBJECT_INGREDIENTS);
            if (valueRecipe.getRawValue().isPresent() && valueIngredients.getRawValue().isPresent()) {
                IMixedIngredients ingredients = (IMixedIngredients)valueIngredients.getRawValue().get();
                IdentityHashMap inputs = Maps.newIdentityHashMap();
                for (IngredientComponent component : ingredients.getComponents()) {
                    IIngredientMatcher matcher = component.getMatcher();
                    inputs.put(component, ingredients.getInstances(component).stream().map(instance -> new PrototypedIngredientAlternativesList(Collections.singletonList(new PrototypedIngredient(component, instance, matcher.getExactMatchCondition())))).collect(Collectors.toList()));
                }
                return ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)new RecipeDefinition((Map)inputs, ((IRecipeDefinition)valueRecipe.getRawValue().get()).getOutput()));
            }
            return ValueObjectTypeRecipe.ValueRecipe.of(null);
        }).build());
        RECIPE_WITH_OUTPUT = REGISTRY.register(OperatorBuilders.RECIPE_2_INFIX.output(ValueTypes.OBJECT_RECIPE).operatorName("with_output").symbol("Recipe.with_out").interactName("withOutput").function(variables -> {
            ValueObjectTypeRecipe.ValueRecipe valueRecipe = variables.getValue(0, ValueTypes.OBJECT_RECIPE);
            ValueObjectTypeIngredients.ValueIngredients valueIngredients = variables.getValue(1, ValueTypes.OBJECT_INGREDIENTS);
            if (valueRecipe.getRawValue().isPresent() && valueIngredients.getRawValue().isPresent()) {
                IRecipeDefinition recipe = (IRecipeDefinition)valueRecipe.getRawValue().get();
                IdentityHashMap inputs = Maps.newIdentityHashMap();
                for (IngredientComponent component : recipe.getInputComponents()) {
                    inputs.put(component, recipe.getInputs(component));
                }
                return ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)new RecipeDefinition((Map)inputs, (IMixedIngredients)valueIngredients.getRawValue().get()));
            }
            return ValueObjectTypeRecipe.ValueRecipe.of(null);
        }).build());
        RECIPE_WITH_INPUT_OUTPUT = REGISTRY.register(OperatorBuilders.RECIPE_2_PREFIX.output(ValueTypes.OBJECT_RECIPE).operatorName("with_input_output").symbol("Recipe.with_io").interactName("withInputOutput").function(variables -> {
            ValueObjectTypeIngredients.ValueIngredients valueIn = variables.getValue(0, ValueTypes.OBJECT_INGREDIENTS);
            ValueObjectTypeIngredients.ValueIngredients valueOut = variables.getValue(1, ValueTypes.OBJECT_INGREDIENTS);
            if (valueIn.getRawValue().isPresent() && valueOut.getRawValue().isPresent()) {
                IMixedIngredients ingredients = (IMixedIngredients)valueIn.getRawValue().get();
                IdentityHashMap inputs = Maps.newIdentityHashMap();
                for (IngredientComponent component : ingredients.getComponents()) {
                    IIngredientMatcher matcher = component.getMatcher();
                    inputs.put(component, ingredients.getInstances(component).stream().map(instance -> new PrototypedIngredientAlternativesList(Collections.singletonList(new PrototypedIngredient(component, instance, matcher.getExactMatchCondition())))).collect(Collectors.toList()));
                }
                try {
                    return ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)new RecipeDefinition((Map)inputs, (IMixedIngredients)valueOut.getRawValue().get()));
                }
                catch (IllegalArgumentException e) {
                    throw new EvaluationException(Component.m_237113_((String)e.getMessage()));
                }
            }
            return ValueObjectTypeRecipe.ValueRecipe.of(null);
        }).build());
        PARSE_BOOLEAN = REGISTRY.register(new ParseOperator(ValueTypes.BOOLEAN, v -> {
            ValueTypeString.ValueString value = v.getValue(0, ValueTypes.STRING);
            Pattern p = Pattern.compile("\\A(F(alse)?|[+-]?(0x|#)?0+|)\\z", 1);
            return ValueTypeBoolean.ValueBoolean.of(!p.matcher(value.getRawValue().trim()).matches());
        }));
        PARSE_DOUBLE = REGISTRY.register(new ParseOperator(ValueTypes.DOUBLE, v -> {
            ValueTypeString.ValueString value = v.getValue(0, ValueTypes.STRING);
            try {
                return ValueTypeDouble.ValueDouble.of(Double.parseDouble(value.getRawValue()));
            }
            catch (NumberFormatException e) {
                try {
                    Pattern p = Pattern.compile("\\A([+-]?)(Inf(inity)?|\u221e)\\z", 1);
                    vendors.com.google.re2j.Matcher m = p.matcher(value.getRawValue().trim());
                    if (m.matches()) {
                        if (m.group(1).equals("-")) {
                            return ValueTypeDouble.ValueDouble.of(Double.NEGATIVE_INFINITY);
                        }
                        return ValueTypeDouble.ValueDouble.of(Double.POSITIVE_INFINITY);
                    }
                    return ValueTypeDouble.ValueDouble.of(Long.decode(value.getRawValue()).longValue());
                }
                catch (NumberFormatException e2) {
                    throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.parse", (Object[])new Object[]{value.getRawValue(), Component.m_237115_((String)ValueTypes.DOUBLE.getTranslationKey())}));
                }
            }
        }));
        PARSE_INTEGER = REGISTRY.register(new ParseOperator(ValueTypes.INTEGER, v -> {
            ValueTypeString.ValueString value = v.getValue(0, ValueTypes.STRING);
            try {
                return ValueTypeInteger.ValueInteger.of(Integer.decode(value.getRawValue()));
            }
            catch (NumberFormatException e) {
                throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.parse", (Object[])new Object[]{value.getRawValue(), Component.m_237115_((String)ValueTypes.INTEGER.getTranslationKey())}));
            }
        }));
        PARSE_LONG = REGISTRY.register(new ParseOperator(ValueTypes.LONG, v -> {
            ValueTypeString.ValueString value = v.getValue(0, ValueTypes.STRING);
            try {
                return ValueTypeLong.ValueLong.of(Long.decode(value.getRawValue()));
            }
            catch (NumberFormatException e) {
                throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.parse", (Object[])new Object[]{value.getRawValue(), Component.m_237115_((String)ValueTypes.LONG.getTranslationKey())}));
            }
        }));
        PARSE_NBT = REGISTRY.register(new ParseOperator(ValueTypes.NBT, v -> {
            ValueTypeString.ValueString value = v.getValue(0, ValueTypes.STRING);
            try {
                return ValueTypeNbt.ValueNbt.of((Tag)TagParser.m_129359_((String)value.getRawValue()));
            }
            catch (CommandSyntaxException e) {
                throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.parse", (Object[])new Object[]{value.getRawValue(), Component.m_237115_((String)ValueTypes.NBT.getTranslationKey())}));
            }
        }));
        GENERAL_CHOICE = REGISTRY.register(new GeneralChoiceOperator("?", "choice", "choice"));
        GENERAL_IDENTITY = REGISTRY.register(new GeneralIdentityOperator("id", "identity", "identity"));
        GENERAL_CONSTANT = REGISTRY.register(new GeneralConstantOperator("K", "constant", "constant"));
    }
}

