/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.function.Supplier;
import org.cyclops.integrateddynamics.api.network.IPartPosIteratorHandler;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class PartPosIteratorHandlerRoundRobin
implements IPartPosIteratorHandler {
    private int offset;

    public PartPosIteratorHandlerRoundRobin(int offset) {
        this.offset = offset;
    }

    public PartPosIteratorHandlerRoundRobin() {
        this(0);
    }

    @Override
    public Iterator<PartPos> handleIterator(Supplier<Iterator<PartPos>> iteratorSupplier, int channel) {
        Iterator<PartPos> it = iteratorSupplier.get();
        int advanced = Iterators.advance(it, (int)this.offset);
        if (this.offset >= advanced && !it.hasNext()) {
            this.offset = Math.max(0, this.offset - advanced);
            it = iteratorSupplier.get();
        }
        return new CountingIterator(this, it, this.offset, iteratorSupplier);
    }

    @Override
    public IPartPosIteratorHandler clone() {
        return new PartPosIteratorHandlerRoundRobin(this.offset);
    }

    public static class CountingIterator
    implements Iterator<PartPos> {
        private final PartPosIteratorHandlerRoundRobin handler;
        private Iterator<PartPos> innerIt;
        private final Supplier<Iterator<PartPos>> iteratorSupplier;
        private boolean countdownAllowedRemaining;
        private int allowedRemaining;

        public CountingIterator(PartPosIteratorHandlerRoundRobin handler, Iterator<PartPos> innerIt, int initialOffset, Supplier<Iterator<PartPos>> iteratorSupplier) {
            this.handler = handler;
            this.innerIt = innerIt;
            this.iteratorSupplier = iteratorSupplier;
            this.countdownAllowedRemaining = false;
            this.allowedRemaining = initialOffset;
        }

        @Override
        public boolean hasNext() {
            if (this.innerIt.hasNext()) {
                return true;
            }
            if (!this.countdownAllowedRemaining) {
                this.countdownAllowedRemaining = true;
                if (this.allowedRemaining > 0) {
                    this.innerIt = this.iteratorSupplier.get();
                    return this.innerIt.hasNext();
                }
            }
            return false;
        }

        @Override
        public PartPos next() {
            PartPos next = this.innerIt.next();
            ++this.handler.offset;
            if (this.countdownAllowedRemaining) {
                --this.allowedRemaining;
                if (this.allowedRemaining <= 0) {
                    this.innerIt = Iterators.forArray((Object[])new PartPos[0]);
                }
            }
            return next;
        }
    }
}

