/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.plant;

import blusunrize.immersiveengineering.common.register.IEItems;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class HempBlock
extends CropBlock
implements BonemealableBlock {
    public static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_278166_(PushReaction.DESTROY).m_60918_(SoundType.f_56758_).m_60910_().m_60966_().m_60977_();
    public static final IntegerProperty AGE = BlockStateProperties.f_222999_;
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    private static final VoxelShape[] shapesByAge = new VoxelShape[]{Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0)), Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0)), Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0)), Shapes.m_83144_(), Shapes.m_83144_()};

    public HempBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE}).m_61104_(new Property[]{TOP});
    }

    protected IntegerProperty m_7959_() {
        return AGE;
    }

    public int m_7419_() {
        return 4;
    }

    protected ItemLike m_6404_() {
        return IEItems.Misc.HEMP_SEEDS.m_5456_();
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        boolean b = super.m_7898_(state, world, pos);
        if (state.m_60734_().equals((Object)this) && ((Boolean)state.m_61143_((Property)TOP)).booleanValue()) {
            BlockState stateBelow = world.m_8055_(pos.m_7495_());
            b = stateBelow.m_60734_().equals((Object)this) && this.m_52305_(stateBelow) == this.m_7419_();
        }
        return b;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)TOP)).booleanValue()) {
            return Shapes.m_83144_();
        }
        return shapesByAge[this.m_52305_(state)];
    }

    private boolean canGrowTop(LevelReader world, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)TOP)).booleanValue()) {
            return false;
        }
        return !world.m_8055_(pos.m_7494_()).m_60734_().equals((Object)this);
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)TOP) == false;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        if (world.m_45524_(pos, 0) >= 9) {
            float f;
            int i = this.m_52305_(state);
            boolean notMaxAge = i < this.m_7419_();
            boolean canGrowTop = this.canGrowTop((LevelReader)world, pos, state);
            if ((notMaxAge || canGrowTop) && ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (rand.m_188503_((int)(25.0f / (f = HempBlock.m_52272_((Block)this, (BlockGetter)world, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0)) {
                if (notMaxAge) {
                    world.m_7731_(pos, this.m_52289_(i + 1), 2);
                    ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
                } else if (canGrowTop) {
                    BlockPos above = pos.m_7494_();
                    BlockState aboveState = (BlockState)this.m_52289_(this.m_7419_()).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true));
                    world.m_7731_(above, aboveState, 2);
                    ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)above, (BlockState)aboveState);
                }
            }
        }
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return !this.m_52307_(state) && (Boolean)state.m_61143_((Property)TOP) == false || this.canGrowTop(world, pos, state);
    }

    public void m_52263_(Level world, BlockPos pos, BlockState state) {
        int newAge = this.m_52305_(state) + this.m_7125_(world);
        boolean growTop = false;
        if (newAge > this.m_7419_()) {
            newAge = this.m_7419_();
            growTop = this.canGrowTop((LevelReader)world, pos, state);
        }
        world.m_7731_(pos, this.m_52289_(newAge), 2);
        if (growTop) {
            world.m_7731_(pos.m_7494_(), (BlockState)this.m_52289_(this.m_7419_()).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true)), 2);
        }
    }
}

