/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic.mixer;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.client.fx.FluidSplashOptions;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.mixer.MixingProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.MixerShapes;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.register.IEParticles;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.MultiFluidTank;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class MixerLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    private static final MultiblockFace OUTPUT_POS = new MultiblockFace(1, 0, 3, RelativeBlockFace.FRONT);
    public static final BlockPos REDSTONE_POS = new BlockPos(2, 1, 2);
    private static final CapabilityPosition FLUID_OUTPUT = new CapabilityPosition(1, 0, 2, RelativeBlockFace.BACK);
    private static final CapabilityPosition FLUID_INPUT = new CapabilityPosition(0, 0, 1, RelativeBlockFace.RIGHT);
    private static final CapabilityPosition ENERGY_INPUT = new CapabilityPosition(0, 1, 2, RelativeBlockFace.UP);
    private static final BlockPos ITEM_INPUT = new BlockPos(1, 1, 0);
    public static final int NUM_SLOTS = 8;
    public static final int ENERGY_CAPACITY = 16000;
    public static final int TANK_VOLUME = 8000;

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        IMultiblockLevel level = context.getLevel();
        boolean rsEnabled = state.rsState.isEnabled(context);
        boolean active = state.processor.tickServer(state, level, rsEnabled);
        RecipeEnqueueState enqueueState = this.enqueueNewRecipes(state, level.getRawLevel());
        boolean updateFromOutput = this.outputFluids(state, enqueueState.foundRecipe);
        if (updateFromOutput || enqueueState.update || active != state.isActive) {
            state.isActive = active;
            context.markMasterDirty();
            context.requestMasterBESync();
        }
    }

    private RecipeEnqueueState enqueueNewRecipes(State state, Level rawLevel) {
        List processQueue = state.processor.getQueue();
        if (state.energy.getEnergyStored() <= 0 || processQueue.size() >= state.processor.getMaxQueueSize()) {
            return RecipeEnqueueState.NOP;
        }
        if (state.tank.getFluidAmount() <= 0) {
            return RecipeEnqueueState.NOP;
        }
        IntOpenHashSet usedInvSlots = new IntOpenHashSet();
        for (MultiblockProcess process : processQueue) {
            if (!(process instanceof MixingProcess)) continue;
            MixingProcess mixingProcess = (MixingProcess)process;
            for (int i : mixingProcess.getInputSlots()) {
                usedInvSlots.add(i);
            }
        }
        NonNullList components = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
        for (int i = 0; i < components.size(); ++i) {
            if (usedInvSlots.contains(i)) continue;
            components.set(i, (Object)state.inventory.getStackInSlot(i));
        }
        boolean foundRecipe = false;
        boolean update = false;
        Object object = state.tank.fluids.iterator();
        while (object.hasNext()) {
            FluidStack fs = (FluidStack)object.next();
            MixerRecipe recipe = MixerRecipe.findRecipe(rawLevel, fs, (NonNullList<ItemStack>)components);
            if (recipe == null) continue;
            foundRecipe = true;
            MultiblockProcessInMachine process = new MixingProcess(recipe, state.tank, recipe.getUsedSlots(fs, (NonNullList<ItemStack>)components)).setInputTanks(0);
            if (!state.processor.addProcessToQueue(process, rawLevel, false)) continue;
            update = true;
        }
        return new RecipeEnqueueState(update, foundRecipe);
    }

    private boolean outputFluids(State state, boolean foundRecipe) {
        int fluidTypes = state.tank.getFluidTypes();
        if (fluidTypes <= 0 || fluidTypes <= 1 && foundRecipe && !state.outputAll) {
            return false;
        }
        IFluidHandler output = state.outputRef.getNullable();
        if (output == null) {
            return false;
        }
        if (!state.outputAll) {
            FluidStack inTank = state.tank.getFluid();
            int maxAmount = Math.min(inTank.getAmount(), 1000);
            FluidStack out = Utils.copyFluidStackWithAmount(inTank, maxAmount, false);
            int drained = output.fill(out, IFluidHandler.FluidAction.EXECUTE);
            state.tank.drain(drained, IFluidHandler.FluidAction.EXECUTE);
            return drained > 0;
        }
        int totalOut = 0;
        Iterator<FluidStack> it = state.tank.fluids.iterator();
        while (it.hasNext()) {
            FluidStack fs = it.next();
            if (fs == null) continue;
            int maxAmount = Math.min(fs.getAmount(), 1000 - totalOut);
            FluidStack out = Utils.copyFluidStackWithAmount(fs, maxAmount, false);
            int drained = output.fill(out, IFluidHandler.FluidAction.EXECUTE);
            MultiFluidTank.drain(drained, fs, it, IFluidHandler.FluidAction.EXECUTE);
            if ((totalOut += drained) < 1000) continue;
            break;
        }
        return totalOut > 0;
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (!state.isActive) {
            return;
        }
        state.animation_agitator = (state.animation_agitator + 9.0f) % 360.0f;
        IMultiblockLevel level = context.getLevel();
        if (!state.isSoundPlaying.getAsBoolean()) {
            Vec3 soundPos = level.toAbsolute(new Vec3(1.5, 1.5, 1.5));
            state.isSoundPlaying = MultiblockSound.startSound(() -> state.isActive, context.isValid(), soundPos, IESounds.mixer);
        }
        if (state.tank.fluids.isEmpty()) {
            return;
        }
        FluidStack fs = state.tank.fluids.get(0);
        float amount = (float)fs.getAmount() / (float)state.tank.getCapacity() * 1.125f;
        Vec3 relativePos = new Vec3(2.0, 0.9375 + (double)amount, 1.0);
        Vec3 partPos = level.toAbsolute(relativePos);
        float r = ApiUtils.RANDOM.nextFloat() * 0.8125f;
        float angleRad = (float)Math.toRadians(state.animation_agitator);
        partPos = partPos.m_82520_((double)r * Math.cos(angleRad), 0.0, (double)r * Math.sin(angleRad));
        Level rawLevel = level.getRawLevel();
        for (int i = 0; i < 2; ++i) {
            if (ApiUtils.RANDOM.nextBoolean()) {
                rawLevel.m_7106_((ParticleOptions)IEParticles.IE_BUBBLE.get(), partPos.f_82479_, partPos.f_82480_, partPos.f_82481_, 0.0, 0.0, 0.0);
                continue;
            }
            rawLevel.m_7106_((ParticleOptions)new FluidSplashOptions(fs.getFluid()), partPos.f_82479_, partPos.f_82480_, partPos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = ctx.getState();
        if (cap == ForgeCapabilities.ENERGY && ENERGY_INPUT.equalsOrNullFace(position)) {
            return state.energyCap.cast(ctx);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (FLUID_INPUT.equalsOrNullFace(position)) {
                return state.fluidInput.cast(ctx);
            }
            if (FLUID_OUTPUT.equals(position)) {
                return state.fluidOutput.cast(ctx);
            }
        } else if (cap == ForgeCapabilities.ITEM_HANDLER && ITEM_INPUT.equals((Object)position.posInMultiblock())) {
            return state.itemInput.cast(ctx);
        }
        return LazyOptional.empty();
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.inventory, drop);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return MixerShapes.SHAPE_GETTER;
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInMachine<MixerRecipe> {
        public final AveragingEnergyStorage energy = new AveragingEnergyStorage(16000);
        public final MultiFluidTank tank = new MultiFluidTank(8000);
        public final SlotwiseItemHandler inventory;
        public boolean outputAll;
        public final MultiblockProcessor.InMachineProcessor<MixerRecipe> processor;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public boolean isActive;
        public float animation_agitator = 0.0f;
        private BooleanSupplier isSoundPlaying = () -> false;
        private final CapabilityReference<IFluidHandler> outputRef;
        private final StoredCapability<IFluidHandler> fluidInput;
        private final StoredCapability<IFluidHandler> fluidOutput;
        private final StoredCapability<IItemHandler> itemInput;
        private final StoredCapability<IEnergyStorage> energyCap;

        public State(IInitialMultiblockContext<State> ctx) {
            this.inventory = SlotwiseItemHandler.makeWithGroups(List.of(new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.ANY_INPUT, 8)), ctx.getMarkDirtyRunnable());
            this.processor = new MultiblockProcessor.InMachineProcessor<MixerRecipe>(8, 0.0f, 8, ctx.getMarkDirtyRunnable(), MixerRecipe.RECIPES::getById);
            this.outputRef = ctx.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, OUTPUT_POS);
            this.fluidInput = new StoredCapability<ArrayFluidHandler>(ArrayFluidHandler.fillOnly(this.tank, ctx.getMarkDirtyRunnable()));
            this.fluidOutput = new StoredCapability<ArrayFluidHandler>(ArrayFluidHandler.drainOnly(this.tank, ctx.getMarkDirtyRunnable()));
            this.itemInput = new StoredCapability<SlotwiseItemHandler>(this.inventory);
            this.energyCap = new StoredCapability<AveragingEnergyStorage>(this.energy);
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
            nbt.m_128379_("outputAll", this.outputAll);
            nbt.m_128365_("processor", this.processor.toNBT());
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.outputAll = nbt.m_128471_("outputAll");
            this.processor.fromNBT(nbt.m_128423_("processor"), (getRecipe, data) -> new MixingProcess(getRecipe, data, this.tank));
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            nbt.m_128379_("isActive", this.isActive);
            nbt.m_128350_("animation_agitator", this.animation_agitator);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            this.isActive = nbt.m_128471_("isActive");
            this.animation_agitator = nbt.m_128457_("animation_agitator");
        }

        @Override
        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        @Override
        public IItemHandlerModifiable getInventory() {
            return this.inventory.getRawHandler();
        }
    }

    private record RecipeEnqueueState(boolean update, boolean foundRecipe) {
        private static final RecipeEnqueueState NOP = new RecipeEnqueueState(false, false);
    }
}

