/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl;

import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.ComponentInstance;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.MultiblockBEHelperMaster;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class MultiblockBEHelperCommon<State extends IMultiblockState>
implements IMultiblockBEHelper<State> {
    protected final BlockEntity be;
    private boolean beingDisassembled = false;
    private final Map<RelativeBlockFace, Integer> cachedRedstoneValues = new EnumMap<RelativeBlockFace, Integer>(RelativeBlockFace.class);
    protected final MultiblockRegistration<State> multiblock;
    protected final MultiblockOrientation orientation;
    private IMultiblockBEHelperMaster<State> masterHelperDuringDisassembly;
    private final EnumMap<ShapeType, CachedValue<BlockPos, MultiblockOrientation, VoxelShape>> cachedShape;

    protected MultiblockBEHelperCommon(BlockEntity be, MultiblockRegistration<State> multiblock, BlockState state) {
        this.be = be;
        this.multiblock = multiblock;
        this.orientation = new MultiblockOrientation(state, multiblock.mirrorable());
        this.cachedShape = new EnumMap(ShapeType.class);
        for (ShapeType type : ShapeType.values()) {
            this.cachedShape.put(type, new CachedValue<BlockPos, MultiblockOrientation, VoxelShape>((pos, orientation) -> {
                VoxelShape relative = multiblock.logic().shapeGetter(type).apply((BlockPos)pos);
                return orientation.transformRelativeShape(relative);
            }));
        }
    }

    @Override
    public VoxelShape getShape(@Nullable CollisionContext ctx, ShapeType type) {
        IMultiblockContext multiblockCtx;
        BlockPos posInMB = this.getPositionInMB();
        IMultiblockLogic logic = this.multiblock.logic();
        VoxelShape absoluteShape = this.cachedShape.get((Object)type).get(posInMB, this.orientation);
        if (ctx != null && this.multiblock.postProcessesShape() && (multiblockCtx = this.getContext()) != null) {
            return logic.postProcessAbsoluteShape(multiblockCtx, absoluteShape, ctx, posInMB, type);
        }
        return absoluteShape;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        MultiblockBEHelperMaster<State> masterHelper = this.getMasterHelper();
        if (masterHelper == null) {
            return LazyOptional.empty();
        }
        IMultiblockContext ctx = masterHelper.getContext();
        RelativeBlockFace relativeSide = RelativeBlockFace.from(this.orientation, side);
        CapabilityPosition position = new CapabilityPosition(this.getPositionInMB(), relativeSide);
        for (ComponentInstance<?> component : masterHelper.getComponentInstances()) {
            LazyOptional<T> fromComponent = component.getCapability(position, cap);
            if (!fromComponent.isPresent()) continue;
            return fromComponent;
        }
        return this.multiblock.logic().getCapability(ctx, position, cap);
    }

    @Override
    public InteractionResult click(Player player, InteractionHand hand, BlockHitResult hit) {
        MultiblockBEHelperMaster<State> helper = this.getMasterHelper();
        if (helper == null) {
            return InteractionResult.FAIL;
        }
        IMultiblockContext ctx = helper.getContext();
        for (ComponentInstance<?> component : helper.getComponentInstances()) {
            InteractionResult componentResult = component.click(this.getPositionInMB(), player, hand, hit, player.m_9236_().f_46443_);
            if (componentResult == InteractionResult.PASS) continue;
            return componentResult;
        }
        return this.multiblock.logic().click(ctx, this.getPositionInMB(), player, hand, hit, player.m_9236_().f_46443_);
    }

    @Override
    public void disassemble() {
        if (this.beingDisassembled) {
            return;
        }
        this.masterHelperDuringDisassembly = this.getMasterHelperWithChunkloads();
        if (this.masterHelperDuringDisassembly == null) {
            return;
        }
        IMultiblockContext<State> ctx = this.masterHelperDuringDisassembly.getContext();
        IMultiblockLevel levelWrapper = ctx.getLevel();
        BlockPos absolutePos = levelWrapper.toAbsolute(this.getPositionInMB());
        Level levelRaw = levelWrapper.getRawLevel();
        this.getMultiblock().disassemble().disassemble(levelRaw, levelWrapper.getAbsoluteOrigin(), levelWrapper.getOrientation());
        levelRaw.m_7471_(absolutePos, false);
    }

    @Override
    public void onEntityCollided(Entity collided) {
        MultiblockBEHelperMaster<State> helper = this.getMasterHelper();
        if (helper == null) {
            return;
        }
        this.getMultiblock().logic().onEntityCollision(helper.getContext(), this.getPositionInMB(), collided);
        for (ComponentInstance<?> component : helper.getComponentInstances()) {
            component.onEntityCollision(this.getPositionInMB(), collided);
        }
    }

    @Nullable
    protected abstract IMultiblockBEHelperMaster<State> getMasterHelperWithChunkloads();

    @Nullable
    protected abstract MultiblockBEHelperMaster<State> getMasterHelper();

    @Override
    public void markDisassembling() {
        this.beingDisassembled = true;
    }

    @Override
    public int getComparatorValue() {
        if (!this.multiblock.hasComparatorOutput()) {
            return 0;
        }
        MultiblockBEHelperMaster<State> masterHelper = this.getMasterHelper();
        if (masterHelper == null) {
            return 0;
        }
        return masterHelper.getCurrentComparatorOutputs().getInt((Object)this.getPositionInMB());
    }

    @Override
    public void onNeighborChanged(BlockPos fromPos) {
        BlockPos delta = fromPos.m_121996_((Vec3i)this.be.m_58899_());
        Direction sideAbsolute = Direction.m_122372_((float)delta.m_123341_(), (float)delta.m_123342_(), (float)delta.m_123343_());
        Preconditions.checkNotNull((Object)sideAbsolute);
        this.updateRedstoneValue(sideAbsolute, fromPos);
    }

    @Override
    public int getRedstoneInput(RelativeBlockFace side) {
        if (this.cachedRedstoneValues.containsKey((Object)side)) {
            return this.cachedRedstoneValues.get((Object)side);
        }
        Direction absoluteFace = side.forFront(this.orientation);
        BlockPos neighbor = this.be.m_58899_().m_121945_(absoluteFace);
        return this.updateRedstoneValue(absoluteFace, neighbor);
    }

    @Override
    public BlockState getOriginalBlock(Level level) {
        for (StructureTemplate.StructureBlockInfo block : this.multiblock.getStructure().apply(level)) {
            if (!block.f_74675_().equals((Object)this.getPositionInMB())) continue;
            return block.f_74676_();
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    public ItemStack getPickBlock() {
        Level level = this.be.m_58904_();
        if (level == null) {
            return ItemStack.f_41583_;
        }
        return Utils.getPickBlock(this.getOriginalBlock(level));
    }

    @Nullable
    public IMultiblockBEHelperMaster<State> getMasterHelperDuringDisassembly() {
        if (this.masterHelperDuringDisassembly != null) {
            return this.masterHelperDuringDisassembly;
        }
        return this.getMasterHelperWithChunkloads();
    }

    private int updateRedstoneValue(Direction sideAbsolute, BlockPos neighborPos) {
        Level level = Objects.requireNonNull(this.be.m_58904_());
        int rsStrength = level.m_277185_(neighborPos, sideAbsolute);
        RelativeBlockFace sideRelative = RelativeBlockFace.from(this.orientation, sideAbsolute);
        this.cachedRedstoneValues.put(sideRelative, rsStrength);
        return rsStrength;
    }

    protected static class CachedValue<K1, K2, T> {
        private final BiFunction<K1, K2, T> computeValue;
        @Nullable
        private T value;
        private K1 key1;
        private K2 key2;

        protected CachedValue(BiFunction<K1, K2, T> computeValue) {
            this.computeValue = computeValue;
        }

        public T get(K1 first, K2 second) {
            if (this.value == null || !Objects.equals(first, this.key1) || !Objects.equals(second, this.key2)) {
                this.value = this.computeValue.apply(first, second);
                this.key1 = first;
                this.key2 = second;
            }
            return this.value;
        }
    }
}

