/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.data;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.json.ItemAdapter;
import dev.shadowsoffire.placebo.json.NBTAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public record DataModel(EntityType<? extends LivingEntity> type, List<EntityType<? extends LivingEntity>> subtypes, MutableComponent name, CompoundTag displayNbt, float guiScale, float guiXOff, float guiYOff, float guiZOff, int simCost, ItemStack input, ItemStack baseDrop, String triviaKey, List<ItemStack> fabDrops, int[] tierData, int[] dataPerKill) implements CodecProvider<DataModel>
{
    public static final Codec<DataModel> CODEC = new DataModelCodec();

    public DataModel(DataModel other, List<ItemStack> newResults) {
        this(other.type, other.subtypes, other.name, other.displayNbt, other.guiScale, other.guiYOff, other.guiXOff, other.guiZOff, other.simCost, other.input, other.baseDrop, other.triviaKey, newResults, other.tierData, other.dataPerKill);
    }

    public int getTierData(ModelTier tier) {
        return this.tierData[tier.ordinal()];
    }

    public int getDataPerKill(ModelTier tier) {
        return this.dataPerKill[tier.ordinal()];
    }

    public ItemStack getPredictionDrop() {
        ItemStack stk = new ItemStack((ItemLike)Hostile.Items.PREDICTION.get());
        DataModelItem.setStoredModel(stk, this);
        return stk;
    }

    public int getNameColor() {
        return this.name.m_7383_().m_131135_().m_131265_();
    }

    public DataModel validate(ResourceLocation key) {
        Preconditions.checkNotNull(this.type, (Object)"Invalid entity type!");
        Preconditions.checkNotNull((Object)this.name, (Object)"Invalid entity name!");
        Preconditions.checkNotNull((Object)this.name.m_7383_().m_131135_(), (Object)"Invalid entity name color!");
        Preconditions.checkArgument((this.guiScale > 0.0f ? 1 : 0) != 0, (Object)"Invalid gui scale!");
        Preconditions.checkArgument((this.simCost > 0 ? 1 : 0) != 0, (Object)"Invalid simulation cost!");
        Preconditions.checkArgument((this.input != null && !this.input.m_41619_() ? 1 : 0) != 0, (Object)"Invalid input item!");
        Preconditions.checkNotNull((Object)this.baseDrop, (Object)"Invalid base drop!");
        Preconditions.checkNotNull((Object)this.triviaKey, (Object)"Invalid trivia key!");
        Preconditions.checkNotNull(this.fabDrops, (Object)"Missing fabricator drops!");
        this.fabDrops.forEach(t -> Preconditions.checkArgument((t != null && !t.m_41619_() ? 1 : 0) != 0, (Object)"Invalid fabricator drop!"));
        Preconditions.checkArgument((this.tierData != null && this.tierData.length == 5 ? 1 : 0) != 0, (Object)"Invalid tier data!");
        Preconditions.checkArgument((this.dataPerKill != null && this.dataPerKill.length == 5 ? 1 : 0) != 0, (Object)"Invalid data per kill!");
        for (int i = 0; i < 4; ++i) {
            if (this.dataPerKill[i] <= 0) {
                throw new IllegalArgumentException("Data per kill may not be zero or negative!");
            }
            if (this.tierData[i] < this.tierData[i + 1]) continue;
            throw new IllegalArgumentException("Malformed tier data, all values must be ascending!");
        }
        return this;
    }

    public Codec<? extends DataModel> getCodec() {
        return CODEC;
    }

    public static class DataModelCodec
    implements Codec<DataModel> {
        public <T> DataResult<T> encode(DataModel input, DynamicOps<T> ops, T prefix) {
            JsonObject obj = new JsonObject();
            ResourceLocation key = EntityType.m_20613_(input.type);
            obj.addProperty("entity", key.toString());
            obj.add("variants", ItemAdapter.ITEM_READER.toJsonTree(input.subtypes.stream().map(EntityType::m_20613_).toList()));
            obj.addProperty("name", ((TranslatableContents)input.name.m_214077_()).m_237508_());
            obj.addProperty("name_color", input.name.m_7383_().m_131135_().m_131274_());
            obj.add("display_nbt", (JsonElement)NBTAdapter.EITHER_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)input.displayNbt).get().left().get());
            obj.addProperty("gui_scale", (Number)Float.valueOf(input.guiScale));
            obj.addProperty("gui_x_offset", (Number)Float.valueOf(input.guiXOff));
            obj.addProperty("gui_y_offset", (Number)Float.valueOf(input.guiYOff));
            obj.addProperty("gui_z_offset", (Number)Float.valueOf(input.guiZOff));
            obj.addProperty("sim_cost", (Number)input.simCost);
            obj.add("input", ItemAdapter.ITEM_READER.toJsonTree((Object)input.input));
            obj.add("base_drop", ItemAdapter.ITEM_READER.toJsonTree((Object)input.baseDrop));
            obj.addProperty("trivia", input.triviaKey);
            JsonArray fabDrops = ItemAdapter.ITEM_READER.toJsonTree(input.fabDrops).getAsJsonArray();
            for (JsonElement e : fabDrops) {
                JsonObject drop = e.getAsJsonObject();
                ResourceLocation itemName = new ResourceLocation(drop.get("item").getAsString());
                if ("minecraft".equals(itemName.m_135827_()) || key.m_135827_().equals(itemName.m_135827_())) continue;
                drop.addProperty("optional", Boolean.valueOf(true));
            }
            obj.add("fabricator_drops", (JsonElement)fabDrops);
            obj.add("tier_data", ItemAdapter.ITEM_READER.toJsonTree((Object)Arrays.copyOfRange(input.tierData, 1, 5)));
            obj.add("data_per_kill", ItemAdapter.ITEM_READER.toJsonTree((Object)Arrays.copyOfRange(input.dataPerKill, 0, 4)));
            return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, (JsonElement)obj));
        }

        public <T> DataResult<Pair<DataModel, T>> decode(DynamicOps<T> ops, T input) {
            JsonObject obj = ((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)).getAsJsonObject();
            String eTypeStr = obj.get("entity").getAsString();
            EntityType t = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(eTypeStr));
            if (t == EntityType.f_20510_ && !"minecraft:pig".equals(eTypeStr)) {
                throw new JsonParseException("DataModel has invalid entity type " + eTypeStr);
            }
            ArrayList<EntityType<? extends LivingEntity>> subtypes = new ArrayList<EntityType<? extends LivingEntity>>();
            if (obj.has("variants")) {
                for (JsonElement json : obj.get("variants").getAsJsonArray()) {
                    EntityType st = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(json.getAsString()));
                    if (st == EntityType.f_20510_ && !"minecraft:pig".equals(json.getAsString())) continue;
                    subtypes.add(st);
                }
            }
            MutableComponent name = Component.m_237115_((String)obj.get("name").getAsString());
            if (obj.has("name_color")) {
                String colorStr = obj.get("name_color").getAsString();
                TextColor color = TextColor.m_131268_((String)colorStr);
                name = name.m_130948_(Style.f_131099_.m_131148_(color));
            } else {
                name.m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE));
            }
            float guiScale = obj.get("gui_scale").getAsFloat();
            float guiXOff = obj.get("gui_x_offset").getAsFloat();
            float guiYOff = obj.get("gui_y_offset").getAsFloat();
            float guiZOff = obj.get("gui_z_offset").getAsFloat();
            int simCost = obj.get("sim_cost").getAsInt();
            ItemStack inputItem = (ItemStack)ItemAdapter.ITEM_READER.fromJson(obj.get("input"), ItemStack.class);
            ItemStack baseDrop = (ItemStack)ItemAdapter.ITEM_READER.fromJson(obj.get("base_drop"), ItemStack.class);
            if (baseDrop.m_41619_()) {
                baseDrop = new ItemStack((ItemLike)Items.f_42127_);
                baseDrop.m_41714_((Component)Component.m_237115_((String)"hostilenetworks.info.no_base_drop"));
            }
            String triviaKey = obj.has("trivia") ? obj.get("trivia").getAsString() : "hostilenetworks.trivia.nothing";
            List fabDrops = (List)ItemAdapter.ITEM_READER.fromJson(obj.get("fabricator_drops"), new TypeToken<List<ItemStack>>(){}.getType());
            fabDrops.removeIf(ItemStack::m_41619_);
            int[] tierData = ModelTier.defaultData();
            if (obj.has("tier_data")) {
                JsonArray arr = obj.get("tier_data").getAsJsonArray();
                tierData = Stream.of(new JsonPrimitive((Number)0), arr.get(0), arr.get(1), arr.get(2), arr.get(3)).mapToInt(JsonElement::getAsShort).toArray();
            }
            int[] dataPerKill = ModelTier.defaultDataPerKill();
            if (obj.has("data_per_kill")) {
                JsonArray arr = obj.get("data_per_kill").getAsJsonArray();
                dataPerKill = Stream.of(arr.get(0), arr.get(1), arr.get(2), arr.get(3), new JsonPrimitive((Number)0)).mapToInt(JsonElement::getAsShort).toArray();
            }
            CompoundTag displayNbt = new CompoundTag();
            if (obj.has("display_nbt")) {
                displayNbt = (CompoundTag)((Pair)NBTAdapter.EITHER_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj.get("display_nbt")).result().get()).getFirst();
            }
            return DataResult.success((Object)Pair.of((Object)new DataModel((EntityType<? extends LivingEntity>)t, subtypes, name, displayNbt, guiScale, guiXOff, guiYOff, guiZOff, simCost, inputItem, baseDrop, triviaKey, fabDrops, tierData, dataPerKill), input));
        }
    }
}

