/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.item;

import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.Gateway;
import dev.shadowsoffire.gateways.gate.GatewayRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.tabs.ITabFiller;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class GatePearlItem
extends Item
implements ITabFiller {
    public GatePearlItem(Item.Properties props) {
        super(props);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        ItemStack stack = ctx.m_43722_();
        BlockPos pos = ctx.m_8083_();
        DynamicHolder<Gateway> gate = GatePearlItem.getGate(stack);
        if (!gate.isBound()) {
            return InteractionResult.FAIL;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        GatewayEntity entity = ((Gateway)gate.get()).createEntity(world, ctx.m_43723_());
        BlockState state = world.m_8055_(pos);
        VoxelShape shape = state.m_60812_((BlockGetter)world, pos);
        entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + (shape.m_83281_() ? 0.0 : shape.m_83297_(Direction.Axis.Y)), (double)pos.m_123343_() + 0.5);
        double spacing = Math.max(0.0, ((Gateway)gate.get()).rules().spacing());
        if (!world.m_45976_(GatewayEntity.class, entity.m_20191_().m_82400_(spacing)).isEmpty()) {
            return InteractionResult.FAIL;
        }
        int y = 0;
        while (y++ < 4 && !world.m_45786_((Entity)entity)) {
            entity.m_6034_(entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_());
        }
        if (!world.m_45786_((Entity)entity)) {
            ctx.m_43723_().m_213846_((Component)Component.m_237115_((String)"error.gateways.no_space").m_130940_(ChatFormatting.RED));
            return InteractionResult.FAIL;
        }
        world.m_7967_((Entity)entity);
        entity.onGateCreated();
        if (!ctx.m_43723_().m_7500_()) {
            stack.m_41774_(1);
        }
        return InteractionResult.CONSUME;
    }

    public static void setGate(ItemStack opener, Gateway gate) {
        opener.m_41784_().m_128359_("gateway", GatewayRegistry.INSTANCE.getKey(gate).toString());
    }

    public static DynamicHolder<Gateway> getGate(ItemStack opener) {
        return GatewayRegistry.INSTANCE.holder(new ResourceLocation(opener.m_41784_().m_128461_("gateway")));
    }

    public Component m_7626_(ItemStack stack) {
        if (stack.m_41788_()) {
            return super.m_7626_(stack);
        }
        DynamicHolder<Gateway> gate = GatePearlItem.getGate(stack);
        if (gate.isBound()) {
            return Component.m_237110_((String)"gateways.gate_pearl", (Object[])new Object[]{Component.m_237115_((String)gate.getId().toString().replace(':', '.'))}).m_130948_(Style.f_131099_.m_131148_(((Gateway)gate.get()).color()));
        }
        return super.m_7626_(stack);
    }

    public void fillItemCategory(CreativeModeTab group, CreativeModeTab.Output out) {
        GatewayRegistry.INSTANCE.getValues().stream().sorted(Comparator.comparing(Gateway::size).thenComparing(arg_0 -> ((GatewayRegistry)GatewayRegistry.INSTANCE).getKey(arg_0))).forEach(gate -> {
            ItemStack stack = new ItemStack((ItemLike)this);
            GatePearlItem.setGate(stack, gate);
            out.m_246342_(stack);
        });
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        DynamicHolder<Gateway> holder = GatePearlItem.getGate(stack);
        if (!holder.isBound()) {
            tooltip.add((Component)Component.m_237113_((String)"Errored Gate Pearl, file a bug report detailing how you obtained this."));
        } else if (FMLEnvironment.dist.isClient()) {
            ((Gateway)holder.get()).appendPearlTooltip(level, tooltip, flag);
        }
    }
}

