/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.stairs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CornerDir;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.TriangleDir;
import xfacthd.framedblocks.common.data.skippreds.pillar.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.PanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.HalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.ExtendedSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalSlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_HALF_STAIRS})
public final class HalfStairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            boolean right = (Boolean)state.m_61143_((Property)PropertyHolder.RIGHT);
            return switch (type) {
                case BlockType.FRAMED_HALF_STAIRS -> HalfStairsSkipPredicate.testAgainstHalfStairs(dir, top, right, adjState, side);
                case BlockType.FRAMED_DIVIDED_STAIRS -> HalfStairsSkipPredicate.testAgainstDividedStairs(dir, top, right, adjState, side);
                case BlockType.FRAMED_STAIRS -> HalfStairsSkipPredicate.testAgainstStairs(dir, top, right, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> HalfStairsSkipPredicate.testAgainstDoubleStairs(dir, top, right, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> HalfStairsSkipPredicate.testAgainstVerticalStairs(dir, top, right, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> HalfStairsSkipPredicate.testAgainstVerticalDoubleStairs(dir, top, right, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> HalfStairsSkipPredicate.testAgainstVerticalHalfStairs(dir, top, right, adjState, side);
                case BlockType.FRAMED_VERTICAL_DIVIDED_STAIRS -> HalfStairsSkipPredicate.testAgainstVerticalDividedStairs(dir, top, right, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> HalfStairsSkipPredicate.testAgainstSlabEdge(dir, top, right, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLAB -> HalfStairsSkipPredicate.testAgainstDividedSlab(dir, top, right, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL -> HalfStairsSkipPredicate.testAgainstDividedPanelHor(dir, top, right, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> HalfStairsSkipPredicate.testAgainstCornerPillar(dir, top, right, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_VERTICAL -> HalfStairsSkipPredicate.testAgainstDividedPanelVert(dir, top, right, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> HalfStairsSkipPredicate.testAgainstSlabCorner(dir, top, right, adjState, side);
                case BlockType.FRAMED_PANEL -> HalfStairsSkipPredicate.testAgainstPanel(dir, top, right, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> HalfStairsSkipPredicate.testAgainstDoublePanel(dir, top, right, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstSlopePanel(dir, top, right, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstExtendedSlopePanel(dir, top, right, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstDoubleSlopePanel(dir, top, right, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstInverseDoubleSlopePanel(dir, top, right, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstExtendedDoubleSlopePanel(dir, top, right, adjState, side);
                case BlockType.FRAMED_STACKED_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstStackedSlopePanel(dir, top, right, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> HalfStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, top, right, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> HalfStairsSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(dir, top, right, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> HalfStairsSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(dir, top, right, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> HalfStairsSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(dir, top, right, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> HalfStairsSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(dir, top, right, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_SLOPE_PANEL_CORNER -> HalfStairsSkipPredicate.testAgainstFlatStackedSlopePanelCorner(dir, top, right, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_PANEL_CORNER -> HalfStairsSkipPredicate.testAgainstFlatStackedInnerSlopePanelCorner(dir, top, right, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstSmallCornerSlopePanel(dir, top, right, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W -> HalfStairsSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, top, right, adjState, side);
                case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W -> HalfStairsSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, top, right, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, top, right, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W -> HalfStairsSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, top, right, adjState, side);
                case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W -> HalfStairsSkipPredicate.testAgainstLargeInnerCornerSlopePanelWall(dir, top, right, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstExtendedCornerSlopePanel(dir, top, right, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W -> HalfStairsSkipPredicate.testAgainstExtendedCornerSlopePanelWall(dir, top, right, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W -> HalfStairsSkipPredicate.testAgainstExtendedInnerCornerSlopePanelWall(dir, top, right, adjState, side);
                case BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstSmallDoubleCornerSlopePanel(dir, top, right, adjState, side);
                case BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL_W -> HalfStairsSkipPredicate.testAgainstSmallDoubleCornerSlopePanelWall(dir, top, right, adjState, side);
                case BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL_W -> HalfStairsSkipPredicate.testAgainstLargeDoubleCornerSlopePanelWall(dir, top, right, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstInverseDoubleCornerSlopePanel(dir, top, right, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL_W -> HalfStairsSkipPredicate.testAgainstInverseDoubleCornerSlopePanelWall(dir, top, right, adjState, side);
                case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstExtendedDoubleCornerSlopePanel(dir, top, right, adjState, side);
                case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL_W -> HalfStairsSkipPredicate.testAgainstExtendedDoubleCornerSlopePanelWall(dir, top, right, adjState, side);
                case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstExtendedInnerDoubleCornerSlopePanel(dir, top, right, adjState, side);
                case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL_W -> HalfStairsSkipPredicate.testAgainstExtendedInnerDoubleCornerSlopePanelWall(dir, top, right, adjState, side);
                case BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstStackedCornerSlopePanel(dir, top, right, adjState, side);
                case BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL_W -> HalfStairsSkipPredicate.testAgainstStackedCornerSlopePanelWall(dir, top, right, adjState, side);
                case BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL -> HalfStairsSkipPredicate.testAgainstStackedInnerCornerSlopePanel(dir, top, right, adjState, side);
                case BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL_W -> HalfStairsSkipPredicate.testAgainstStackedInnerCornerSlopePanelWall(dir, top, right, adjState, side);
                case BlockType.FRAMED_HALF_SLOPE -> HalfStairsSkipPredicate.testAgainstHalfSlope(dir, top, right, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> HalfStairsSkipPredicate.testAgainstDividedSlope(dir, top, right, adjState, side);
                case BlockType.FRAMED_DOUBLE_HALF_SLOPE -> HalfStairsSkipPredicate.testAgainstDoubleHalfSlope(dir, top, right, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> HalfStairsSkipPredicate.testAgainstVerticalSlopedStairs(dir, top, right, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstHalfStairs(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (HalfStairsSkipPredicate.getStairDir(dir, top, right, side).isEqualTo(HalfStairsSkipPredicate.getStairDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return true;
        }
        if (HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(HalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return true;
        }
        return HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(HalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, adjRight, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_STAIRS, partTargets={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstDividedStairs(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstHalfStairs(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstHalfStairs(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        Half adjHalf = (Half)adjState.m_61143_((Property)StairBlock.f_56842_);
        if (HalfStairsSkipPredicate.getStairDir(dir, top, right, side).isEqualTo(StairsSkipPredicate.getStairDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return true;
        }
        if (HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return true;
        }
        return HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(StairsSkipPredicate.getCornerDir(adjDir, adjShape, adjHalf, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_STAIRS, partTargets={BlockType.FRAMED_STAIRS, BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDoubleStairs(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstStairs(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstSlabEdge(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (HalfStairsSkipPredicate.getStairDir(dir, top, right, side).isEqualTo(VerticalStairsSkipPredicate.getStairDir(adjDir, adjType, side.m_122424_()))) {
            return true;
        }
        if (HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(VerticalStairsSkipPredicate.getHalfDir(adjDir, adjType, side.m_122424_()))) {
            return true;
        }
        return HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(VerticalStairsSkipPredicate.getCornerDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS, partTargets={BlockType.FRAMED_VERTICAL_STAIRS, BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstVerticalDoubleStairs(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstVerticalStairs(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstCornerPillar(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalHalfStairs(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(VerticalHalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_VERTICAL_DIVIDED_STAIRS, partTargets={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalDividedStairs(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstVerticalHalfStairs(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstVerticalHalfStairs(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstSlabEdge(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return true;
        }
        return HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(SlabEdgeSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_SLAB, partTargets={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDividedSlab(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstSlabEdge(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstSlabEdge(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL, partTargets={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDividedPanelHor(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstSlabEdge(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstSlabEdge(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstCornerPillar(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(CornerPillarSkipPredicate.getHalfDir(adjDir, side.m_122424_()))) {
            return true;
        }
        return HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(CornerPillarSkipPredicate.getCornerDir(adjDir, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_PANEL_VERTICAL, partTargets={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstDividedPanelVert(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstCornerPillar(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstCornerPillar(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLAB_CORNER})
    private static boolean testAgainstSlabCorner(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(SlabCornerSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_PANEL})
    private static boolean testAgainstPanel(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        return HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(PanelSkipPredicate.getHalfDir(adjDir, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_PANEL, partTargets={BlockType.FRAMED_PANEL})
    private static boolean testAgainstDoublePanel(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstPanel(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstPanel(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstSlopePanel(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        return HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(SlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_EXTENDED_SLOPE_PANEL})
    private static boolean testAgainstExtendedSlopePanel(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(ExtendedSlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_SLOPE_PANEL, partTargets={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstDoubleSlopePanel(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstSlopePanel(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstSlopePanel(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL, partTargets={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstInverseDoubleSlopePanel(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstSlopePanel(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstSlopePanel(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL, partTargets={BlockType.FRAMED_EXTENDED_SLOPE_PANEL, BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstExtendedDoubleSlopePanel(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstExtendedSlopePanel(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstSlopePanel(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_SLOPE_PANEL, partTargets={BlockType.FRAMED_PANEL, BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstStackedSlopePanel(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstPanel(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstSlopePanel(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatInnerSlopePanelCorner(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        return HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedSlopePanelCorner(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatDoubleSlopePanelCorner(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, top, right, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, top, right, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER, BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_STACKED_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_PANEL})
    private static boolean testAgainstFlatStackedSlopePanelCorner(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstPanel(dir, top, right, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_PANEL, BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatStackedInnerSlopePanelCorner(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstPanel(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallCornerSlopePanel(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(SmallCornerSlopePanelSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallCornerSlopePanelWall(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(SmallCornerSlopePanelWallSkipPredicate.getCornerDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeCornerSlopePanelWall(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return HalfStairsSkipPredicate.getStairDir(dir, top, right, side).isEqualTo(LargeCornerSlopePanelWallSkipPredicate.getStairDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallInnerCornerSlopePanel(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(SmallInnerCornerSlopePanelSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallInnerCornerSlopePanelWall(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(SmallInnerCornerSlopePanelWallSkipPredicate.getCornerDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeInnerCornerSlopePanelWall(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return HalfStairsSkipPredicate.getStairDir(dir, top, right, side).isEqualTo(LargeInnerCornerSlopePanelWallSkipPredicate.getStairDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedCornerSlopePanel(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(ExtendedCornerSlopePanelSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedCornerSlopePanelWall(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return HalfStairsSkipPredicate.getCornerDir(dir, top, right, side).isEqualTo(ExtendedCornerSlopePanelWallSkipPredicate.getCornerDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedInnerCornerSlopePanelWall(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return HalfStairsSkipPredicate.getStairDir(dir, top, right, side).isEqualTo(ExtendedInnerCornerSlopePanelWallSkipPredicate.getStairDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL, BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallDoubleCornerSlopePanel(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstSmallCornerSlopePanel(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W, BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallDoubleCornerSlopePanelWall(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W, BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeDoubleCornerSlopePanelWall(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstLargeInnerCornerSlopePanelWall(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstInverseDoubleCornerSlopePanel(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W, BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstInverseDoubleCornerSlopePanelWall(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedDoubleCornerSlopePanel(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstExtendedCornerSlopePanel(dir, top, right, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W, BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedDoubleCornerSlopePanelWall(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstExtendedCornerSlopePanelWall(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstLargeInnerCornerSlopePanelWall(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedInnerDoubleCornerSlopePanel(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstSmallCornerSlopePanel(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W, BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedInnerDoubleCornerSlopePanelWall(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstExtendedInnerCornerSlopePanelWall(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstStackedCornerSlopePanel(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstCornerPillar(dir, top, right, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_SLAB_EDGE, BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstStackedCornerSlopePanelWall(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstSlabEdge(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL}, ignoredParts={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstStackedInnerCornerSlopePanel(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_STAIRS, BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstStackedInnerCornerSlopePanelWall(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstStairs(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstHalfSlope(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        return HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(HalfSlopeSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_SLOPE, partTargets={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstDividedSlope(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return false;
        }
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstHalfSlope(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstHalfSlope(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_HALF_SLOPE, partTargets={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstDoubleHalfSlope(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfStairsSkipPredicate.testAgainstHalfSlope(dir, top, right, (BlockState)states.m_14418_(), side) || HalfStairsSkipPredicate.testAgainstHalfSlope(dir, top, right, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_SLOPED_STAIRS})
    private static boolean testAgainstVerticalSlopedStairs(Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return HalfStairsSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()));
    }

    public static TriangleDir getStairDir(Direction dir, boolean top, boolean right, Direction side) {
        if (!right && side == dir.m_122428_() || right && side == dir.m_122427_()) {
            return TriangleDir.fromDirections(dir, top ? Direction.UP : Direction.DOWN);
        }
        return TriangleDir.NULL;
    }

    public static HalfDir getHalfDir(Direction dir, boolean top, boolean right, Direction side) {
        if (side == dir || !top && side == Direction.DOWN || top && side == Direction.UP) {
            return HalfDir.fromDirections(side, right ? dir.m_122427_() : dir.m_122428_());
        }
        return HalfDir.NULL;
    }

    public static CornerDir getCornerDir(Direction dir, boolean top, boolean right, Direction side) {
        if (side == dir.m_122424_()) {
            return CornerDir.fromDirections(side, top ? Direction.UP : Direction.DOWN, right ? dir.m_122427_() : dir.m_122428_());
        }
        if (!top && side == Direction.UP || top && side == Direction.DOWN) {
            return CornerDir.fromDirections(side, dir, right ? dir.m_122427_() : dir.m_122428_());
        }
        return CornerDir.NULL;
    }
}

