/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CornerDir;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.pillar.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_SLAB_CORNER})
public final class SlabCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            return switch (type) {
                case BlockType.FRAMED_SLAB_CORNER -> SlabCornerSkipPredicate.testAgainstCorner(dir, top, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> SlabCornerSkipPredicate.testAgainstEdge(dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLAB -> SlabCornerSkipPredicate.testAgainstDividedSlab(dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL -> SlabCornerSkipPredicate.testAgainstDividedPanelHor(dir, top, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> SlabCornerSkipPredicate.testAgainstPillar(dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_VERTICAL -> SlabCornerSkipPredicate.testAgainstDividedPanelVert(dir, top, adjState, side);
                case BlockType.FRAMED_STAIRS -> SlabCornerSkipPredicate.testAgainstStairs(dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> SlabCornerSkipPredicate.testAgainstDoubleStairs(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> SlabCornerSkipPredicate.testAgainstVerticalStairs(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> SlabCornerSkipPredicate.testAgainstVerticalDoubleStairs(dir, top, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> SlabCornerSkipPredicate.testAgainstHalfStairs(dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_STAIRS -> SlabCornerSkipPredicate.testAgainstDividedStairs(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> SlabCornerSkipPredicate.testAgainstVerticalHalfStairs(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_DIVIDED_STAIRS -> SlabCornerSkipPredicate.testAgainstVerticalDividedStairs(dir, top, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL -> SlabCornerSkipPredicate.testAgainstSmallCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W -> SlabCornerSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, top, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL -> SlabCornerSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W -> SlabCornerSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL -> SlabCornerSkipPredicate.testAgainstExtendedCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W -> SlabCornerSkipPredicate.testAgainstExtendedCornerSlopePanelWall(dir, top, adjState, side);
                case BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL -> SlabCornerSkipPredicate.testAgainstSmallDoubleCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL_W -> SlabCornerSkipPredicate.testAgainstSmallDoubleCornerSlopePanelWall(dir, top, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL -> SlabCornerSkipPredicate.testAgainstInverseDoubleCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL_W -> SlabCornerSkipPredicate.testAgainstInverseDoubleCornerSlopePanelWall(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL -> SlabCornerSkipPredicate.testAgainstExtendedDoubleCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL_W -> SlabCornerSkipPredicate.testAgainstExtendedDoubleCornerSlopePanelWall(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL -> SlabCornerSkipPredicate.testAgainstExtendedInnerDoubleCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL_W -> SlabCornerSkipPredicate.testAgainstExtendedInnerDoubleCornerSlopePanelWall(dir, top, adjState, side);
                case BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL -> SlabCornerSkipPredicate.testAgainstStackedCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL_W -> SlabCornerSkipPredicate.testAgainstStackedCornerSlopePanelWall(dir, top, adjState, side);
                case BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL -> SlabCornerSkipPredicate.testAgainstStackedInnerCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL_W -> SlabCornerSkipPredicate.testAgainstStackedInnerCornerSlopePanelWall(dir, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLAB_CORNER})
    private static boolean testAgainstCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(SlabCornerSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstEdge(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(SlabEdgeSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_SLAB, partTargets={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDividedSlab(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstEdge(dir, top, (BlockState)states.m_14418_(), side) || SlabCornerSkipPredicate.testAgainstEdge(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL, partTargets={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDividedPanelHor(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstEdge(dir, top, (BlockState)states.m_14418_(), side) || SlabCornerSkipPredicate.testAgainstEdge(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstPillar(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        return SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(CornerPillarSkipPredicate.getCornerDir(adjDir, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_PANEL_VERTICAL, partTargets={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstDividedPanelVert(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstPillar(dir, top, (BlockState)states.m_14418_(), side) || SlabCornerSkipPredicate.testAgainstPillar(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        Half adjHalf = (Half)adjState.m_61143_((Property)BlockStateProperties.f_61402_);
        return SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(StairsSkipPredicate.getCornerDir(adjDir, adjShape, adjHalf, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_STAIRS, partTargets={BlockType.FRAMED_SLAB_EDGE}, ignoredParts={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstDoubleStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstEdge(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        return SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(VerticalStairsSkipPredicate.getCornerDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS, partTargets={BlockType.FRAMED_CORNER_PILLAR}, ignoredParts={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalDoubleStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstPillar(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstHalfStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        return SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(HalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, adjRight, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_STAIRS, partTargets={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstDividedStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstHalfStairs(dir, top, (BlockState)states.m_14418_(), side) || SlabCornerSkipPredicate.testAgainstHalfStairs(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalHalfStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(VerticalHalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_VERTICAL_DIVIDED_STAIRS, partTargets={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalDividedStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstVerticalHalfStairs(dir, top, (BlockState)states.m_14418_(), side) || SlabCornerSkipPredicate.testAgainstVerticalHalfStairs(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(SmallCornerSlopePanelSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallCornerSlopePanelWall(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(SmallCornerSlopePanelWallSkipPredicate.getCornerDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallInnerCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(SmallInnerCornerSlopePanelSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallInnerCornerSlopePanelWall(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(SmallInnerCornerSlopePanelWallSkipPredicate.getCornerDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(ExtendedCornerSlopePanelSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedCornerSlopePanelWall(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(ExtendedCornerSlopePanelWallSkipPredicate.getCornerDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL, BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallDoubleCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, top, (BlockState)states.m_14418_(), side) || SlabCornerSkipPredicate.testAgainstSmallCornerSlopePanel(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W, BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallDoubleCornerSlopePanelWall(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, top, (BlockState)states.m_14418_(), side) || SlabCornerSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstInverseDoubleCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstInverseDoubleCornerSlopePanelWall(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedDoubleCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstExtendedCornerSlopePanel(dir, top, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedDoubleCornerSlopePanelWall(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstExtendedCornerSlopePanelWall(dir, top, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedInnerDoubleCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstSmallCornerSlopePanel(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedInnerDoubleCornerSlopePanelWall(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstStackedCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstPillar(dir, top, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstStackedCornerSlopePanelWall(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstEdge(dir, top, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL}, ignoredParts={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstStackedInnerCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W}, ignoredParts={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStackedInnerCornerSlopePanelWall(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, top, (BlockState)states.m_14419_(), side);
    }

    public static CornerDir getCornerDir(Direction dir, boolean top, Direction side) {
        if (!top && side == Direction.DOWN || top && side == Direction.UP) {
            return CornerDir.fromDirections(side, dir, dir.m_122428_());
        }
        if (side == dir) {
            return CornerDir.fromDirections(side, dir.m_122428_(), top ? Direction.UP : Direction.DOWN);
        }
        if (side == dir.m_122428_()) {
            return CornerDir.fromDirections(side, dir, top ? Direction.UP : Direction.DOWN);
        }
        return CornerDir.NULL;
    }
}

