/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.property;

import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import xfacthd.framedblocks.api.util.Utils;

public enum DirectionAxis implements StringRepresentable
{
    DOWN_X(Direction.DOWN, Direction.Axis.X),
    DOWN_Z(Direction.DOWN, Direction.Axis.Z),
    UP_X(Direction.UP, Direction.Axis.X),
    UP_Z(Direction.UP, Direction.Axis.Z),
    NORTH_X(Direction.NORTH, Direction.Axis.X),
    NORTH_Y(Direction.NORTH, Direction.Axis.Y),
    SOUTH_X(Direction.SOUTH, Direction.Axis.X),
    SOUTH_Y(Direction.SOUTH, Direction.Axis.Y),
    WEST_Y(Direction.WEST, Direction.Axis.Y),
    WEST_Z(Direction.WEST, Direction.Axis.Z),
    EAST_Y(Direction.EAST, Direction.Axis.Y),
    EAST_Z(Direction.EAST, Direction.Axis.Z);

    private static final DirectionAxis[][] FROM_DIR_AXIS;
    public static final int COUNT;
    private final String name = this.toString().toLowerCase(Locale.ROOT);
    private final Direction dir;
    private final Direction.Axis axis;

    private DirectionAxis(Direction dir, Direction.Axis axis) {
        this.dir = dir;
        this.axis = axis;
    }

    public Direction direction() {
        return this.dir;
    }

    public Direction.Axis axis() {
        return this.axis;
    }

    public DirectionAxis rotate(Rotation rot) {
        if (rot == Rotation.NONE) {
            return this;
        }
        if (Utils.isY(this.dir)) {
            if (rot == Rotation.CLOCKWISE_180) {
                return this;
            }
            return DirectionAxis.of(this.dir, Utils.nextAxisNotEqualTo(this.axis, this.dir.m_122434_()));
        }
        Direction.Axis newAxis = this.axis;
        if (this.axis != Direction.Axis.Y) {
            newAxis = Utils.nextAxisNotEqualTo(this.axis, Direction.Axis.Y);
        }
        return DirectionAxis.of(rot.m_55954_(this.dir), newAxis);
    }

    public DirectionAxis mirror(Mirror mirror) {
        return switch (mirror) {
            default -> throw new IncompatibleClassChangeError();
            case Mirror.NONE -> this;
            case Mirror.FRONT_BACK -> {
                if (Utils.isX(this.dir)) {
                    yield DirectionAxis.of(this.dir.m_122424_(), this.axis);
                }
                yield this;
            }
            case Mirror.LEFT_RIGHT -> Utils.isZ(this.dir) ? DirectionAxis.of(this.dir.m_122424_(), this.axis) : this;
        };
    }

    public String m_7912_() {
        return this.name;
    }

    public static DirectionAxis of(Direction dir, Direction.Axis axis) {
        DirectionAxis dirAxis = FROM_DIR_AXIS[dir.ordinal()][axis.ordinal()];
        if (dirAxis == null) {
            throw new IllegalArgumentException("Invalid dir/axis pair! Direction: " + dir + ", Axis: " + axis);
        }
        return dirAxis;
    }

    private static DirectionAxis[][] makeDirTable() {
        DirectionAxis[][] table = new DirectionAxis[6][3];
        for (DirectionAxis dirAxis : DirectionAxis.values()) {
            Direction dir = dirAxis.dir;
            Direction.Axis axis = dirAxis.axis;
            table[dir.ordinal()][axis.ordinal()] = dirAxis;
        }
        return table;
    }

    static {
        FROM_DIR_AXIS = DirectionAxis.makeDirTable();
        COUNT = DirectionAxis.values().length;
    }
}

