/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.guidebook;

import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import xfacthd.framedblocks.api.util.Utils;

public final class GuidebookCompat {
    public static final ResourceLocation BOOK_NAME = Utils.rl("books/framed_blocks.xml");
    private static boolean loaded = false;

    public static void init() {
        if (ModList.get().isLoaded("gbook") && !FMLEnvironment.production) {
            GuardedAccess.init();
            loaded = true;
        }
    }

    public static void addBookToTab(Consumer<ItemStack> tabAdder) {
        if (loaded) {
            GuardedAccess.addBookToTab(tabAdder);
        }
    }

    private GuidebookCompat() {
    }

    private static final class GuardedAccess {
        private static final RegistryObject<Item> GUIDEBOOK_ITEM = RegistryObject.create((ResourceLocation)new ResourceLocation("gbook", "guidebook"), (IForgeRegistry)ForgeRegistries.ITEMS);

        private GuardedAccess() {
        }

        public static void init() {
        }

        public static void addBookToTab(Consumer<ItemStack> tabAdder) {
            ItemStack stack = new ItemStack((ItemLike)GUIDEBOOK_ITEM.get());
            stack.m_41784_().m_128359_("Book", BOOK_NAME.toString());
            tabAdder.accept(stack);
        }
    }
}

