/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.NullableDirection;

public class FramedCollapsibleBlockEntity
extends FramedBlockEntity {
    public static final ModelProperty<Integer> OFFSETS = new ModelProperty();
    private static final int DIRECTIONS = Direction.values().length;
    private static final int VERTEX_COUNT = 4;
    private static final NeighborVertex[][] VERTEX_MAPPINGS = FramedCollapsibleBlockEntity.makeVertexMapping();
    private Direction collapsedFace = null;
    private int packedOffsets = 0;
    private byte[] vertexOffsets = new byte[4];

    public FramedCollapsibleBlockEntity(BlockPos pos, BlockState state) {
        super(FBContent.BE_TYPE_FRAMED_COLLAPSIBLE_BLOCK.get(), pos, state);
    }

    public void handleDeform(Player player) {
        HitResult hit = player.m_19907_(10.0, 0.0f, false);
        if (!(hit instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHit = (BlockHitResult)hit;
        Direction faceHit = blockHit.m_82434_();
        Vec3 hitLoc = Utils.fraction(hit.m_82450_());
        if (this.collapsedFace != null && faceHit != this.collapsedFace) {
            return;
        }
        int vert = FramedCollapsibleBlockEntity.vertexFromHit(faceHit, hitLoc);
        if (vert == 4) {
            for (int i = 0; i < 4; ++i) {
                this.handleDeformOfVertex(player, faceHit, i);
            }
        } else {
            this.handleDeformOfVertex(player, faceHit, vert);
        }
    }

    private void handleDeformOfVertex(Player player, Direction faceHit, int vert) {
        if (player.m_6144_() && this.collapsedFace != null && this.vertexOffsets[vert] > 0) {
            byte target = (byte)(this.vertexOffsets[vert] - 1);
            this.applyDeformation(vert, target, faceHit);
            this.deformNeighbors(faceHit, vert, target);
        } else if (!player.m_6144_() && this.vertexOffsets[vert] < 16) {
            byte target = (byte)(this.vertexOffsets[vert] + 1);
            this.applyDeformation(vert, target, faceHit);
            this.deformNeighbors(faceHit, vert, target);
        }
    }

    private void applyDeformation(int vertex, byte offset, Direction faceHit) {
        if ((offset = (byte)Mth.m_14045_((int)offset, (int)0, (int)16)) == this.vertexOffsets[vertex]) {
            return;
        }
        this.vertexOffsets[vertex] = offset;
        this.packedOffsets = FramedCollapsibleBlockEntity.packOffsets(this.vertexOffsets);
        if (offset == 0) {
            boolean noOffsets = true;
            for (int i = 0; i < 4; ++i) {
                if (this.vertexOffsets[i] <= 0) continue;
                noOffsets = false;
                break;
            }
            if (noOffsets) {
                this.collapsedFace = null;
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(PropertyHolder.NULLABLE_FACE, (Comparable)((Object)NullableDirection.NONE)), 3);
            } else {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        } else if (this.collapsedFace == null) {
            this.collapsedFace = faceHit;
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(PropertyHolder.NULLABLE_FACE, (Comparable)((Object)NullableDirection.fromDirection(this.collapsedFace))), 3);
        } else {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
        this.m_6596_();
    }

    private void deformNeighbors(Direction faceHit, int srcVert, byte offset) {
        NeighborVertex[] verts = VERTEX_MAPPINGS[FramedCollapsibleBlockEntity.getMappingIndex(faceHit, srcVert)];
        for (int i = 0; i < 3; ++i) {
            NeighborVertex vert = verts[i];
            BlockPos pos = this.f_58858_.m_121955_(vert.offset);
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof FramedCollapsibleBlockEntity)) continue;
            FramedCollapsibleBlockEntity be = (FramedCollapsibleBlockEntity)blockEntity;
            if (be.collapsedFace != null && be.collapsedFace != faceHit) continue;
            be.applyDeformation(vert.targetVert, offset, faceHit);
        }
    }

    public static int vertexFromHit(Direction faceHit, Vec3 loc) {
        boolean positive;
        if (Utils.isY(faceHit)) {
            double ax = Math.abs((loc.f_82479_ - 0.5) * 4.0);
            double az = Math.abs((loc.f_82481_ - 0.5) * 4.0);
            if (ax >= 0.0 && ax <= 1.0 && az >= 0.0 && az <= 1.0 && az <= 1.0 - ax) {
                return 4;
            }
            if (loc.f_82481_ < 0.5 == (faceHit == Direction.UP)) {
                return loc.f_82479_ < 0.5 ? 0 : 3;
            }
            return loc.f_82479_ < 0.5 ? 1 : 2;
        }
        double xz = Utils.isX(faceHit) ? loc.f_82481_ : loc.f_82479_;
        double axz = Math.abs((xz - 0.5) * 4.0);
        double ay = Math.abs((loc.f_82480_ - 0.5) * 4.0);
        if (axz >= 0.0 && axz <= 1.0 && ay >= 0.0 && ay <= 1.0 && ay <= 1.0 - axz) {
            return 4;
        }
        boolean bl = positive = faceHit == Direction.SOUTH || faceHit == Direction.WEST;
        if (loc.f_82480_ < 0.5) {
            return xz < 0.5 == positive ? 1 : 2;
        }
        return xz < 0.5 == positive ? 0 : 3;
    }

    public Direction getCollapsedFace() {
        return this.collapsedFace;
    }

    public byte[] getVertexOffsets() {
        return this.vertexOffsets;
    }

    public int getPackedOffsets() {
        return this.packedOffsets;
    }

    @Override
    public ModelData getModelData() {
        return ModelData.builder().with(FramedBlockData.PROPERTY, (Object)this.getModelDataInternal()).with(OFFSETS, (Object)this.getPackedOffsets()).build();
    }

    @Override
    protected void writeToDataPacket(CompoundTag nbt) {
        super.writeToDataPacket(nbt);
        nbt.m_128405_("offsets", FramedCollapsibleBlockEntity.packOffsets(this.vertexOffsets));
        nbt.m_128344_("face", (byte)(this.collapsedFace == null ? -1 : this.collapsedFace.m_122411_()));
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag nbt) {
        byte faceIdx;
        Direction face;
        boolean needUpdate = super.readFromDataPacket(nbt);
        int packed = nbt.m_128451_("offsets");
        if (packed != this.packedOffsets) {
            this.packedOffsets = packed;
            this.vertexOffsets = FramedCollapsibleBlockEntity.unpackOffsets(this.packedOffsets);
            needUpdate = true;
        }
        Direction direction = face = (faceIdx = nbt.m_128445_("face")) == -1 ? null : Direction.m_122376_((int)faceIdx);
        if (this.collapsedFace != face) {
            this.collapsedFace = face;
            needUpdate = true;
        }
        return needUpdate;
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("offsets", this.packedOffsets);
        nbt.m_128344_("face", (byte)(this.collapsedFace == null ? -1 : this.collapsedFace.m_122411_()));
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        this.packedOffsets = nbt.m_128451_("offsets");
        this.vertexOffsets = FramedCollapsibleBlockEntity.unpackOffsets(this.packedOffsets);
        byte face = nbt.m_128445_("face");
        this.collapsedFace = face == -1 ? null : Direction.m_122376_((int)face);
        super.handleUpdateTag(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("offsets", this.packedOffsets);
        nbt.m_128405_("face", this.collapsedFace == null ? -1 : this.collapsedFace.m_122411_());
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.packedOffsets = nbt.m_128451_("offsets");
        this.vertexOffsets = FramedCollapsibleBlockEntity.unpackOffsets(this.packedOffsets);
        int face = nbt.m_128451_("face");
        this.collapsedFace = face == -1 ? null : Direction.m_122376_((int)face);
    }

    public static int packOffsets(byte[] offsets) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result |= offsets[i] << i * 5;
        }
        return result;
    }

    public static byte[] unpackOffsets(int packed) {
        byte[] offsets = new byte[4];
        for (int i = 0; i < 4; ++i) {
            offsets[i] = (byte)(packed >> i * 5 & 0x1F);
        }
        return offsets;
    }

    private static int getMappingIndex(Direction face, int srcVert) {
        return face.ordinal() * 4 + srcVert;
    }

    private static NeighborVertex[][] makeVertexMapping() {
        NeighborVertex[][] mappings = new NeighborVertex[DIRECTIONS * 4][];
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.UP, 0, new NeighborVertex(new Vec3i(-1, 0, 0), 3), new NeighborVertex(new Vec3i(0, 0, -1), 1), new NeighborVertex(new Vec3i(-1, 0, -1), 2));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.UP, 1, new NeighborVertex(new Vec3i(-1, 0, 0), 2), new NeighborVertex(new Vec3i(0, 0, 1), 0), new NeighborVertex(new Vec3i(-1, 0, 1), 3));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.UP, 2, new NeighborVertex(new Vec3i(1, 0, 0), 1), new NeighborVertex(new Vec3i(0, 0, 1), 3), new NeighborVertex(new Vec3i(1, 0, 1), 0));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.UP, 3, new NeighborVertex(new Vec3i(1, 0, 0), 0), new NeighborVertex(new Vec3i(0, 0, -1), 2), new NeighborVertex(new Vec3i(1, 0, -1), 1));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.DOWN, 0, new NeighborVertex(new Vec3i(-1, 0, 0), 3), new NeighborVertex(new Vec3i(0, 0, 1), 1), new NeighborVertex(new Vec3i(-1, 0, 1), 2));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.DOWN, 1, new NeighborVertex(new Vec3i(-1, 0, 0), 2), new NeighborVertex(new Vec3i(0, 0, -1), 0), new NeighborVertex(new Vec3i(-1, 0, -1), 3));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.DOWN, 2, new NeighborVertex(new Vec3i(1, 0, 0), 1), new NeighborVertex(new Vec3i(0, 0, -1), 3), new NeighborVertex(new Vec3i(1, 0, -1), 0));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.DOWN, 3, new NeighborVertex(new Vec3i(1, 0, 0), 0), new NeighborVertex(new Vec3i(0, 0, 1), 2), new NeighborVertex(new Vec3i(1, 0, 1), 1));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.NORTH, 0, new NeighborVertex(new Vec3i(1, 0, 0), 3), new NeighborVertex(new Vec3i(0, 1, 0), 1), new NeighborVertex(new Vec3i(1, 1, 0), 2));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.NORTH, 1, new NeighborVertex(new Vec3i(1, 0, 0), 2), new NeighborVertex(new Vec3i(0, -1, 0), 0), new NeighborVertex(new Vec3i(1, -1, 0), 3));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.NORTH, 2, new NeighborVertex(new Vec3i(-1, 0, 0), 1), new NeighborVertex(new Vec3i(0, -1, 0), 3), new NeighborVertex(new Vec3i(-1, -1, 0), 0));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.NORTH, 3, new NeighborVertex(new Vec3i(-1, 0, 0), 0), new NeighborVertex(new Vec3i(0, 1, 0), 2), new NeighborVertex(new Vec3i(-1, 1, 0), 1));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.SOUTH, 0, new NeighborVertex(new Vec3i(-1, 0, 0), 3), new NeighborVertex(new Vec3i(0, 1, 0), 1), new NeighborVertex(new Vec3i(-1, 1, 0), 2));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.SOUTH, 1, new NeighborVertex(new Vec3i(-1, 0, 0), 2), new NeighborVertex(new Vec3i(0, -1, 0), 0), new NeighborVertex(new Vec3i(-1, -1, 0), 3));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.SOUTH, 2, new NeighborVertex(new Vec3i(1, 0, 0), 1), new NeighborVertex(new Vec3i(0, -1, 0), 3), new NeighborVertex(new Vec3i(1, -1, 0), 0));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.SOUTH, 3, new NeighborVertex(new Vec3i(1, 0, 0), 0), new NeighborVertex(new Vec3i(0, 1, 0), 2), new NeighborVertex(new Vec3i(1, 1, 0), 1));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.EAST, 0, new NeighborVertex(new Vec3i(0, 0, 1), 3), new NeighborVertex(new Vec3i(0, 1, 0), 1), new NeighborVertex(new Vec3i(0, 1, 1), 2));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.EAST, 1, new NeighborVertex(new Vec3i(0, 0, 1), 2), new NeighborVertex(new Vec3i(0, -1, 0), 0), new NeighborVertex(new Vec3i(0, -1, 1), 3));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.EAST, 2, new NeighborVertex(new Vec3i(0, 0, -1), 1), new NeighborVertex(new Vec3i(0, -1, 0), 3), new NeighborVertex(new Vec3i(0, -1, -1), 0));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.EAST, 3, new NeighborVertex(new Vec3i(0, 0, -1), 0), new NeighborVertex(new Vec3i(0, 1, 0), 2), new NeighborVertex(new Vec3i(0, 1, -1), 1));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.WEST, 0, new NeighborVertex(new Vec3i(0, 0, -1), 3), new NeighborVertex(new Vec3i(0, 1, 0), 1), new NeighborVertex(new Vec3i(0, 1, -1), 2));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.WEST, 1, new NeighborVertex(new Vec3i(0, 0, -1), 2), new NeighborVertex(new Vec3i(0, -1, 0), 0), new NeighborVertex(new Vec3i(0, -1, -1), 3));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.WEST, 2, new NeighborVertex(new Vec3i(0, 0, 1), 1), new NeighborVertex(new Vec3i(0, -1, 0), 3), new NeighborVertex(new Vec3i(0, -1, 1), 0));
        FramedCollapsibleBlockEntity.putMapping(mappings, Direction.WEST, 3, new NeighborVertex(new Vec3i(0, 0, 1), 0), new NeighborVertex(new Vec3i(0, 1, 0), 2), new NeighborVertex(new Vec3i(0, 1, 1), 1));
        return mappings;
    }

    private static void putMapping(NeighborVertex[][] mappings, Direction face, int srcVert, NeighborVertex vertOne, NeighborVertex vertTwo, NeighborVertex vertBoth) {
        mappings[FramedCollapsibleBlockEntity.getMappingIndex((Direction)face, (int)srcVert)] = new NeighborVertex[]{vertOne, vertTwo, vertBoth};
    }

    private record NeighborVertex(Vec3i offset, int targetVert) {
    }
}

