/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopeslab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedSlopeSlabBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedFlatSlopeSlabCornerBlock
extends FramedBlock {
    public FramedFlatSlopeSlabCornerBlock(BlockType type) {
        super(type);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PropertyHolder.TOP_HALF, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, PropertyHolder.TOP_HALF, FramedProperties.SOLID, BlockStateProperties.f_61362_, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = FramedFlatSlopeSlabCornerBlock.withCornerFacing(this.m_49966_(), context.m_43719_(), context.m_8125_(), context.m_43720_());
        state = FramedFlatSlopeSlabCornerBlock.withTop(state, (Property<Boolean>)PropertyHolder.TOP_HALF, context.m_43719_(), context.m_43720_());
        state = (BlockState)state.m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(context.m_43723_() != null && context.m_43723_().m_6144_()));
        return FramedFlatSlopeSlabCornerBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction dir;
        Direction face = hit.m_82434_();
        if (face == (dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)).m_122424_() || face == dir.m_122427_()) {
            if (this.getBlockType() == BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER) {
                face = Direction.UP;
            } else {
                double hor;
                Vec3 vec = Utils.fraction(hit.m_82450_());
                Direction perpDir = face == dir.m_122427_() ? dir : dir.m_122428_();
                double d = hor = Utils.isX(perpDir) ? vec.m_7096_() : vec.m_7094_();
                if (!Utils.isPositive(perpDir)) {
                    hor = 1.0 - hor;
                }
                double y = vec.m_7098_();
                if (((Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF)).booleanValue()) {
                    y -= 0.5;
                }
                if (((Boolean)state.m_61143_((Property)FramedProperties.TOP)).booleanValue()) {
                    y = 0.5 - y;
                }
                if (y * 2.0 >= hor) {
                    face = Direction.UP;
                }
            }
        }
        return this.rotate(state, face, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)PropertyHolder.TOP_HALF);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeSlopeBottom = FramedSlopeSlabBlock.SHAPES.get(Boolean.FALSE);
        VoxelShape shapeSlopeTop = FramedSlopeSlabBlock.SHAPES.get(Boolean.TRUE);
        VoxelShape shapeBottomBottomHalf = ShapeUtils.andUnoptimized(shapeSlopeBottom, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, shapeSlopeBottom));
        VoxelShape shapeBottomTopHalf = shapeBottomBottomHalf.m_83216_(0.0, 0.5, 0.0);
        VoxelShape shapeTopBottomHalf = ShapeUtils.andUnoptimized(shapeSlopeTop, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, shapeSlopeTop));
        VoxelShape shapeTopTopHalf = shapeTopBottomHalf.m_83216_(0.0, 0.5, 0.0);
        int maskTop = 4;
        int maskTopHalf = 8;
        VoxelShape[] shapes = new VoxelShape[16];
        ShapeUtils.makeHorizontalRotations(shapeBottomBottomHalf, Direction.NORTH, shapes, 0);
        ShapeUtils.makeHorizontalRotations(shapeBottomTopHalf, Direction.NORTH, shapes, maskTopHalf);
        ShapeUtils.makeHorizontalRotations(shapeTopBottomHalf, Direction.NORTH, shapes, maskTop);
        ShapeUtils.makeHorizontalRotations(shapeTopTopHalf, Direction.NORTH, shapes, maskTop | maskTopHalf);
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            int top = (Boolean)state.m_61143_((Property)FramedProperties.TOP) != false ? maskTop : 0;
            int topHalf = (Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF) != false ? maskTopHalf : 0;
            int idx = dir.m_122416_() | top | topHalf;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeSlopeBottom = FramedSlopeSlabBlock.SHAPES.get(Boolean.FALSE);
        VoxelShape shapeSlopeTop = FramedSlopeSlabBlock.SHAPES.get(Boolean.TRUE);
        VoxelShape shapeBottomBottomHalf = ShapeUtils.orUnoptimized(shapeSlopeBottom, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, shapeSlopeBottom));
        VoxelShape shapeBottomTopHalf = shapeBottomBottomHalf.m_83216_(0.0, 0.5, 0.0);
        VoxelShape shapeTopBottomHalf = ShapeUtils.orUnoptimized(shapeSlopeTop, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, shapeSlopeTop));
        VoxelShape shapeTopTopHalf = shapeTopBottomHalf.m_83216_(0.0, 0.5, 0.0);
        int maskTop = 4;
        int maskTopHalf = 8;
        VoxelShape[] shapes = new VoxelShape[16];
        ShapeUtils.makeHorizontalRotations(shapeBottomBottomHalf, Direction.NORTH, shapes, 0);
        ShapeUtils.makeHorizontalRotations(shapeBottomTopHalf, Direction.NORTH, shapes, maskTopHalf);
        ShapeUtils.makeHorizontalRotations(shapeTopBottomHalf, Direction.NORTH, shapes, maskTop);
        ShapeUtils.makeHorizontalRotations(shapeTopTopHalf, Direction.NORTH, shapes, maskTop | maskTopHalf);
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            int top = (Boolean)state.m_61143_((Property)FramedProperties.TOP) != false ? maskTop : 0;
            int topHalf = (Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF) != false ? maskTopHalf : 0;
            int idx = dir.m_122416_() | top | topHalf;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

