/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopeslab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedElevatedDoubleSlopeSlabBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.util.DoubleBlockTopInteractionMode;

public class FramedElevatedDoubleSlopeSlabBlock
extends AbstractFramedDoubleBlock {
    public FramedElevatedDoubleSlopeSlabBlock() {
        super(BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction face = context.m_43719_();
        Direction facing = Utils.isY(face) ? context.m_8125_() : face.m_122424_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing);
        return FramedElevatedDoubleSlopeSlabBlock.withTop(state, face, context.m_43720_());
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)FramedProperties.TOP);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, mirror);
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        boolean ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_ELEVATED_SLOPE_SLAB.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLOPE_SLAB.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing.m_122424_())).m_61124_((Property)PropertyHolder.TOP_HALF, (Comparable)Boolean.valueOf(!top))).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(!top))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        if (((Boolean)state.m_61143_((Property)FramedProperties.TOP)).booleanValue()) {
            return DoubleBlockTopInteractionMode.FIRST;
        }
        return DoubleBlockTopInteractionMode.SECOND;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction dirTwo;
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        Direction direction = dirTwo = top ? Direction.UP : Direction.DOWN;
        if (side == dirTwo || side == facing) {
            return CamoGetter.FIRST;
        }
        if (side == dirTwo.m_122424_()) {
            return CamoGetter.SECOND;
        }
        if (!Utils.isY(side)) {
            if (edge == dirTwo) {
                return CamoGetter.FIRST;
            }
            if (edge == dirTwo.m_122424_()) {
                return CamoGetter.SECOND;
            }
        }
        return CamoGetter.NONE;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        if (side == Direction.UP) {
            return top ? SolidityCheck.FIRST : SolidityCheck.SECOND;
        }
        if (side == Direction.DOWN) {
            return top ? SolidityCheck.SECOND : SolidityCheck.FIRST;
        }
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == facing) {
            return SolidityCheck.FIRST;
        }
        return SolidityCheck.BOTH;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedElevatedDoubleSlopeSlabBlockEntity(pos, state);
    }

    public static BlockState itemModelSource() {
        return (BlockState)((Block)FBContent.BLOCK_FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

