/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanelcorner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedSlopeSlabBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedCornerSlopePanelWallBlock
extends FramedBlock {
    private final boolean large;
    public static final ShapeCache<HorizontalRotation> SHAPES_LARGE = new ShapeCache<HorizontalRotation>(new EnumMap(HorizontalRotation.class), map -> {
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape shapeOne = switch (rot) {
                default -> throw new IncompatibleClassChangeError();
                case HorizontalRotation.UP, HorizontalRotation.LEFT -> ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, FramedSlopePanelBlock.SHAPES.get(HorizontalRotation.LEFT).m_83216_(0.0, 0.0, 0.5));
                case HorizontalRotation.DOWN, HorizontalRotation.RIGHT -> ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.EAST, FramedSlopePanelBlock.SHAPES.get(HorizontalRotation.RIGHT).m_83216_(0.0, 0.0, 0.5));
            };
            VoxelShape shapeTwo = switch (rot) {
                default -> throw new IncompatibleClassChangeError();
                case HorizontalRotation.UP, HorizontalRotation.RIGHT -> FramedSlopeSlabBlock.SHAPES.get(Boolean.TRUE);
                case HorizontalRotation.LEFT, HorizontalRotation.DOWN -> FramedSlopeSlabBlock.SHAPES.get(Boolean.FALSE).m_83216_(0.0, 0.5, 0.0);
            };
            VoxelShape mask = Shapes.m_83148_((VoxelShape)Shapes.m_83144_(), (VoxelShape)rot.getOpposite().getCornerShape(), (BooleanOp)BooleanOp.f_82687_);
            map.put(rot, ShapeUtils.orUnoptimized(ShapeUtils.andUnoptimized(shapeOne, shapeTwo), ShapeUtils.orUnoptimized(ShapeUtils.andUnoptimized(shapeOne, mask), ShapeUtils.andUnoptimized(shapeTwo, mask))));
        }
    });
    public static final ShapeCache<HorizontalRotation> SHAPES_SMALL_INNER = new ShapeCache<HorizontalRotation>(new EnumMap(HorizontalRotation.class), shapes -> {
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape shapeOne = switch (rot) {
                default -> throw new IncompatibleClassChangeError();
                case HorizontalRotation.UP, HorizontalRotation.LEFT -> ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.EAST, FramedSlopePanelBlock.SHAPES.get(HorizontalRotation.RIGHT).m_83216_(0.0, 0.0, 0.5));
                case HorizontalRotation.DOWN, HorizontalRotation.RIGHT -> ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, FramedSlopePanelBlock.SHAPES.get(HorizontalRotation.LEFT).m_83216_(0.0, 0.0, 0.5));
            };
            VoxelShape shapeTwo = switch (rot) {
                default -> throw new IncompatibleClassChangeError();
                case HorizontalRotation.UP, HorizontalRotation.RIGHT -> FramedSlopeSlabBlock.SHAPES.get(Boolean.FALSE).m_83216_(0.0, 0.5, 0.0);
                case HorizontalRotation.LEFT, HorizontalRotation.DOWN -> FramedSlopeSlabBlock.SHAPES.get(Boolean.TRUE);
            };
            shapes.put(rot, ShapeUtils.andUnoptimized(ShapeUtils.orUnoptimized(shapeOne, shapeTwo), rot.getCornerShape()));
        }
    });

    public FramedCornerSlopePanelWallBlock(BlockType type) {
        super(type);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(true)));
        this.large = type == BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W || type == BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, FramedProperties.Y_SLOPE, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return FramedCornerSlopePanelWallBlock.getStateForPlacement(this.m_49966_(), ctx, this.large);
    }

    public static BlockState getStateForPlacement(BlockState defState, BlockPlaceContext ctx, boolean invert) {
        Direction side = ctx.m_43719_();
        HorizontalRotation rot = HorizontalRotation.fromWallCorner(ctx.m_43720_(), side);
        if (!invert) {
            rot = rot.getOpposite();
        }
        if ((defState = (BlockState)((BlockState)defState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)side.m_122424_())).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rot))).m_61138_((Property)BlockStateProperties.f_61362_)) {
            defState = FramedCornerSlopePanelWallBlock.withWater(defState, (LevelReader)ctx.m_43725_(), ctx.m_8083_());
        }
        return defState;
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction side = hit.m_82434_();
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        Direction rotDir = rotation.withFacing(dir);
        Direction perpRotDir = rotation.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
        switch ((BlockType)this.getBlockType()) {
            case FRAMED_SMALL_CORNER_SLOPE_PANEL_W: 
            case FRAMED_LARGE_CORNER_SLOPE_PANEL_W: {
                if (side != rotDir.m_122424_() && side != perpRotDir.m_122424_()) break;
                side = dir;
                break;
            }
            case FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W: 
            case FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W: {
                if (side != rotDir && side != perpRotDir) break;
                Vec3 hitVec = hit.m_82450_();
                double paralell = Utils.fractionInDir(hitVec, dir);
                double perp = Utils.fractionInDir(hitVec, side == rotDir ? perpRotDir : rotDir) - 0.5;
                if (!(perp * 2.0 > paralell)) break;
                side = dir;
            }
        }
        return this.rotate(state, side, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (face.m_122434_() == dir.m_122434_()) {
            HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            return (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR), rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return FramedCornerSlopePanelWallBlock.mirrorCornerPanel(state, mirror);
    }

    public static BlockState mirrorCornerPanel(BlockState state, Mirror mirror) {
        HorizontalRotation rot;
        if (mirror == Mirror.NONE) {
            return state;
        }
        BlockState newState = Utils.mirrorFaceBlock(state, mirror);
        rot = rot.rotate((rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION))).isVertical() ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90);
        return (BlockState)newState.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rot));
    }

    public static ShapeProvider generateSmallShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = new VoxelShape[16];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape shapeOne = switch (rot) {
                default -> throw new IncompatibleClassChangeError();
                case HorizontalRotation.UP, HorizontalRotation.LEFT -> ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, FramedSlopePanelBlock.SHAPES.get(HorizontalRotation.LEFT));
                case HorizontalRotation.DOWN, HorizontalRotation.RIGHT -> ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.EAST, FramedSlopePanelBlock.SHAPES.get(HorizontalRotation.RIGHT));
            };
            VoxelShape shapeTwo = switch (rot) {
                default -> throw new IncompatibleClassChangeError();
                case HorizontalRotation.UP, HorizontalRotation.RIGHT -> FramedSlopeSlabBlock.SHAPES.get(Boolean.TRUE).m_83216_(0.0, 0.5, 0.0);
                case HorizontalRotation.LEFT, HorizontalRotation.DOWN -> FramedSlopeSlabBlock.SHAPES.get(Boolean.FALSE);
            };
            VoxelShape preShape = ShapeUtils.andUnoptimized(shapeOne, shapeTwo);
            ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 2);
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            int idx = dir.m_122416_() | rot.ordinal() << 2;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateLargeShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = new VoxelShape[16];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape preShape = SHAPES_LARGE.get(rot);
            ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 2);
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            int idx = dir.m_122416_() | rot.ordinal() << 2;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateSmallInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = new VoxelShape[16];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape preShape = SHAPES_SMALL_INNER.get(rot);
            ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 2);
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            int idx = dir.m_122416_() | rot.ordinal() << 2;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateLargeInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = new VoxelShape[16];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape shapeOne = switch (rot) {
                default -> throw new IncompatibleClassChangeError();
                case HorizontalRotation.UP, HorizontalRotation.LEFT -> ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.EAST, FramedSlopePanelBlock.SHAPES.get(HorizontalRotation.RIGHT));
                case HorizontalRotation.DOWN, HorizontalRotation.RIGHT -> ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, FramedSlopePanelBlock.SHAPES.get(HorizontalRotation.LEFT));
            };
            VoxelShape shapeTwo = switch (rot) {
                default -> throw new IncompatibleClassChangeError();
                case HorizontalRotation.UP, HorizontalRotation.RIGHT -> FramedSlopeSlabBlock.SHAPES.get(Boolean.FALSE);
                case HorizontalRotation.LEFT, HorizontalRotation.DOWN -> FramedSlopeSlabBlock.SHAPES.get(Boolean.TRUE).m_83216_(0.0, 0.5, 0.0);
            };
            VoxelShape preShape = ShapeUtils.orUnoptimized(shapeOne, shapeTwo);
            ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 2);
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            int idx = dir.m_122416_() | rot.ordinal() << 2;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

