/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanelcorner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerSlopePanelShape;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.item.VerticalAndWallBlockItem;

public class FramedCornerSlopePanelBlock
extends FramedBlock {
    private final boolean inner;
    private final boolean frontEdge;
    public static final ShapeCache<CornerSlopePanelShape> SHAPES = new ShapeCache<CornerSlopePanelShape>(new EnumMap(CornerSlopePanelShape.class), map -> {
        VoxelShape panelShapeBottom = FramedSlopePanelBlock.SHAPES.get(HorizontalRotation.UP);
        map.put(CornerSlopePanelShape.SMALL_BOTTOM, ShapeUtils.andUnoptimized(panelShapeBottom, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, panelShapeBottom)));
        VoxelShape panelShapeTop = FramedSlopePanelBlock.SHAPES.get(HorizontalRotation.DOWN);
        map.put(CornerSlopePanelShape.SMALL_TOP, ShapeUtils.andUnoptimized(panelShapeTop, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, panelShapeTop)));
        VoxelShape panelShapeBot = FramedSlopePanelBlock.SHAPES.get(HorizontalRotation.UP).m_83216_(0.0, 0.0, 0.5);
        VoxelShape panelShapeBotRot = ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, panelShapeBot);
        map.put(CornerSlopePanelShape.LARGE_BOTTOM, ShapeUtils.orUnoptimized(ShapeUtils.andUnoptimized(panelShapeBot, panelShapeBotRot), ShapeUtils.orUnoptimized(ShapeUtils.andUnoptimized(panelShapeBot, FramedCornerSlopePanelBlock.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0)), ShapeUtils.andUnoptimized(panelShapeBotRot, FramedCornerSlopePanelBlock.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0)))));
        panelShapeTop = FramedSlopePanelBlock.SHAPES.get(HorizontalRotation.DOWN).m_83216_(0.0, 0.0, 0.5);
        VoxelShape panelShapeTopRot = ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, panelShapeTop);
        map.put(CornerSlopePanelShape.LARGE_TOP, ShapeUtils.orUnoptimized(ShapeUtils.andUnoptimized(panelShapeTop, panelShapeTopRot), ShapeUtils.orUnoptimized(ShapeUtils.andUnoptimized(panelShapeTop, FramedCornerSlopePanelBlock.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0)), ShapeUtils.andUnoptimized(panelShapeTopRot, FramedCornerSlopePanelBlock.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0)))));
        panelShapeBottom = FramedSlopePanelBlock.SHAPES.get(HorizontalRotation.UP).m_83216_(0.0, 0.0, 0.5);
        map.put(CornerSlopePanelShape.SMALL_INNER_BOTTOM, ShapeUtils.andUnoptimized(FramedCornerSlopePanelBlock.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), ShapeUtils.orUnoptimized(panelShapeBottom, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, panelShapeBottom))));
        panelShapeTop = FramedSlopePanelBlock.SHAPES.get(HorizontalRotation.DOWN).m_83216_(0.0, 0.0, 0.5);
        map.put(CornerSlopePanelShape.SMALL_INNER_TOP, ShapeUtils.andUnoptimized(FramedCornerSlopePanelBlock.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), ShapeUtils.orUnoptimized(panelShapeTop, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, panelShapeTop))));
        panelShapeBottom = FramedSlopePanelBlock.SHAPES.get(HorizontalRotation.UP);
        map.put(CornerSlopePanelShape.LARGE_INNER_BOTTOM, ShapeUtils.orUnoptimized(panelShapeBottom, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, panelShapeBottom)));
        panelShapeTop = FramedSlopePanelBlock.SHAPES.get(HorizontalRotation.DOWN);
        map.put(CornerSlopePanelShape.LARGE_INNER_TOP, ShapeUtils.orUnoptimized(panelShapeTop, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, panelShapeTop)));
    });

    public FramedCornerSlopePanelBlock(BlockType type) {
        super(type);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
        this.inner = type == BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL || type == BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL;
        this.frontEdge = type == BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL || type == BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, FramedProperties.Y_SLOPE, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return FramedCornerSlopePanelBlock.getStateForPlacement(this.m_49966_(), ctx, this.inner, this.frontEdge);
    }

    public static BlockState getStateForPlacement(BlockState defState, BlockPlaceContext ctx, boolean invert, boolean invertFracDir) {
        Direction dir = ctx.m_8125_();
        if (invert) {
            dir = dir.m_122424_();
        }
        Direction fracDir = ctx.m_8125_();
        if (invertFracDir) {
            fracDir = fracDir.m_122424_();
        }
        if (Utils.fractionInDir(ctx.m_43720_(), fracDir.m_122427_()) > 0.5) {
            dir = dir.m_122427_();
        }
        defState = (BlockState)defState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir);
        if ((defState = FramedCornerSlopePanelBlock.withTop(defState, ctx.m_43719_(), ctx.m_43720_())).m_61138_((Property)BlockStateProperties.f_61362_)) {
            defState = FramedCornerSlopePanelBlock.withWater(defState, (LevelReader)ctx.m_43725_(), ctx.m_8083_());
        }
        return defState;
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction side = hit.m_82434_();
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        switch ((BlockType)this.getBlockType()) {
            case FRAMED_SMALL_CORNER_SLOPE_PANEL: 
            case FRAMED_LARGE_CORNER_SLOPE_PANEL: {
                if (side != dir.m_122424_() && side != dir.m_122427_()) break;
                side = Direction.UP;
                break;
            }
            case FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL: 
            case FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL: {
                if (side != dir && side != dir.m_122428_()) break;
                boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
                Vec3 hitVec = hit.m_82450_();
                double y = Utils.fractionInDir(hitVec, top ? Direction.UP : Direction.DOWN);
                double xz = Utils.fractionInDir(hitVec, side == dir ? dir.m_122428_() : dir) - 0.5;
                if (!(xz * 2.0 > y)) break;
                side = Direction.UP;
            }
        }
        return this.rotate(state, side, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        return (BlockState)state.m_61122_((Property)FramedProperties.TOP);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return this.rotate(state, Direction.UP, rotation);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    @Override
    public BlockItem createBlockItem() {
        Block other = switch ((BlockType)this.getBlockType()) {
            case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL -> (Block)FBContent.BLOCK_FRAMED_SMALL_CORNER_SLOPE_PANEL_WALL.get();
            case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL -> (Block)FBContent.BLOCK_FRAMED_LARGE_CORNER_SLOPE_PANEL_WALL.get();
            case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL -> (Block)FBContent.BLOCK_FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_WALL.get();
            case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL -> (Block)FBContent.BLOCK_FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_WALL.get();
            default -> throw new IllegalStateException("Unexpected type: " + this.getBlockType());
        };
        return new VerticalAndWallBlockItem(this, other, new Item.Properties());
    }

    public static ShapeProvider generateSmallShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(SHAPES.get(CornerSlopePanelShape.SMALL_BOTTOM), SHAPES.get(CornerSlopePanelShape.SMALL_TOP), Direction.NORTH);
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.m_122416_() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateLargeShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(SHAPES.get(CornerSlopePanelShape.LARGE_BOTTOM), SHAPES.get(CornerSlopePanelShape.LARGE_TOP), Direction.NORTH);
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.m_122416_() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateSmallInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(SHAPES.get(CornerSlopePanelShape.SMALL_INNER_BOTTOM), SHAPES.get(CornerSlopePanelShape.SMALL_INNER_TOP), Direction.SOUTH);
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.m_122416_() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateLargeInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(SHAPES.get(CornerSlopePanelShape.LARGE_INNER_BOTTOM), SHAPES.get(CornerSlopePanelShape.LARGE_INNER_TOP), Direction.SOUTH);
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.m_122416_() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

