/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleSlopeBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.util.DoubleBlockTopInteractionMode;

public class FramedDoubleSlopeBlock
extends AbstractFramedDoubleBlock {
    public FramedDoubleSlopeBlock() {
        super(BlockType.FRAMED_DOUBLE_SLOPE);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.SLOPE_TYPE, FramedProperties.Y_SLOPE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return FramedDoubleSlopeBlock.withSlopeType(this.m_49966_(), context.m_43719_(), context.m_8125_(), context.m_43720_());
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(face)) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_(PropertyHolder.SLOPE_TYPE);
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (state.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return Utils.mirrorCornerBlock(state, mirror);
        }
        return Utils.mirrorFaceBlock(state, mirror);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        boolean ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
        BlockState defState = ((Block)FBContent.BLOCK_FRAMED_SLOPE.get()).m_49966_();
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)defState.m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)type))).m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)defState.m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)(type == SlopeType.HORIZONTAL ? type : type.getOpposite())))).m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing.m_122424_())).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return switch ((SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE))) {
            default -> throw new IncompatibleClassChangeError();
            case SlopeType.BOTTOM -> DoubleBlockTopInteractionMode.SECOND;
            case SlopeType.TOP -> DoubleBlockTopInteractionMode.FIRST;
            case SlopeType.HORIZONTAL -> DoubleBlockTopInteractionMode.EITHER;
        };
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case SlopeType.HORIZONTAL -> {
                if (FramedDoubleSlopeBlock.matchesHor(side, facing) || Utils.isY(side) && FramedDoubleSlopeBlock.matchesHor(edge, facing)) {
                    yield CamoGetter.FIRST;
                }
                Direction oppFacing = facing.m_122424_();
                if (FramedDoubleSlopeBlock.matchesHor(side, oppFacing) || Utils.isY(side) && FramedDoubleSlopeBlock.matchesHor(edge, oppFacing)) {
                    yield CamoGetter.SECOND;
                }
                yield CamoGetter.NONE;
            }
            case SlopeType.TOP -> {
                if (side.m_122434_() == facing.m_122427_().m_122434_()) {
                    if (edge == facing || edge == Direction.UP) {
                        yield CamoGetter.FIRST;
                    }
                    if (edge == facing.m_122424_() || edge == Direction.DOWN) {
                        yield CamoGetter.SECOND;
                    }
                    yield CamoGetter.NONE;
                }
                if (side == facing || side == Direction.UP) {
                    yield CamoGetter.FIRST;
                }
                if (side == facing.m_122424_() || side == Direction.DOWN) {
                    yield CamoGetter.SECOND;
                }
                yield CamoGetter.NONE;
            }
            case SlopeType.BOTTOM -> {
                if (side.m_122434_() == facing.m_122427_().m_122434_()) {
                    if (edge == facing || edge == Direction.DOWN) {
                        yield CamoGetter.FIRST;
                    }
                    if (edge == facing.m_122424_() || edge == Direction.UP) {
                        yield CamoGetter.SECOND;
                    }
                    yield CamoGetter.NONE;
                }
                yield side == facing || side == Direction.DOWN ? CamoGetter.FIRST : (side == facing.m_122424_() || side == Direction.UP ? CamoGetter.SECOND : CamoGetter.NONE);
            }
        };
    }

    private static boolean matchesHor(Direction side, Direction facing) {
        return side == facing || side == facing.m_122428_();
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case SlopeType.HORIZONTAL -> {
                if (side == facing || side == facing.m_122428_()) {
                    yield SolidityCheck.FIRST;
                }
                if (side == facing.m_122424_() || side == facing.m_122427_()) {
                    yield SolidityCheck.SECOND;
                }
                yield SolidityCheck.BOTH;
            }
            case SlopeType.TOP -> {
                if (side == facing || side == Direction.UP) {
                    yield SolidityCheck.FIRST;
                }
                if (side == facing.m_122424_() || side == Direction.DOWN) {
                    yield SolidityCheck.SECOND;
                }
                yield SolidityCheck.BOTH;
            }
            case SlopeType.BOTTOM -> side == facing || side == Direction.UP ? SolidityCheck.SECOND : (side == facing.m_122424_() || side == Direction.DOWN ? SolidityCheck.FIRST : SolidityCheck.BOTH);
        };
    }

    @Override
    public final BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedDoubleSlopeBlockEntity(pos, state);
    }

    public static BlockState itemModelSource() {
        return (BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_DOUBLE_SLOPE.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.WEST)).m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.HORIZONTAL));
    }
}

