/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.sign;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.sign.AbstractFramedHangingSignBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedSignBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.item.FramedHangingSignItem;

public class FramedCeilingHangingSignBlock
extends AbstractFramedHangingSignBlock {
    public FramedCeilingHangingSignBlock() {
        super(BlockType.FRAMED_HANGING_SIGN, IFramedBlock.createProperties(BlockType.FRAMED_HANGING_SIGN).m_60910_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61386_, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61390_, BlockStateProperties.f_61386_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        boolean attached;
        BlockState state = this.m_49966_();
        Level level = ctx.m_43725_();
        BlockPos adjPos = ctx.m_8083_().m_7494_();
        BlockState adjState = level.m_8055_(adjPos);
        Direction dir = Direction.m_122364_((double)ctx.m_7074_());
        boolean bl = attached = !Block.m_49918_((VoxelShape)adjState.m_60812_((BlockGetter)level, adjPos), (Direction)Direction.DOWN) || ctx.m_7078_();
        if (adjState.m_60734_() instanceof AbstractFramedHangingSignBlock && !ctx.m_7078_()) {
            int adjRot;
            Optional optDir;
            if (adjState.m_61138_((Property)FramedProperties.FACING_HOR)) {
                Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
                if (adjDir.m_122434_().test(dir)) {
                    attached = false;
                }
            } else if (adjState.m_61138_((Property)BlockStateProperties.f_61390_) && (optDir = RotationSegment.m_247487_((int)(adjRot = ((Integer)adjState.m_61143_((Property)BlockStateProperties.f_61390_)).intValue()))).isPresent() && ((Direction)optDir.get()).m_122434_().test(dir)) {
                attached = false;
            }
        }
        int rotation = attached ? RotationSegment.m_246374_((float)(ctx.m_7074_() + 180.0f)) : RotationSegment.m_245225_((Direction)dir.m_122424_());
        state = (BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(rotation))).m_61124_((Property)BlockStateProperties.f_61386_, (Comparable)Boolean.valueOf(attached));
        return FramedCeilingHangingSignBlock.withWater(state, (LevelReader)ctx.m_43725_(), ctx.m_8083_());
    }

    @Override
    protected boolean preventUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedSignBlockEntity) {
            FramedSignBlockEntity sign = (FramedSignBlockEntity)blockEntity;
            boolean front = sign.isFacingFrontText(player);
            ItemStack stack = player.m_21120_(hand);
            return !sign.canExecuteCommands(front, player) && stack.m_41720_() == this.m_5456_() && hit.m_82434_() == Direction.DOWN;
        }
        return false;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction dir, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (dir == Direction.UP && !this.m_7898_(state, (LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, dir, facingState, level, pos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos above = pos.m_7494_();
        return level.m_8055_(above).m_60659_((BlockGetter)level, above, Direction.DOWN, SupportType.CENTER);
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.m_5940_(state, level, pos, CollisionContext.m_82749_());
    }

    @Override
    public float getYRotationDegrees(BlockState state) {
        return RotationSegment.m_245107_((int)((Integer)state.m_61143_((Property)BlockStateProperties.f_61390_)));
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        int rotation = (Integer)state.m_61143_((Property)BlockStateProperties.f_61390_);
        rotation = rot == Rotation.COUNTERCLOCKWISE_90 ? (rotation += 15) : ++rotation;
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(rotation % 16));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        int rotation = (Integer)state.m_61143_((Property)BlockStateProperties.f_61390_);
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(rot.m_55949_(rotation, 16)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        int rotation = (Integer)state.m_61143_((Property)BlockStateProperties.f_61390_);
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(mirror.m_54843_(rotation, 16)));
    }

    @Override
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return Utils.createBlockEntityTicker(type, FBContent.BE_TYPE_FRAMED_HANGING_SIGN.get(), FramedSignBlockEntity::tick);
    }

    @Override
    public BlockItem createBlockItem() {
        return new FramedHangingSignItem();
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeZeroEight = FramedCeilingHangingSignBlock.m_49796_((double)1.0, (double)0.0, (double)7.0, (double)15.0, (double)10.0, (double)9.0);
        VoxelShape shapeFourTwelve = FramedCeilingHangingSignBlock.m_49796_((double)7.0, (double)0.0, (double)1.0, (double)9.0, (double)10.0, (double)15.0);
        VoxelShape fallbackShape = FramedCeilingHangingSignBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        for (BlockState state : states) {
            int rot = (Integer)state.m_61143_((Property)BlockStateProperties.f_61390_);
            builder.put((Object)state, (Object)(switch (rot) {
                case 0, 8 -> shapeZeroEight;
                case 4, 12 -> shapeFourTwelve;
                default -> fallbackShape;
            }));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

