/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.interactive;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedChiseledBookshelfBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedChiseledBookshelfBlock
extends FramedBlock {
    public FramedChiseledBookshelfBlock() {
        super(BlockType.FRAMED_CHISELED_BOOKSHELF);
        BlockState state = this.m_49966_();
        for (BooleanProperty prop : ChiseledBookShelfBlock.f_260698_) {
            state = (BlockState)state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(false));
        }
        this.m_49959_(state);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.SOLID});
        ChiseledBookShelfBlock.f_260698_.forEach(xva$0 -> builder.m_61104_(new Property[]{xva$0}));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)ctx.m_8125_().m_122424_());
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (level.m_5776_() || !stack.m_41782_() || !stack.m_41783_().m_128441_("BlockEntityTag")) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedChiseledBookshelfBlockEntity) {
            FramedChiseledBookshelfBlockEntity be = (FramedChiseledBookshelfBlockEntity)blockEntity;
            be.forceStateUpdate();
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = super.m_6227_(state, level, pos, player, hand, hit);
        if (result != InteractionResult.PASS) {
            return result;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedChiseledBookshelfBlockEntity) {
            FramedChiseledBookshelfBlockEntity be = (FramedChiseledBookshelfBlockEntity)blockEntity;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            Optional optional = ChiseledBookShelfBlock.m_260871_((BlockHitResult)hit, (Direction)dir);
            if (optional.isEmpty()) {
                return InteractionResult.PASS;
            }
            int slot = ChiseledBookShelfBlock.m_261279_((Vec2)((Vec2)optional.get()));
            if (((Boolean)state.m_61143_((Property)ChiseledBookShelfBlock.f_260698_.get(slot))).booleanValue()) {
                FramedChiseledBookshelfBlock.takeBook(level, pos, player, be, slot);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            ItemStack stack = player.m_21120_(hand);
            if (!stack.m_204117_(ItemTags.f_244646_)) {
                return InteractionResult.CONSUME;
            }
            FramedChiseledBookshelfBlock.placeBook(level, pos, player, be, stack, slot);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    private static void placeBook(Level level, BlockPos pos, Player player, FramedChiseledBookshelfBlockEntity be, ItemStack stack, int slot) {
        if (level.m_5776_()) {
            return;
        }
        be.placeBook(stack.m_41620_(1), slot);
        if (player.m_7500_()) {
            stack.m_41769_(1);
        }
        SoundEvent sound = stack.m_150930_(Items.f_42690_) ? SoundEvents.f_256863_ : SoundEvents.f_256961_;
        level.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
        level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
    }

    private static void takeBook(Level level, BlockPos pos, Player player, FramedChiseledBookshelfBlockEntity be, int slot) {
        if (level.m_5776_()) {
            return;
        }
        ItemStack stack = be.takeBook(slot);
        if (!player.m_150109_().m_36054_(stack)) {
            player.m_36176_(stack, false);
        }
        SoundEvent sound = stack.m_150930_(Items.f_42690_) ? SoundEvents.f_257000_ : SoundEvents.f_256717_;
        level.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (newState.m_60734_() != state.m_60734_() && (blockEntity = level.m_7702_(pos)) instanceof FramedChiseledBookshelfBlockEntity) {
            FramedChiseledBookshelfBlockEntity be = (FramedChiseledBookshelfBlockEntity)blockEntity;
            be.getDrops().forEach(stack -> FramedChiseledBookshelfBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack));
            be.clearContents();
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedChiseledBookshelfBlockEntity) {
            FramedChiseledBookshelfBlockEntity be = (FramedChiseledBookshelfBlockEntity)blockEntity;
            return be.getAnalogOutputSignal();
        }
        return 0;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, mirror);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedChiseledBookshelfBlockEntity(pos, state);
    }
}

