/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.cache.StateCache;
import xfacthd.framedblocks.api.block.render.ParticleHelper;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockStateCache;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.item.FramedBlueprintItem;
import xfacthd.framedblocks.common.util.DoubleBlockTopInteractionMode;

public interface IFramedDoubleBlock
extends IFramedBlock {
    @ApiStatus.OverrideOnly
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState var1);

    @ApiStatus.OverrideOnly
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState var1);

    @ApiStatus.OverrideOnly
    public SolidityCheck calculateSolidityCheck(BlockState var1, Direction var2);

    @ApiStatus.OverrideOnly
    public CamoGetter calculateCamoGetter(BlockState var1, Direction var2, Direction var3);

    @ApiStatus.NonExtendable
    default public DoubleBlockTopInteractionMode getTopInteractionMode(BlockState state) {
        return this.getCache(state).getTopInteractionMode();
    }

    @ApiStatus.NonExtendable
    default public Tuple<BlockState, BlockState> getBlockPair(BlockState state) {
        return this.getCache(state).getBlockPair();
    }

    @ApiStatus.NonExtendable
    default public SolidityCheck getSolidityCheck(BlockState state, Direction side) {
        return this.getCache(state).getSolidityCheck(side);
    }

    @ApiStatus.NonExtendable
    default public CamoGetter getCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        return this.getCache(state).getCamoGetter(side, edge);
    }

    @Override
    default public StateCache initCache(BlockState state) {
        return new DoubleBlockStateCache(state, this.getBlockType());
    }

    @Override
    default public DoubleBlockStateCache getCache(BlockState state) {
        return (DoubleBlockStateCache)IFramedBlock.super.getCache(state);
    }

    @Override
    default public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedDoubleBlockEntity) {
            FramedDoubleBlockEntity be = (FramedDoubleBlockEntity)blockEntity;
            Tuple<BlockState, BlockState> statePair = this.getBlockPair(state);
            switch (this.getTopInteractionMode(state)) {
                case FIRST: {
                    ParticleHelper.spawnRunningParticles(be.getCamo((BlockState)statePair.m_14418_()).getState(), level, pos, entity);
                    break;
                }
                case SECOND: {
                    ParticleHelper.spawnRunningParticles(be.getCamo((BlockState)statePair.m_14419_()).getState(), level, pos, entity);
                    break;
                }
                case EITHER: {
                    ParticleHelper.spawnRunningParticles(be.getCamo((BlockState)statePair.m_14418_()).getState(), level, pos, entity);
                    ParticleHelper.spawnRunningParticles(be.getCamo((BlockState)statePair.m_14419_()).getState(), level, pos, entity);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    default public boolean addLandingEffects(BlockState state, ServerLevel level, BlockPos pos, BlockState sameState, LivingEntity entity, int count) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedDoubleBlockEntity) {
            FramedDoubleBlockEntity be = (FramedDoubleBlockEntity)blockEntity;
            Tuple<BlockState, BlockState> statePair = this.getBlockPair(state);
            switch (this.getTopInteractionMode(state)) {
                case FIRST: {
                    ParticleHelper.spawnLandingParticles(be.getCamo((BlockState)statePair.m_14418_()).getState(), level, pos, entity, count);
                    break;
                }
                case SECOND: {
                    ParticleHelper.spawnLandingParticles(be.getCamo((BlockState)statePair.m_14419_()).getState(), level, pos, entity, count);
                    break;
                }
                case EITHER: {
                    ParticleHelper.spawnLandingParticles(be.getCamo((BlockState)statePair.m_14418_()).getState(), level, pos, entity, count);
                    ParticleHelper.spawnLandingParticles(be.getCamo((BlockState)statePair.m_14419_()).getState(), level, pos, entity, count);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    default public Optional<MutableComponent> printCamoBlock(CompoundTag beTag) {
        BlockState camoState = CamoContainer.load(beTag.m_128469_("camo")).getState();
        BlockState camoStateTwo = CamoContainer.load(beTag.m_128469_("camo_two")).getState();
        MutableComponent component = IFramedDoubleBlock.getCamoComponent(camoState);
        component.m_7220_((Component)Component.m_237113_((String)" | ").m_130940_(ChatFormatting.GOLD));
        component.m_7220_((Component)IFramedDoubleBlock.getCamoComponent(camoStateTwo));
        return Optional.of(component);
    }

    private static MutableComponent getCamoComponent(BlockState camoState) {
        if (!camoState.m_60795_()) {
            return camoState.m_60734_().m_49954_().m_130940_(ChatFormatting.WHITE);
        }
        return FramedBlueprintItem.BLOCK_NONE.m_6881_();
    }
}

