/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.block;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.cube.FramedChestLidModel;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.special.FramedChestBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.ChestState;
import xfacthd.framedblocks.common.data.property.LatchType;

public class FramedChestRenderer
implements BlockEntityRenderer<FramedChestBlockEntity> {
    private static final Table<Direction, LatchType, BakedModel> LID_MODELS_PRE_CACHE = HashBasedTable.create((int)4, (int)3);
    private static final Table<Direction, LatchType, BakedModel> LID_MODELS = HashBasedTable.create((int)4, (int)3);

    public FramedChestRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(FramedChestBlockEntity be, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        float xOff;
        BlockState state = be.m_58900_();
        ChestState chestState = (ChestState)((Object)state.m_61143_(PropertyHolder.CHEST_STATE));
        if (chestState == ChestState.CLOSED) {
            return;
        }
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        long lastChange = be.getLastChangeTime(chestState);
        BakedModel model = (BakedModel)LID_MODELS.get((Object)dir, (Object)state.m_61143_(PropertyHolder.LATCH_TYPE));
        ModelData data = model.getModelData((BlockAndTintGetter)be.m_58904_(), be.m_58899_(), state, be.getModelData());
        float angle = FramedChestRenderer.calculateAngle(be, chestState, dir, lastChange, partialTicks);
        float f = Utils.isX(dir) ? (Utils.isPositive(dir) ? 0.0625f : 0.9375f) : (xOff = 0.0f);
        float zOff = Utils.isZ(dir) ? (Utils.isPositive(dir) ? 0.0625f : 0.9375f) : 0.0f;
        poseStack.m_85836_();
        poseStack.m_252880_(xOff, 0.5625f, zOff);
        poseStack.m_252781_(Utils.isX(dir) ? Axis.f_252403_.m_252977_(angle) : Axis.f_252495_.m_252977_(angle));
        poseStack.m_252880_(-xOff, -0.5625f, -zOff);
        FramedChestRenderer.renderLidModel(be, state, poseStack, buffer, model, data);
        poseStack.m_85849_();
    }

    private static void renderLidModel(FramedChestBlockEntity be, BlockState state, PoseStack matrix, MultiBufferSource buffer, BakedModel model, ModelData data) {
        ModelBlockRenderer renderer = Minecraft.m_91087_().m_91289_().m_110937_();
        RandomSource rand = be.m_58904_().m_213780_();
        int color = Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)be.m_58904_(), be.m_58899_(), 0);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int light = LevelRenderer.m_109541_((BlockAndTintGetter)be.m_58904_(), (BlockPos)be.m_58899_());
        for (RenderType type : model.getRenderTypes(state, rand, data)) {
            RenderType bufferType = RenderTypeHelper.getEntityRenderType((RenderType)type, (boolean)false);
            renderer.renderModel(matrix.m_85850_(), buffer.m_6299_(bufferType), state, model, red, green, blue, light, OverlayTexture.f_118083_, data, type);
        }
    }

    private static float calculateAngle(FramedChestBlockEntity be, ChestState chestState, Direction dir, long lastChange, float partialTicks) {
        float diff = (float)(be.m_58904_().m_46467_() - lastChange) + partialTicks;
        float factor = Mth.m_14179_((float)(diff / 10.0f), (float)0.0f, (float)1.0f);
        if (chestState == ChestState.CLOSING) {
            factor = 1.0f - factor;
        }
        factor = 1.0f - factor;
        factor = 1.0f - factor * factor * factor;
        float angle = Mth.m_14036_((float)(factor * 90.0f), (float)0.0f, (float)90.0f);
        if (!Utils.isPositive(dir)) {
            angle *= -1.0f;
        }
        return angle;
    }

    public boolean shouldRender(FramedChestBlockEntity be, Vec3 camera) {
        return ClientUtils.OPTIFINE_LOADED.get() == false && super.m_142756_((BlockEntity)be, camera);
    }

    public static void onModelsLoaded(Map<ResourceLocation, BakedModel> registry) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            for (LatchType latch : LatchType.values()) {
                BlockState state = (BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_CHEST.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir)).m_61124_(PropertyHolder.LATCH_TYPE, (Comparable)((Object)latch));
                ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)state);
                LID_MODELS_PRE_CACHE.put((Object)dir, (Object)latch, (Object)new FramedChestLidModel(state, registry.get(location)));
            }
        }
    }

    public static void onModelLoadingComplete() {
        LID_MODELS.putAll(LID_MODELS_PRE_CACHE);
        LID_MODELS_PRE_CACHE.clear();
    }
}

