/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.interactive;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.util.ModelCache;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.interactive.FramedFlowerPotBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedFlowerPotBlockEntity;
import xfacthd.framedblocks.common.compat.supplementaries.SupplementariesCompat;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedFlowerPotModel
extends FramedBlockModel {
    private static final ResourceLocation POT_TEXTURE = new ResourceLocation("minecraft:block/flower_pot");
    private static final ResourceLocation DIRT_TEXTURE = new ResourceLocation("minecraft:block/dirt");
    private final boolean hanging;
    private final BakedModel hangingPotModel;

    public FramedFlowerPotModel(BlockState state, BakedModel baseModel, Map<ResourceLocation, BakedModel> registry) {
        super(state, baseModel);
        this.hanging = SupplementariesCompat.isLoaded() && (Boolean)state.m_61143_((Property)PropertyHolder.HANGING) != false;
        this.hangingPotModel = this.hanging ? registry.get(SupplementariesCompat.HANGING_MODEL_LOCATION) : null;
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (quad.m_111306_() == Direction.DOWN) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.3125f, 0.3125f, 0.6875f, 0.6875f)).export(quadMap.get(Direction.DOWN));
        } else if (quad.m_111306_() == Direction.UP) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.3125f, 0.3125f, 0.6875f, 0.375f)).apply(Modifiers.setPosition(0.375f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.3125f, 0.625f, 0.6875f, 0.6875f)).apply(Modifiers.setPosition(0.375f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.3125f, 0.375f, 0.375f, 0.625f)).apply(Modifiers.setPosition(0.375f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.625f, 0.375f, 0.6875f, 0.625f)).apply(Modifiers.setPosition(0.375f)).export(quadMap.get(null));
        } else if (!Utils.isY(quad.m_111306_())) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.3125f, 0.0f, 0.6875f, 0.375f)).apply(Modifiers.setPosition(0.6875f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.375f, 0.0625f, 0.625f, 0.375f)).apply(Modifiers.setPosition(0.375f)).export(quadMap.get(null));
        }
    }

    @Override
    protected ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData data) {
        Block flower = FramedFlowerPotModel.getFlowerBlock(data);
        return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{ModelCache.getRenderTypes(Blocks.f_50493_.m_49966_(), rand, ModelData.EMPTY), ModelCache.getRenderTypes(flower.m_49966_(), rand, ModelData.EMPTY), this.hanging ? ModelUtils.CUTOUT : ChunkRenderTypeSet.none()});
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, RandomSource rand, ModelData data, RenderType layer) {
        BlockState potState = FramedFlowerPotBlock.getFlowerPotState(FramedFlowerPotModel.getFlowerBlock(data));
        if (!potState.m_60795_()) {
            FramedFlowerPotModel.addPlantQuads(quadMap, potState, rand, layer);
        }
        FramedFlowerPotModel.addDirtQuads(quadMap, rand, data, layer);
        if (this.hanging && layer == RenderType.m_110463_()) {
            quadMap.get(null).addAll(this.hangingPotModel.getQuads(null, null, rand, data, null));
            for (Direction side : Direction.values()) {
                quadMap.get(side).addAll(this.hangingPotModel.getQuads(null, side, rand, data, null));
            }
        }
    }

    @Override
    protected FramedBlockModel.QuadCacheKey makeCacheKey(BlockState state, Object ctCtx, ModelData data) {
        return new FlowerPotQuadCacheKey(state, ctCtx, FramedFlowerPotModel.getFlowerBlock(data));
    }

    private static void addPlantQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState potState, RandomSource rand, RenderType layer) {
        BakedModel potModel = ModelCache.getModel(potState);
        if (potModel.getRenderTypes(potState, rand, ModelData.EMPTY).contains(layer)) {
            Arrays.stream(Direction.values()).map(dir -> Pair.of((Object)dir, FramedFlowerPotModel.getFilteredPlantQuads(potState, potModel, dir, rand, layer))).forEach(pair -> ((List)quadMap.get(pair.getFirst())).addAll((Collection)pair.getSecond()));
            quadMap.get(null).addAll(FramedFlowerPotModel.getFilteredPlantQuads(potState, potModel, null, rand, layer));
        }
    }

    private static List<BakedQuad> getFilteredPlantQuads(BlockState potState, BakedModel potModel, Direction face, RandomSource rand, RenderType layer) {
        return potModel.getQuads(potState, face, rand, ModelData.EMPTY, layer).stream().filter(q -> !ClientUtils.isTexture(q, POT_TEXTURE)).filter(q -> !ClientUtils.isTexture(q, DIRT_TEXTURE)).map(ModelUtils::invertTintIndex).collect(Collectors.toList());
    }

    private static void addDirtQuads(Map<Direction, List<BakedQuad>> quadMap, RandomSource rand, ModelData data, RenderType layer) {
        BakedModel dirtModel = ModelCache.getModel(Blocks.f_50493_.m_49966_());
        if (dirtModel.getRenderTypes(Blocks.f_50493_.m_49966_(), rand, ModelData.EMPTY).contains(layer)) {
            dirtModel.getQuads(Blocks.f_50493_.m_49966_(), Direction.UP, rand, ModelData.EMPTY, layer).forEach(q -> QuadModifier.geometry(q).apply(Modifiers.cutTopBottom(0.375f, 0.375f, 0.625f, 0.625f)).apply(Modifiers.setPosition(0.25f)).export((List)quadMap.get(null)));
            FramedBlockData fbData = (FramedBlockData)data.get(FramedBlockData.PROPERTY);
            if (fbData != null && !fbData.getCamoState().m_60815_()) {
                dirtModel.getQuads(Blocks.f_50493_.m_49966_(), Direction.DOWN, rand, ModelData.EMPTY, layer).forEach(q -> QuadModifier.geometry(q).apply(Modifiers.cutTopBottom(0.375f, 0.375f, 0.625f, 0.625f)).apply(Modifiers.setPosition(0.9375f)).export((List)quadMap.get(null)));
                Direction.Plane.HORIZONTAL.m_122557_().flatMap(face -> dirtModel.getQuads(Blocks.f_50016_.m_49966_(), face, rand, ModelData.EMPTY, layer).stream()).forEach(q -> QuadModifier.geometry(q).apply(Modifiers.cutSide(0.375f, 0.0625f, 0.625f, 0.25f)).apply(Modifiers.setPosition(0.625f)).export((List)quadMap.get(null)));
            }
        }
    }

    private static Block getFlowerBlock(ModelData data) {
        Block flower = (Block)data.get(FramedFlowerPotBlockEntity.FLOWER_BLOCK);
        return flower != null ? flower : Blocks.f_50016_;
    }

    private record FlowerPotQuadCacheKey(BlockState state, Object ctCtx, Block flower) implements FramedBlockModel.QuadCacheKey
    {
    }
}

