/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.shapes;

import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.util.Utils;

public final class ShapeUtils {
    private static final Direction[] HORIZONTAL_DIRECTIONS = (Direction[])Direction.Plane.HORIZONTAL.m_122557_().toArray(Direction[]::new);

    public static VoxelShape orUnoptimized(VoxelShape first, VoxelShape second) {
        return Shapes.m_83148_((VoxelShape)first, (VoxelShape)second, (BooleanOp)BooleanOp.f_82695_);
    }

    public static VoxelShape orUnoptimized(VoxelShape first, VoxelShape ... others) {
        for (VoxelShape shape : others) {
            first = ShapeUtils.orUnoptimized(first, shape);
        }
        return first;
    }

    public static VoxelShape andUnoptimized(VoxelShape first, VoxelShape second) {
        return Shapes.m_83148_((VoxelShape)first, (VoxelShape)second, (BooleanOp)BooleanOp.f_82689_);
    }

    public static VoxelShape andUnoptimized(VoxelShape first, VoxelShape ... others) {
        for (VoxelShape shape : others) {
            first = ShapeUtils.andUnoptimized(first, shape);
        }
        return first;
    }

    public static VoxelShape and(VoxelShape first, VoxelShape second) {
        return ShapeUtils.andUnoptimized(first, second).m_83296_();
    }

    public static VoxelShape and(VoxelShape first, VoxelShape ... others) {
        return ShapeUtils.andUnoptimized(first, others).m_83296_();
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        return ShapeUtils.rotateShapeUnoptimized(from, to, shape).m_83296_();
    }

    public static VoxelShape rotateShapeUnoptimized(Direction from, Direction to, VoxelShape shape) {
        if (Utils.isY(from) || Utils.isY(to)) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        if (from == to) {
            return shape;
        }
        List sourceBoxes = shape.m_83299_();
        VoxelShape rotatedShape = Shapes.m_83040_();
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (AABB box : sourceBoxes) {
            for (int i = 0; i < times; ++i) {
                box = new AABB(1.0 - box.f_82293_, box.f_82289_, box.f_82288_, 1.0 - box.f_82290_, box.f_82292_, box.f_82291_);
            }
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.m_83064_((AABB)box));
        }
        return rotatedShape;
    }

    public static void makeHorizontalRotations(VoxelShape shape, Direction srcDir, VoxelShape[] out, int baseOffset) {
        if (Utils.isY(srcDir)) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        for (int i = 0; i < 4; ++i) {
            boolean baseShape = i == srcDir.m_122416_();
            out[baseOffset + i] = baseShape ? shape : Shapes.m_83040_();
        }
        List sourceBoxes = shape.m_83299_();
        for (AABB box : sourceBoxes) {
            for (int i = 1; i < 4; ++i) {
                int idx = baseOffset + (srcDir.m_122416_() + i) % 4;
                box = new AABB(1.0 - box.f_82293_, box.f_82289_, box.f_82288_, 1.0 - box.f_82290_, box.f_82292_, box.f_82291_);
                out[idx] = ShapeUtils.orUnoptimized(out[idx], Shapes.m_83064_((AABB)box));
            }
        }
    }

    public static VoxelShape[] makeHorizontalRotations(VoxelShape shape, Direction srcDir) {
        VoxelShape[] shapes = new VoxelShape[4];
        ShapeUtils.makeHorizontalRotations(shape, srcDir, shapes, 0);
        return shapes;
    }

    public static void makeHorizontalRotations(VoxelShape shape, Direction srcDir, Map<Direction, VoxelShape> targetMap) {
        VoxelShape[] shapes = new VoxelShape[4];
        ShapeUtils.makeHorizontalRotations(shape, srcDir, shapes, 0);
        for (Direction dir : HORIZONTAL_DIRECTIONS) {
            targetMap.put(dir, shapes[dir.m_122416_()]);
        }
    }

    public static <V, T> void makeHorizontalRotations(VoxelShape shape, Direction srcDir, Map<T, VoxelShape> targetMap, V staticKeyParam, ArbKeyGenerator<V, T> keyGen) {
        VoxelShape[] shapes = new VoxelShape[4];
        ShapeUtils.makeHorizontalRotations(shape, srcDir, shapes, 0);
        for (Direction dir : HORIZONTAL_DIRECTIONS) {
            targetMap.put(keyGen.makeKey(dir, staticKeyParam), shapes[dir.m_122416_()]);
        }
    }

    public static VoxelShape[] makeHorizontalRotationsWithFlag(VoxelShape shapeFalse, VoxelShape shapeTrue, Direction srcDir) {
        VoxelShape[] shapes = new VoxelShape[8];
        ShapeUtils.makeHorizontalRotations(shapeFalse, srcDir, shapes, 0);
        ShapeUtils.makeHorizontalRotations(shapeTrue, srcDir, shapes, 4);
        return shapes;
    }

    public static <T> void makeHorizontalRotationsWithFlag(VoxelShape shapeFalse, VoxelShape shapeTrue, Direction srcDir, Map<T, VoxelShape> targetMap, FlagKeyGenerator<T> keyGen) {
        VoxelShape[] shapes = new VoxelShape[8];
        ShapeUtils.makeHorizontalRotations(shapeFalse, srcDir, shapes, 0);
        ShapeUtils.makeHorizontalRotations(shapeTrue, srcDir, shapes, 4);
        for (Direction dir : HORIZONTAL_DIRECTIONS) {
            targetMap.put(keyGen.makeKey(dir, false), shapes[dir.m_122416_()]);
            targetMap.put(keyGen.makeKey(dir, true), shapes[dir.m_122416_() + 4]);
        }
    }

    private ShapeUtils() {
    }

    public static interface ArbKeyGenerator<V, T> {
        public T makeKey(Direction var1, V var2);
    }

    public static interface FlagKeyGenerator<T> {
        public T makeKey(Direction var1, boolean var2);
    }
}

