/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.model.util;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.FramedBlocksClientAPI;
import xfacthd.framedblocks.api.model.util.ModelUtils;

public final class ModelCache {
    public static final Duration DEFAULT_CACHE_DURATION = Duration.ofMinutes(10L);
    private static final Map<Fluid, BakedModel> modelCache = new ConcurrentHashMap<Fluid, BakedModel>();
    private static ModelBakery modelBakery = null;

    public static void clear(ModelBakery bakery) {
        modelCache.clear();
        modelBakery = bakery;
    }

    public static BakedModel getModel(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof LiquidBlock) {
            LiquidBlock fluidBlock = (LiquidBlock)block;
            return modelCache.computeIfAbsent((Fluid)fluidBlock.getFluid(), FramedBlocksClientAPI.getInstance()::createFluidModel);
        }
        return Minecraft.m_91087_().m_91289_().m_110910_(state);
    }

    public static ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource random, ModelData data) {
        if (state.m_60734_() instanceof LiquidBlock) {
            return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{ItemBlockRenderTypes.m_109287_((FluidState)state.m_60819_())});
        }
        return ModelCache.getModel(state).getRenderTypes(state, random, data);
    }

    public static ChunkRenderTypeSet getCamoRenderTypes(BlockState state, RandomSource random, ModelData data) {
        if (state.m_60734_() instanceof LiquidBlock) {
            return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{ItemBlockRenderTypes.m_109287_((FluidState)state.m_60819_())});
        }
        BakedModel model = ModelCache.getModel(state);
        data = ModelUtils.getCamoModelData(data);
        return model.getRenderTypes(state, random, data);
    }

    public static ModelBakery getModelBakery() {
        Preconditions.checkNotNull((Object)modelBakery, (Object)"ModelBakery requested before first resource reload");
        return modelBakery;
    }

    private ModelCache() {
    }
}

