/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block.render;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelDataManager;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xfacthd.framedblocks.api.FramedBlocksClientAPI;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.cache.StateCache;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.predicate.contex.ConTexMode;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.Utils;

@ApiStatus.Internal
public final class AppearanceHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final BlockState AIR = Blocks.f_50016_.m_49966_();

    public static BlockState getAppearance(IFramedBlock framedBlock, BlockState state, BlockGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        return AppearanceHelper.getAppearance(framedBlock, state, level, pos, side, queryState, queryPos, false);
    }

    private static BlockState getAppearance(IFramedBlock framedBlock, BlockState state, BlockGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos, boolean recursive) {
        Direction detEdge;
        Direction conEdge;
        if (!FMLEnvironment.dist.isClient() || !framedBlock.getBlockType().supportsConnectedTextures()) {
            return AIR;
        }
        ConTexMode mode = FramedBlocksClientAPI.getInstance().getConTexMode();
        if (mode == ConTexMode.NONE || queryPos == null) {
            return AIR;
        }
        BlockState actualQueryState = AppearanceHelper.findApplicableNeighbor(level, queryPos, queryState);
        if (actualQueryState == AIR) {
            return AIR;
        }
        Direction edge = AppearanceHelper.findFirstSuitableDirectionFromOffset(pos, queryPos, side, $ -> true);
        StateCache stateCache = framedBlock.getCache(state);
        if (framedBlock.getBlockType().isDoubleBlock()) {
            BlockEntity blockEntity;
            if (recursive) {
                LOGGER.error("AppearanceHelper#getAppearance() trying to recurse multiple times, this is a bug. Please report this to FramedBlocks with the following stacktrace. Pos: {}, State: {}, Side: {}", new Object[]{pos, state, side, new Throwable()});
                return AIR;
            }
            if (actualQueryState != null && (blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity) {
                FramedBlockEntity be = (FramedBlockEntity)blockEntity;
                if (AppearanceHelper.canDoubleBlockConnectFullEdgeTo(pos, queryPos, actualQueryState, side, edge)) {
                    if (stateCache.canConnectFullEdge(side, edge)) {
                        return AppearanceHelper.getCamo(level, pos, side, edge);
                    }
                    return AIR;
                }
                if (edge == null) {
                    return AIR;
                }
                BlockState componentState = be.getComponentBySkipPredicate(level, actualQueryState, edge);
                if (componentState != null) {
                    IFramedBlock componentBlock = (IFramedBlock)componentState.m_60734_();
                    return AppearanceHelper.getAppearance(componentBlock, componentState, level, pos, side, actualQueryState, queryPos, true);
                }
            }
            return AIR;
        }
        ConTexMode typeMode = framedBlock.getBlockType().getMinimumConTexMode();
        if (AppearanceHelper.canUseMode(mode, typeMode, ConTexMode.FULL_FACE) && stateCache.canConnectFullEdge(side, null)) {
            if (AppearanceHelper.isNotFramedOrCanConnectFullEdgeTo(pos, queryPos, actualQueryState, side, edge)) {
                return AppearanceHelper.getCamo(level, pos, state);
            }
            return AIR;
        }
        if (edge == null) {
            return AIR;
        }
        if (AppearanceHelper.canUseMode(mode, typeMode, ConTexMode.FULL_EDGE) && (conEdge = AppearanceHelper.findFirstSuitableDirectionFromOffset(pos, queryPos, side, testEdge -> stateCache.canConnectFullEdge(side, (Direction)testEdge))) != null) {
            return AppearanceHelper.getCamo(level, pos, state);
        }
        if (mode == ConTexMode.DETAILED && !queryPos.equals((Object)pos) && (detEdge = AppearanceHelper.findFirstSuitableDirectionFromOffset(pos, queryPos, side, testEdge -> AppearanceHelper.isSideHidden(level, pos, state, testEdge))) != null && stateCache.canConnectDetailed(side, detEdge)) {
            return AppearanceHelper.getCamo(level, pos, state);
        }
        return AIR;
    }

    private static boolean canUseMode(ConTexMode cfgMode, ConTexMode typeMode, ConTexMode targetMode) {
        return cfgMode.atleast(targetMode) && targetMode.atleast(typeMode);
    }

    private static Direction findFirstSuitableDirectionFromOffset(BlockPos pos, BlockPos queryPos, Direction side, Predicate<Direction> pred) {
        int nz;
        int ny;
        if (pos.equals((Object)queryPos)) {
            return null;
        }
        int nx = queryPos.m_123341_() - pos.m_123341_();
        Direction conFace = Utils.dirByNormal(nx, ny = queryPos.m_123342_() - pos.m_123342_(), nz = queryPos.m_123343_() - pos.m_123343_());
        if (conFace != null) {
            return pred.test(conFace) ? conFace : null;
        }
        if (!Utils.isX(side) && (conFace = Utils.dirByNormal(nx, 0, 0)) != null && pred.test(conFace)) {
            return conFace;
        }
        if (!Utils.isY(side) && (conFace = Utils.dirByNormal(0, ny, 0)) != null && pred.test(conFace)) {
            return conFace;
        }
        if (!Utils.isZ(side) && (conFace = Utils.dirByNormal(0, 0, nz)) != null && pred.test(conFace)) {
            return conFace;
        }
        return null;
    }

    private static BlockState findApplicableNeighbor(BlockGetter level, BlockPos queryPos, @Nullable BlockState queryState) {
        Block block;
        if (queryState != null && (block = queryState.m_60734_()) instanceof IFramedBlock) {
            IFramedBlock block2 = (IFramedBlock)block;
            return block2.getBlockType().supportsConnectedTextures() ? queryState : AIR;
        }
        BlockState actualQueryState = level.m_8055_(queryPos);
        Block block3 = actualQueryState.m_60734_();
        if (block3 instanceof IFramedBlock) {
            IFramedBlock block4 = (IFramedBlock)block3;
            IBlockType type = block4.getBlockType();
            if (type.isDoubleBlock()) {
                return null;
            }
            if (!type.supportsConnectedTextures()) {
                return AIR;
            }
            return actualQueryState;
        }
        return queryState != null && queryState.m_60795_() ? null : queryState;
    }

    private static boolean canDoubleBlockConnectFullEdgeTo(BlockPos pos, BlockPos queryPos, BlockState queryState, Direction side, @Nullable Direction edge) {
        Block block = queryState.m_60734_();
        if (!(block instanceof IFramedBlock)) {
            return true;
        }
        IFramedBlock block2 = (IFramedBlock)block;
        int nx = queryPos.m_123341_() - pos.m_123341_();
        int ny = queryPos.m_123342_() - pos.m_123342_();
        int nz = queryPos.m_123343_() - pos.m_123343_();
        if (side.m_122434_().m_7863_(nx, ny, nz) != 0) {
            side = side.m_122424_();
        }
        if (edge != null) {
            edge = edge.m_122424_();
        }
        return block2.getCache(queryState).canConnectFullEdge(side, edge);
    }

    private static boolean isNotFramedOrCanConnectFullEdgeTo(BlockPos pos, BlockPos queryPos, BlockState queryState, Direction side, @Nullable Direction edge) {
        Block block;
        if (queryState != null && (block = queryState.m_60734_()) instanceof IFramedBlock) {
            IFramedBlock block2 = (IFramedBlock)block;
            int nx = queryPos.m_123341_() - pos.m_123341_();
            int ny = queryPos.m_123342_() - pos.m_123342_();
            int nz = queryPos.m_123343_() - pos.m_123343_();
            if (side.m_122434_().m_7863_(nx, ny, nz) != 0) {
                side = side.m_122424_();
            }
            if (edge != null) {
                edge = edge.m_122424_();
            }
            return block2.getCache(queryState).canConnectFullEdge(side, edge);
        }
        return true;
    }

    private static boolean isSideHidden(BlockGetter level, BlockPos pos, BlockState state, Direction side) {
        ModelDataManager manager = level.getModelDataManager();
        if (manager == null) {
            return false;
        }
        ModelData data = manager.getAt(pos);
        if (data == null) {
            return false;
        }
        FramedBlockData fbData = (FramedBlockData)data.get(FramedBlockData.PROPERTY);
        if (fbData != null) {
            return fbData.isSideHidden(side);
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            fbData = (FramedBlockData)be.getModelData(data, state).get(FramedBlockData.PROPERTY);
            return fbData != null && fbData.isSideHidden(side);
        }
        return false;
    }

    private static BlockState getCamo(BlockGetter level, BlockPos pos, Direction side, @Nullable Direction edge) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.getCamo(side, edge).getState();
        }
        return AIR;
    }

    private static BlockState getCamo(BlockGetter level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.getCamo(state).getState();
        }
        return AIR;
    }

    private AppearanceHelper() {
    }
}

