/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.extensions.IForgeBlock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.FramedBlocksAPI;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.cache.IStateCacheAccessor;
import xfacthd.framedblocks.api.block.cache.StateCache;
import xfacthd.framedblocks.api.block.render.AppearanceHelper;
import xfacthd.framedblocks.api.block.render.CullingHelper;
import xfacthd.framedblocks.api.block.render.ParticleHelper;
import xfacthd.framedblocks.api.block.update.CullingUpdateTracker;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.internal.InternalAPI;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.Utils;

public interface IFramedBlock
extends EntityBlock,
IForgeBlock {
    public static final String LOCK_MESSAGE = Utils.translationKey("msg", "lock_state");
    public static final Component STATE_LOCKED = Utils.translate("msg", "lock_state.locked").m_130940_(ChatFormatting.RED);
    public static final Component STATE_UNLOCKED = Utils.translate("msg", "lock_state.unlocked").m_130940_(ChatFormatting.GREEN);

    public IBlockType getBlockType();

    public static BlockBehaviour.Properties createProperties(IBlockType type) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_278183_().m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_60971_(IFramedBlock::isBlockSuffocating).m_60960_(IFramedBlock::isBlockSuffocating);
        if (!type.canOccludeWithSolidCamo()) {
            props.m_60955_();
        }
        return props;
    }

    private static boolean isBlockSuffocating(BlockState state, BlockGetter level, BlockPos pos) {
        return ((IFramedBlock)state.m_60734_()).isSuffocating(state, level, pos);
    }

    default public BlockItem createBlockItem() {
        return new BlockItem((Block)this, new Item.Properties());
    }

    @ApiStatus.OverrideOnly
    default public StateCache initCache(BlockState state) {
        return new StateCache(state, this.getBlockType());
    }

    default public StateCache getCache(BlockState state) {
        return ((IStateCacheAccessor)state).framedblocks$getCache();
    }

    default public void tryApplyCamoImmediately(Level level, BlockPos pos, @Nullable LivingEntity placer, ItemStack stack) {
        Player player;
        if (level.m_5776_()) {
            return;
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("BlockEntityTag")) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof FramedBlockEntity) {
                FramedBlockEntity be = (FramedBlockEntity)blockEntity;
                be.checkCamoSolid();
            }
            return;
        }
        if (placer instanceof Player && (player = (Player)placer).m_21205_() == stack) {
            FramedBlockEntity be;
            BlockItem item;
            ItemStack offhandStack = player.m_21206_();
            Item item2 = offhandStack.m_41720_();
            if (item2 instanceof BlockItem ? (item = (BlockItem)item2).m_40614_() instanceof IFramedBlock : !offhandStack.m_204117_(Tags.Items.DUSTS_GLOWSTONE)) {
                return;
            }
            item2 = level.m_7702_(pos);
            if (item2 instanceof FramedBlockEntity && (be = (FramedBlockEntity)item2).canAutoApplyCamoOnPlacement()) {
                Vec3 hitVec = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                be.handleInteraction(player, InteractionHand.OFF_HAND, new BlockHitResult(hitVec, Direction.UP, pos, false));
            }
        }
    }

    default public InteractionResult handleUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.getBlockType().canLockState() && hand == InteractionHand.MAIN_HAND && this.lockState(level, pos, player, player.m_21120_(hand))) {
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (player.m_21120_(hand).m_204117_(Utils.WRENCH)) {
            Rotation rot = player.m_6144_() ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
            BlockState newState = this.rotate(state, hit, rot);
            if (newState != state) {
                if (!level.m_5776_()) {
                    level.m_46597_(pos, newState);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.handleInteraction(player, hand, hit);
        }
        return InteractionResult.FAIL;
    }

    default public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if (!((Boolean)state.m_61143_((Property)FramedProperties.GLOWING)).booleanValue()) {
            return 0;
        }
        BlockEntity blockEntity = InternalAPI.INSTANCE.getBlockEntityForLight(level, pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.getLightValue();
        }
        return 0;
    }

    default public boolean playBreakSound(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            BlockState camoState = be.getCamo().getState();
            if (camoState.m_60795_()) {
                camoState = state;
            }
            IFramedBlock.playCamoBreakSound(level, pos, camoState);
            return true;
        }
        return false;
    }

    public static void playCamoBreakSound(Level level, BlockPos pos, BlockState camoState) {
        SoundType type = camoState.m_60827_();
        SoundEvent sound = type.m_56775_();
        level.m_245747_(pos, sound, SoundSource.BLOCKS, (type.m_56773_() + 1.0f) / 2.0f, type.m_56774_() * 0.8f, false);
    }

    default public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        FramedBlockEntity be;
        CamoContainer camo;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && !(camo = (be = (FramedBlockEntity)blockEntity).getCamo()).isEmpty()) {
            return camo.getSoundType();
        }
        return ((Block)this).m_49962_(state);
    }

    default public List<ItemStack> getCamoDrops(List<ItemStack> drops, LootParams.Builder builder) {
        Object object = builder.m_287159_(LootContextParams.f_81462_);
        if (object instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)((Object)object);
            be.addAdditionalDrops(drops, FramedBlocksAPI.getInstance().shouldConsumeCamo());
        }
        return drops;
    }

    @Nullable
    default public BlockState runOcclusionTestAndGetLookupState(SideSkipPredicate pred, BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (pred.test(level, pos, state, adjState, side)) {
            return adjState;
        }
        return null;
    }

    default public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        return AppearanceHelper.getAppearance(this, state, (BlockGetter)level, pos, side, queryState, queryPos);
    }

    default public boolean shouldPreventNeighborCulling(BlockGetter level, BlockPos pos, BlockState state, BlockPos adjPos, BlockState adjState) {
        if (!FramedBlocksAPI.getInstance().enableIntangibility() || this.isIntangible(adjState, level, adjPos, null)) {
            return false;
        }
        if (this.getBlockType().allowMakingIntangible()) {
            return this.isIntangible(state, level, pos, null);
        }
        return false;
    }

    default public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.getCamoFriction(state, entity);
        }
        return state.m_60734_().m_49958_();
    }

    default public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        FramedBlockEntity be;
        float resistance;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && (resistance = (be = (FramedBlockEntity)blockEntity).getCamoExplosionResistance(explosion)) > 0.0f) {
            return resistance;
        }
        return state.m_60734_().m_7325_();
    }

    default public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        if (FramedBlocksAPI.getInstance().areBlocksFireproof()) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.isCamoFlammable(face);
        }
        return true;
    }

    default public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        FramedBlockEntity be;
        int flammability;
        if (FramedBlocksAPI.getInstance().areBlocksFireproof()) {
            return 0;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && (flammability = (be = (FramedBlockEntity)blockEntity).getCamoFlammability(face)) > -1) {
            return flammability;
        }
        return 20;
    }

    default public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        FramedBlockEntity be;
        int spreadSpeed;
        if (FramedBlocksAPI.getInstance().areBlocksFireproof()) {
            return 0;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && (spreadSpeed = (be = (FramedBlockEntity)blockEntity).getCamoFireSpreadSpeed(face)) > -1) {
            return spreadSpeed;
        }
        return 5;
    }

    default public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    default public boolean isIntangible(BlockState state, BlockGetter level, BlockPos pos, @Nullable CollisionContext ctx) {
        FramedBlockEntity be;
        if (!FramedBlocksAPI.getInstance().enableIntangibility() || !this.getBlockType().allowMakingIntangible()) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        return blockEntity instanceof FramedBlockEntity && (be = (FramedBlockEntity)blockEntity).isIntangible(ctx);
    }

    default public boolean isSuffocating(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState stateAtPos;
        if (FramedBlocksAPI.getInstance().enableIntangibility() && this.getBlockType().allowMakingIntangible() && (state != (stateAtPos = level.m_8055_(pos)) || this.isIntangible(state, level, pos, null))) {
            return false;
        }
        return state.m_280555_() && state.m_60838_(level, pos);
    }

    default public boolean useCamoOcclusionShapeForLightOcclusion(BlockState state) {
        if (this.getBlockType() != null && !this.getBlockType().canOccludeWithSolidCamo()) {
            return false;
        }
        return Utils.tryGetValue(state, FramedProperties.SOLID, false) != false && (Boolean)state.m_61143_((Property)FramedProperties.GLOWING) == false;
    }

    default public VoxelShape getCamoOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        if (this.getBlockType().canOccludeWithSolidCamo() && !((Boolean)state.m_61143_((Property)FramedProperties.SOLID)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return state.m_60808_(level, pos);
    }

    default public VoxelShape getCamoVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (this.getBlockType().canOccludeWithSolidCamo() && !((Boolean)state.m_61143_((Property)FramedProperties.SOLID)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return state.m_60742_(level, pos, ctx);
    }

    default public float getCamoShadeBrightness(BlockState state, BlockGetter level, BlockPos pos, float ownShade) {
        FramedBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && !(be = (FramedBlockEntity)blockEntity).getCamo().isEmpty()) {
            return Math.max(ownShade, be.getCamo().getState().m_60792_(level, pos));
        }
        return ownShade;
    }

    default public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            ParticleHelper.spawnRunningParticles(be.getCamo().getState(), level, pos, entity);
            return true;
        }
        return false;
    }

    default public boolean addLandingEffects(BlockState state, ServerLevel level, BlockPos pos, BlockState sameState, LivingEntity entity, int count) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            ParticleHelper.spawnLandingParticles(be.getCamo().getState(), level, pos, entity, count);
            return true;
        }
        return false;
    }

    default public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        return CullingHelper.hidesNeighborFace(this, level, pos, state, adjState, side);
    }

    default public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        BlockEntity blockEntity;
        if (this.needCullingUpdateAfterStateChange(level, oldState, newState)) {
            this.updateCulling(level, pos);
        }
        if (level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            be.m_155250_(newState);
        }
    }

    default public void updateCulling(LevelReader level, BlockPos pos) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && level instanceof Level) {
            Level realLevel = (Level)level;
            CullingUpdateTracker.enqueueCullingUpdate(realLevel, pos);
        } else if (level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            be.updateCulling(true, false);
        }
    }

    default public boolean needCullingUpdateAfterStateChange(LevelReader level, BlockState oldState, BlockState newState) {
        if (!level.m_5776_() || oldState.m_60734_() != newState.m_60734_()) {
            return false;
        }
        if (this.getBlockType().canOccludeWithSolidCamo() && oldState.m_61124_((Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf((Boolean)oldState.m_61143_((Property)FramedProperties.SOLID) == false)) == newState) {
            return false;
        }
        return oldState.m_61124_((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf((Boolean)oldState.m_61143_((Property)FramedProperties.GLOWING) == false)) != newState;
    }

    default public boolean lockState(Level level, BlockPos pos, Player player, ItemStack stack) {
        if (stack.m_41720_() != Utils.FRAMED_KEY.get()) {
            return false;
        }
        if (!level.m_5776_()) {
            BlockState state = level.m_8055_(pos);
            boolean locked = (Boolean)state.m_61143_((Property)FramedProperties.STATE_LOCKED);
            player.m_5661_((Component)Component.m_237110_((String)LOCK_MESSAGE, (Object[])new Object[]{locked ? STATE_UNLOCKED : STATE_LOCKED}), true);
            level.m_46597_(pos, (BlockState)state.m_61122_((Property)FramedProperties.STATE_LOCKED));
        }
        return true;
    }

    default public BlockState updateShapeLockable(BlockState state, LevelAccessor level, BlockPos pos, Supplier<BlockState> updateShape) {
        if (!((Boolean)state.m_61143_((Property)FramedProperties.STATE_LOCKED)).booleanValue()) {
            return updateShape.get();
        }
        if (this.getBlockType().supportsWaterLogging() && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return state;
    }

    default public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        return this.rotate(state, hit.m_82434_(), rot);
    }

    default public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        return state.m_60717_(rot);
    }

    default public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        FramedBlockEntity be;
        MapColor color;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && (color = (be = (FramedBlockEntity)blockEntity).getMapColor()) != null) {
            return color;
        }
        return defaultColor;
    }

    default public float[] getBeaconColorMultiplier(BlockState state, LevelReader level, BlockPos pos, BlockPos beaconPos) {
        if (!this.doesBlockOccludeBeaconBeam(state, level, pos)) {
            return null;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.getCamoBeaconColorMultiplier(level, pos, beaconPos);
        }
        return null;
    }

    default public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return false;
    }

    default public boolean canCamoSustainPlant(BlockState state, BlockGetter level, BlockPos pos, Direction side, IPlantable plant) {
        BlockEntity blockEntity;
        if (state.m_60659_(level, pos, side, SupportType.FULL) && (blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.canCamoSustainPlant(side, plant);
        }
        return false;
    }

    default public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter level, BlockPos pos, FluidState fluid) {
        BlockEntity blockEntity;
        if (!this.getBlockType().canOccludeWithSolidCamo()) {
            return false;
        }
        if (!((Boolean)state.m_61143_((Property)FramedProperties.SOLID)).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.shouldCamoDisplayFluidOverlay(level, pos, fluid);
        }
        return false;
    }

    default public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        FramedBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && (be = (FramedBlockEntity)blockEntity).doesCamoPreventDestructionByEntity(entity)) {
            return false;
        }
        return super.canEntityDestroy(state, level, pos, entity);
    }

    default public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedBlockEntity(pos, state);
    }

    default public Optional<MutableComponent> printCamoBlock(CompoundTag beTag) {
        BlockState camoState = CamoContainer.load(beTag.m_128469_("camo")).getState();
        if (camoState.m_60795_()) {
            return Optional.empty();
        }
        return Optional.of(camoState.m_60734_().m_49954_().m_130940_(ChatFormatting.WHITE));
    }

    public static boolean toggleYSlope(BlockState state, Level level, BlockPos pos, Player player) {
        if (player.m_21205_().m_41720_() == Utils.FRAMED_WRENCH.get()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE) == false)));
            return true;
        }
        return false;
    }
}

