/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.util.NonNullConsumer;

public enum Reactants implements NonNullConsumer<LivingEntity>
{
    Yellorium(ReactantType.Fuel, "yellorium", 13023828, 2000, 5, Rarity.RARE, MobEffects.f_19613_, MobEffects.f_19597_),
    Cyanite(ReactantType.Waste, "cyanite", 5474231, 2000, 6, Rarity.RARE, MobEffects.f_19613_, MobEffects.f_19597_, MobEffects.f_19612_),
    Blutonium(ReactantType.Fuel, "blutonium", 1513372, 2500, 7, Rarity.RARE, MobEffects.f_19613_, MobEffects.f_19597_, MobEffects.f_19612_, MobEffects.f_19614_),
    Magentite(ReactantType.Waste, "magentite", 14949860, 2500, 8, Rarity.RARE, MobEffects.f_19613_, MobEffects.f_19597_, MobEffects.f_19612_, MobEffects.f_19615_),
    Verderium(ReactantType.Fuel, "verderium", 65280, 3000, 9, Rarity.EPIC, MobEffects.f_19615_, MobEffects.f_19612_, MobEffects.f_19614_, MobEffects.f_19613_, MobEffects.f_19610_),
    Rossinite(ReactantType.Waste, "rossinite", 0xFF0000, 460, 12, Rarity.EPIC, MobEffects.f_19596_, MobEffects.f_19598_, MobEffects.f_19591_, MobEffects.f_19595_);

    private final ReactantType _type;
    private final String _name;
    private final int _colour;
    private final List<MobEffect> _effects;
    private final int _fluidDensity;
    private final int _fluidLightLevel;
    private final Rarity _rarity;

    public ReactantType getType() {
        return this._type;
    }

    public String getReactantName() {
        return this._name;
    }

    public String getTagName() {
        return this._name;
    }

    public String getLangKey() {
        return "reactant.bigreactors." + this._name;
    }

    public String getBlockName() {
        return this._name + "_block";
    }

    public String getIngotName() {
        return this._name + "_ingot";
    }

    public String getNuggetName() {
        return this._name + "_nugget";
    }

    public String getDustName() {
        return this._name + "_dust";
    }

    public String getBucketName() {
        return this._name + "_bucket";
    }

    public String getFluidName() {
        return this._name + "_fluid";
    }

    public String getFluidSourceName() {
        return this._name;
    }

    public String getFluidFlowingName() {
        return this._name + "_flowing";
    }

    public int getColour() {
        return this._colour;
    }

    public int getFluidDensity() {
        return this._fluidDensity;
    }

    public int getFluidLightLevel() {
        return this._fluidLightLevel;
    }

    public Rarity getRarity() {
        return this._rarity;
    }

    public void accept(@Nonnull LivingEntity entity) {
        this._effects.forEach(effect -> entity.m_7292_(new MobEffectInstance(effect, 400, 0, true, true, true)));
    }

    private Reactants(ReactantType type, String name, int colour, int density, int lightLevel, Rarity rarity, MobEffect ... effects) {
        this._type = type;
        this._name = name;
        this._colour = colour;
        this._fluidDensity = density;
        this._fluidLightLevel = lightLevel;
        this._rarity = rarity;
        this._effects = new ObjectArrayList((Object[])effects);
    }
}

