/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.turbine;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.ExtremeReactorsAPI;
import it.zerono.mods.extremereactors.api.internal.InternalDispatcher;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.ApiWrapper;
import it.zerono.mods.extremereactors.api.turbine.CoilMaterial;
import it.zerono.mods.zerocore.lib.tag.TagList;
import it.zerono.mods.zerocore.lib.tag.TagSource;
import it.zerono.mods.zerocore.lib.tag.TagsHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Mod.EventBusSubscriber(modid="bigreactors", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CoilMaterialRegistry {
    private static final TagList<Block> s_tags = TagList.blocks();
    private static final Map<TagKey<Block>, CoilMaterial> s_materials = new Object2ObjectArrayMap(32);
    private static final Component TOOLTIP_COIL = Component.m_237115_((String)"api.bigreactors.reactor.tooltip.coil").m_6270_(ExtremeReactorsAPI.STYLE_TOOLTIP);
    private static final Marker MARKER = MarkerManager.getMarker((String)"API/CoilMaterialRegistry").addParents(new Marker[]{ExtremeReactorsAPI.MARKER});
    private static final Marker WRAPPER = MarkerManager.getMarker((String)"ModPack API Wrapper").addParents(new Marker[]{MARKER});

    public static boolean contains(TagKey<Block> tag) {
        return s_materials.containsKey(tag);
    }

    public static Optional<CoilMaterial> get(BlockState state) {
        List tags = TagsHelper.BLOCKS.getTags((Object)state.m_60734_());
        return s_tags.findFirst(tags::contains).map(s_materials::get);
    }

    public static Optional<CoilMaterial> get(TagKey<Block> tag) {
        return Optional.ofNullable(s_materials.get(tag));
    }

    public static void register(String tagId, float efficiency, float bonus, float extractionRate) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tagId) ? 1 : 0) != 0);
        CoilMaterialRegistry.register((TagKey<Block>)TagsHelper.BLOCKS.createKey(tagId), efficiency, bonus, extractionRate);
    }

    public static void register(TagKey<Block> tag, float efficiency, float bonus, float extractionRate) {
        Preconditions.checkNotNull(tag);
        InternalDispatcher.dispatch("coilmaterial-register", () -> {
            if (s_materials.containsKey(tag)) {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Overriding existing coil data for Tag {}", (Object)tag);
            }
            CoilMaterial c = new CoilMaterial(efficiency, bonus, extractionRate);
            s_materials.merge(tag, c, (o, n) -> c);
            s_tags.addTag(tag);
        });
    }

    public static void remove(String tagId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tagId) ? 1 : 0) != 0);
        CoilMaterialRegistry.remove((TagKey<Block>)TagsHelper.BLOCKS.createKey(tagId));
    }

    public static void remove(TagKey<Block> tag) {
        Preconditions.checkNotNull(tag);
        InternalDispatcher.dispatch("coilmaterial-remove", () -> {
            s_materials.remove(tag);
            s_tags.removeTag(tag);
        });
    }

    public static void fillCoilsTooltips(Map<Item, Set<Component>> tooltipsMap, NonNullSupplier<Set<Component>> setSupplier) {
        s_tags.stream().map(arg_0 -> ((TagSource)TagsHelper.BLOCKS).getObjects(arg_0)).flatMap(Collection::stream).map(Block::m_5456_).forEach(item -> tooltipsMap.computeIfAbsent((Item)item, k -> (Set)setSupplier.get()).add(TOOLTIP_COIL));
    }

    public static void processWrapper(ApiWrapper wrapper) {
        if (!wrapper.Enabled) {
            return;
        }
        if (wrapper.TurbineCoils.WipeExistingValuesBeforeAdding) {
            Log.LOGGER.info(WRAPPER, "Wiping all existing Reactor reactants reactions");
            s_materials.clear();
        } else {
            Arrays.stream(wrapper.TurbineCoils.Remove).filter(name -> !Strings.isNullOrEmpty((String)name)).forEach(CoilMaterialRegistry::remove);
        }
        Arrays.stream((it.zerono.mods.extremereactors.api.internal.modpack.wrapper.CoilMaterial[])wrapper.TurbineCoils.Add).filter(Objects::nonNull).forEach(w -> CoilMaterialRegistry.register(w.BlockTagId, w.Efficiency, w.Bonus, w.ExtractionRate));
    }
}

